# SPDX-FileCopyrightText: 2024 Manpreet Singh <manpreet.singh.dev@proton.me>
#
# SPDX-License-Identifier: GPL-2.0-or-later

from io import BytesIO

import pytest

from inkaf.parser.parse import AFParser
from inkaf.parser.types import (
    AFDictObject,
    ObjectStatus,
)
from inkaf.svg.curve import AFCurve

curves = [
    (
        # Circle
        b"2svrC\x01DvCP\x01\x000ataD\x01\x00\x03\x01\x00\x00\x00)\x01\xac\r\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\xdc\xa8\xbe\xc9 fS@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00Y@\x8f\\\x05\xd9|g6@\x00\x02\x00\x00\x00\x00\x00\x00Y@\x00\x00\x00\x00\x00\x00I@\x02\x00\x00\x00\x00\x00\x00\x00Y@\xdc\xa8\xbe\xc9 fS@\x00\x01\xdc\xa8\xbe\xc9 fS@\x00\x00\x00\x00\x00\x00Y@\x00\x02\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00Y@\x02\x00\x8f\\\x05\xd9|g6@\x00\x00\x00\x00\x00\x00Y@\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\xdc\xa8\xbe\xc9 fS@\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00I@\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8f\\\x05\xd9|g6@\x00\x01\x8f\\\x05\xd9|g6@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00",
        "M 50 0 C 77.5958 0 100 22.4042 100 50 C 100 77.5958 77.5958 100 50 100 C 22.4042 100 0 77.5958 0 50 C 0 22.4042 22.4042 0 50 0 Z",
    ),
    (
        # Diamond
        b"2svrC\x01DvCP\x01\x000ataD\x01\x00\x03\x01\x00\x00\x00)\x01\xac\r\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00Y@\x00\x00\x00\x00\x00\x00I@\x00\x02\x00\x00\x00\x00\x00\x00Y@\x00\x00\x00\x00\x00\x00I@\x01\x00\x00\x00\x00\x00\x00\x00Y@\x00\x00\x00\x00\x00\x00I@\x00\x01\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00Y@\x00\x02\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00Y@\x01\x00\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00Y@\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00I@\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00I@\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00I@\x00\x01\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00I@\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00",
        "M 50 0 L 100 50 L 50 100 L 0 50 L 50 0 Z",
    ),
    (
        # CrvD
        b"2svrC\x01DvrC\x01\x000ataD\x01\x00)\x00\xac\x07\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\xc9N\xff\x9f\x14B\xa0?\xe1i\xa0f(\xcf\xc6?\x00\x01\xe1i\xa0f(\xcf\xc6?\x00\x00\x00\x00\x00\x00\xf0?\x00\x02\x9b\xdf\xfa\xdd>\x12\xd6?\x00\x00\x00\x00\x00\x00\xf0?\x04\x00#\xc5R\xc4t^\xe0?\x00\x00\x00\x00\x00\x00\xf0?\x00\x01\x00\x00\x00\x00\x00\x00\xf0?\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\xf0?\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00",
        "M 0 0 C 0.0317542 0.178197 0.178197 1 0.344864 1 C 0.51153 1 1 0 1 0",
    ),
]


@pytest.mark.parametrize("bytes, expected", curves)
def test_curve_pcvd(bytes, expected):
    parser = AFParser(BytesIO(bytes + b"\x00"))
    parent = AFDictObject(0, [], ObjectStatus.NULL, {})
    parser.load_fields(parent)

    path = AFCurve.from_af(parent["Crvs"])
    assert str(path.get_svg_path()) == expected
