/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;

public class JJTreeNode
extends SimpleNode {
    private int myOrdinal;
    private Token first;
    private Token last;
    private boolean whitingOut = false;

    public JJTreeNode(int n) {
        super(n);
    }

    public JJTreeNode(JJTreeParser jJTreeParser, int n) {
        this(n);
    }

    public static Node jjtCreate(int n) {
        return new JJTreeNode(n);
    }

    public void jjtAddChild(Node node, int n) {
        super.jjtAddChild(node, n);
        ((JJTreeNode)node).setOrdinal(n);
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public void setOrdinal(int n) {
        this.myOrdinal = n;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public void setFirstToken(Token token) {
        this.first = token;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void setLastToken(Token token) {
        this.last = token;
    }

    public void print(IO iO) {
        if (this.getLastToken().next == this.getFirstToken()) {
            return;
        }
        Token token = this.getFirstToken();
        Token token2 = new Token();
        token2.next = token;
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            JJTreeNode jJTreeNode = (JJTreeNode)this.jjtGetChild(i);
            while ((token2 = token2.next) != jJTreeNode.getFirstToken()) {
                this.print(token2, iO);
            }
            jJTreeNode.print(iO);
            token2 = jJTreeNode.getLastToken();
        }
        while (token2 != this.getLastToken()) {
            token2 = token2.next;
            this.print(token2, iO);
        }
    }

    String translateImage(Token token) {
        return token.image;
    }

    String whiteOut(Token token) {
        StringBuffer stringBuffer = new StringBuffer(token.image.length());
        for (int i = 0; i < token.image.length(); ++i) {
            char c = token.image.charAt(i);
            if (c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected void print(Token token, IO iO) {
        NodeScope nodeScope;
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                iO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token2)));
                token2 = token2.next;
            }
        }
        if ((nodeScope = NodeScope.getEnclosingNodeScope(this)) == null) {
            iO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token)));
            return;
        }
        if (token.image.equals("jjtThis")) {
            iO.print(nodeScope.getNodeVariable());
            return;
        }
        if (token.image.equals("jjtree") && token.next.image.equals(".") && token.next.next.image.equals("currentNode") && token.next.next.next.image.equals("(") && token.next.next.next.next.image.equals(")")) {
            this.whitingOut = true;
        }
        if (this.whitingOut) {
            if (token.image.equals("jjtree")) {
                iO.print(nodeScope.getNodeVariable());
                iO.print(" ");
            } else if (token.image.equals(")")) {
                iO.print(" ");
                this.whitingOut = false;
            } else {
                for (int i = 0; i < token.image.length(); ++i) {
                    iO.print(" ");
                }
            }
            return;
        }
        iO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token)));
    }

    static void openJJTreeComment(IO iO, String string) {
        if (string != null) {
            iO.print("/*@bgen(jjtree) " + string + " */");
        } else {
            iO.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(IO iO) {
        iO.print("/*@egen*/");
    }

    String getIndentation(JJTreeNode jJTreeNode) {
        return this.getIndentation(jJTreeNode, 0);
    }

    String getIndentation(JJTreeNode jJTreeNode, int n) {
        String string = "";
        for (int i = n + 1; i < jJTreeNode.getFirstToken().beginColumn; ++i) {
            string = string + " ";
        }
        return string;
    }
}

