/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

#ifndef _Method_H
#define _Method_H

#include <Python.h>
#include "JArray.h"

namespace java {
    namespace lang {
        class Class;
        class String;

        namespace reflect {
#ifdef _java_generics
            class Type;
            class TypeVariable;
#endif

            class Method : public Object {
            public:
                static Class *class$;
                static jmethodID *_mids;
                static jclass initializeClass(bool);

                explicit Method(jobject obj) : Object(obj) {
                    initializeClass(false);
                }
                Method(const Method& obj) : Object(obj) {}

                int getModifiers() const;
                Class getReturnType() const;
                String getName() const;
                JArray<Class> getParameterTypes() const;
                JArray<Class> getExceptionTypes() const;
                Class getDeclaringClass() const;
                bool isSynthetic() const;
                bool isBridge() const;
#ifdef _java_generics
                JArray<TypeVariable> getTypeParameters() const;
                JArray<Type> getGenericExceptionTypes() const;
                JArray<Type> getGenericParameterTypes() const;
                Type getGenericReturnType() const;
#endif
            };

            DECLARE_TYPE(Method);

            class t_Method {
            public:
                PyObject_HEAD
                Method object;
                static PyObject *wrap_Object(const Method& object);
                static PyObject *wrap_jobject(const jobject& object);
            };
        }
    }
}

#endif /* _Method_H */
