# OpenGL XML API Registry

This directory contains the OpenGL, GLX, and WGL XML API registries, in
gl.xml, glx.xml, and wgl.xml respectively. They are used to reserve
enumerant ranges for vendors working on new extensions, to register
extension interfaces when an extension is published, and to generate the
Khronos-supplied header files in ../api .

The canonical versions are always found in the master branch of the github
repository at https://github.com/KhronosGroup/OpenGL-Registry

The 'validate' Makefile target uses the 'jing' tool to confirm that each XML
file is structurally valid and conforms to the registry schema in
registry.rnc. The schema is described in detail in readme.pdf.

The 'default' Makefile target generates updated headers in ../api/ from the
XML files.

Note that while there are targets for ../api/{gl.h,glx.h,wgl.h} in
genglvnd.py and genheaders.py, these targets are not generated by default
and are experimental. At present, you should use the versions of these
headers shipped with your OS or IHV SDK.
