
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPlainTextDocumentLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPlainTextDocumentLayout>
#include <QChildEvent>
#include <QEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPainter>
#include <QPointF>
#include <QRectF>
#include <QSizeF>
#include <QTextBlock>
#include <QTextCharFormat>
#include <QTextDocument>
#include <QTextFormat>
#include <QTextFrame>
#include <QTextInlineObject>
#include <QTextObjectInterface>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPlainTextDocumentLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPlainTextDocumentLayout::staticMetaObject);
}


// QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)


static void _init_f_blockBoundingRect_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_blockBoundingRect_c2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout *)cls)->blockBoundingRect (arg1));
}


// int QPlainTextDocumentLayout::cursorWidth()


static void _init_f_cursorWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->cursorWidth ());
}


// QSizeF QPlainTextDocumentLayout::documentSize()


static void _init_f_documentSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_documentSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QPlainTextDocumentLayout *)cls)->documentSize ());
}


// void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)


static void _init_f_draw_6787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_draw_6787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QAbstractTextDocumentLayout::PaintContext &arg2 = gsi::arg_reader<const QAbstractTextDocumentLayout::PaintContext & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout *)cls)->draw (arg1, arg2);
}


// void QPlainTextDocumentLayout::ensureBlockLayout(const QTextBlock &block)


static void _init_f_ensureBlockLayout_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ensureBlockLayout_c2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout *)cls)->ensureBlockLayout (arg1);
}


// QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)


static void _init_f_frameBoundingRect_c1615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_frameBoundingRect_c1615 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextFrame *arg1 = gsi::arg_reader<QTextFrame * >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout *)cls)->frameBoundingRect (arg1));
}


// int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)


static void _init_f_hitTest_c4147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_hitTest_c4147 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & >() (args, heap);
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->hitTest (arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref()));
}


// int QPlainTextDocumentLayout::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->pageCount ());
}


// void QPlainTextDocumentLayout::requestUpdate()


static void _init_f_requestUpdate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_requestUpdate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout *)cls)->requestUpdate ();
}


// void QPlainTextDocumentLayout::setCursorWidth(int width)


static void _init_f_setCursorWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout *)cls)->setCursorWidth (arg1);
}


// static QString QPlainTextDocumentLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::tr (arg1, arg2));
}


// static QString QPlainTextDocumentLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::tr (arg1, arg2, arg3));
}


// static QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::trUtf8 (arg1, arg2));
}


// static QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPlainTextDocumentLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Method QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis is a reimplementation of QAbstractTextDocumentLayout::blockBoundingRect", true, &_init_f_blockBoundingRect_c2306, &_call_f_blockBoundingRect_c2306);
  methods += new qt_gsi::GenericMethod (":cursorWidth", "@brief Method int QPlainTextDocumentLayout::cursorWidth()\n", true, &_init_f_cursorWidth_c0, &_call_f_cursorWidth_c0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@brief Method QSizeF QPlainTextDocumentLayout::documentSize()\nThis is a reimplementation of QAbstractTextDocumentLayout::documentSize", true, &_init_f_documentSize_c0, &_call_f_documentSize_c0);
  methods += new qt_gsi::GenericMethod ("draw", "@brief Method void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)\nThis is a reimplementation of QAbstractTextDocumentLayout::draw", false, &_init_f_draw_6787, &_call_f_draw_6787);
  methods += new qt_gsi::GenericMethod ("ensureBlockLayout", "@brief Method void QPlainTextDocumentLayout::ensureBlockLayout(const QTextBlock &block)\n", true, &_init_f_ensureBlockLayout_c2306, &_call_f_ensureBlockLayout_c2306);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Method QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)\nThis is a reimplementation of QAbstractTextDocumentLayout::frameBoundingRect", true, &_init_f_frameBoundingRect_c1615, &_call_f_frameBoundingRect_c1615);
  methods += new qt_gsi::GenericMethod ("hitTest", "@brief Method int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)\nThis is a reimplementation of QAbstractTextDocumentLayout::hitTest", true, &_init_f_hitTest_c4147, &_call_f_hitTest_c4147);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Method int QPlainTextDocumentLayout::pageCount()\nThis is a reimplementation of QAbstractTextDocumentLayout::pageCount", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
  methods += new qt_gsi::GenericMethod ("requestUpdate", "@brief Method void QPlainTextDocumentLayout::requestUpdate()\n", false, &_init_f_requestUpdate_0, &_call_f_requestUpdate_0);
  methods += new qt_gsi::GenericMethod ("setCursorWidth|cursorWidth=", "@brief Method void QPlainTextDocumentLayout::setCursorWidth(int width)\n", false, &_init_f_setCursorWidth_767, &_call_f_setCursorWidth_767);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPlainTextDocumentLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSizeF & > ("documentSizeChanged(const QSizeF &)", "documentSizeChanged", gsi::arg("newSize"), "@brief Signal declaration for QPlainTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("pageCountChanged(int)", "pageCountChanged", gsi::arg("newPages"), "@brief Signal declaration for QPlainTextDocumentLayout::pageCountChanged(int newPages)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRectF & > ("update(const QRectF &)", "update", gsi::arg("arg1"), "@brief Signal declaration for QPlainTextDocumentLayout::update(const QRectF &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QTextBlock & > ("updateBlock(const QTextBlock &)", "updateBlock", gsi::arg("block"), "@brief Signal declaration for QPlainTextDocumentLayout::updateBlock(const QTextBlock &block)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPlainTextDocumentLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPlainTextDocumentLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractTextDocumentLayout> &qtdecl_QAbstractTextDocumentLayout ();

qt_gsi::QtNativeClass<QPlainTextDocumentLayout> decl_QPlainTextDocumentLayout (qtdecl_QAbstractTextDocumentLayout (), "QtGui", "QPlainTextDocumentLayout_Native",
  methods_QPlainTextDocumentLayout (),
  "@hide\n@alias QPlainTextDocumentLayout");

GSI_QTGUI_PUBLIC gsi::Class<QPlainTextDocumentLayout> &qtdecl_QPlainTextDocumentLayout () { return decl_QPlainTextDocumentLayout; }

}


class QPlainTextDocumentLayout_Adaptor : public QPlainTextDocumentLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPlainTextDocumentLayout_Adaptor();

  //  [adaptor ctor] QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document)
  QPlainTextDocumentLayout_Adaptor(QTextDocument *document) : QPlainTextDocumentLayout(document)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QTextCharFormat QPlainTextDocumentLayout::format(int pos)
  QTextCharFormat fp_QPlainTextDocumentLayout_format_767 (int pos) {
    return QPlainTextDocumentLayout::format(pos);
  }

  //  [expose] int QPlainTextDocumentLayout::formatIndex(int pos)
  int fp_QPlainTextDocumentLayout_formatIndex_767 (int pos) {
    return QPlainTextDocumentLayout::formatIndex(pos);
  }

  //  [expose] int QPlainTextDocumentLayout::receivers(const char *signal)
  int fp_QPlainTextDocumentLayout_receivers_c1731 (const char *signal) const {
    return QPlainTextDocumentLayout::receivers(signal);
  }

  //  [expose] QObject *QPlainTextDocumentLayout::sender()
  QObject * fp_QPlainTextDocumentLayout_sender_c0 () const {
    return QPlainTextDocumentLayout::sender();
  }

  //  [adaptor impl] QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)
  QRectF cbs_blockBoundingRect_c2306_0(const QTextBlock &block) const
  {
    return QPlainTextDocumentLayout::blockBoundingRect(block);
  }

  virtual QRectF blockBoundingRect(const QTextBlock &block) const
  {
    if (cb_blockBoundingRect_c2306_0.can_issue()) {
      return cb_blockBoundingRect_c2306_0.issue<QPlainTextDocumentLayout_Adaptor, QRectF, const QTextBlock &>(&QPlainTextDocumentLayout_Adaptor::cbs_blockBoundingRect_c2306_0, block);
    } else {
      return QPlainTextDocumentLayout::blockBoundingRect(block);
    }
  }

  //  [adaptor impl] QSizeF QPlainTextDocumentLayout::documentSize()
  QSizeF cbs_documentSize_c0_0() const
  {
    return QPlainTextDocumentLayout::documentSize();
  }

  virtual QSizeF documentSize() const
  {
    if (cb_documentSize_c0_0.can_issue()) {
      return cb_documentSize_c0_0.issue<QPlainTextDocumentLayout_Adaptor, QSizeF>(&QPlainTextDocumentLayout_Adaptor::cbs_documentSize_c0_0);
    } else {
      return QPlainTextDocumentLayout::documentSize();
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)
  void cbs_draw_6787_0(QPainter *arg1, const QAbstractTextDocumentLayout::PaintContext &arg2)
  {
    QPlainTextDocumentLayout::draw(arg1, arg2);
  }

  virtual void draw(QPainter *arg1, const QAbstractTextDocumentLayout::PaintContext &arg2)
  {
    if (cb_draw_6787_0.can_issue()) {
      cb_draw_6787_0.issue<QPlainTextDocumentLayout_Adaptor, QPainter *, const QAbstractTextDocumentLayout::PaintContext &>(&QPlainTextDocumentLayout_Adaptor::cbs_draw_6787_0, arg1, arg2);
    } else {
      QPlainTextDocumentLayout::draw(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QPlainTextDocumentLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPlainTextDocumentLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPlainTextDocumentLayout_Adaptor, bool, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPlainTextDocumentLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPlainTextDocumentLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPlainTextDocumentLayout_Adaptor, bool, QObject *, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPlainTextDocumentLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)
  QRectF cbs_frameBoundingRect_c1615_0(QTextFrame *arg1) const
  {
    return QPlainTextDocumentLayout::frameBoundingRect(arg1);
  }

  virtual QRectF frameBoundingRect(QTextFrame *arg1) const
  {
    if (cb_frameBoundingRect_c1615_0.can_issue()) {
      return cb_frameBoundingRect_c1615_0.issue<QPlainTextDocumentLayout_Adaptor, QRectF, QTextFrame *>(&QPlainTextDocumentLayout_Adaptor::cbs_frameBoundingRect_c1615_0, arg1);
    } else {
      return QPlainTextDocumentLayout::frameBoundingRect(arg1);
    }
  }

  //  [adaptor impl] int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)
  int cbs_hitTest_c4147_0(const QPointF &arg1, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2) const
  {
    return QPlainTextDocumentLayout::hitTest(arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref());
  }

  virtual int hitTest(const QPointF &arg1, Qt::HitTestAccuracy arg2) const
  {
    if (cb_hitTest_c4147_0.can_issue()) {
      return cb_hitTest_c4147_0.issue<QPlainTextDocumentLayout_Adaptor, int, const QPointF &, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type &>(&QPlainTextDocumentLayout_Adaptor::cbs_hitTest_c4147_0, arg1, qt_gsi::CppToQtAdaptor<Qt::HitTestAccuracy>(arg2));
    } else {
      return QPlainTextDocumentLayout::hitTest(arg1, arg2);
    }
  }

  //  [adaptor impl] int QPlainTextDocumentLayout::pageCount()
  int cbs_pageCount_c0_0() const
  {
    return QPlainTextDocumentLayout::pageCount();
  }

  virtual int pageCount() const
  {
    if (cb_pageCount_c0_0.can_issue()) {
      return cb_pageCount_c0_0.issue<QPlainTextDocumentLayout_Adaptor, int>(&QPlainTextDocumentLayout_Adaptor::cbs_pageCount_c0_0);
    } else {
      return QPlainTextDocumentLayout::pageCount();
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPlainTextDocumentLayout::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPlainTextDocumentLayout_Adaptor, QChildEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPlainTextDocumentLayout::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPlainTextDocumentLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPlainTextDocumentLayout_Adaptor, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPlainTextDocumentLayout::customEvent(arg1);
    }
  }

  //  [emitter impl] void QPlainTextDocumentLayout::destroyed(QObject *)
  void emitter_QPlainTextDocumentLayout_destroyed_1302(QObject *arg1)
  {
    emit QPlainTextDocumentLayout::destroyed(arg1);
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPlainTextDocumentLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPlainTextDocumentLayout_Adaptor, const char *>(&QPlainTextDocumentLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPlainTextDocumentLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)
  void cbs_documentChanged_2085_0(int from, int arg2, int charsAdded)
  {
    QPlainTextDocumentLayout::documentChanged(from, arg2, charsAdded);
  }

  virtual void documentChanged(int from, int arg2, int charsAdded)
  {
    if (cb_documentChanged_2085_0.can_issue()) {
      cb_documentChanged_2085_0.issue<QPlainTextDocumentLayout_Adaptor, int, int, int>(&QPlainTextDocumentLayout_Adaptor::cbs_documentChanged_2085_0, from, arg2, charsAdded);
    } else {
      QPlainTextDocumentLayout::documentChanged(from, arg2, charsAdded);
    }
  }

  //  [emitter impl] void QPlainTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)
  void emitter_QPlainTextDocumentLayout_documentSizeChanged_1875(const QSizeF &newSize)
  {
    emit QPlainTextDocumentLayout::documentSizeChanged(newSize);
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  void cbs_drawInlineObject_8199_0(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
  }

  virtual void drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    if (cb_drawInlineObject_8199_0.can_issue()) {
      cb_drawInlineObject_8199_0.issue<QPlainTextDocumentLayout_Adaptor, QPainter *, const QRectF &, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_drawInlineObject_8199_0, painter, rect, object, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }
  }

  //  [emitter impl] void QPlainTextDocumentLayout::pageCountChanged(int newPages)
  void emitter_QPlainTextDocumentLayout_pageCountChanged_767(int newPages)
  {
    emit QPlainTextDocumentLayout::pageCountChanged(newPages);
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_positionInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::positionInlineObject(item, posInDocument, format);
  }

  virtual void positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_positionInlineObject_5127_0.can_issue()) {
      cb_positionInlineObject_5127_0.issue<QPlainTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_positionInlineObject_5127_0, item, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_resizeInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
  }

  virtual void resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_resizeInlineObject_5127_0.can_issue()) {
      cb_resizeInlineObject_5127_0.issue<QPlainTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_resizeInlineObject_5127_0, item, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPlainTextDocumentLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPlainTextDocumentLayout_Adaptor, QTimerEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPlainTextDocumentLayout::timerEvent(arg1);
    }
  }

  //  [emitter impl] void QPlainTextDocumentLayout::update(const QRectF &)
  void emitter_QPlainTextDocumentLayout_update_1862(const QRectF &arg1)
  {
    emit QPlainTextDocumentLayout::update(arg1);
  }

  //  [emitter impl] void QPlainTextDocumentLayout::updateBlock(const QTextBlock &block)
  void emitter_QPlainTextDocumentLayout_updateBlock_2306(const QTextBlock &block)
  {
    emit QPlainTextDocumentLayout::updateBlock(block);
  }

  gsi::Callback cb_blockBoundingRect_c2306_0;
  gsi::Callback cb_documentSize_c0_0;
  gsi::Callback cb_draw_6787_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_frameBoundingRect_c1615_0;
  gsi::Callback cb_hitTest_c4147_0;
  gsi::Callback cb_pageCount_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_documentChanged_2085_0;
  gsi::Callback cb_drawInlineObject_8199_0;
  gsi::Callback cb_positionInlineObject_5127_0;
  gsi::Callback cb_resizeInlineObject_5127_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPlainTextDocumentLayout_Adaptor::~QPlainTextDocumentLayout_Adaptor() { }

//  Constructor QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document) (adaptor class)

static void _init_ctor_QPlainTextDocumentLayout_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QPlainTextDocumentLayout_Adaptor> ();
}

static void _call_ctor_QPlainTextDocumentLayout_Adaptor_1955 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  ret.write<QPlainTextDocumentLayout_Adaptor *> (new QPlainTextDocumentLayout_Adaptor (arg1));
}


// QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)

static void _init_cbs_blockBoundingRect_c2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_blockBoundingRect_c2306_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = args.read<const QTextBlock & > (heap);
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_blockBoundingRect_c2306_0 (arg1));
}

static void _set_callback_cbs_blockBoundingRect_c2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_blockBoundingRect_c2306_0 = cb;
}


// void QPlainTextDocumentLayout::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPlainTextDocumentLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPlainTextDocumentLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->emitter_QPlainTextDocumentLayout_destroyed_1302 (arg1);
}


// void QPlainTextDocumentLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)

static void _init_cbs_documentChanged_2085_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("charsAdded");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_documentChanged_2085_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_documentChanged_2085_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_documentChanged_2085_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_documentChanged_2085_0 = cb;
}


// QSizeF QPlainTextDocumentLayout::documentSize()

static void _init_cbs_documentSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_cbs_documentSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_documentSize_c0_0 ());
}

static void _set_callback_cbs_documentSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_documentSize_c0_0 = cb;
}


// emitter void QPlainTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)

static void _init_emitter_documentSizeChanged_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSize");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_documentSizeChanged_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->emitter_QPlainTextDocumentLayout_documentSizeChanged_1875 (arg1);
}


// void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)

static void _init_cbs_draw_6787_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_draw_6787_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_draw_6787_0 (arg1, arg2);
}

static void _set_callback_cbs_draw_6787_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_draw_6787_0 = cb;
}


// void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)

static void _init_cbs_drawInlineObject_8199_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("object");
  decl->add_arg<QTextInlineObject > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("posInDocument");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("format");
  decl->add_arg<const QTextFormat & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_cbs_drawInlineObject_8199_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  QTextInlineObject arg3 = args.read<QTextInlineObject > (heap);
  int arg4 = args.read<int > (heap);
  const QTextFormat &arg5 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_drawInlineObject_8199_0 (arg1, arg2, arg3, arg4, arg5);
}

static void _set_callback_cbs_drawInlineObject_8199_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_drawInlineObject_8199_0 = cb;
}


// bool QPlainTextDocumentLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed QTextCharFormat QPlainTextDocumentLayout::format(int pos)

static void _init_fp_format_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_fp_format_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_format_767 (arg1));
}


// exposed int QPlainTextDocumentLayout::formatIndex(int pos)

static void _init_fp_formatIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_formatIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_formatIndex_767 (arg1));
}


// QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)

static void _init_cbs_frameBoundingRect_c1615_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_frameBoundingRect_c1615_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextFrame *arg1 = args.read<QTextFrame * > (heap);
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_frameBoundingRect_c1615_0 (arg1));
}

static void _set_callback_cbs_frameBoundingRect_c1615_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_frameBoundingRect_c1615_0 = cb;
}


// int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)

static void _init_cbs_hitTest_c4147_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_cbs_hitTest_c4147_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (heap);
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_hitTest_c4147_0 (arg1, arg2));
}

static void _set_callback_cbs_hitTest_c4147_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_hitTest_c4147_0 = cb;
}


// int QPlainTextDocumentLayout::pageCount()

static void _init_cbs_pageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_pageCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_pageCount_c0_0 ());
}

static void _set_callback_cbs_pageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_pageCount_c0_0 = cb;
}


// emitter void QPlainTextDocumentLayout::pageCountChanged(int newPages)

static void _init_emitter_pageCountChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newPages");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pageCountChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->emitter_QPlainTextDocumentLayout_pageCountChanged_767 (arg1);
}


// void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_positionInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_positionInlineObject_5127_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextInlineObject arg1 = args.read<QTextInlineObject > (heap);
  int arg2 = args.read<int > (heap);
  const QTextFormat &arg3 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_positionInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_positionInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_positionInlineObject_5127_0 = cb;
}


// exposed int QPlainTextDocumentLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_receivers_c1731 (arg1));
}


// void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_resizeInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_resizeInlineObject_5127_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextInlineObject arg1 = args.read<QTextInlineObject > (heap);
  int arg2 = args.read<int > (heap);
  const QTextFormat &arg3 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_resizeInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_resizeInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_resizeInlineObject_5127_0 = cb;
}


// exposed QObject *QPlainTextDocumentLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_sender_c0 ());
}


// void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QPlainTextDocumentLayout::update(const QRectF &)

static void _init_emitter_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QRectF(0., 0., 1000000000., 1000000000.)");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_update_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(0., 0., 1000000000., 1000000000.), heap);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->emitter_QPlainTextDocumentLayout_update_1862 (arg1);
}


// emitter void QPlainTextDocumentLayout::updateBlock(const QTextBlock &block)

static void _init_emitter_updateBlock_2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_updateBlock_2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ((QPlainTextDocumentLayout_Adaptor *)cls)->emitter_QPlainTextDocumentLayout_updateBlock_2306 (arg1);
}


namespace gsi
{

gsi::Class<QPlainTextDocumentLayout> &qtdecl_QPlainTextDocumentLayout ();

static gsi::Methods methods_QPlainTextDocumentLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document)\nThis method creates an object of class QPlainTextDocumentLayout.", &_init_ctor_QPlainTextDocumentLayout_Adaptor_1955, &_call_ctor_QPlainTextDocumentLayout_Adaptor_1955);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@hide", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Virtual method QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0, &_set_callback_cbs_blockBoundingRect_c2306_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPlainTextDocumentLayout::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPlainTextDocumentLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPlainTextDocumentLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPlainTextDocumentLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*documentChanged", "@hide", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0);
  methods += new qt_gsi::GenericMethod ("*documentChanged", "@brief Virtual method void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0, &_set_callback_cbs_documentChanged_2085_0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@hide", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@brief Virtual method QSizeF QPlainTextDocumentLayout::documentSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0, &_set_callback_cbs_documentSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_documentSizeChanged", "@brief Emitter for signal void QPlainTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nCall this method to emit this signal.", false, &_init_emitter_documentSizeChanged_1875, &_call_emitter_documentSizeChanged_1875);
  methods += new qt_gsi::GenericMethod ("draw", "@hide", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0);
  methods += new qt_gsi::GenericMethod ("draw", "@brief Virtual method void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0, &_set_callback_cbs_draw_6787_0);
  methods += new qt_gsi::GenericMethod ("*drawInlineObject", "@hide", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0);
  methods += new qt_gsi::GenericMethod ("*drawInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0, &_set_callback_cbs_drawInlineObject_8199_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPlainTextDocumentLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*format", "@brief Method QTextCharFormat QPlainTextDocumentLayout::format(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_format_767, &_call_fp_format_767);
  methods += new qt_gsi::GenericMethod ("*formatIndex", "@brief Method int QPlainTextDocumentLayout::formatIndex(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_formatIndex_767, &_call_fp_formatIndex_767);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@hide", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Virtual method QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0, &_set_callback_cbs_frameBoundingRect_c1615_0);
  methods += new qt_gsi::GenericMethod ("hitTest", "@hide", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0);
  methods += new qt_gsi::GenericMethod ("hitTest", "@brief Virtual method int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0, &_set_callback_cbs_hitTest_c4147_0);
  methods += new qt_gsi::GenericMethod ("pageCount", "@hide", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Virtual method int QPlainTextDocumentLayout::pageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0, &_set_callback_cbs_pageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_pageCountChanged", "@brief Emitter for signal void QPlainTextDocumentLayout::pageCountChanged(int newPages)\nCall this method to emit this signal.", false, &_init_emitter_pageCountChanged_767, &_call_emitter_pageCountChanged_767);
  methods += new qt_gsi::GenericMethod ("*positionInlineObject", "@hide", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*positionInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0, &_set_callback_cbs_positionInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPlainTextDocumentLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resizeInlineObject", "@hide", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*resizeInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0, &_set_callback_cbs_resizeInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPlainTextDocumentLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_update", "@brief Emitter for signal void QPlainTextDocumentLayout::update(const QRectF &)\nCall this method to emit this signal.", false, &_init_emitter_update_1862, &_call_emitter_update_1862);
  methods += new qt_gsi::GenericMethod ("emit_updateBlock", "@brief Emitter for signal void QPlainTextDocumentLayout::updateBlock(const QTextBlock &block)\nCall this method to emit this signal.", false, &_init_emitter_updateBlock_2306, &_call_emitter_updateBlock_2306);
  return methods;
}

gsi::Class<QPlainTextDocumentLayout_Adaptor> decl_QPlainTextDocumentLayout_Adaptor (qtdecl_QPlainTextDocumentLayout (), "QtGui", "QPlainTextDocumentLayout",
  methods_QPlainTextDocumentLayout_Adaptor (),
  "@qt\n@brief Binding of QPlainTextDocumentLayout");

}

