// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2014 Konrad Twardowski

#pragma once

#include "../plugins.h"

#include <QComboBox>
#include <QMenu>

class BootEntry final {
public:
	inline static const QString SEPARATOR = "KS:-";
	static QStringList getEntryList() { return m_entryList; }
	static QStringList getProblemList() { return m_problemList; }
	static void initFromConfig();
	static bool setDefault(const QString &name);
	static void showProblemList(QWidget *parent);
private:
	Q_DISABLE_COPY(BootEntry)
	explicit BootEntry() { }
	inline static QStringList m_entryList = QStringList();
	inline static QStringList m_problemList = QStringList();
};

class BootEntryAction final: public Action {
public:
	explicit BootEntryAction(const QString &entry);
	virtual void initContainerWidget() override { }
	virtual bool onAction() override;
private:
	Q_DISABLE_COPY(BootEntryAction)
	QString m_entry;
};

class BootEntryComboBox final: public QComboBox {
public:
	explicit BootEntryComboBox();
	void updateBootEntryList();
private:
	Q_DISABLE_COPY(BootEntryComboBox)
};

class BootEntryMenu final: public QMenu {
public:
	explicit BootEntryMenu(QWidget *parent);
private:
	Q_DISABLE_COPY(BootEntryMenu)
	void onUpdate();
};
