
#include "config.h"

#include <QTemporaryFile>
#include <QTest>

class ConfigTest: public QObject {
	Q_OBJECT
private slots:
	void initTestCase();
	void cleanupTestCase();

	void desktopEntryTest();
};

// private slots:

void ConfigTest::initTestCase() {
	Config::init();
}

void ConfigTest::cleanupTestCase() {
	Config::shutDown();
}

void ConfigTest::desktopEntryTest() {
	QString expectedExec = "test-exec";
	QString expectedKeywords = "test-keywords";

	QTemporaryFile desktopEntryFile(QApplication::applicationDirPath() + "/configtest-XXXXXX.desktop");
	desktopEntryFile.open();

	UPath desktopEntryPath = desktopEntryFile.fileName().toStdString();

	std::shared_ptr<QSettings> writer(Config::createDesktopEntry(desktopEntryPath));
	writer->setValue("Exec", expectedExec);
	writer->setValue("Keywords", expectedKeywords);
	writer->endGroup();

	writer->beginGroup("X-Test Group");
	writer->setValue("Foo", "Bar");
	writer->setValue("Unicode", "Żółw");
	writer->endGroup();

	writer->sync();

	std::shared_ptr<QSettings> reader(Config::openDesktopEntry(desktopEntryPath));
	QCOMPARE(reader->value("Exec", ""), expectedExec);
	QCOMPARE(reader->value("Keywords", ""), expectedKeywords);
	reader->endGroup();

	reader->beginGroup("X-Test Group");
	QCOMPARE(reader->value("Foo", ""), "Bar");
	QCOMPARE(reader->value("Unicode", ""), "Żółw");
	reader->endGroup();
}

QTEST_MAIN(ConfigTest)
#include "configtest.moc"
