BEGIN;
-- Czech chart of accounts
-- Tomas.Fencl@centrum.cz
--
-- 3.3.2008
-- Vladimir Botka vlado@netng.org
-- customized for http://www.ledgersmb.org/
-- encoding UTF-8
--
-- Needs to be converted to use new framework.  Works, though, for now.
SELECT account_heading_save(NULL, accno, description, NULL)
  FROM (VALUES ('0000', '-----'),
               ('3000', 'Dlouhodobý hmotný majetek neodpisovaný'),
               ('2000', 'Dlouhodobý Hmotný majetek odpisovaný'),
               ('10000', 'Zásoby'),
               ('11000', 'Materiál'),
               ('12000', 'Zásoby vlastní výroby'),
               ('31000', 'Pohledávky'),
               ('32000', 'Závazky'),
               ('37000', 'Jiné pohledávky a závazky'),
               ('45000', 'Rezervy'),
               ('6000', 'Dlouhodobý finanční majetek'),
               ('47000', 'Dlouhodobé závazky'),
               ('13000', 'Zboží'),
               ('20000', 'Finanční účty'),
               ('22000', 'Účty v bankách'),
               ('23000', 'Běžné bankovní úvěry'),
               ('25000', 'Krátkodobý finanční majetek'),
               ('26000', 'Převody mezi finančními účty'),
               ('29000', 'Opravné položky ke krátkodobému finančnímu majetku'),
               ('30000', 'Zúčtovací vztahy'),
               ('34000', 'Zůčtování daní a dotací'),
               ('35000', 'Pohledávky ke společníkům a sdružení'),
               ('36000', 'Závazky ke společníkům a sdružení'),
               ('38000', 'Přechodné účty aktiv a pasiv'),
               ('40000', 'Kapitálové účty a dlouhodobé závazky'),
               ('41000', 'Základní kapitál a kapitálové fondy'),
               ('42000', 'Fondy ze zisku a převedené hospodářské výsledky'),
               ('43000', 'Hospodářský výsledek'),
               ('46000', 'Bankovní úvěry'),
               ('55000', 'Odpisy, rezervy a opravné položky provozních nákladů'),
               ('57000', 'Rezervy a opravné položky finančních nákladù'),
               ('59000', 'Daně z příjmù a převodové účty'),
               ('65000', 'Zúčtování rezerv a opravných položek provozních výnosů'),
               ('67000', 'Zúčtování rezerv a opravných položek finančních výnosů'),
               ('69000', 'Převodové účty'),
               ('70000', 'Účty rozvažné')
       ) h (accno, description);

SELECT account__save(null, accno, description, category, gifi_accno, null, contra, false, string_to_array(link, ':'), false, false)
  FROM (VALUES (10001, '1000', 'Dlouhodobý nehmotný majetek', 'A', 'A', 'AP_amount', '', false),
               (10033, '3200', 'Umělecká díla a sbírky', 'A', 'A', 'AP_amount', '', false),
               (10005, '1200', 'Nehmotné výsledky výzkumu a vývoje', 'A', 'A', 'AP_amount', '', false),
               (10007, '1300', 'Software', 'A', 'A', 'AP_amount', '', false),
               (10009, '1400', 'Ocenitelná práva', 'A', 'A', 'AP_amount', '', false),
               (10011, '1800', 'Drobný dlouhodobý nehmotný majetek', 'A', 'A', 'AP_amount', '', false),
               (10013, '1900', 'Ostatní dlouhodobý nehmotný majetek', 'A', 'A', 'AP_amount', '', false),
               (10017, '2100', 'Stavby', 'A', 'A', 'AP_amount', '', false),
               (10025, '2800', 'Drobný dlouhodobý hmotný majetek', 'A', 'A', 'AP_amount', '', false),
               (10027, '2900', 'Ostatní dlouhodobý hmotný majetek', 'A', 'A', 'AP_amount', '', false),
               (10031, '3100', 'Pozemky', 'A', 'A', 'AP_amount', '', false),
               (10041, '5000', 'Poskytnuté zálohy na dlouhodobý nehmotný a hmotný majetek', 'A', 'A', '', '', false),
               (10043, '5100', 'Poskytnuté zálohy na dlouhodobý nehmotný majetek', 'A', 'A', '', '', false),
               (10045, '5200', 'Poskytnuté zálohy na dlouhodobý hmotný majetek', 'A', 'A', '', '', false),
               (10049, '6100', 'Podílové cenné papíry a vklady v podnicích s rozhodujícím', 'A', 'A', '', '', false),
               (10051, '6200', 'Podílové cenné papíry a vklady v podnicích s podstatným', 'A', 'A', '', '', false),
               (10053, '6300', 'Ostatní dlouhodobé cenné papíry a vklady', 'A', 'A', '', '', false),
               (10067, '7300', 'Oprávky k softwaru', 'A', 'A', '', '', false),
               (10071, '7800', 'Oprávky k drobnému dlouhodobému nehmotnému majetku', 'A', 'A', '', '', false),
               (10073, '7900', 'Oprávky k ostatnímu dlouhodobému nehmotnému majetku', 'A', 'A', '', '', false),
               (10075, '8000', 'Oprávky k dlouhodobému hmotnému majetku', 'H', 'A', '', '', false),
               (10077, '8100', 'Oprávky ke stavbám', 'A', 'A', '', '', false),
               (10085, '8800', 'Oprávky k drobnému dlouhodobému hmotnému majetku', 'A', 'A', '', '', false),
               (10087, '8900', 'Oprávky k ostatnímu dlouhodobému hmotnému majetku', 'A', 'A', '', '', false),
               (10121, '12200', 'Polotovary vlastní výroby', 'A', 'A', 'IC', '', false),
               (10123, '12300', 'Výrobky', 'A', 'A', 'IC', '', false),
               (10151, '21000', 'Peníze', 'A', 'A', 'AR_paid:AP_paid', '', false),
               (10153, '21100', 'Pokladna', 'A', 'A', 'AR_paid:AP_paid', '', false),
               (10155, '21300', 'Ceniny', 'A', 'A', 'AR_paid:AP_paid', '', false),
               (10171, '24100', 'Emitované krátkodobé dluhopisy', 'A', 'L', '', '', false),
               (10177, '25100', 'Majetkové cenné papíry', 'A', 'A', '', '', false),
               (10179, '25200', 'Vlastní akcie a vlastní obchodní podíly', 'A', 'A', '', '', false),
               (10183, '25500', 'Vlastní dluhopisy', 'A', 'A', '', '', false),
               (10185, '25600', 'Ostatní cenné papíry', 'A', 'A', '', '', false),
               (10205, '31300', 'Pohledávky za eskontované cenné papíry', 'A', 'A', 'AR', '', false),
               (10207, '31400', 'Poskytnuté provozní zálohy', 'A', 'A', 'AR', '', false),
               (10209, '31500', 'Ostatní pohledávky', 'A', 'A', 'AR', '', false),
               (10213, '32100', 'Dodavatelé', 'A', 'L', 'AP', '', false),
               (10219, '32500', 'Ostatní závazky', 'A', 'L', 'AP', '', false),
               (10019, '2200', 'Samostatné movité věci a soubory movitých věcí', 'A', 'A', 'AP_amount', '', false),
               (10021, '2500', 'Pěstitelské celky trvalých porostů', 'A', 'A', 'AP_amount', '', false),
               (10023, '2600', 'Základní stádo a tažná zvířata', 'A', 'A', 'AP_amount', '', false),
               (10035, '4000', 'Pořízení dlouhodobého nehmotného a hmotného majetku', 'A', 'A', 'AP_amount', '', false),
               (10139, '19200', 'Opravná položka k nedokonèené výrobì', 'A', 'A', '', '', false),
               (10255, '34700', 'Ostatní dotace', 'A', 'L', '', '', false),
               (10261, '35300', 'Pohledávky za upsaný vlastní kapitál', 'A', 'A', '', '', false),
               (10287, '37300', 'Nakoupené opce', 'A', 'A', '', '', false),
               (10289, '37400', 'Prodané opce', 'A', 'L', '', '', false),
               (10295, '37800', 'Jiné pohledávky', 'A', 'A', 'AR', '', false),
               (10297, '37900', 'Jiné závazky', 'A', 'L', 'AP', '', false),
               (10311, '38600', 'Kursové rozdíly aktivní', 'A', 'A', '', '', false),
               (10313, '38700', 'Kursové rozdíly pasívní', 'A', 'L', '', '', false),
               (10331, '41100', 'Základní kapitál', 'A', 'Q', '', '', false),
               (10335, '41300', 'Ostatní kapitálové fondy', 'A', 'Q', '', '', false),
               (10341, '42100', 'Zákonný rezervní fond', 'A', 'Q', '', '', false),
               (10345, '42300', 'Statutární fondy', 'A', 'Q', '', '', false),
               (10347, '42700', 'Ostatní fondy', 'A', 'Q', '', '', false),
               (10359, '45100', 'Rezervy zákonné', 'A', 'Q', '', '', false),
               (10361, '45400', 'Rezerva na kursové ztráty', 'A', 'Q', '', '', false),
               (10363, '45900', 'Ostatní rezervy', 'A', 'Q', '', '', false),
               (10373, '47300', 'Emitované dluhopisy', 'A', 'L', '', '', false),
               (10375, '47400', 'Závazky z pronájmu', 'A', 'L', 'AP', '', false),
               (10381, '47900', 'Ostatní dlouhodobé závazky', 'A', 'L', 'AP', '', false),
               (10383, '49000', 'Individuální podnikatel', 'A', 'Q', '', '', false),
               (10401, '51200', 'Cestovné', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10403, '51300', 'Náklady na reprezentaci', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10407, '52000', 'Osobní náklady', 'A', 'E', 'AP_amount', '', false),
               (10409, '52100', 'Mzdové náklady', 'A', 'E', 'AP_amount', '', false),
               (10419, '52600', 'Sociální náklady individuálního podnikatele', 'A', 'E', 'AP_amount', '', false),
               (10421, '52700', 'Zákonné sociální náklady', 'A', 'E', 'AP_amount', '', false),
               (10423, '52800', 'Ostatní sociální náklady', 'A', 'E', 'AP_amount', '', false),
               (10433, '54000', 'Jiné provozní náklady', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10437, '54200', 'Prodaný materiál', 'A', 'E', 'IC_expense', '', false),
               (10439, '54300', 'Dary', 'A', 'E', '', '', false),
               (10441, '54400', 'Smluvní pokuty a úroky z prodlení', 'A', 'E', 'AP_amount', '', false),
               (10443, '54500', 'Ostatní pokuty a penále', 'A', 'E', 'AP_amount', '', false),
               (10445, '54600', 'Odpis pohledávky', 'A', 'E', '', '', false),
               (10447, '54800', 'Ostatní provozní náklady', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10451, '55100', 'Odpisy dlouhodobého nehmotného a hmotného majetku', 'A', 'E', '', '', false),
               (10453, '55200', 'Tvorba zákonných rezerv', 'A', 'E', '', '', false),
               (10455, '55400', 'Tvorba ostatních rezerv', 'A', 'E', '', '', false),
               (10467, '56100', 'Prodané cenné papíry a vklady', 'A', 'E', '', '', false),
               (10469, '56200', 'Úroky', 'A', 'E', '', '', false),
               (10471, '56300', 'Kursové ztráty', 'A', 'E', '', '', false),
               (10477, '57400', 'Tvorba rezerv', 'A', 'E', '', '', false),
               (10487, '58400', 'Tvorba rezerv', 'A', 'E', '', '', false),
               (10529, '62000', 'Aktivace', 'A', 'I', '', '', false),
               (10537, '62400', 'Aktivace dlouhodobého hmotného majetku', 'A', 'I', '', '', false),
               (10539, '64000', 'Jiné provozní výnosy.', 'A', 'I', 'AR_amount:IC_sale:IC_income', '', false),
               (10547, '64600', 'Výnosy z odepsaných pohledávek', 'A', 'I', 'AR_amount', '', false),
               (10549, '64800', 'Jiné provozní výnosy', 'A', 'I', 'AR_amount:IC_sale:IC_income', '', false),
               (10569, '66200', 'Úroky', 'A', 'I', '', '', false),
               (10571, '66300', 'Kursové zisky', 'A', 'I', '', '', false),
               (10243, '34311', 'DPH snížená vstup', 'A', 'L', 'AP_tax:IC_taxpart:IC_taxservice', '', false),
               (10245, '34312', 'DPH základní vstup', 'A', 'L', 'AP_tax:IC_taxpart:IC_taxservice', '', false),
               (10247, '34321', 'DPH snížená výstup', 'A', 'L', 'AR_tax:IC_taxpart:IC_taxservice', '', false),
               (10249, '34322', 'DPH základní výstup', 'A', 'L', 'AR_tax:IC_taxpart:IC_taxservice', '', false),
               (10003, '1100', 'Zřizovací výdaje', 'A', 'A', 'AP_amount', '', false),
               (10037, '4100', 'Pořízení dlouhodobého nehmotného majetku', 'A', 'A', 'AP_amount', '', false),
               (10039, '4200', 'Pořízení dlouhodobého hmotného majetku', 'A', 'A', 'AP_amount', '', false),
               (10055, '6600', 'Pùjčky podnikùm ve skupinì', 'A', 'A', '', '', false),
               (10057, '6700', 'Ostatní pùjčky', 'A', 'A', '', '', false),
               (10059, '6900', 'Ostatní dlouhodobý finanční majetek', 'A', 'A', '', '', false),
               (10061, '7000', 'Oprávky k dlouhodobému nehmotnému majetku', 'A', 'A', '', '', false),
               (10063, '7100', 'Oprávky ke zřizovacím výdajùm', 'A', 'A', '', '', false),
               (10065, '7200', 'Oprávky k nehmotným výsledkům výzkumu a vývoje', 'A', 'A', '', '', false),
               (10069, '7400', 'Oprávky k ocenitelným právům', 'A', 'A', '', '', false),
               (10079, '8200', 'Oprávky k samostatným movitým věcem a souborùm movitých věcí', 'A', 'A', '', '', false),
               (10081, '8500', 'Oprávky k pěstitelským celkům trvalých porostů', 'A', 'A', '', '', false),
               (10083, '8600', 'Oprávky k základnímu stádu a tažným zvířatům', 'A', 'A', '', '', false),
               (10089, '9000', 'Opravné položky k dlouhodobému majetku', 'H', 'A', '', '', false),
               (10091, '9100', 'Opravná položka k dlouhodobému nehmotnému majetku', 'A', 'A', '', '', false),
               (10093, '9200', 'Opravná položka k dlouhodobému hmotnému majetku', 'A', 'A', '', '', false),
               (10095, '9300', 'Opravná položka k dlouhodobému nedokončenému nehmotnému', 'A', 'A', '', '', false),
               (10097, '9400', 'Opravná položka k dlouhodobému nedokončenému hmotnému', 'A', 'A', '', '', false),
               (10099, '9500', 'Opravná položka k poskytnutým zálohám', 'A', 'A', '', '', false),
               (10101, '9600', 'Opravná položka k dlouhodobému finančnímu majetku', 'A', 'A', '', '', false),
               (10103, '9700', 'Opravná položka k nabytému majetku', 'A', 'A', '', '', false),
               (10105, '9800', 'Oprávky k opravné položce k nabytému majetku', 'A', 'A', '', '', false),
               (10111, '11100', 'Pořízení materiálu', 'A', 'A', 'IC', '', false),
               (10113, '11200', 'Materiál na skladě', 'A', 'A', 'IC', '', false),
               (10115, '11900', 'Materiál na cestě', 'A', 'A', 'IC', '', false),
               (10119, '12100', 'Nedokončená výroba', 'A', 'A', 'IC', '', false),
               (10125, '12400', 'Zvířata', 'A', 'A', 'IC', '', false),
               (10129, '13100', 'Pořízení zboží', 'A', 'A', 'IC', '', false),
               (10131, '13200', 'Zboží na skladě a v prodejnách', 'A', 'A', 'IC', '', false),
               (10133, '13900', 'Zboží na cestě', 'A', 'A', 'IC', '', false),
               (10135, '19000', 'Opravné položky k zásobám', 'H', 'A', '', '', false),
               (10137, '19100', 'Opravná položka k materiálu', 'A', 'A', '', '', false),
               (10141, '19300', 'Opravná položka k polotovarům vlastní výroby', 'A', 'A', '', '', false),
               (10143, '19400', 'Opravná položka k výrobkùm', 'A', 'A', '', '', false),
               (10145, '19500', 'Opravná položka ke zvířatům', 'A', 'A', '', '', false),
               (10147, '19600', 'Opravná položka ke zboží', 'A', 'A', '', '', false),
               (10159, '22100', 'Bankovní účty', 'A', 'A', 'AR_paid:AP_paid', '', false),
               (10161, '22200', 'Bankovní účty klientù', 'A', 'A', 'AR_paid:AP_paid', '', false),
               (10165, '23100', 'Krátkodobé bankovní úvěry', 'A', 'L', '', '', false),
               (10167, '23200', 'Eskontní úvěry', 'A', 'L', '', '', false),
               (10169, '24000', 'Jiné krátkodobé finanční výpomoci', 'H', 'L', '', '', false),
               (10173, '24900', 'Ostatní krátkodobé finanční výpomoci', 'A', 'L', '', '', false),
               (10181, '25300', 'Dlužné cenné papíry', 'A', 'A', '', '', false),
               (10189, '26100', 'Peníze na cestě', 'A', 'A', '', '', false),
               (10193, '29100', 'Opravná položka k majetkovým cenným papírùm', 'A', 'A', '', '', false),
               (10195, '29300', 'Opravná položka k dlužným cenným papírům', 'A', 'A', '', '', false),
               (10201, '31100', 'Odběratelé', 'A', 'A', 'AR', '', false),
               (10203, '31200', 'Směnky k inkasu', 'A', 'A', 'AR', '', false),
               (10215, '32200', 'Směnky k úhradě', 'A', 'L', 'AP', '', false),
               (10217, '32400', 'Přijaté zálohy', 'A', 'L', 'AP', '', false),
               (10221, '32600', ' Závazky vůči klientům', 'A', 'L', 'AP', '', false),
               (10223, '32700', ' Závazky vůči trhům', 'A', 'L', 'AP', '', false),
               (10225, '33000', 'Zúčtování se zaměstnanci a institucemi', 'H', 'L', '', '', false),
               (10227, '33100', 'Zaměstnanci', 'A', 'L', 'AP', '', false),
               (10229, '33300', 'Ostatní závazky vůči zaměstnancům', 'A', 'L', 'AP', '', false),
               (10231, '33500', 'Pohledávky za zaměstnanci', 'A', 'A', 'AR', '', false),
               (10233, '33600', 'Zůčtování s institucemi sociálního zabezpečení a zp', 'A', 'L', 'AP', '', false),
               (10237, '34100', 'Daň z příjmu', 'A', 'L', '', '', false),
               (10239, '34200', 'Ostatní přímé daně', 'A', 'L', '', '', false),
               (10241, '34300', 'Daň z přidané hodnoty - zúčtování', 'A', 'L', '', '', false),
               (10251, '34500', 'Ostatní daně a poplatky', 'A', 'L', '', '', false),
               (10253, '34600', 'Dotace ze státního rozpočtu', 'A', 'L', '', '', false),
               (10259, '35100', 'Pohledávky k podnikům ve skupině', 'A', 'A', 'AR', '', false),
               (10263, '35400', 'Pohledávky za společníky při úhradě ztráty', 'A', 'A', '', '', false),
               (10265, '35500', 'Ostatní pohledávky za společníky', 'A', 'A', 'AR', '', false),
               (10267, '35800', 'Pohledávky k účastníkùm sdružení', 'A', 'A', 'AR', '', false),
               (10271, '36100', 'Závazky k podnikům ve skupině', 'A', 'L', 'AP', '', false),
               (10273, '36400', 'Závazky ke společníkům při rozdělování zisku', 'A', 'L', 'AP', '', false),
               (10275, '36500', 'Ostatní závazky ke společníkům', 'A', 'L', 'AP', '', false),
               (10277, '36600', 'Závazky ke společníkům a členům družstva ze závislé', 'A', 'L', '', '', false),
               (10279, '36700', 'Závazky z upsaných nesplacených cenných papírů a vkladů', 'A', 'L', '', '', false),
               (10281, '36800', 'Závazky k účastníkům sdružení', 'A', 'L', 'AP', '', false),
               (10285, '37100', 'Odložená daňová pohledávka a závazek', 'A', 'L', '', '', false),
               (10291, '37500', 'Pohledávky z emitovaných dluhopisů', 'A', 'A', '', '', false),
               (10293, '37700', ' Zúčtování obchodů', 'A', 'A', '', '', false),
               (10301, '38100', 'Náklady příštích období', 'A', 'A', 'AP', '', false),
               (10303, '38200', 'Komplexní náklady příštích období', 'A', 'A', 'AP', '', false),
               (10305, '38300', 'Výdaje příštích období', 'A', 'L', '', '', false),
               (10307, '38400', 'Výnosy příštích období', 'A', 'L', 'AR', '', false),
               (10309, '38500', 'Příjmy příštích období', 'A', 'A', '', '', false),
               (10315, '38800', 'Dohadné účty aktivní', 'A', 'A', '', '', false),
               (10317, '38900', 'Dohadné účty pasívní', 'A', 'L', '', '', false),
               (10319, '39000', 'Opravná položka k zúčtovacím vztahům a vnitřní zúčtování', 'H', 'A', '', '', false),
               (10321, '39100', 'Opravná položka k pohledávkám', 'A', 'A', '', '', false),
               (10323, '39500', 'Vnitřní zúčtování', 'A', 'A', '', '', false),
               (10325, '39800', 'Spojovací účet při sdružení', 'A', 'A', '', '', false),
               (10333, '41200', 'Emisní ážio', 'A', 'Q', '', '', false),
               (10337, '41400', 'Oceňovací rozdíly z přecenění majetku a závazků', 'A', 'Q', '', '', false),
               (10343, '42200', 'Nedělitelný fond', 'A', 'Q', '', '', false),
               (10349, '42800', 'Nerozdělený zisk minulých let', 'A', 'Q', '', '', false),
               (10351, '42900', 'Neuhrazená ztráta minulých let', 'A', 'Q', '', '', false),
               (10355, '43100', 'Hospodářský výsledek ve schvalovacím řízení', 'A', 'Q', '', '', false),
               (10367, '46100', 'Bankovní úvěry', 'A', 'L', '', '', false),
               (10371, '47100', 'Dlouhodobé závazky k podnikům ve skupině', 'A', 'L', 'AP', '', false),
               (10377, '47500', 'Dlouhodobé přijaté zálohy', 'A', 'L', 'AP', '', false),
               (10379, '47800', 'Dlouhodobé směnky k úhradě', 'A', 'L', 'AP', '', false),
               (10385, '49100', 'Účet individuálního podnikatele', 'A', 'Q', '', '', false),
               (10387, '50000', 'Spotřebované nákupy', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10389, '50100', 'Spotřeba materiálu', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10391, '50200', 'Spotřeba energie', 'A', 'E', 'AP_amount', '', false),
               (10393, '50300', 'Spotřeba ostatních neskladovatelných dodávek', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10395, '50400', 'Prodané zboží', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10397, '51000', 'Služby', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10399, '51100', 'Opravy a udržování', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10405, '51800', 'Ostatní služby', 'A', 'E', 'AP_amount:IC_expense', '', false),
               (10411, '52200', 'Příjmy společníků a členů družstva ze závislé činnosti', 'A', 'E', 'AP_amount', '', false),
               (10413, '52300', 'Odměny členům orgánů společnosti a družstva', 'A', 'E', 'AP_amount', '', false),
               (10415, '52400', 'Zákonné sociální pojištění', 'A', 'E', 'AP_amount', '', false),
               (10417, '52500', 'Ostatní sociální pojištění', 'A', 'E', 'AP_amount', '', false),
               (10425, '53000', 'Daně a poplatky', 'A', 'E', '', '', false),
               (10427, '53100', 'Daň silniční', 'A', 'E', '', '', false),
               (10429, '53200', 'Daň z nemovitostí', 'A', 'E', '', '', false),
               (10431, '53800', 'Ostatní daně a poplatky', 'A', 'E', '', '', false),
               (10435, '54100', 'Zůstatková cena prodaného dlouhodobého nehmotného a hmotného', 'A', 'E', '', '', false),
               (10457, '55500', 'Zúčtování komplexních nákladů příštích období', 'A', 'E', '', '', false),
               (10459, '55700', 'Zúčtování oprávky k opravné položce k nabytému majetku', 'A', 'E', '', '', false),
               (10461, '55800', 'Tvorba zákonných opravných položek', 'A', 'E', '', '', false),
               (10463, '55900', 'Tvorba opravných položek', 'A', 'E', '', '', false),
               (10465, '56000', 'Finanční náklady', 'A', 'E', '', '', false),
               (10473, '56800', 'Ostatní finanční náklady', 'A', 'E', '', '', false),
               (10479, '57900', 'Tvorba opravných položek', 'A', 'E', '', '', false),
               (10481, '58000', 'Mimořádné náklady', 'A', 'E', '', '', false),
               (10483, '58100', 'Náklady na změnu metody', 'A', 'E', '', '', false),
               (10485, '58200', 'Manka a škody', 'A', 'E', '', '', false),
               (10489, '58800', 'Ostatní mimořádné náklady', 'A', 'E', '', '', false),
               (10491, '58900', 'Tvorba opravných položek', 'A', 'E', '', '', false),
               (10495, '59100', 'Daň z příjmu z běžné činnosti - splatná', 'A', 'E', '', '', false),
               (10497, '59200', 'Daň z příjmu z běžné činnosti - odložená', 'A', 'E', '', '', false),
               (10499, '59300', 'Daň z příjmu z mimořádné činnosti - splatná', 'A', 'E', '', '', false),
               (10501, '59400', 'Daň z příjmu z mimořádné činnosti - odložená', 'A', 'E', '', '', false),
               (10503, '59500', 'Dodatečné odvody daně z příjmu', 'A', 'E', '', '', false),
               (10505, '59600', 'Převod podílu na hospodářském výsledku společníkùm', 'A', 'E', '', '', false),
               (10507, '59700', 'Převod provozních nákladů', 'A', 'E', '', '', false),
               (10509, '59800', 'Převod finančních nákladù', 'A', 'E', '', '', false),
               (10511, '60000', 'Tržby za vlastní výkony a zboží', 'A', 'I', 'AR_amount:IC_sale:IC_income', '', false),
               (10513, '60100', 'Tržby za vlastní výrobky', 'A', 'I', 'AR_amount:IC_sale', '', false),
               (10515, '60200', 'Tržby z prodeje služeb', 'A', 'I', 'AR_amount:IC_income', '', false),
               (10517, '60400', 'Tržby za zboží', 'A', 'I', 'AR_amount:IC_sale', '', false),
               (10519, '61000', 'Změny stavu vnitropodnikových zásob', 'A', 'I', '', '', false),
               (10521, '61100', 'Změna stavu nedokončené výroby', 'A', 'I', '', '', false),
               (10523, '61200', 'Změna stavu polotovarů', 'A', 'I', '', '', false),
               (10525, '61300', 'Změna stavu výrobků', 'A', 'I', '', '', false),
               (10527, '61400', 'Změna stavu zvířat', 'A', 'I', '', '', false),
               (10531, '62100', 'Aktivace materiálu a zboží', 'A', 'I', '', '', false),
               (10533, '62200', 'Aktivace vnitropodnikových služeb', 'A', 'I', '', '', false),
               (10535, '62300', 'Aktivace dlouhodobého nehmotného majetku', 'A', 'I', '', '', false),
               (10541, '64100', 'Tržby z prodeje dlouhodobého nehmotného a hmotného majetku', 'A', 'I', 'AR_amount', '', false),
               (10543, '64200', 'Tržby z prodeje materiálu', 'A', 'I', 'AR_amount:IC_sale', '', false),
               (10545, '64400', 'Smluvní pokuty a úroky z prodlení', 'A', 'I', 'AR_amount', '', false),
               (10553, '65200', 'Zúčtování zákonných rezerv', 'A', 'I', '', '', false),
               (10555, '65400', 'Zúčtování ostatních rezerv', 'A', 'I', '', '', false),
               (10557, '65500', 'Zúčtování komplexních nákladů příětích období', 'A', 'I', '', '', false),
               (10559, '65700', 'Zúčtování oprávky k opravné položce k nabytému majetku', 'A', 'I', '', '', false),
               (10561, '65800', 'Zúčtování zákonných opravných položek', 'A', 'I', '', '', false),
               (10563, '65900', 'Zúčtování opravných položek', 'A', 'I', '', '', false),
               (10565, '66000', 'Finanční výnosy', 'A', 'I', '', '', false),
               (10567, '66100', 'Tržby z prodeje cenných papírů a vkladů', 'A', 'I', '', '', false),
               (10573, '66500', 'Výnosy z dlouhodobého finančního majetku', 'A', 'I', '', '', false),
               (10575, '66600', 'Výnosy z krátkodobého finančního majetku', 'A', 'I', '', '', false),
               (10577, '66800', 'Ostatní finanční výnosy', 'A', 'I', '', '', false),
               (10581, '67400', 'Zúčtování rezerv', 'A', 'I', '', '', false),
               (10583, '67900', 'Zúčtování opravných položek', 'A', 'I', '', '', false),
               (10585, '68000', 'Mimořádné výnosy', 'A', 'I', '', '', false),
               (10587, '68100', 'Výnosy ze změny metody', 'A', 'I', '', '', false),
               (10589, '68400', 'Zúčtování rezerv', 'A', 'I', '', '', false),
               (10591, '68800', 'Ostatní mimořádné výnosy', 'A', 'I', '', '', false),
               (10593, '68900', 'Zúčtování opravných položek', 'A', 'I', '', '', false),
               (10597, '69700', 'Převod provozních výnosů', 'A', 'I', '', '', false),
               (10599, '69800', 'Převod finančních výnosů', 'A', 'I', '', '', false),
               (10603, '70100', 'Počáteční účet rozvažný', 'A', 'A', '', '', false),
               (10605, '70200', 'Konečný účet rozvažný', 'A', 'A', '', '', false),
               (10607, '71000', 'Účet zisků a ztrát', 'A', 'A', '', '', false)
       ) c (id, accno, description, charttype, category, link, gifi_accno, contra);

SELECT cr_coa_to_account_save(accno, accno || '--' || description)
FROM account WHERE id IN (select account_id FROM account_link
                           WHERE description = 'AP_paid');
--
insert into tax (chart_id,rate) values ((select id from account where accno = '34311'),0.05);
insert into tax (chart_id,rate) values ((select id from account where accno = '34312'),0.19);
insert into tax (chart_id,rate) values ((select id from account where accno = '34321'),0.05);
insert into tax (chart_id,rate) values ((select id from account where accno = '34322'),0.19);
--
INSERT INTO defaults (setting_key, value) VALUES ('inventory_accno_id', (select id from account where accno = '13200'));

INSERT INTO defaults (setting_key, value) VALUES ('income_accno_id', (select id from account where accno = '60000'));

INSERT INTO defaults (setting_key, value) VALUES ('expense_accno_id', (select id from account where accno = '50000'));

INSERT INTO defaults (setting_key, value) VALUES ('fxgain_accno_id', (select id from account where accno = '99998'));

INSERT INTO defaults (setting_key, value) VALUES ('fxloss_accno_id', (select id from account where accno = '99999'));

INSERT INTO defaults (setting_key, value) VALUES ('curr', 'CZK');

INSERT INTO defaults (setting_key, value) VALUES ('weightunit', 'kg');
--
commit;

--
UPDATE account
   SET tax = true
WHERE id
   IN (SELECT account_id
       FROM account_link
       WHERE description LIKE '%_tax');
