/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 13 янв. 2020 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef DSP_ARCH_AARCH64_ASIMD_FASTCONV_H_
#define DSP_ARCH_AARCH64_ASIMD_FASTCONV_H_

#ifndef DSP_ARCH_AARCH64_ASIMD_IMPL
    #error "This header should not be included directly"
#endif /* DSP_ARCH_AARCH64_ASIMD_IMPL */

#include <dsp/arch/aarch64/asimd/fft/const.h>
#include <dsp/arch/aarch64/asimd/fastconv/const.h>
#include <dsp/arch/aarch64/asimd/fastconv/parse.h>
#include <dsp/arch/aarch64/asimd/fastconv/restore.h>
#include <dsp/arch/aarch64/asimd/fastconv/apply.h>
#include <dsp/arch/aarch64/asimd/fastconv/papply.h>

#endif /* DSP_ARCH_AARCH64_ASIMD_FASTCONV_H_ */
