/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.spi.editor.hints.projects.support;

import java.io.File;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.spi.editor.hints.projects.support.StandardProjectSettings.Standard;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author lahvac
 */
class AdvancedLocationPanel extends javax.swing.JPanel {
    private final Standard standard;

    public AdvancedLocationPanel(String currentHintFileLocation, Standard standard) {
        initComponents();
        this.fileLocation.setText(currentHintFileLocation);
        this.standard = standard;
        this.browse.setEnabled(standard.getProjectLocation() != null);
        this.fileLocation.getDocument().addDocumentListener(new DocumentListener() {
            @Override public void insertUpdate(DocumentEvent e) {
                enableDisable();
            }
            @Override public void removeUpdate(DocumentEvent e) {
                enableDisable();
            }
            @Override public void changedUpdate(DocumentEvent e) { }
        });
        enableDisable();
    }
    
    public String getHintFileLocation() {
        return fileLocation.getText();
    }
    
    private void enableDisable() {
        toDefault.setEnabled(!Objects.equals(standard.getDefaultHintLocation(), fileLocation.getText()));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        fileLocation = new javax.swing.JTextField();
        toDefault = new javax.swing.JButton();
        browse = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 0, 0, 0));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(AdvancedLocationPanel.class, "AdvancedLocationPanel.jLabel1.text")); // NOI18N

        fileLocation.setColumns(30);
        fileLocation.setText(org.openide.util.NbBundle.getMessage(AdvancedLocationPanel.class, "AdvancedLocationPanel.fileLocation.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(toDefault, org.openide.util.NbBundle.getMessage(AdvancedLocationPanel.class, "AdvancedLocationPanel.toDefault.text")); // NOI18N
        toDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                toDefaultActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(browse, org.openide.util.NbBundle.getMessage(AdvancedLocationPanel.class, "AdvancedLocationPanel.browse.text")); // NOI18N
        browse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fileLocation, javax.swing.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(toDefault)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(browse))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(fileLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(toDefault)
                    .addComponent(browse))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void toDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toDefaultActionPerformed
        fileLocation.setText(standard.getDefaultHintLocation());
    }//GEN-LAST:event_toDefaultActionPerformed

    @Messages("LBL_Select=Select")
    private void browseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseActionPerformed
        JFileChooser jfc = new JFileChooser();
        
        jfc.setSelectedFile(new File(standard.getProjectLocation(), fileLocation.getText()));
        
        if (jfc.showDialog(this, Bundle.LBL_Select()) == JFileChooser.APPROVE_OPTION) {
            fileLocation.setText(standard.getProjectLocation().toURI().relativize(jfc.getSelectedFile().toURI()).getPath());
        }
    }//GEN-LAST:event_browseActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browse;
    private javax.swing.JTextField fileLocation;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton toDefault;
    // End of variables declaration//GEN-END:variables
}
