/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: nntp.h,v 1.3 2004/09/13 15:51:13 mnordstr Exp $
    This file provides the NNTP class headers.

*/

#ifndef NNTP_H
#define NNTP_H

#include <iostream>

#define MAXDATASIZE 4096 // max number of bytes we can get at once

using namespace std;

class NNTP {
	public:
		NNTP();
		~NNTP();
		
		int initialize(string host, int port, string user, string pass);
		int terminate();
		string get_article(string msgid);
		unsigned long get_bytes() { return bytes; }
	
	private:
		int net_send(string data);
		string net_recv();
		
		int sockfd;
		unsigned long bytes;
};

#endif
