
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileXmlSceneNodeAttributes.h
    \brief Definition of XmlSceneNode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef XmlSceneNodeAttributes_H
#define XmlSceneNodeAttributes_H

#include "magics.h"
#include "PageID.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class XmlSceneNodeAttributes 
{
public:
//  --  constructor
    XmlSceneNodeAttributes();
    
//  --  destructor
    virtual ~XmlSceneNodeAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XmlSceneNodeAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string bottom_;
	string left_;
	string width_;
	string height_;
	string margin_bottom_;
	string margin_left_;
	string margin_right_;
	string margin_top_;
	string border_bottom_;
	string border_left_;
	string border_right_;
	bool border_;
	string border_top_;
	int border_thickness_;
	string padding_bottom_;
	string padding_left_;
	string padding_right_;
	string padding_top_;
	DisplayType display_;
	unique_ptr<Colour> background_;
	unique_ptr<Colour> border_colour_;
	LineStyle border_style_;
	unique_ptr<Colour> padding_colour_;
	unique_ptr<NoPageID> page_id_;
	 

private:
	friend ostream& operator<<(ostream& s,const XmlSceneNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

