// Arc class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "Arc.h"
#include "Marking.h"
#include "Place.h"

/** @file Arc.C
 * Labelled arc in a net
 */

/* Copyright  1998-2003 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

Arc::Arc (bool output,
	  class Marking& expr,
	  const class Place& place,
	  bool copy) :
  myIsOutput (output), myExpr (&expr),
  myPlace (place), myIndex (place.getIndex ()), myCopy (copy)
{
  expr.setPlace (&place);
}

Arc::~Arc ()
{
  myExpr->destroy ();
}

void
Arc::substitute (class Substitution& substitution)
{
  class Expression* expr = myExpr->substitute (substitution);
  assert (expr && expr->getKind () == Expression::eMarking);
  myExpr->destroy ();
  myExpr = static_cast<class Marking*>(expr);
}

void
Arc::append (class Marking& expr)
{
  expr.setPlace (&myPlace);
  myExpr->append (expr);
}
