
# Copyright (C) 2015 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

import os
import sys

# The list functions present in the dispatch table.
all_functions = [
    "NewList",
    "EndList",
    "CallList",
    "CallLists",
    "DeleteLists",
    "GenLists",
    "ListBase",
    "Begin",
    "Bitmap",
    "Color3b",
    "Color3bv",
    "Color3d",
    "Color3dv",
    "Color3f",
    "Color3fv",
    "Color3i",
    "Color3iv",
    "Color3s",
    "Color3sv",
    "Color3ub",
    "Color3ubv",
    "Color3ui",
    "Color3uiv",
    "Color3us",
    "Color3usv",
    "Color4b",
    "Color4bv",
    "Color4d",
    "Color4dv",
    "Color4f",
    "Color4fv",
    "Color4i",
    "Color4iv",
    "Color4s",
    "Color4sv",
    "Color4ub",
    "Color4ubv",
    "Color4ui",
    "Color4uiv",
    "Color4us",
    "Color4usv",
    "EdgeFlag",
    "EdgeFlagv",
    "End",
    "Indexd",
    "Indexdv",
    "Indexf",
    "Indexfv",
    "Indexi",
    "Indexiv",
    "Indexs",
    "Indexsv",
    "Normal3b",
    "Normal3bv",
    "Normal3d",
    "Normal3dv",
    "Normal3f",
    "Normal3fv",
    "Normal3i",
    "Normal3iv",
    "Normal3s",
    "Normal3sv",
    "RasterPos2d",
    "RasterPos2dv",
    "RasterPos2f",
    "RasterPos2fv",
    "RasterPos2i",
    "RasterPos2iv",
    "RasterPos2s",
    "RasterPos2sv",
    "RasterPos3d",
    "RasterPos3dv",
    "RasterPos3f",
    "RasterPos3fv",
    "RasterPos3i",
    "RasterPos3iv",
    "RasterPos3s",
    "RasterPos3sv",
    "RasterPos4d",
    "RasterPos4dv",
    "RasterPos4f",
    "RasterPos4fv",
    "RasterPos4i",
    "RasterPos4iv",
    "RasterPos4s",
    "RasterPos4sv",
    "Rectd",
    "Rectdv",
    "Rectf",
    "Rectfv",
    "Recti",
    "Rectiv",
    "Rects",
    "Rectsv",
    "TexCoord1d",
    "TexCoord1dv",
    "TexCoord1f",
    "TexCoord1fv",
    "TexCoord1i",
    "TexCoord1iv",
    "TexCoord1s",
    "TexCoord1sv",
    "TexCoord2d",
    "TexCoord2dv",
    "TexCoord2f",
    "TexCoord2fv",
    "TexCoord2i",
    "TexCoord2iv",
    "TexCoord2s",
    "TexCoord2sv",
    "TexCoord3d",
    "TexCoord3dv",
    "TexCoord3f",
    "TexCoord3fv",
    "TexCoord3i",
    "TexCoord3iv",
    "TexCoord3s",
    "TexCoord3sv",
    "TexCoord4d",
    "TexCoord4dv",
    "TexCoord4f",
    "TexCoord4fv",
    "TexCoord4i",
    "TexCoord4iv",
    "TexCoord4s",
    "TexCoord4sv",
    "Vertex2d",
    "Vertex2dv",
    "Vertex2f",
    "Vertex2fv",
    "Vertex2i",
    "Vertex2iv",
    "Vertex2s",
    "Vertex2sv",
    "Vertex3d",
    "Vertex3dv",
    "Vertex3f",
    "Vertex3fv",
    "Vertex3i",
    "Vertex3iv",
    "Vertex3s",
    "Vertex3sv",
    "Vertex4d",
    "Vertex4dv",
    "Vertex4f",
    "Vertex4fv",
    "Vertex4i",
    "Vertex4iv",
    "Vertex4s",
    "Vertex4sv",
    "ClipPlane",
    "ColorMaterial",
    "CullFace",
    "Fogf",
    "Fogfv",
    "Fogi",
    "Fogiv",
    "FrontFace",
    "Hint",
    "Lightf",
    "Lightfv",
    "Lighti",
    "Lightiv",
    "LightModelf",
    "LightModelfv",
    "LightModeli",
    "LightModeliv",
    "LineStipple",
    "LineWidth",
    "Materialf",
    "Materialfv",
    "Materiali",
    "Materialiv",
    "PointSize",
    "PolygonMode",
    "PolygonStipple",
    "Scissor",
    "ShadeModel",
    "TexParameterf",
    "TexParameterfv",
    "TexParameteri",
    "TexParameteriv",
    "TexImage1D",
    "TexImage2D",
    "TexEnvf",
    "TexEnvfv",
    "TexEnvi",
    "TexEnviv",
    "TexGend",
    "TexGendv",
    "TexGenf",
    "TexGenfv",
    "TexGeni",
    "TexGeniv",
    "FeedbackBuffer",
    "SelectBuffer",
    "RenderMode",
    "InitNames",
    "LoadName",
    "PassThrough",
    "PopName",
    "PushName",
    "DrawBuffer",
    "Clear",
    "ClearAccum",
    "ClearIndex",
    "ClearColor",
    "ClearStencil",
    "ClearDepth",
    "StencilMask",
    "ColorMask",
    "DepthMask",
    "IndexMask",
    "Accum",
    "Disable",
    "Enable",
    "Finish",
    "Flush",
    "PopAttrib",
    "PushAttrib",
    "Map1d",
    "Map1f",
    "Map2d",
    "Map2f",
    "MapGrid1d",
    "MapGrid1f",
    "MapGrid2d",
    "MapGrid2f",
    "EvalCoord1d",
    "EvalCoord1dv",
    "EvalCoord1f",
    "EvalCoord1fv",
    "EvalCoord2d",
    "EvalCoord2dv",
    "EvalCoord2f",
    "EvalCoord2fv",
    "EvalMesh1",
    "EvalPoint1",
    "EvalMesh2",
    "EvalPoint2",
    "AlphaFunc",
    "BlendFunc",
    "LogicOp",
    "StencilFunc",
    "StencilOp",
    "DepthFunc",
    "PixelZoom",
    "PixelTransferf",
    "PixelTransferi",
    "PixelStoref",
    "PixelStorei",
    "PixelMapfv",
    "PixelMapuiv",
    "PixelMapusv",
    "ReadBuffer",
    "CopyPixels",
    "ReadPixels",
    "DrawPixels",
    "GetBooleanv",
    "GetClipPlane",
    "GetDoublev",
    "GetError",
    "GetFloatv",
    "GetIntegerv",
    "GetLightfv",
    "GetLightiv",
    "GetMapdv",
    "GetMapfv",
    "GetMapiv",
    "GetMaterialfv",
    "GetMaterialiv",
    "GetPixelMapfv",
    "GetPixelMapuiv",
    "GetPixelMapusv",
    "GetPolygonStipple",
    "GetString",
    "GetTexEnvfv",
    "GetTexEnviv",
    "GetTexGendv",
    "GetTexGenfv",
    "GetTexGeniv",
    "GetTexImage",
    "GetTexParameterfv",
    "GetTexParameteriv",
    "GetTexLevelParameterfv",
    "GetTexLevelParameteriv",
    "IsEnabled",
    "IsList",
    "DepthRange",
    "Frustum",
    "LoadIdentity",
    "LoadMatrixf",
    "LoadMatrixd",
    "MatrixMode",
    "MultMatrixf",
    "MultMatrixd",
    "Ortho",
    "PopMatrix",
    "PushMatrix",
    "Rotated",
    "Rotatef",
    "Scaled",
    "Scalef",
    "Translated",
    "Translatef",
    "Viewport",
    "ArrayElement",
    "BindTexture",
    "ColorPointer",
    "DisableClientState",
    "DrawArrays",
    "DrawElements",
    "EdgeFlagPointer",
    "EnableClientState",
    "IndexPointer",
    "Indexub",
    "Indexubv",
    "InterleavedArrays",
    "NormalPointer",
    "PolygonOffset",
    "TexCoordPointer",
    "VertexPointer",
    "AreTexturesResident",
    "CopyTexImage1D",
    "CopyTexImage2D",
    "CopyTexSubImage1D",
    "CopyTexSubImage2D",
    "DeleteTextures",
    "GenTextures",
    "GetPointerv",
    "IsTexture",
    "PrioritizeTextures",
    "TexSubImage1D",
    "TexSubImage2D",
    "PopClientAttrib",
    "PushClientAttrib",
    "BlendColor",
    "BlendEquation",
    "DrawRangeElements",
    "TexImage3D",
    "TexSubImage3D",
    "CopyTexSubImage3D",
    "ActiveTexture",
    "ClientActiveTexture",
    "MultiTexCoord1d",
    "MultiTexCoord1dv",
    "MultiTexCoord1fARB",
    "MultiTexCoord1fvARB",
    "MultiTexCoord1i",
    "MultiTexCoord1iv",
    "MultiTexCoord1s",
    "MultiTexCoord1sv",
    "MultiTexCoord2d",
    "MultiTexCoord2dv",
    "MultiTexCoord2fARB",
    "MultiTexCoord2fvARB",
    "MultiTexCoord2i",
    "MultiTexCoord2iv",
    "MultiTexCoord2s",
    "MultiTexCoord2sv",
    "MultiTexCoord3d",
    "MultiTexCoord3dv",
    "MultiTexCoord3fARB",
    "MultiTexCoord3fvARB",
    "MultiTexCoord3i",
    "MultiTexCoord3iv",
    "MultiTexCoord3s",
    "MultiTexCoord3sv",
    "MultiTexCoord4d",
    "MultiTexCoord4dv",
    "MultiTexCoord4fARB",
    "MultiTexCoord4fvARB",
    "MultiTexCoord4i",
    "MultiTexCoord4iv",
    "MultiTexCoord4s",
    "MultiTexCoord4sv",
    "CompressedTexImage1D",
    "CompressedTexImage2D",
    "CompressedTexImage3D",
    "CompressedTexSubImage1D",
    "CompressedTexSubImage2D",
    "CompressedTexSubImage3D",
    "GetCompressedTexImage",
    "LoadTransposeMatrixd",
    "LoadTransposeMatrixf",
    "MultTransposeMatrixd",
    "MultTransposeMatrixf",
    "SampleCoverage",
    "BlendFuncSeparate",
    "FogCoordPointer",
    "FogCoordd",
    "FogCoorddv",
    "MultiDrawArrays",
    "PointParameterf",
    "PointParameterfv",
    "PointParameteri",
    "PointParameteriv",
    "SecondaryColor3b",
    "SecondaryColor3bv",
    "SecondaryColor3d",
    "SecondaryColor3dv",
    "SecondaryColor3i",
    "SecondaryColor3iv",
    "SecondaryColor3s",
    "SecondaryColor3sv",
    "SecondaryColor3ub",
    "SecondaryColor3ubv",
    "SecondaryColor3ui",
    "SecondaryColor3uiv",
    "SecondaryColor3us",
    "SecondaryColor3usv",
    "SecondaryColorPointer",
    "WindowPos2d",
    "WindowPos2dv",
    "WindowPos2f",
    "WindowPos2fv",
    "WindowPos2i",
    "WindowPos2iv",
    "WindowPos2s",
    "WindowPos2sv",
    "WindowPos3d",
    "WindowPos3dv",
    "WindowPos3f",
    "WindowPos3fv",
    "WindowPos3i",
    "WindowPos3iv",
    "WindowPos3s",
    "WindowPos3sv",
    "BeginQuery",
    "BindBuffer",
    "BufferData",
    "BufferSubData",
    "DeleteBuffers",
    "DeleteQueries",
    "EndQuery",
    "GenBuffers",
    "GenQueries",
    "GetBufferParameteriv",
    "GetBufferPointerv",
    "GetBufferSubData",
    "GetQueryObjectiv",
    "GetQueryObjectuiv",
    "GetQueryiv",
    "IsBuffer",
    "IsQuery",
    "MapBuffer",
    "UnmapBuffer",
    "AttachShader",
    "BindAttribLocation",
    "BlendEquationSeparate",
    "CompileShader",
    "CreateProgram",
    "CreateShader",
    "DeleteProgram",
    "DeleteShader",
    "DetachShader",
    "DisableVertexAttribArray",
    "DrawBuffers",
    "EnableVertexAttribArray",
    "GetActiveAttrib",
    "GetActiveUniform",
    "GetAttachedShaders",
    "GetAttribLocation",
    "GetProgramInfoLog",
    "GetProgramiv",
    "GetShaderInfoLog",
    "GetShaderSource",
    "GetShaderiv",
    "GetUniformLocation",
    "GetUniformfv",
    "GetUniformiv",
    "GetVertexAttribPointerv",
    "GetVertexAttribdv",
    "GetVertexAttribfv",
    "GetVertexAttribiv",
    "IsProgram",
    "IsShader",
    "LinkProgram",
    "ShaderSource",
    "StencilFuncSeparate",
    "StencilMaskSeparate",
    "StencilOpSeparate",
    "Uniform1f",
    "Uniform1fv",
    "Uniform1i",
    "Uniform1iv",
    "Uniform2f",
    "Uniform2fv",
    "Uniform2i",
    "Uniform2iv",
    "Uniform3f",
    "Uniform3fv",
    "Uniform3i",
    "Uniform3iv",
    "Uniform4f",
    "Uniform4fv",
    "Uniform4i",
    "Uniform4iv",
    "UniformMatrix2fv",
    "UniformMatrix3fv",
    "UniformMatrix4fv",
    "UseProgram",
    "ValidateProgram",
    "VertexAttrib1d",
    "VertexAttrib1dv",
    "VertexAttrib1s",
    "VertexAttrib1sv",
    "VertexAttrib2d",
    "VertexAttrib2dv",
    "VertexAttrib2s",
    "VertexAttrib2sv",
    "VertexAttrib3d",
    "VertexAttrib3dv",
    "VertexAttrib3s",
    "VertexAttrib3sv",
    "VertexAttrib4Nbv",
    "VertexAttrib4Niv",
    "VertexAttrib4Nsv",
    "VertexAttrib4Nub",
    "VertexAttrib4Nubv",
    "VertexAttrib4Nuiv",
    "VertexAttrib4Nusv",
    "VertexAttrib4bv",
    "VertexAttrib4d",
    "VertexAttrib4dv",
    "VertexAttrib4iv",
    "VertexAttrib4s",
    "VertexAttrib4sv",
    "VertexAttrib4ubv",
    "VertexAttrib4uiv",
    "VertexAttrib4usv",
    "VertexAttribPointer",
    "UniformMatrix2x3fv",
    "UniformMatrix2x4fv",
    "UniformMatrix3x2fv",
    "UniformMatrix3x4fv",
    "UniformMatrix4x2fv",
    "UniformMatrix4x3fv",
    "BeginConditionalRender",
    "BeginTransformFeedback",
    "BindBufferBase",
    "BindBufferRange",
    "BindFragDataLocation",
    "ClampColor",
    "ClearBufferfi",
    "ClearBufferfv",
    "ClearBufferiv",
    "ClearBufferuiv",
    "ColorMaski",
    "Disablei",
    "Enablei",
    "EndConditionalRender",
    "EndTransformFeedback",
    "GetBooleani_v",
    "GetFragDataLocation",
    "GetIntegeri_v",
    "GetStringi",
    "GetTexParameterIiv",
    "GetTexParameterIuiv",
    "GetTransformFeedbackVarying",
    "GetUniformuiv",
    "GetVertexAttribIiv",
    "GetVertexAttribIuiv",
    "IsEnabledi",
    "TexParameterIiv",
    "TexParameterIuiv",
    "TransformFeedbackVaryings",
    "Uniform1ui",
    "Uniform1uiv",
    "Uniform2ui",
    "Uniform2uiv",
    "Uniform3ui",
    "Uniform3uiv",
    "Uniform4ui",
    "Uniform4uiv",
    "VertexAttribI1iv",
    "VertexAttribI1uiv",
    "VertexAttribI4bv",
    "VertexAttribI4sv",
    "VertexAttribI4ubv",
    "VertexAttribI4usv",
    "VertexAttribIPointer",
    "PrimitiveRestartIndex",
    "TexBuffer",
    "FramebufferTexture",
    "GetBufferParameteri64v",
    "GetInteger64i_v",
    "VertexAttribDivisor",
    "MinSampleShading",
    "MemoryBarrierByRegion",
    "BindProgramARB",
    "DeleteProgramsARB",
    "GenProgramsARB",
    "GetProgramEnvParameterdvARB",
    "GetProgramEnvParameterfvARB",
    "GetProgramLocalParameterdvARB",
    "GetProgramLocalParameterfvARB",
    "GetProgramStringARB",
    "GetProgramivARB",
    "IsProgramARB",
    "ProgramEnvParameter4dARB",
    "ProgramEnvParameter4dvARB",
    "ProgramEnvParameter4fARB",
    "ProgramEnvParameter4fvARB",
    "ProgramLocalParameter4dARB",
    "ProgramLocalParameter4dvARB",
    "ProgramLocalParameter4fARB",
    "ProgramLocalParameter4fvARB",
    "ProgramStringARB",
    "VertexAttrib1fARB",
    "VertexAttrib1fvARB",
    "VertexAttrib2fARB",
    "VertexAttrib2fvARB",
    "VertexAttrib3fARB",
    "VertexAttrib3fvARB",
    "VertexAttrib4fARB",
    "VertexAttrib4fvARB",
    "AttachObjectARB",
    "CreateProgramObjectARB",
    "CreateShaderObjectARB",
    "DeleteObjectARB",
    "DetachObjectARB",
    "GetAttachedObjectsARB",
    "GetHandleARB",
    "GetInfoLogARB",
    "GetObjectParameterfvARB",
    "GetObjectParameterivARB",
    "DrawArraysInstanced",
    "DrawElementsInstanced",
    "BindFramebuffer",
    "BindRenderbuffer",
    "BlitFramebuffer",
    "CheckFramebufferStatus",
    "DeleteFramebuffers",
    "DeleteRenderbuffers",
    "FramebufferRenderbuffer",
    "FramebufferTexture1D",
    "FramebufferTexture2D",
    "FramebufferTexture3D",
    "FramebufferTextureLayer",
    "GenFramebuffers",
    "GenRenderbuffers",
    "GenerateMipmap",
    "GetFramebufferAttachmentParameteriv",
    "GetRenderbufferParameteriv",
    "IsFramebuffer",
    "IsRenderbuffer",
    "RenderbufferStorage",
    "RenderbufferStorageMultisample",
    "FlushMappedBufferRange",
    "MapBufferRange",
    "BindVertexArray",
    "DeleteVertexArrays",
    "GenVertexArrays",
    "IsVertexArray",
    "GetActiveUniformBlockName",
    "GetActiveUniformBlockiv",
    "GetActiveUniformName",
    "GetActiveUniformsiv",
    "GetUniformBlockIndex",
    "GetUniformIndices",
    "UniformBlockBinding",
    "CopyBufferSubData",
    "ClientWaitSync",
    "DeleteSync",
    "FenceSync",
    "GetInteger64v",
    "GetSynciv",
    "IsSync",
    "WaitSync",
    "DrawElementsBaseVertex",
    "DrawElementsInstancedBaseVertex",
    "DrawRangeElementsBaseVertex",
    "MultiDrawElementsBaseVertex",
    "ProvokingVertex",
    "GetMultisamplefv",
    "SampleMaski",
    "TexImage2DMultisample",
    "TexImage3DMultisample",
    "BlendEquationSeparateiARB",
    "BlendEquationiARB",
    "BlendFuncSeparateiARB",
    "BlendFunciARB",
    "BindFragDataLocationIndexed",
    "GetFragDataIndex",
    "BindSampler",
    "DeleteSamplers",
    "GenSamplers",
    "GetSamplerParameterIiv",
    "GetSamplerParameterIuiv",
    "GetSamplerParameterfv",
    "GetSamplerParameteriv",
    "IsSampler",
    "SamplerParameterIiv",
    "SamplerParameterIuiv",
    "SamplerParameterf",
    "SamplerParameterfv",
    "SamplerParameteri",
    "SamplerParameteriv",
    "GetQueryObjecti64v",
    "GetQueryObjectui64v",
    "QueryCounter",
    "ColorP3ui",
    "ColorP3uiv",
    "ColorP4ui",
    "ColorP4uiv",
    "MultiTexCoordP1ui",
    "MultiTexCoordP1uiv",
    "MultiTexCoordP2ui",
    "MultiTexCoordP2uiv",
    "MultiTexCoordP3ui",
    "MultiTexCoordP3uiv",
    "MultiTexCoordP4ui",
    "MultiTexCoordP4uiv",
    "NormalP3ui",
    "NormalP3uiv",
    "SecondaryColorP3ui",
    "SecondaryColorP3uiv",
    "TexCoordP1ui",
    "TexCoordP1uiv",
    "TexCoordP2ui",
    "TexCoordP2uiv",
    "TexCoordP3ui",
    "TexCoordP3uiv",
    "TexCoordP4ui",
    "TexCoordP4uiv",
    "VertexAttribP1ui",
    "VertexAttribP1uiv",
    "VertexAttribP2ui",
    "VertexAttribP2uiv",
    "VertexAttribP3ui",
    "VertexAttribP3uiv",
    "VertexAttribP4ui",
    "VertexAttribP4uiv",
    "VertexP2ui",
    "VertexP2uiv",
    "VertexP3ui",
    "VertexP3uiv",
    "VertexP4ui",
    "VertexP4uiv",
    "DrawArraysIndirect",
    "DrawElementsIndirect",
    "GetUniformdv",
    "Uniform1d",
    "Uniform1dv",
    "Uniform2d",
    "Uniform2dv",
    "Uniform3d",
    "Uniform3dv",
    "Uniform4d",
    "Uniform4dv",
    "UniformMatrix2dv",
    "UniformMatrix2x3dv",
    "UniformMatrix2x4dv",
    "UniformMatrix3dv",
    "UniformMatrix3x2dv",
    "UniformMatrix3x4dv",
    "UniformMatrix4dv",
    "UniformMatrix4x2dv",
    "UniformMatrix4x3dv",
    "GetActiveSubroutineName",
    "GetActiveSubroutineUniformName",
    "GetActiveSubroutineUniformiv",
    "GetProgramStageiv",
    "GetSubroutineIndex",
    "GetSubroutineUniformLocation",
    "GetUniformSubroutineuiv",
    "UniformSubroutinesuiv",
    "PatchParameterfv",
    "PatchParameteri",
    "BindTransformFeedback",
    "DeleteTransformFeedbacks",
    "DrawTransformFeedback",
    "GenTransformFeedbacks",
    "IsTransformFeedback",
    "PauseTransformFeedback",
    "ResumeTransformFeedback",
    "BeginQueryIndexed",
    "DrawTransformFeedbackStream",
    "EndQueryIndexed",
    "GetQueryIndexediv",
    "ClearDepthf",
    "DepthRangef",
    "GetShaderPrecisionFormat",
    "ReleaseShaderCompiler",
    "ShaderBinary",
    "GetProgramBinary",
    "ProgramBinary",
    "ProgramParameteri",
    "GetVertexAttribLdv",
    "VertexAttribL1d",
    "VertexAttribL1dv",
    "VertexAttribL2d",
    "VertexAttribL2dv",
    "VertexAttribL3d",
    "VertexAttribL3dv",
    "VertexAttribL4d",
    "VertexAttribL4dv",
    "VertexAttribLPointer",
    "DepthRangeArrayv",
    "DepthRangeIndexed",
    "GetDoublei_v",
    "GetFloati_v",
    "ScissorArrayv",
    "ScissorIndexed",
    "ScissorIndexedv",
    "ViewportArrayv",
    "ViewportIndexedf",
    "ViewportIndexedfv",
    "GetGraphicsResetStatusARB",
    "GetnCompressedTexImageARB",
    "GetnMapdvARB",
    "GetnMapfvARB",
    "GetnMapivARB",
    "GetnPixelMapfvARB",
    "GetnPixelMapuivARB",
    "GetnPixelMapusvARB",
    "GetnPolygonStippleARB",
    "GetnTexImageARB",
    "GetnUniformdvARB",
    "GetnUniformfvARB",
    "GetnUniformivARB",
    "GetnUniformuivARB",
    "ReadnPixelsARB",
    "DrawArraysInstancedBaseInstance",
    "DrawElementsInstancedBaseInstance",
    "DrawElementsInstancedBaseVertexBaseInstance",
    "DrawTransformFeedbackInstanced",
    "DrawTransformFeedbackStreamInstanced",
    "GetInternalformativ",
    "GetActiveAtomicCounterBufferiv",
    "BindImageTexture",
    "MemoryBarrier",
    "TexStorage1D",
    "TexStorage2D",
    "TexStorage3D",
    "TextureStorage1DEXT",
    "TextureStorage2DEXT",
    "TextureStorage3DEXT",
    "ClearBufferData",
    "ClearBufferSubData",
    "DispatchCompute",
    "DispatchComputeIndirect",
    "CopyImageSubData",
    "TextureView",
    "BindVertexBuffer",
    "VertexAttribBinding",
    "VertexAttribFormat",
    "VertexAttribIFormat",
    "VertexAttribLFormat",
    "VertexBindingDivisor",
    "FramebufferParameteri",
    "GetFramebufferParameteriv",
    "GetInternalformati64v",
    "MultiDrawArraysIndirect",
    "MultiDrawElementsIndirect",
    "GetProgramInterfaceiv",
    "GetProgramResourceIndex",
    "GetProgramResourceLocation",
    "GetProgramResourceLocationIndex",
    "GetProgramResourceName",
    "GetProgramResourceiv",
    "ShaderStorageBlockBinding",
    "TexBufferRange",
    "TexStorage2DMultisample",
    "TexStorage3DMultisample",
    "BufferStorage",
    "ClearTexImage",
    "ClearTexSubImage",
    "BindBuffersBase",
    "BindBuffersRange",
    "BindImageTextures",
    "BindSamplers",
    "BindTextures",
    "BindVertexBuffers",
    "GetImageHandleARB",
    "GetTextureHandleARB",
    "GetTextureSamplerHandleARB",
    "GetVertexAttribLui64vARB",
    "IsImageHandleResidentARB",
    "IsTextureHandleResidentARB",
    "MakeImageHandleNonResidentARB",
    "MakeImageHandleResidentARB",
    "MakeTextureHandleNonResidentARB",
    "MakeTextureHandleResidentARB",
    "ProgramUniformHandleui64ARB",
    "ProgramUniformHandleui64vARB",
    "UniformHandleui64ARB",
    "UniformHandleui64vARB",
    "VertexAttribL1ui64ARB",
    "VertexAttribL1ui64vARB",
    "DispatchComputeGroupSizeARB",
    "MultiDrawArraysIndirectCountARB",
    "MultiDrawElementsIndirectCountARB",
    "ClipControl",
    "BindTextureUnit",
    "BlitNamedFramebuffer",
    "CheckNamedFramebufferStatus",
    "ClearNamedBufferData",
    "ClearNamedBufferSubData",
    "ClearNamedFramebufferfi",
    "ClearNamedFramebufferfv",
    "ClearNamedFramebufferiv",
    "ClearNamedFramebufferuiv",
    "CompressedTextureSubImage1D",
    "CompressedTextureSubImage2D",
    "CompressedTextureSubImage3D",
    "CopyNamedBufferSubData",
    "CopyTextureSubImage1D",
    "CopyTextureSubImage2D",
    "CopyTextureSubImage3D",
    "CreateBuffers",
    "CreateFramebuffers",
    "CreateProgramPipelines",
    "CreateQueries",
    "CreateRenderbuffers",
    "CreateSamplers",
    "CreateTextures",
    "CreateTransformFeedbacks",
    "CreateVertexArrays",
    "DisableVertexArrayAttrib",
    "EnableVertexArrayAttrib",
    "FlushMappedNamedBufferRange",
    "GenerateTextureMipmap",
    "GetCompressedTextureImage",
    "GetNamedBufferParameteri64v",
    "GetNamedBufferParameteriv",
    "GetNamedBufferPointerv",
    "GetNamedBufferSubData",
    "GetNamedFramebufferAttachmentParameteriv",
    "GetNamedFramebufferParameteriv",
    "GetNamedRenderbufferParameteriv",
    "GetQueryBufferObjecti64v",
    "GetQueryBufferObjectiv",
    "GetQueryBufferObjectui64v",
    "GetQueryBufferObjectuiv",
    "GetTextureImage",
    "GetTextureLevelParameterfv",
    "GetTextureLevelParameteriv",
    "GetTextureParameterIiv",
    "GetTextureParameterIuiv",
    "GetTextureParameterfv",
    "GetTextureParameteriv",
    "GetTransformFeedbacki64_v",
    "GetTransformFeedbacki_v",
    "GetTransformFeedbackiv",
    "GetVertexArrayIndexed64iv",
    "GetVertexArrayIndexediv",
    "GetVertexArrayiv",
    "InvalidateNamedFramebufferData",
    "InvalidateNamedFramebufferSubData",
    "MapNamedBuffer",
    "MapNamedBufferRange",
    "NamedBufferData",
    "NamedBufferStorage",
    "NamedBufferSubData",
    "NamedFramebufferDrawBuffer",
    "NamedFramebufferDrawBuffers",
    "NamedFramebufferParameteri",
    "NamedFramebufferReadBuffer",
    "NamedFramebufferRenderbuffer",
    "NamedFramebufferTexture",
    "NamedFramebufferTextureLayer",
    "NamedRenderbufferStorage",
    "NamedRenderbufferStorageMultisample",
    "TextureBuffer",
    "TextureBufferRange",
    "TextureParameterIiv",
    "TextureParameterIuiv",
    "TextureParameterf",
    "TextureParameterfv",
    "TextureParameteri",
    "TextureParameteriv",
    "TextureStorage1D",
    "TextureStorage2D",
    "TextureStorage2DMultisample",
    "TextureStorage3D",
    "TextureStorage3DMultisample",
    "TextureSubImage1D",
    "TextureSubImage2D",
    "TextureSubImage3D",
    "TransformFeedbackBufferBase",
    "TransformFeedbackBufferRange",
    "UnmapNamedBufferEXT",
    "VertexArrayAttribBinding",
    "VertexArrayAttribFormat",
    "VertexArrayAttribIFormat",
    "VertexArrayAttribLFormat",
    "VertexArrayBindingDivisor",
    "VertexArrayElementBuffer",
    "VertexArrayVertexBuffer",
    "VertexArrayVertexBuffers",
    "GetCompressedTextureSubImage",
    "GetTextureSubImage",
    "BufferPageCommitmentARB",
    "NamedBufferPageCommitmentARB",
    "GetUniformi64vARB",
    "GetUniformui64vARB",
    "GetnUniformi64vARB",
    "GetnUniformui64vARB",
    "ProgramUniform1i64ARB",
    "ProgramUniform1i64vARB",
    "ProgramUniform1ui64ARB",
    "ProgramUniform1ui64vARB",
    "ProgramUniform2i64ARB",
    "ProgramUniform2i64vARB",
    "ProgramUniform2ui64ARB",
    "ProgramUniform2ui64vARB",
    "ProgramUniform3i64ARB",
    "ProgramUniform3i64vARB",
    "ProgramUniform3ui64ARB",
    "ProgramUniform3ui64vARB",
    "ProgramUniform4i64ARB",
    "ProgramUniform4i64vARB",
    "ProgramUniform4ui64ARB",
    "ProgramUniform4ui64vARB",
    "Uniform1i64ARB",
    "Uniform1i64vARB",
    "Uniform1ui64ARB",
    "Uniform1ui64vARB",
    "Uniform2i64ARB",
    "Uniform2i64vARB",
    "Uniform2ui64ARB",
    "Uniform2ui64vARB",
    "Uniform3i64ARB",
    "Uniform3i64vARB",
    "Uniform3ui64ARB",
    "Uniform3ui64vARB",
    "Uniform4i64ARB",
    "Uniform4i64vARB",
    "Uniform4ui64ARB",
    "Uniform4ui64vARB",
    "EvaluateDepthValuesARB",
    "FramebufferSampleLocationsfvARB",
    "NamedFramebufferSampleLocationsfvARB",
    "SpecializeShaderARB",
    "InvalidateBufferData",
    "InvalidateBufferSubData",
    "InvalidateFramebuffer",
    "InvalidateSubFramebuffer",
    "InvalidateTexImage",
    "InvalidateTexSubImage",
    "DrawTexfOES",
    "DrawTexfvOES",
    "DrawTexiOES",
    "DrawTexivOES",
    "DrawTexsOES",
    "DrawTexsvOES",
    "DrawTexxOES",
    "DrawTexxvOES",
    "PointSizePointerOES",
    "QueryMatrixxOES",
    "ColorPointerEXT",
    "EdgeFlagPointerEXT",
    "IndexPointerEXT",
    "NormalPointerEXT",
    "TexCoordPointerEXT",
    "VertexPointerEXT",
    "DiscardFramebufferEXT",
    "ActiveShaderProgram",
    "BindProgramPipeline",
    "CreateShaderProgramv",
    "DeleteProgramPipelines",
    "GenProgramPipelines",
    "GetProgramPipelineInfoLog",
    "GetProgramPipelineiv",
    "IsProgramPipeline",
    "LockArraysEXT",
    "ProgramUniform1d",
    "ProgramUniform1dv",
    "ProgramUniform1f",
    "ProgramUniform1fv",
    "ProgramUniform1i",
    "ProgramUniform1iv",
    "ProgramUniform1ui",
    "ProgramUniform1uiv",
    "ProgramUniform2d",
    "ProgramUniform2dv",
    "ProgramUniform2f",
    "ProgramUniform2fv",
    "ProgramUniform2i",
    "ProgramUniform2iv",
    "ProgramUniform2ui",
    "ProgramUniform2uiv",
    "ProgramUniform3d",
    "ProgramUniform3dv",
    "ProgramUniform3f",
    "ProgramUniform3fv",
    "ProgramUniform3i",
    "ProgramUniform3iv",
    "ProgramUniform3ui",
    "ProgramUniform3uiv",
    "ProgramUniform4d",
    "ProgramUniform4dv",
    "ProgramUniform4f",
    "ProgramUniform4fv",
    "ProgramUniform4i",
    "ProgramUniform4iv",
    "ProgramUniform4ui",
    "ProgramUniform4uiv",
    "ProgramUniformMatrix2dv",
    "ProgramUniformMatrix2fv",
    "ProgramUniformMatrix2x3dv",
    "ProgramUniformMatrix2x3fv",
    "ProgramUniformMatrix2x4dv",
    "ProgramUniformMatrix2x4fv",
    "ProgramUniformMatrix3dv",
    "ProgramUniformMatrix3fv",
    "ProgramUniformMatrix3x2dv",
    "ProgramUniformMatrix3x2fv",
    "ProgramUniformMatrix3x4dv",
    "ProgramUniformMatrix3x4fv",
    "ProgramUniformMatrix4dv",
    "ProgramUniformMatrix4fv",
    "ProgramUniformMatrix4x2dv",
    "ProgramUniformMatrix4x2fv",
    "ProgramUniformMatrix4x3dv",
    "ProgramUniformMatrix4x3fv",
    "UnlockArraysEXT",
    "UseProgramStages",
    "ValidateProgramPipeline",
    "FramebufferTexture2DMultisampleEXT",
    "DebugMessageCallback",
    "DebugMessageControl",
    "DebugMessageInsert",
    "GetDebugMessageLog",
    "GetObjectLabel",
    "GetObjectPtrLabel",
    "ObjectLabel",
    "ObjectPtrLabel",
    "PopDebugGroup",
    "PushDebugGroup",
    "SecondaryColor3fEXT",
    "SecondaryColor3fvEXT",
    "MultiDrawElements",
    "FogCoordfEXT",
    "FogCoordfvEXT",
    "WindowPos4dMESA",
    "WindowPos4dvMESA",
    "WindowPos4fMESA",
    "WindowPos4fvMESA",
    "WindowPos4iMESA",
    "WindowPos4ivMESA",
    "WindowPos4sMESA",
    "WindowPos4svMESA",
    "MultiModeDrawArraysIBM",
    "MultiModeDrawElementsIBM",
    "VertexAttrib1dNV",
    "VertexAttrib1dvNV",
    "VertexAttrib1fNV",
    "VertexAttrib1fvNV",
    "VertexAttrib1sNV",
    "VertexAttrib1svNV",
    "VertexAttrib2dNV",
    "VertexAttrib2dvNV",
    "VertexAttrib2fNV",
    "VertexAttrib2fvNV",
    "VertexAttrib2sNV",
    "VertexAttrib2svNV",
    "VertexAttrib3dNV",
    "VertexAttrib3dvNV",
    "VertexAttrib3fNV",
    "VertexAttrib3fvNV",
    "VertexAttrib3sNV",
    "VertexAttrib3svNV",
    "VertexAttrib4dNV",
    "VertexAttrib4dvNV",
    "VertexAttrib4fNV",
    "VertexAttrib4fvNV",
    "VertexAttrib4sNV",
    "VertexAttrib4svNV",
    "VertexAttrib4ubNV",
    "VertexAttrib4ubvNV",
    "VertexAttribs1dvNV",
    "VertexAttribs1fvNV",
    "VertexAttribs1svNV",
    "VertexAttribs2dvNV",
    "VertexAttribs2fvNV",
    "VertexAttribs2svNV",
    "VertexAttribs3dvNV",
    "VertexAttribs3fvNV",
    "VertexAttribs3svNV",
    "VertexAttribs4dvNV",
    "VertexAttribs4fvNV",
    "VertexAttribs4svNV",
    "VertexAttribs4ubvNV",
    "AlphaFragmentOp1ATI",
    "AlphaFragmentOp2ATI",
    "AlphaFragmentOp3ATI",
    "BeginFragmentShaderATI",
    "BindFragmentShaderATI",
    "ColorFragmentOp1ATI",
    "ColorFragmentOp2ATI",
    "ColorFragmentOp3ATI",
    "DeleteFragmentShaderATI",
    "EndFragmentShaderATI",
    "GenFragmentShadersATI",
    "PassTexCoordATI",
    "SampleMapATI",
    "SetFragmentShaderConstantATI",
    "DepthRangeArrayfvOES",
    "DepthRangeIndexedfOES",
    "ActiveStencilFaceEXT",
    "PrimitiveRestartNV",
    "GetTexGenxvOES",
    "TexGenxOES",
    "TexGenxvOES",
    "DepthBoundsEXT",
    "BindFramebufferEXT",
    "BindRenderbufferEXT",
    "StringMarkerGREMEDY",
    "VertexAttribI1iEXT",
    "VertexAttribI1uiEXT",
    "VertexAttribI2iEXT",
    "VertexAttribI2ivEXT",
    "VertexAttribI2uiEXT",
    "VertexAttribI2uivEXT",
    "VertexAttribI3iEXT",
    "VertexAttribI3ivEXT",
    "VertexAttribI3uiEXT",
    "VertexAttribI3uivEXT",
    "VertexAttribI4iEXT",
    "VertexAttribI4ivEXT",
    "VertexAttribI4uiEXT",
    "VertexAttribI4uivEXT",
    "ClearColorIiEXT",
    "ClearColorIuiEXT",
    "BindBufferOffsetEXT",
    "BeginPerfMonitorAMD",
    "DeletePerfMonitorsAMD",
    "EndPerfMonitorAMD",
    "GenPerfMonitorsAMD",
    "GetPerfMonitorCounterDataAMD",
    "GetPerfMonitorCounterInfoAMD",
    "GetPerfMonitorCounterStringAMD",
    "GetPerfMonitorCountersAMD",
    "GetPerfMonitorGroupStringAMD",
    "GetPerfMonitorGroupsAMD",
    "SelectPerfMonitorCountersAMD",
    "TextureBarrierNV",
    "VDPAUFiniNV",
    "VDPAUGetSurfaceivNV",
    "VDPAUInitNV",
    "VDPAUIsSurfaceNV",
    "VDPAUMapSurfacesNV",
    "VDPAURegisterOutputSurfaceNV",
    "VDPAURegisterVideoSurfaceNV",
    "VDPAUSurfaceAccessNV",
    "VDPAUUnmapSurfacesNV",
    "VDPAUUnregisterSurfaceNV",
    "BeginPerfQueryINTEL",
    "CreatePerfQueryINTEL",
    "DeletePerfQueryINTEL",
    "EndPerfQueryINTEL",
    "GetFirstPerfQueryIdINTEL",
    "GetNextPerfQueryIdINTEL",
    "GetPerfCounterInfoINTEL",
    "GetPerfQueryDataINTEL",
    "GetPerfQueryIdByNameINTEL",
    "GetPerfQueryInfoINTEL",
    "PolygonOffsetClampEXT",
    "SubpixelPrecisionBiasNV",
    "ConservativeRasterParameterfNV",
    "ConservativeRasterParameteriNV",
    "WindowRectanglesEXT",
    "BufferStorageMemEXT",
    "CreateMemoryObjectsEXT",
    "DeleteMemoryObjectsEXT",
    "DeleteSemaphoresEXT",
    "GenSemaphoresEXT",
    "GetMemoryObjectParameterivEXT",
    "GetSemaphoreParameterui64vEXT",
    "GetUnsignedBytei_vEXT",
    "GetUnsignedBytevEXT",
    "IsMemoryObjectEXT",
    "IsSemaphoreEXT",
    "MemoryObjectParameterivEXT",
    "NamedBufferStorageMemEXT",
    "SemaphoreParameterui64vEXT",
    "SignalSemaphoreEXT",
    "TexStorageMem1DEXT",
    "TexStorageMem2DEXT",
    "TexStorageMem2DMultisampleEXT",
    "TexStorageMem3DEXT",
    "TexStorageMem3DMultisampleEXT",
    "TextureStorageMem1DEXT",
    "TextureStorageMem2DEXT",
    "TextureStorageMem2DMultisampleEXT",
    "TextureStorageMem3DEXT",
    "TextureStorageMem3DMultisampleEXT",
    "WaitSemaphoreEXT",
    "ImportMemoryFdEXT",
    "ImportSemaphoreFdEXT",
    "FramebufferFetchBarrierEXT",
    "NamedRenderbufferStorageMultisampleAdvancedAMD",
    "RenderbufferStorageMultisampleAdvancedAMD",
    "StencilFuncSeparateATI",
    "ProgramEnvParameters4fvEXT",
    "ProgramLocalParameters4fvEXT",
    "EGLImageTargetRenderbufferStorageOES",
    "EGLImageTargetTexture2DOES",
    "AlphaFuncx",
    "ClearColorx",
    "ClearDepthx",
    "Color4x",
    "DepthRangex",
    "Fogx",
    "Fogxv",
    "Frustumf",
    "Frustumx",
    "LightModelx",
    "LightModelxv",
    "Lightx",
    "Lightxv",
    "LineWidthx",
    "LoadMatrixx",
    "Materialx",
    "Materialxv",
    "MultMatrixx",
    "MultiTexCoord4x",
    "Normal3x",
    "Orthof",
    "Orthox",
    "PointSizex",
    "PolygonOffsetx",
    "Rotatex",
    "SampleCoveragex",
    "Scalex",
    "TexEnvx",
    "TexEnvxv",
    "TexParameterx",
    "Translatex",
    "ClipPlanef",
    "ClipPlanex",
    "GetClipPlanef",
    "GetClipPlanex",
    "GetFixedv",
    "GetLightxv",
    "GetMaterialxv",
    "GetTexEnvxv",
    "GetTexParameterxv",
    "PointParameterx",
    "PointParameterxv",
    "TexParameterxv",
    "BlendBarrier",
    "PrimitiveBoundingBox",
    "MaxShaderCompilerThreadsKHR",
    "MatrixLoadfEXT",
    "MatrixLoaddEXT",
    "MatrixMultfEXT",
    "MatrixMultdEXT",
    "MatrixLoadIdentityEXT",
    "MatrixRotatefEXT",
    "MatrixRotatedEXT",
    "MatrixScalefEXT",
    "MatrixScaledEXT",
    "MatrixTranslatefEXT",
    "MatrixTranslatedEXT",
    "MatrixOrthoEXT",
    "MatrixFrustumEXT",
    "MatrixPushEXT",
    "MatrixPopEXT",
    "MatrixLoadTransposefEXT",
    "MatrixLoadTransposedEXT",
    "MatrixMultTransposefEXT",
    "MatrixMultTransposedEXT",
    "BindMultiTextureEXT",
    "NamedBufferDataEXT",
    "NamedBufferSubDataEXT",
    "NamedBufferStorageEXT",
    "MapNamedBufferRangeEXT",
    "TextureImage1DEXT",
    "TextureImage2DEXT",
    "TextureImage3DEXT",
    "TextureSubImage1DEXT",
    "TextureSubImage2DEXT",
    "TextureSubImage3DEXT",
    "CopyTextureImage1DEXT",
    "CopyTextureImage2DEXT",
    "CopyTextureSubImage1DEXT",
    "CopyTextureSubImage2DEXT",
    "CopyTextureSubImage3DEXT",
    "MapNamedBufferEXT",
    "GetTextureParameterivEXT",
    "GetTextureParameterfvEXT",
    "TextureParameteriEXT",
    "TextureParameterivEXT",
    "TextureParameterfEXT",
    "TextureParameterfvEXT",
    "GetTextureImageEXT",
    "GetTextureLevelParameterivEXT",
    "GetTextureLevelParameterfvEXT",
    "GetNamedBufferSubDataEXT",
    "GetNamedBufferPointervEXT",
    "GetNamedBufferParameterivEXT",
    "FlushMappedNamedBufferRangeEXT",
    "FramebufferDrawBufferEXT",
    "FramebufferDrawBuffersEXT",
    "FramebufferReadBufferEXT",
    "GetFramebufferParameterivEXT",
    "CheckNamedFramebufferStatusEXT",
    "NamedFramebufferTexture1DEXT",
    "NamedFramebufferTexture2DEXT",
    "NamedFramebufferTexture3DEXT",
    "NamedFramebufferRenderbufferEXT",
    "GetNamedFramebufferAttachmentParameterivEXT",
    "EnableClientStateiEXT",
    "DisableClientStateiEXT",
    "GetPointerIndexedvEXT",
    "MultiTexEnviEXT",
    "MultiTexEnvivEXT",
    "MultiTexEnvfEXT",
    "MultiTexEnvfvEXT",
    "GetMultiTexEnvivEXT",
    "GetMultiTexEnvfvEXT",
    "MultiTexParameteriEXT",
    "MultiTexParameterivEXT",
    "MultiTexParameterfEXT",
    "MultiTexParameterfvEXT",
    "GetMultiTexImageEXT",
    "MultiTexImage1DEXT",
    "MultiTexImage2DEXT",
    "MultiTexImage3DEXT",
    "MultiTexSubImage1DEXT",
    "MultiTexSubImage2DEXT",
    "MultiTexSubImage3DEXT",
    "GetMultiTexParameterivEXT",
    "GetMultiTexParameterfvEXT",
    "CopyMultiTexImage1DEXT",
    "CopyMultiTexImage2DEXT",
    "CopyMultiTexSubImage1DEXT",
    "CopyMultiTexSubImage2DEXT",
    "CopyMultiTexSubImage3DEXT",
    "MultiTexGendEXT",
    "MultiTexGendvEXT",
    "MultiTexGenfEXT",
    "MultiTexGenfvEXT",
    "MultiTexGeniEXT",
    "MultiTexGenivEXT",
    "GetMultiTexGendvEXT",
    "GetMultiTexGenfvEXT",
    "GetMultiTexGenivEXT",
    "MultiTexCoordPointerEXT",
    "BindImageTextureEXT",
    "CompressedTextureImage1DEXT",
    "CompressedTextureImage2DEXT",
    "CompressedTextureImage3DEXT",
    "CompressedTextureSubImage1DEXT",
    "CompressedTextureSubImage2DEXT",
    "CompressedTextureSubImage3DEXT",
    "GetCompressedTextureImageEXT",
    "CompressedMultiTexImage1DEXT",
    "CompressedMultiTexImage2DEXT",
    "CompressedMultiTexImage3DEXT",
    "CompressedMultiTexSubImage1DEXT",
    "CompressedMultiTexSubImage2DEXT",
    "CompressedMultiTexSubImage3DEXT",
    "GetCompressedMultiTexImageEXT",
    "GetMultiTexLevelParameterivEXT",
    "GetMultiTexLevelParameterfvEXT",
    "FramebufferParameteriMESA",
    "GetFramebufferParameterivMESA",
    "NamedRenderbufferStorageEXT",
    "GetNamedRenderbufferParameterivEXT",
    "ClientAttribDefaultEXT",
    "PushClientAttribDefaultEXT",
    "NamedProgramStringEXT",
    "GetNamedProgramStringEXT",
    "NamedProgramLocalParameter4fEXT",
    "NamedProgramLocalParameter4fvEXT",
    "GetNamedProgramLocalParameterfvEXT",
    "NamedProgramLocalParameter4dEXT",
    "NamedProgramLocalParameter4dvEXT",
    "GetNamedProgramLocalParameterdvEXT",
    "GetNamedProgramivEXT",
    "TextureBufferEXT",
    "MultiTexBufferEXT",
    "TextureParameterIivEXT",
    "TextureParameterIuivEXT",
    "GetTextureParameterIivEXT",
    "GetTextureParameterIuivEXT",
    "MultiTexParameterIivEXT",
    "MultiTexParameterIuivEXT",
    "GetMultiTexParameterIivEXT",
    "GetMultiTexParameterIuivEXT",
    "NamedProgramLocalParameters4fvEXT",
    "GenerateTextureMipmapEXT",
    "GenerateMultiTexMipmapEXT",
    "NamedRenderbufferStorageMultisampleEXT",
    "NamedCopyBufferSubDataEXT",
    "VertexArrayVertexOffsetEXT",
    "VertexArrayColorOffsetEXT",
    "VertexArrayEdgeFlagOffsetEXT",
    "VertexArrayIndexOffsetEXT",
    "VertexArrayNormalOffsetEXT",
    "VertexArrayTexCoordOffsetEXT",
    "VertexArrayMultiTexCoordOffsetEXT",
    "VertexArrayFogCoordOffsetEXT",
    "VertexArraySecondaryColorOffsetEXT",
    "VertexArrayVertexAttribOffsetEXT",
    "VertexArrayVertexAttribIOffsetEXT",
    "EnableVertexArrayEXT",
    "DisableVertexArrayEXT",
    "EnableVertexArrayAttribEXT",
    "DisableVertexArrayAttribEXT",
    "GetVertexArrayIntegervEXT",
    "GetVertexArrayPointervEXT",
    "GetVertexArrayIntegeri_vEXT",
    "GetVertexArrayPointeri_vEXT",
    "ClearNamedBufferDataEXT",
    "ClearNamedBufferSubDataEXT",
    "NamedFramebufferParameteriEXT",
    "GetNamedFramebufferParameterivEXT",
    "VertexArrayVertexAttribLOffsetEXT",
    "VertexArrayVertexAttribDivisorEXT",
    "TextureBufferRangeEXT",
    "TextureStorage2DMultisampleEXT",
    "TextureStorage3DMultisampleEXT",
    "VertexArrayBindVertexBufferEXT",
    "VertexArrayVertexAttribFormatEXT",
    "VertexArrayVertexAttribIFormatEXT",
    "VertexArrayVertexAttribLFormatEXT",
    "VertexArrayVertexAttribBindingEXT",
    "VertexArrayVertexBindingDivisorEXT",
    "NamedBufferPageCommitmentEXT",
    "NamedStringARB",
    "DeleteNamedStringARB",
    "CompileShaderIncludeARB",
    "IsNamedStringARB",
    "GetNamedStringARB",
    "GetNamedStringivARB",
    "EGLImageTargetTexStorageEXT" ,
    "EGLImageTargetTextureStorageEXT" ,
    "CopyImageSubDataNV",
    "ViewportSwizzleNV",
    "AlphaToCoverageDitherControlNV",
    "InternalBufferSubDataCopyMESA",
    "Vertex2hNV",
    "Vertex2hvNV",
    "Vertex3hNV",
    "Vertex3hvNV",
    "Vertex4hNV",
    "Vertex4hvNV",
    "Normal3hNV",
    "Normal3hvNV",
    "Color3hNV",
    "Color3hvNV",
    "Color4hNV",
    "Color4hvNV",
    "TexCoord1hNV",
    "TexCoord1hvNV",
    "TexCoord2hNV",
    "TexCoord2hvNV",
    "TexCoord3hNV",
    "TexCoord3hvNV",
    "TexCoord4hNV",
    "TexCoord4hvNV",
    "MultiTexCoord1hNV",
    "MultiTexCoord1hvNV",
    "MultiTexCoord2hNV",
    "MultiTexCoord2hvNV",
    "MultiTexCoord3hNV",
    "MultiTexCoord3hvNV",
    "MultiTexCoord4hNV",
    "MultiTexCoord4hvNV",
    "FogCoordhNV",
    "FogCoordhvNV",
    "SecondaryColor3hNV",
    "SecondaryColor3hvNV",
    "InternalSetError",
    "VertexAttrib1hNV",
    "VertexAttrib1hvNV",
    "VertexAttrib2hNV",
    "VertexAttrib2hvNV",
    "VertexAttrib3hNV",
    "VertexAttrib3hvNV",
    "VertexAttrib4hNV",
    "VertexAttrib4hvNV",
    "VertexAttribs1hvNV",
    "VertexAttribs2hvNV",
    "VertexAttribs3hvNV",
    "VertexAttribs4hvNV",
    "TexPageCommitmentARB",
    "TexturePageCommitmentEXT",
    "ImportMemoryWin32HandleEXT",
    "ImportSemaphoreWin32HandleEXT",
    "ImportMemoryWin32NameEXT",
    "ImportSemaphoreWin32NameEXT",
    "GetObjectLabelEXT",
    "LabelObjectEXT",
    "DrawArraysUserBuf",
    "DrawElementsUserBuf",
    "MultiDrawArraysUserBuf",
    "MultiDrawElementsUserBuf",
    "DrawArraysInstancedBaseInstanceDrawID",
    "DrawElementsInstancedBaseVertexBaseInstanceDrawID",
    "InternalInvalidateFramebufferAncillaryMESA",
    "DrawElementsPacked",
    "DrawElementsUserBufPacked",
    "TexStorageAttribs2DEXT",
    "TexStorageAttribs3DEXT",
    "FramebufferTextureMultiviewOVR",
    "NamedFramebufferTextureMultiviewOVR",
    "FramebufferTextureMultisampleMultiviewOVR",
    "CreateSemaphoresNV",
    "GetSemaphoreParameterivNV",
    "SemaphoreParameterivNV",

    # Keep these last. They are never used by any app.
    "ColorTable",
    "ColorTableParameterfv",
    "ColorTableParameteriv",
    "CopyColorTable",
    "GetColorTable",
    "GetColorTableParameterfv",
    "GetColorTableParameteriv",
    "ColorSubTable",
    "CopyColorSubTable",
    "ConvolutionFilter1D",
    "ConvolutionFilter2D",
    "ConvolutionParameterf",
    "ConvolutionParameterfv",
    "ConvolutionParameteri",
    "ConvolutionParameteriv",
    "CopyConvolutionFilter1D",
    "CopyConvolutionFilter2D",
    "GetConvolutionFilter",
    "GetConvolutionParameterfv",
    "GetConvolutionParameteriv",
    "GetSeparableFilter",
    "SeparableFilter2D",
    "GetHistogram",
    "GetHistogramParameterfv",
    "GetHistogramParameteriv",
    "GetMinmax",
    "GetMinmaxParameterfv",
    "GetMinmaxParameteriv",
    "Histogram",
    "Minmax",
    "ResetHistogram",
    "ResetMinmax",
    "GetnColorTableARB",
    "GetnConvolutionFilterARB",
    "GetnHistogramARB",
    "GetnMinmaxARB",
    "GetnSeparableFilterARB",
]

offsets = {}
i = 0
for name in all_functions:
    if name in offsets:
        print('duplicated name in all_functions: ' + name)
        assert False
    offsets[name] = i
    i += 1

function_count = i

# Exported from libGL.so
libgl_public_functions = set()
with open(os.path.join(os.path.dirname(os.path.abspath(__file__)),
                       '..', '..', '..', 'glx', 'libgl-symbols.txt'), 'r') as f:
    for line in f:
        if len(line) > 3 and line[0:2] == 'gl' and line[2] != 'X':
            libgl_public_functions.add(line[2:].rstrip())
