; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
;
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; =========================
;  Section: Special Axioms
; =========================
; contains special axioms


; Subsection: Axiom "AC", "ACL", "IP", "UNC"
; ==========================================

; Definition: "AC"
; ----------------
(add-global-assumption "AC" 
 (pf "all alpha1^ ex alpha2^ (Pvar alpha1 alpha2)alpha1^alpha2^ ->
      ex alpha1=>alpha2^ all alpha1^ 
      (Pvar alpha1 alpha2)alpha1^(alpha1=>alpha2^alpha1^)"))

; Definition: "ACL"
; -----------------
; Remark: Arity 1 would conflict with animating ACL later

(add-global-assumption "ACL" 
 (pf "(all k.(Pvar nat)k -> ex r (Pvar nat term)k r) ->
      ex g all k.(Pvar nat)k ->  (Pvar nat term)k(g k)"))

; Definition: "IP"
; ----------------
(add-global-assumption "IP" 
 (pf "(Pvar -> ex alpha^ (Pvar alpha)alpha^) -> 
      ex alpha^(Pvar -> (Pvar alpha)alpha^)"))

; Definition: "UNC"
; -----------------
(add-global-assumption "UNC" 
 (pf "allnc alpha1 ex alpha2^ (Pvar alpha1 alpha2)alpha1 alpha2^ ->
      ex alpha2^ allnc alpha1 (Pvar alpha1 alpha2)alpha1 alpha2^"))


; Subsection: Compatibility Lemmas
; ================================

; Lemma: "SCrCompat2"
; -------------------
(add-global-assumption "SCrCompat2"
 (pf "all rhos,rho^1,rho^2,a^,r.rho^1=rho^2 -> 
      SCr rhos rho^1 a^ r -> SCr rhos rho^2 a^ r"))

; Lemma: "SCrCompat2Rev"
; ----------------------
(add-global-assumption "SCrCompat2Rev"
 (pf "all rhos,rho^1,rho^2,a^,r.rho^1=rho^2 -> 
      SCr rhos rho^2 a^ r -> SCr rhos rho^1 a^ r"))
