(* tag.sml
 * 2005 Matthew Fluet (mfluet@acm.org)
 *  Adapted for MLton.
 *)

(*
 * This module provides an infinite family of mutually distinct types
 * where each type corresponds to a sequence of "letters" (taken
 * from [a-zA-Z0-9_']).  There are no values that correspond to these
 * types.
 *
 * (C) 2001, Lucent Technologies, Bell Laboratories
 *
 * author: Matthias Blume (blume@research.bell-labs.com)
 *)
structure Tag :> sig

    type 't t_0 type 't t_1 type 't t_2 type 't t_3
    type 't t_4 type 't t_5 type 't t_6 type 't t_7
    type 't t_8 type 't t_9

    type 't t__ type 't t_'

    type 't t_a type 't t_b type 't t_c type 't t_d
    type 't t_e type 't t_f type 't t_g type 't t_h
    type 't t_i type 't t_j type 't t_k type 't t_l
    type 't t_m type 't t_n type 't t_o type 't t_p
    type 't t_q type 't t_r type 't t_s type 't t_t
    type 't t_u type 't t_v type 't t_w type 't t_x
    type 't t_y type 't t_z

    type 't t_A type 't t_B type 't t_C type 't t_D
    type 't t_E type 't t_F type 't t_G type 't t_H
    type 't t_I type 't t_J type 't t_K type 't t_L
    type 't t_M type 't t_N type 't t_O type 't t_P
    type 't t_Q type 't t_R type 't t_S type 't t_T
    type 't t_U type 't t_V type 't t_W type 't t_X
    type 't t_Y type 't t_Z

    type s
    type u
    type e
end = struct

    type 't t_0 = unit type 't t_1 = unit type 't t_2 = unit type 't t_3 = unit
    type 't t_4 = unit type 't t_5 = unit type 't t_6 = unit type 't t_7 = unit
    type 't t_8 = unit type 't t_9 = unit

    type 't t__ = unit type 't t_' = unit

    type 't t_a = unit type 't t_b = unit type 't t_c = unit type 't t_d = unit
    type 't t_e = unit type 't t_f = unit type 't t_g = unit type 't t_h = unit
    type 't t_i = unit type 't t_j = unit type 't t_k = unit type 't t_l = unit
    type 't t_m = unit type 't t_n = unit type 't t_o = unit type 't t_p = unit
    type 't t_q = unit type 't t_r = unit type 't t_s = unit type 't t_t = unit
    type 't t_u = unit type 't t_v = unit type 't t_w = unit type 't t_x = unit
    type 't t_y = unit type 't t_z = unit

    type 't t_A = unit type 't t_B = unit type 't t_C = unit type 't t_D = unit
    type 't t_E = unit type 't t_F = unit type 't t_G = unit type 't t_H = unit
    type 't t_I = unit type 't t_J = unit type 't t_K = unit type 't t_L = unit
    type 't t_M = unit type 't t_N = unit type 't t_O = unit type 't t_P = unit
    type 't t_Q = unit type 't t_R = unit type 't t_S = unit type 't t_T = unit
    type 't t_U = unit type 't t_V = unit type 't t_W = unit type 't t_X = unit
    type 't t_Y = unit type 't t_Z = unit

    type s = unit
    type u = unit
    type e = unit
end
