//------------------------------------------------------------------------------
// <copyright file="XPathSelfQuery.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
// <owner current="true" primary="true">Microsoft</owner>
//------------------------------------------------------------------------------

namespace MS.Internal.Xml.XPath {
    using System;
    using System.Xml;
    using System.Xml.XPath;
    using System.Diagnostics;

    internal sealed class XPathSelfQuery : BaseAxisQuery {
        public XPathSelfQuery(Query qyInput, string Name, string Prefix, XPathNodeType Type) : base(qyInput, Name, Prefix, Type) {}
        private XPathSelfQuery(XPathSelfQuery other) : base(other) { }
                
        public override XPathNavigator Advance() {
            while ((currentNode = qyInput.Advance()) != null) {
                if (matches(currentNode)) {
                    position = 1;
                    return currentNode;
                }
            }
            return null;
        }
                
        public override XPathNodeIterator Clone() { return new XPathSelfQuery(this); }
    }
}
