# -*- coding: utf-8 -*-
# Copyright 2010-2021, Google Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

"""Generates usage stats name list."""

import argparse
import sys


def GetStatsNameList(infile):
  stats = []
  for line in infile:
    stat = line.strip()
    if not stat or stat[0] == '#':
      continue
    stats.append(stat)
  return stats


def main():
  parser = argparse.ArgumentParser()
  parser.add_argument(
      '--output',
      type=argparse.FileType('w', encoding='utf-8'),
      default=sys.stdout,
  )
  parser.add_argument('input', type=argparse.FileType('r', encoding='utf-8'))
  args = parser.parse_args()

  stats_list = GetStatsNameList(args.input)
  args.output.write('// This header file is generated by gen_stats_list.py\n')
  for stats in stats_list:
    args.output.write(
        'constexpr absl::string_view k%s = "%s";\n' % (stats, stats)
    )
  args.output.write('constexpr absl::string_view kStatsList[] = {\n')
  for stats in stats_list:
    args.output.write('  k%s,\n' % stats)
  args.output.write('};\n')


if __name__ == '__main__':
  main()
