// |reftest| shell-option(--enable-temporal) skip-if(!this.hasOwnProperty('Temporal')||!xulRuntime.shell) -- Temporal is not enabled unconditionally, requires shell-options
// Copyright (C) 2024 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-date.prototype.totemporalinstant
description: >
  Date.prototype.toTemporalInstant does not implement [[Construct]]
info: |
  ECMAScript Function Objects

  Built-in function objects that are not identified as constructors do not
  implement the [[Construct]] internal method unless otherwise specified in
  the description of a particular function.
includes: [isConstructor.js]
features: [Temporal, Reflect.construct]
---*/

assert.sameValue(
  isConstructor(Date.prototype.toTemporalInstant),
  false,
  'isConstructor(Date.prototype.toTemporalInstant) must return false'
);

var date = new Date(0);

assert.throws(TypeError, function() {
  new date.toTemporalInstant();
});


reportCompare(0, 0);
