# Copyright (C) Jan 2020 Mellanox Technologies Ltd. All rights reserved.   
#                                                                           
# This software is available to you under a choice of one of two            
# licenses.  You may choose to be licensed under the terms of the GNU       
# General Public License (GPL) Version 2, available from the file           
# COPYING in the main directory of this source tree, or the                 
# OpenIB.org BSD license below:                                             
#                                                                           
#     Redistribution and use in source and binary forms, with or            
#     without modification, are permitted provided that the following       
#     conditions are met:                                                   
#                                                                           
#      - Redistributions of source code must retain the above               
#        copyright notice, this list of conditions and the following        
#        disclaimer.                                                        
#                                                                           
#      - Redistributions in binary form must reproduce the above            
#        copyright notice, this list of conditions and the following        
#        disclaimer in the documentation and/or other materials             
#        provided with the distribution.                                    
#                                                                           
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,         
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF        
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                     
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS       
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN        
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN         
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE          
# SOFTWARE.                                                                 
# --                                                                        


#######################################################
# 
# resourceparse.py
# Python implementation of the Class ResourceParse
# Generated by Enterprise Architect
# Created on:      16-Dec-2019 14:11:58 AM
# Original author: talve
# 
#######################################################
import sys
import os

if sys.version_info[0] < 3:
    print("Error: This tool supports python 3.x only. Exiting...")
    exit(1)

import argparse
from utils import constants as cs
from parsers.Parser import Parser

sys.path.append(os.path.join("common"))
import tools_version


class ResourceParse:
    """This class is responsible for the resource dump UI by handling the user inputs and
       and running the right command.
    """

    @classmethod
    def _run_arg_parse(self):
        """This method run the arg parse and return the arguments from the UI.
        """
        # main parser
        tool_name = os.path.basename(__file__.split('.')[0])
        parser = argparse.ArgumentParser(prog=tool_name, add_help=False, formatter_class=argparse.RawTextHelpFormatter)

        # required arguments by the parser
        required_named = parser.add_argument_group('required arguments')
        required_named.add_argument(cs.UI_DASHES + cs.UI_ARG_DUMP_FILE.replace("_", "-"),
                                    help='Location of the dump file used for parsing', required=True)
        required_named.add_argument(cs.UI_DASHES + cs.UI_ARG_ADB_FILE.replace("_", "-"),
                                    help='Location of the ADB file', required=True)

        # optional arguments by the parser
        parser.add_argument('-h', '--help', action='help', default=argparse.SUPPRESS,
                            help='Shows this help message and exit')
        parser.add_argument('--version', action='version', help="Shows the tool's version and exit",
                            version=tools_version.GetVersionString(tool_name, None))

        parser.add_argument(cs.UI_DASHES + cs.UI_ARG_OUT, help='Location of the output file', required=False)
        parser.add_argument(cs.UI_DASHES + cs.UI_ARG_RAW, help='Prints the raw data in addition to the parsed data',
                            required=False, action="store_true", default=False)
        parser.add_argument(cs.UI_DASHES_SHORT + cs.UI_ARG_VERBOSITY,
                            help='Verbosity notice', dest=cs.UI_ARG_VERBOSITY_COUNT,
                            default=0, action='count')
        arguments = parser.parse_args()
        return arguments

    def run(self):
        """This method run the parser with the needed arguments
        """
        arguments = self._run_arg_parse()
        resource_parser = Parser(**vars(arguments))
        resource_parser.parse()


if __name__ == '__main__':
    try:
        ResourceParse().run()
    except Exception as e:
        print("Error: {0}. Exiting...".format(e))
        sys.exit(1)
