/* $Id: id2_client.hpp 605265 2020-04-08 16:20:52Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file id2_client.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: id2_client_.hpp


#ifndef OBJECTS_ID2_ID2_CLIENT_HPP
#define OBJECTS_ID2_ID2_CLIENT_HPP


// generated includes
#include <objects/id2/id2_client_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CID2_Request_Packet;

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2Client : public CID2Client_Base
{
    typedef CID2Client_Base Tparent;
public:
    // constructor
    CID2Client(void);
    // destructor
    ~CID2Client(void);

    // ID2 allows multuple replies on each request, so we have to override
    // default ReadReply. The Ask() methods return only the last reply,
    // all replies are available via GetAllReplies() method.
    typedef vector< CRef<TReply> > TReplies;
    const TReplies& GetAllReplies(void)
    { return m_Replies; }

    void JustAsk(const CID2_Request_Packet& packet);
    void JustAsk(const CID2_Request& request);
    void JustFetch(CID2_Reply& reply)
        { ReadReply(*m_In, reply); }

protected:
    // ID2 requires requests to be sent in ID2-Request-Packet that may hold
    // several requests, so we have to override default WriteRequest.
    virtual void WriteRequest(CObjectOStream& out, const TRequest& request);

    // ID2 allows multuple replies on each request, so we have to override
    // default ReadReply. The Ask() methods return only the last reply,
    // all replies are available via GetAllReplies() method.
    virtual void ReadReply(CObjectIStream& in, TReply& reply);

private:
    TReplies m_Replies;

private:
    // Prohibit copy constructor and assignment operator
    CID2Client(const CID2Client& value);
    CID2Client& operator=(const CID2Client& value);

};

/////////////////// CID2Client inline methods

// constructor
inline
CID2Client::CID2Client(void)
{
}


/////////////////// end of CID2Client inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_CLIENT_HPP
