# Collaborator Guide

As a collaborator, you will be involved with axios with some administrative responsibilities. This guide will help you understand your role and the responsibilities that come with being a collaborator.

1. __Adhere to and help enforce the Code of Conduct.__ It is expected that you have read the [code of conduct](https://github.com/axios/axios/blob/master/CODE_OF_CONDUCT.md) and that you agree to live by it. This community should be friendly and welcoming.

1. __Triage issues.__ As a collaborator, you may help sort through the issues that are reported. Issues vary from bugs, regressions, feature requests, questions, etc. Apply the appropriate label(s) and respond as needed. If it is a legitimate request, please address it, otherwise feel free to close the issue and include a comment with a suggestion on where to find support. If an issue has been inactive for more than a week (i.e., the owner of the issue hasn’t responded to you), close the issue with a note indicating stale issues are closed; it can always be reopened if needed. In the case of issues that require a code change, encourage the owner to submit a PR. For less complex code changes, add a very simple and detailed checklist, apply the “first-timers-only” label, and encourage a newcomer to open source to get involved.

1. __Answer questions.__ It is not expected that you provide answers to questions that aren’t relevant, nor do you need to mentor people on how to use JavaScript, etc. If the question is not directly about the module, please close the issue. If the question stems from poor documentation, please update the docs and consider adding a code example. In any event try to be helpful and remember that there’s no such thing as a stupid question.

1. __Assist with PRs.__ By encouraging contributors to supply a PR for their own issue this is ideally where most of your attention will be focused. Keep a few things in mind as you review PRs.

- When fixing a bug: does the PR adequately solve the problem without introducing any regressions?
- When implementing a feature: does the feature fit within the scope of axios?
- When removing functionality: is it properly deprecated with a warning?
- When introducing functionality: is the API predictable?
- Does the new code work for all supported platforms/browsers?
- Do the tests and linting pass CI?
- Are there tests to validate the changes that have been made?

1. __Fix bugs and implement features.__ When things need to be fixed or implemented, and a PR can’t wait, you may do things yourself. You should still submit a PR yourself and get it checked off by at least one other contributor. Keep the points from number 4 in consideration as you push your code.

Thank you again for your help as a collaborator and in making axios community great! If you have any questions or need any assistance, please feel free to contact another collaborator or the owner.
