/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.security.AccessControlList;

public class LogoutUser
extends Action {
    public void doPerform(RunData data) throws Exception {
        User user = data.getUser();
        if (user != null) {
            if (!user.hasLoggedIn()) {
                return;
            }
            user.setHasLoggedIn(new Boolean(false));
            TurbineSecurity.saveUser(user);
        }
        data.setMessage(TurbineResources.getString("logout.message"));
        data.setACL(null);
        data.setUser(TurbineSecurity.getAnonymousUser());
        data.save();
        data.getSession().removeValue(AccessControlList.SESSION_KEY);
        if (!TurbineResources.getString("action.logout", "").equals("LogoutUser")) {
            data.setScreen(TurbineResources.getString("screen.homepage"));
        }
    }
}

