/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.turbine.services.intake.model.BigDecimalField;
import org.apache.turbine.services.intake.model.BooleanField;
import org.apache.turbine.services.intake.model.ComboKeyField;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.model.IntegerField;
import org.apache.turbine.services.intake.model.NumberKeyField;
import org.apache.turbine.services.intake.model.StringField;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.TurbineException;

public abstract class FieldFactory {
    private static Map fieldCtors = FieldFactory.initFieldCtors();

    private static Map initFieldCtors() {
        fieldCtors = new HashMap();
        fieldCtors.put("int", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new IntegerField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        fieldCtors.put("boolean", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new BooleanField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        fieldCtors.put("String", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new StringField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        fieldCtors.put("BigDecimal", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new BigDecimalField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        fieldCtors.put("NumberKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new NumberKeyField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        fieldCtors.put("ComboKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new ComboKeyField(f, g);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        return fieldCtors;
    }

    public static final Field getInstance(XmlField f, Group g) throws Exception {
        Field field = null;
        String type = f.getType();
        field = ((FieldCtor)fieldCtors.get(type)).getInstance(f, g);
        if (field == null) {
            throw new TurbineException("Unsupported type: " + type);
        }
        return field;
    }

    private static abstract class FieldCtor {
        public Field getInstance(XmlField f, Group g) throws Exception {
            return null;
        }

        FieldCtor() {
        }
    }
}

