/*
  Adplug - Replayer for many OPL2/OPL3 audio file formats.
  Copyright (C) 1999 - 2003 Simon Peter, <dn.tlp@gmx.net>, et al.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  mad.h - MAD loader by Riven the Mage <riven@ok.ru>
*/

#include "protrack.h"

class CmadLoader: public CmodPlayer
{
public:
	static CPlayer *factory(Copl *newopl);

	CmadLoader(Copl *newopl) : CmodPlayer(newopl) { };

	bool	load(const std::string &filename, const CFileProvider &fp) override;
	void	rewind(int subsong) override;
	float	getrefresh() override;

	std::string	gettype() override;
	std::string	getinstrument(unsigned int n) override;
	unsigned int	getinstruments() override;

private:

	struct mad_instrument
	{
	  char            name[8];
	  unsigned char   data[12]; // last two unused
	} instruments[9];

	unsigned char   timer;
};
