/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/relative_pose/modules/fivept_kneip/modules.hpp>


void
opengv::relative_pose::modules::fivept_kneip::computeBasis(
    Eigen::Matrix<double,66,197> & groebnerMatrix )
{
  double factor = 0.0;

  sPolynomial30(groebnerMatrix);
  factor = -groebnerMatrix(30,1);
  groebnerMatrix(30,1) = 0.0;
  groebnerMatrix(30,8) = groebnerMatrix(30,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,179) = groebnerMatrix(30,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,2);
  groebnerMatrix(30,2) = 0.0;
  groebnerMatrix(30,11) = groebnerMatrix(30,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,24) = groebnerMatrix(30,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,3);
  groebnerMatrix(30,3) = 0.0;
  groebnerMatrix(30,10) = groebnerMatrix(30,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,180) = groebnerMatrix(30,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,4);
  groebnerMatrix(30,4) = 0.0;
  groebnerMatrix(30,36) = groebnerMatrix(30,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(30,136) = groebnerMatrix(30,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(30,190) = groebnerMatrix(30,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(30,5);
  groebnerMatrix(30,5) = 0.0;
  groebnerMatrix(30,17) = groebnerMatrix(30,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(30,34) = groebnerMatrix(30,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(30,188) = groebnerMatrix(30,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(30,6);
  groebnerMatrix(30,6) = 0.0;
  groebnerMatrix(30,18) = groebnerMatrix(30,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(30,35) = groebnerMatrix(30,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(30,189) = groebnerMatrix(30,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(30,10);
  groebnerMatrix(30,10) = 0.0;
  groebnerMatrix(30,20) = groebnerMatrix(30,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,163) = groebnerMatrix(30,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(30,11);
  groebnerMatrix(30,11) = 0.0;
  groebnerMatrix(30,21) = groebnerMatrix(30,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,164) = groebnerMatrix(30,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(30,12);
  groebnerMatrix(30,12) = 0.0;
  groebnerMatrix(30,23) = groebnerMatrix(30,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,165) = groebnerMatrix(30,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,13);
  groebnerMatrix(30,13) = 0.0;
  groebnerMatrix(30,17) = groebnerMatrix(30,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,30) = groebnerMatrix(30,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,14);
  groebnerMatrix(30,14) = 0.0;
  groebnerMatrix(30,16) = groebnerMatrix(30,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,182) = groebnerMatrix(30,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(30,15);
  groebnerMatrix(30,15) = 0.0;
  groebnerMatrix(30,26) = groebnerMatrix(30,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,166) = groebnerMatrix(30,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(30,18);
  groebnerMatrix(30,18) = 0.0;
  groebnerMatrix(30,29) = groebnerMatrix(30,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,167) = groebnerMatrix(30,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,19);
  groebnerMatrix(30,19) = 0.0;
  groebnerMatrix(30,21) = groebnerMatrix(30,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(30,24) = groebnerMatrix(30,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(30,192) = groebnerMatrix(30,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(30,22);
  groebnerMatrix(30,22) = 0.0;
  groebnerMatrix(30,36) = groebnerMatrix(30,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(30,123) = groebnerMatrix(30,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(30,25);
  groebnerMatrix(30,25) = 0.0;
  groebnerMatrix(30,29) = groebnerMatrix(30,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,35) = groebnerMatrix(30,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,26);
  groebnerMatrix(30,26) = 0.0;
  groebnerMatrix(30,28) = groebnerMatrix(30,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,183) = groebnerMatrix(30,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,27);
  groebnerMatrix(30,27) = 0.0;
  groebnerMatrix(30,33) = groebnerMatrix(30,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(30,175) = groebnerMatrix(30,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(30,30);
  groebnerMatrix(30,30) = 0.0;
  groebnerMatrix(30,34) = groebnerMatrix(30,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,168) = groebnerMatrix(30,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,39);
  groebnerMatrix(30,39) = 0.0;
  groebnerMatrix(30,63) = groebnerMatrix(30,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,101) = groebnerMatrix(30,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,40);
  groebnerMatrix(30,40) = 0.0;
  groebnerMatrix(30,62) = groebnerMatrix(30,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,158) = groebnerMatrix(30,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(30,41);
  groebnerMatrix(30,41) = 0.0;
  groebnerMatrix(30,65) = groebnerMatrix(30,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,102) = groebnerMatrix(30,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,42);
  groebnerMatrix(30,42) = 0.0;
  groebnerMatrix(30,64) = groebnerMatrix(30,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,159) = groebnerMatrix(30,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(30,43);
  groebnerMatrix(30,43) = 0.0;
  groebnerMatrix(30,56) = groebnerMatrix(30,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(30,139) = groebnerMatrix(30,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(30,193) = groebnerMatrix(30,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(30,44);
  groebnerMatrix(30,44) = 0.0;
  groebnerMatrix(30,72) = groebnerMatrix(30,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,113) = groebnerMatrix(30,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(30,45);
  groebnerMatrix(30,45) = 0.0;
  groebnerMatrix(30,73) = groebnerMatrix(30,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,114) = groebnerMatrix(30,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(30,46);
  groebnerMatrix(30,46) = 0.0;
  groebnerMatrix(30,72) = groebnerMatrix(30,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,109) = groebnerMatrix(30,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,47);
  groebnerMatrix(30,47) = 0.0;
  groebnerMatrix(30,71) = groebnerMatrix(30,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,161) = groebnerMatrix(30,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(30,48);
  groebnerMatrix(30,48) = 0.0;
  groebnerMatrix(30,52) = groebnerMatrix(30,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,169) = groebnerMatrix(30,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,49);
  groebnerMatrix(30,49) = 0.0;
  groebnerMatrix(30,75) = groebnerMatrix(30,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,116) = groebnerMatrix(30,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(30,50);
  groebnerMatrix(30,50) = 0.0;
  groebnerMatrix(30,74) = groebnerMatrix(30,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(30,154) = groebnerMatrix(30,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(30,51);
  groebnerMatrix(30,51) = 0.0;
  groebnerMatrix(30,77) = groebnerMatrix(30,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,114) = groebnerMatrix(30,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,52);
  groebnerMatrix(30,52) = 0.0;
  groebnerMatrix(30,76) = groebnerMatrix(30,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,162) = groebnerMatrix(30,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(30,53);
  groebnerMatrix(30,53) = 0.0;
  groebnerMatrix(30,105) = groebnerMatrix(30,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(30,146) = groebnerMatrix(30,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(30,54);
  groebnerMatrix(30,54) = 0.0;
  groebnerMatrix(30,80) = groebnerMatrix(30,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,117) = groebnerMatrix(30,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(30,55);
  groebnerMatrix(30,55) = 0.0;
  groebnerMatrix(30,79) = groebnerMatrix(30,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(30,159) = groebnerMatrix(30,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(30,56);
  groebnerMatrix(30,56) = 0.0;
  groebnerMatrix(30,115) = groebnerMatrix(30,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(30,158) = groebnerMatrix(30,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(30,57);
  groebnerMatrix(30,57) = 0.0;
  groebnerMatrix(30,90) = groebnerMatrix(30,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(30,134) = groebnerMatrix(30,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(30,188) = groebnerMatrix(30,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(30,58);
  groebnerMatrix(30,58) = 0.0;
  groebnerMatrix(30,91) = groebnerMatrix(30,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(30,135) = groebnerMatrix(30,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(30,189) = groebnerMatrix(30,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(30,59);
  groebnerMatrix(30,59) = 0.0;
  groebnerMatrix(30,93) = groebnerMatrix(30,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(30,137) = groebnerMatrix(30,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(30,191) = groebnerMatrix(30,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(30,60);
  groebnerMatrix(30,60) = 0.0;
  groebnerMatrix(30,94) = groebnerMatrix(30,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(30,138) = groebnerMatrix(30,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(30,192) = groebnerMatrix(30,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(30,61);
  groebnerMatrix(30,61) = 0.0;
  groebnerMatrix(30,63) = groebnerMatrix(30,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(30,66) = groebnerMatrix(30,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(30,194) = groebnerMatrix(30,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(30,64);
  groebnerMatrix(30,64) = 0.0;
  groebnerMatrix(30,98) = groebnerMatrix(30,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,148) = groebnerMatrix(30,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(30,65);
  groebnerMatrix(30,65) = 0.0;
  groebnerMatrix(30,99) = groebnerMatrix(30,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,149) = groebnerMatrix(30,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(30,66);
  groebnerMatrix(30,66) = 0.0;
  groebnerMatrix(30,101) = groebnerMatrix(30,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,150) = groebnerMatrix(30,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(30,67);
  groebnerMatrix(30,67) = 0.0;
  groebnerMatrix(30,72) = groebnerMatrix(30,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,78) = groebnerMatrix(30,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,68);
  groebnerMatrix(30,68) = 0.0;
  groebnerMatrix(30,71) = groebnerMatrix(30,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,185) = groebnerMatrix(30,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,69);
  groebnerMatrix(30,69) = 0.0;
  groebnerMatrix(30,104) = groebnerMatrix(30,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,151) = groebnerMatrix(30,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(30,70);
  groebnerMatrix(30,70) = 0.0;
  groebnerMatrix(30,75) = groebnerMatrix(30,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(30,81) = groebnerMatrix(30,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(30,194) = groebnerMatrix(30,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(30,73);
  groebnerMatrix(30,73) = 0.0;
  groebnerMatrix(30,77) = groebnerMatrix(30,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,176) = groebnerMatrix(30,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(30,76);
  groebnerMatrix(30,76) = 0.0;
  groebnerMatrix(30,107) = groebnerMatrix(30,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,142) = groebnerMatrix(30,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(30,77);
  groebnerMatrix(30,77) = 0.0;
  groebnerMatrix(30,108) = groebnerMatrix(30,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,143) = groebnerMatrix(30,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(30,78);
  groebnerMatrix(30,78) = 0.0;
  groebnerMatrix(30,113) = groebnerMatrix(30,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,160) = groebnerMatrix(30,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(30,79);
  groebnerMatrix(30,79) = 0.0;
  groebnerMatrix(30,110) = groebnerMatrix(30,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,148) = groebnerMatrix(30,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(30,80);
  groebnerMatrix(30,80) = 0.0;
  groebnerMatrix(30,111) = groebnerMatrix(30,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,152) = groebnerMatrix(30,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(30,81);
  groebnerMatrix(30,81) = 0.0;
  groebnerMatrix(30,116) = groebnerMatrix(30,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,157) = groebnerMatrix(30,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(30,82);
  groebnerMatrix(30,82) = 0.0;
  groebnerMatrix(30,90) = groebnerMatrix(30,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,127) = groebnerMatrix(30,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,83);
  groebnerMatrix(30,83) = 0.0;
  groebnerMatrix(30,89) = groebnerMatrix(30,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,175) = groebnerMatrix(30,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(30,84);
  groebnerMatrix(30,84) = 0.0;
  groebnerMatrix(30,119) = groebnerMatrix(30,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,166) = groebnerMatrix(30,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(30,85);
  groebnerMatrix(30,85) = 0.0;
  groebnerMatrix(30,93) = groebnerMatrix(30,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,130) = groebnerMatrix(30,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(30,86);
  groebnerMatrix(30,86) = 0.0;
  groebnerMatrix(30,92) = groebnerMatrix(30,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(30,172) = groebnerMatrix(30,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(30,87);
  groebnerMatrix(30,87) = 0.0;
  groebnerMatrix(30,122) = groebnerMatrix(30,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,163) = groebnerMatrix(30,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(30,91);
  groebnerMatrix(30,91) = 0.0;
  groebnerMatrix(30,126) = groebnerMatrix(30,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,173) = groebnerMatrix(30,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(30,94);
  groebnerMatrix(30,94) = 0.0;
  groebnerMatrix(30,129) = groebnerMatrix(30,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,170) = groebnerMatrix(30,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(30,97);
  groebnerMatrix(30,97) = 0.0;
  groebnerMatrix(30,99) = groebnerMatrix(30,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(30,102) = groebnerMatrix(30,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(30,195) = groebnerMatrix(30,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(30,100);
  groebnerMatrix(30,100) = 0.0;
  groebnerMatrix(30,115) = groebnerMatrix(30,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(30,139) = groebnerMatrix(30,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(30,103);
  groebnerMatrix(30,103) = 0.0;
  groebnerMatrix(30,108) = groebnerMatrix(30,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,114) = groebnerMatrix(30,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,104);
  groebnerMatrix(30,104) = 0.0;
  groebnerMatrix(30,107) = groebnerMatrix(30,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,186) = groebnerMatrix(30,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,105);
  groebnerMatrix(30,105) = 0.0;
  groebnerMatrix(30,112) = groebnerMatrix(30,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(30,185) = groebnerMatrix(30,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(30,106);
  groebnerMatrix(30,106) = 0.0;
  groebnerMatrix(30,111) = groebnerMatrix(30,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(30,117) = groebnerMatrix(30,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(30,195) = groebnerMatrix(30,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(30,109);
  groebnerMatrix(30,109) = 0.0;
  groebnerMatrix(30,113) = groebnerMatrix(30,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,184) = groebnerMatrix(30,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,118);
  groebnerMatrix(30,118) = 0.0;
  groebnerMatrix(30,126) = groebnerMatrix(30,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,135) = groebnerMatrix(30,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,119);
  groebnerMatrix(30,119) = 0.0;
  groebnerMatrix(30,125) = groebnerMatrix(30,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,183) = groebnerMatrix(30,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(30,120);
  groebnerMatrix(30,120) = 0.0;
  groebnerMatrix(30,133) = groebnerMatrix(30,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(30,182) = groebnerMatrix(30,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(30,121);
  groebnerMatrix(30,121) = 0.0;
  groebnerMatrix(30,129) = groebnerMatrix(30,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,138) = groebnerMatrix(30,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(30,122);
  groebnerMatrix(30,122) = 0.0;
  groebnerMatrix(30,128) = groebnerMatrix(30,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(30,180) = groebnerMatrix(30,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(30,123);
  groebnerMatrix(30,123) = 0.0;
  groebnerMatrix(30,136) = groebnerMatrix(30,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(30,179) = groebnerMatrix(30,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(30,127);
  groebnerMatrix(30,127) = 0.0;
  groebnerMatrix(30,134) = groebnerMatrix(30,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,181) = groebnerMatrix(30,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(30,130);
  groebnerMatrix(30,130) = 0.0;
  groebnerMatrix(30,137) = groebnerMatrix(30,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,178) = groebnerMatrix(30,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(30,142);
  groebnerMatrix(30,142) = 0.0;
  groebnerMatrix(30,144) = groebnerMatrix(30,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(30,147) = groebnerMatrix(30,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(30,196) = groebnerMatrix(30,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(30,143);
  groebnerMatrix(30,143) = 0.0;
  groebnerMatrix(30,155) = groebnerMatrix(30,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(30,176) = groebnerMatrix(30,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(30,144);
  groebnerMatrix(30,144) = 0.0;
  groebnerMatrix(30,156) = groebnerMatrix(30,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(30,177) = groebnerMatrix(30,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(30,196) = groebnerMatrix(30,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(30,146);
  groebnerMatrix(30,146) = 0.0;
  groebnerMatrix(30,161) = groebnerMatrix(30,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(30,185) = groebnerMatrix(30,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(30,147);
  groebnerMatrix(30,147) = 0.0;
  groebnerMatrix(30,162) = groebnerMatrix(30,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(30,186) = groebnerMatrix(30,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(30,196) = groebnerMatrix(30,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(30,148);
  groebnerMatrix(30,148) = 0.0;
  groebnerMatrix(30,153) = groebnerMatrix(30,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(30,159) = groebnerMatrix(30,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(30,149);
  groebnerMatrix(30,149) = 0.0;
  groebnerMatrix(30,152) = groebnerMatrix(30,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(30,195) = groebnerMatrix(30,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(30,150);
  groebnerMatrix(30,150) = 0.0;
  groebnerMatrix(30,157) = groebnerMatrix(30,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(30,194) = groebnerMatrix(30,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(30,151);
  groebnerMatrix(30,151) = 0.0;
  groebnerMatrix(30,156) = groebnerMatrix(30,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(30,162) = groebnerMatrix(30,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(30,196) = groebnerMatrix(30,196) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(30,154);
  groebnerMatrix(30,154) = 0.0;
  groebnerMatrix(30,158) = groebnerMatrix(30,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(30,193) = groebnerMatrix(30,193) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(30,163);
  groebnerMatrix(30,163) = 0.0;
  groebnerMatrix(30,171) = groebnerMatrix(30,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(30,180) = groebnerMatrix(30,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(30,164);
  groebnerMatrix(30,164) = 0.0;
  groebnerMatrix(30,170) = groebnerMatrix(30,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(30,192) = groebnerMatrix(30,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(30,165);
  groebnerMatrix(30,165) = 0.0;
  groebnerMatrix(30,178) = groebnerMatrix(30,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(30,191) = groebnerMatrix(30,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(30,166);
  groebnerMatrix(30,166) = 0.0;
  groebnerMatrix(30,174) = groebnerMatrix(30,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(30,183) = groebnerMatrix(30,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(30,167);
  groebnerMatrix(30,167) = 0.0;
  groebnerMatrix(30,173) = groebnerMatrix(30,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(30,189) = groebnerMatrix(30,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(30,168);
  groebnerMatrix(30,168) = 0.0;
  groebnerMatrix(30,181) = groebnerMatrix(30,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(30,188) = groebnerMatrix(30,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(30,169);
  groebnerMatrix(30,169) = 0.0;
  groebnerMatrix(30,177) = groebnerMatrix(30,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(30,186) = groebnerMatrix(30,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(30,196) = groebnerMatrix(30,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(30,172);
  groebnerMatrix(30,172) = 0.0;
  groebnerMatrix(30,179) = groebnerMatrix(30,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(30,190) = groebnerMatrix(30,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(30,175);
  groebnerMatrix(30,175) = 0.0;
  groebnerMatrix(30,182) = groebnerMatrix(30,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(30,187) = groebnerMatrix(30,187) - factor * groebnerMatrix(18,187);

  sPolynomial31(groebnerMatrix);
  factor = -groebnerMatrix(31,1);
  groebnerMatrix(31,1) = 0.0;
  groebnerMatrix(31,8) = groebnerMatrix(31,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,179) = groebnerMatrix(31,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,2);
  groebnerMatrix(31,2) = 0.0;
  groebnerMatrix(31,11) = groebnerMatrix(31,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,24) = groebnerMatrix(31,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,3);
  groebnerMatrix(31,3) = 0.0;
  groebnerMatrix(31,10) = groebnerMatrix(31,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,180) = groebnerMatrix(31,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,4);
  groebnerMatrix(31,4) = 0.0;
  groebnerMatrix(31,36) = groebnerMatrix(31,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(31,136) = groebnerMatrix(31,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(31,190) = groebnerMatrix(31,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(31,5);
  groebnerMatrix(31,5) = 0.0;
  groebnerMatrix(31,17) = groebnerMatrix(31,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(31,34) = groebnerMatrix(31,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(31,188) = groebnerMatrix(31,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(31,6);
  groebnerMatrix(31,6) = 0.0;
  groebnerMatrix(31,18) = groebnerMatrix(31,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(31,35) = groebnerMatrix(31,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(31,189) = groebnerMatrix(31,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(31,10);
  groebnerMatrix(31,10) = 0.0;
  groebnerMatrix(31,20) = groebnerMatrix(31,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,163) = groebnerMatrix(31,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(31,11);
  groebnerMatrix(31,11) = 0.0;
  groebnerMatrix(31,21) = groebnerMatrix(31,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,164) = groebnerMatrix(31,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(31,12);
  groebnerMatrix(31,12) = 0.0;
  groebnerMatrix(31,23) = groebnerMatrix(31,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,165) = groebnerMatrix(31,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,13);
  groebnerMatrix(31,13) = 0.0;
  groebnerMatrix(31,17) = groebnerMatrix(31,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,30) = groebnerMatrix(31,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,14);
  groebnerMatrix(31,14) = 0.0;
  groebnerMatrix(31,16) = groebnerMatrix(31,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,182) = groebnerMatrix(31,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(31,15);
  groebnerMatrix(31,15) = 0.0;
  groebnerMatrix(31,26) = groebnerMatrix(31,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,166) = groebnerMatrix(31,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(31,18);
  groebnerMatrix(31,18) = 0.0;
  groebnerMatrix(31,29) = groebnerMatrix(31,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,167) = groebnerMatrix(31,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,19);
  groebnerMatrix(31,19) = 0.0;
  groebnerMatrix(31,21) = groebnerMatrix(31,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(31,24) = groebnerMatrix(31,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(31,192) = groebnerMatrix(31,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(31,22);
  groebnerMatrix(31,22) = 0.0;
  groebnerMatrix(31,36) = groebnerMatrix(31,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(31,123) = groebnerMatrix(31,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(31,25);
  groebnerMatrix(31,25) = 0.0;
  groebnerMatrix(31,29) = groebnerMatrix(31,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,35) = groebnerMatrix(31,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,26);
  groebnerMatrix(31,26) = 0.0;
  groebnerMatrix(31,28) = groebnerMatrix(31,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,183) = groebnerMatrix(31,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,27);
  groebnerMatrix(31,27) = 0.0;
  groebnerMatrix(31,33) = groebnerMatrix(31,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(31,175) = groebnerMatrix(31,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(31,30);
  groebnerMatrix(31,30) = 0.0;
  groebnerMatrix(31,34) = groebnerMatrix(31,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,168) = groebnerMatrix(31,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,39);
  groebnerMatrix(31,39) = 0.0;
  groebnerMatrix(31,63) = groebnerMatrix(31,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,101) = groebnerMatrix(31,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,40);
  groebnerMatrix(31,40) = 0.0;
  groebnerMatrix(31,62) = groebnerMatrix(31,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,158) = groebnerMatrix(31,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(31,41);
  groebnerMatrix(31,41) = 0.0;
  groebnerMatrix(31,65) = groebnerMatrix(31,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,102) = groebnerMatrix(31,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,42);
  groebnerMatrix(31,42) = 0.0;
  groebnerMatrix(31,64) = groebnerMatrix(31,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,159) = groebnerMatrix(31,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(31,43);
  groebnerMatrix(31,43) = 0.0;
  groebnerMatrix(31,56) = groebnerMatrix(31,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(31,139) = groebnerMatrix(31,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(31,193) = groebnerMatrix(31,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(31,44);
  groebnerMatrix(31,44) = 0.0;
  groebnerMatrix(31,72) = groebnerMatrix(31,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,113) = groebnerMatrix(31,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(31,45);
  groebnerMatrix(31,45) = 0.0;
  groebnerMatrix(31,73) = groebnerMatrix(31,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,114) = groebnerMatrix(31,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(31,46);
  groebnerMatrix(31,46) = 0.0;
  groebnerMatrix(31,72) = groebnerMatrix(31,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,109) = groebnerMatrix(31,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,47);
  groebnerMatrix(31,47) = 0.0;
  groebnerMatrix(31,71) = groebnerMatrix(31,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,161) = groebnerMatrix(31,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(31,48);
  groebnerMatrix(31,48) = 0.0;
  groebnerMatrix(31,52) = groebnerMatrix(31,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,169) = groebnerMatrix(31,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,49);
  groebnerMatrix(31,49) = 0.0;
  groebnerMatrix(31,75) = groebnerMatrix(31,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,116) = groebnerMatrix(31,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(31,50);
  groebnerMatrix(31,50) = 0.0;
  groebnerMatrix(31,74) = groebnerMatrix(31,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(31,154) = groebnerMatrix(31,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(31,51);
  groebnerMatrix(31,51) = 0.0;
  groebnerMatrix(31,77) = groebnerMatrix(31,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,114) = groebnerMatrix(31,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,52);
  groebnerMatrix(31,52) = 0.0;
  groebnerMatrix(31,76) = groebnerMatrix(31,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,162) = groebnerMatrix(31,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(31,53);
  groebnerMatrix(31,53) = 0.0;
  groebnerMatrix(31,105) = groebnerMatrix(31,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(31,146) = groebnerMatrix(31,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(31,54);
  groebnerMatrix(31,54) = 0.0;
  groebnerMatrix(31,80) = groebnerMatrix(31,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,117) = groebnerMatrix(31,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(31,55);
  groebnerMatrix(31,55) = 0.0;
  groebnerMatrix(31,79) = groebnerMatrix(31,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(31,159) = groebnerMatrix(31,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(31,56);
  groebnerMatrix(31,56) = 0.0;
  groebnerMatrix(31,115) = groebnerMatrix(31,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(31,158) = groebnerMatrix(31,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(31,57);
  groebnerMatrix(31,57) = 0.0;
  groebnerMatrix(31,90) = groebnerMatrix(31,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(31,134) = groebnerMatrix(31,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(31,188) = groebnerMatrix(31,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(31,58);
  groebnerMatrix(31,58) = 0.0;
  groebnerMatrix(31,91) = groebnerMatrix(31,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(31,135) = groebnerMatrix(31,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(31,189) = groebnerMatrix(31,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(31,59);
  groebnerMatrix(31,59) = 0.0;
  groebnerMatrix(31,93) = groebnerMatrix(31,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(31,137) = groebnerMatrix(31,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(31,191) = groebnerMatrix(31,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(31,60);
  groebnerMatrix(31,60) = 0.0;
  groebnerMatrix(31,94) = groebnerMatrix(31,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(31,138) = groebnerMatrix(31,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(31,192) = groebnerMatrix(31,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(31,61);
  groebnerMatrix(31,61) = 0.0;
  groebnerMatrix(31,63) = groebnerMatrix(31,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(31,66) = groebnerMatrix(31,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(31,194) = groebnerMatrix(31,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(31,64);
  groebnerMatrix(31,64) = 0.0;
  groebnerMatrix(31,98) = groebnerMatrix(31,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,148) = groebnerMatrix(31,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(31,65);
  groebnerMatrix(31,65) = 0.0;
  groebnerMatrix(31,99) = groebnerMatrix(31,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,149) = groebnerMatrix(31,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(31,66);
  groebnerMatrix(31,66) = 0.0;
  groebnerMatrix(31,101) = groebnerMatrix(31,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,150) = groebnerMatrix(31,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(31,67);
  groebnerMatrix(31,67) = 0.0;
  groebnerMatrix(31,72) = groebnerMatrix(31,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,78) = groebnerMatrix(31,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,68);
  groebnerMatrix(31,68) = 0.0;
  groebnerMatrix(31,71) = groebnerMatrix(31,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,185) = groebnerMatrix(31,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,69);
  groebnerMatrix(31,69) = 0.0;
  groebnerMatrix(31,104) = groebnerMatrix(31,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,151) = groebnerMatrix(31,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(31,70);
  groebnerMatrix(31,70) = 0.0;
  groebnerMatrix(31,75) = groebnerMatrix(31,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(31,81) = groebnerMatrix(31,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(31,194) = groebnerMatrix(31,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(31,73);
  groebnerMatrix(31,73) = 0.0;
  groebnerMatrix(31,77) = groebnerMatrix(31,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,176) = groebnerMatrix(31,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(31,76);
  groebnerMatrix(31,76) = 0.0;
  groebnerMatrix(31,107) = groebnerMatrix(31,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,142) = groebnerMatrix(31,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(31,77);
  groebnerMatrix(31,77) = 0.0;
  groebnerMatrix(31,108) = groebnerMatrix(31,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,143) = groebnerMatrix(31,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(31,78);
  groebnerMatrix(31,78) = 0.0;
  groebnerMatrix(31,113) = groebnerMatrix(31,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,160) = groebnerMatrix(31,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(31,79);
  groebnerMatrix(31,79) = 0.0;
  groebnerMatrix(31,110) = groebnerMatrix(31,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,148) = groebnerMatrix(31,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(31,80);
  groebnerMatrix(31,80) = 0.0;
  groebnerMatrix(31,111) = groebnerMatrix(31,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,152) = groebnerMatrix(31,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(31,81);
  groebnerMatrix(31,81) = 0.0;
  groebnerMatrix(31,116) = groebnerMatrix(31,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,157) = groebnerMatrix(31,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(31,82);
  groebnerMatrix(31,82) = 0.0;
  groebnerMatrix(31,90) = groebnerMatrix(31,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,127) = groebnerMatrix(31,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,83);
  groebnerMatrix(31,83) = 0.0;
  groebnerMatrix(31,89) = groebnerMatrix(31,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,175) = groebnerMatrix(31,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(31,84);
  groebnerMatrix(31,84) = 0.0;
  groebnerMatrix(31,119) = groebnerMatrix(31,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,166) = groebnerMatrix(31,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(31,85);
  groebnerMatrix(31,85) = 0.0;
  groebnerMatrix(31,93) = groebnerMatrix(31,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,130) = groebnerMatrix(31,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(31,86);
  groebnerMatrix(31,86) = 0.0;
  groebnerMatrix(31,92) = groebnerMatrix(31,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(31,172) = groebnerMatrix(31,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(31,87);
  groebnerMatrix(31,87) = 0.0;
  groebnerMatrix(31,122) = groebnerMatrix(31,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,163) = groebnerMatrix(31,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(31,91);
  groebnerMatrix(31,91) = 0.0;
  groebnerMatrix(31,126) = groebnerMatrix(31,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,173) = groebnerMatrix(31,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(31,94);
  groebnerMatrix(31,94) = 0.0;
  groebnerMatrix(31,129) = groebnerMatrix(31,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,170) = groebnerMatrix(31,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(31,97);
  groebnerMatrix(31,97) = 0.0;
  groebnerMatrix(31,99) = groebnerMatrix(31,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(31,102) = groebnerMatrix(31,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(31,195) = groebnerMatrix(31,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(31,100);
  groebnerMatrix(31,100) = 0.0;
  groebnerMatrix(31,115) = groebnerMatrix(31,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(31,139) = groebnerMatrix(31,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(31,103);
  groebnerMatrix(31,103) = 0.0;
  groebnerMatrix(31,108) = groebnerMatrix(31,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,114) = groebnerMatrix(31,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,104);
  groebnerMatrix(31,104) = 0.0;
  groebnerMatrix(31,107) = groebnerMatrix(31,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,186) = groebnerMatrix(31,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,105);
  groebnerMatrix(31,105) = 0.0;
  groebnerMatrix(31,112) = groebnerMatrix(31,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(31,185) = groebnerMatrix(31,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(31,106);
  groebnerMatrix(31,106) = 0.0;
  groebnerMatrix(31,111) = groebnerMatrix(31,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(31,117) = groebnerMatrix(31,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(31,195) = groebnerMatrix(31,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(31,109);
  groebnerMatrix(31,109) = 0.0;
  groebnerMatrix(31,113) = groebnerMatrix(31,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,184) = groebnerMatrix(31,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,118);
  groebnerMatrix(31,118) = 0.0;
  groebnerMatrix(31,126) = groebnerMatrix(31,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,135) = groebnerMatrix(31,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,119);
  groebnerMatrix(31,119) = 0.0;
  groebnerMatrix(31,125) = groebnerMatrix(31,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,183) = groebnerMatrix(31,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(31,120);
  groebnerMatrix(31,120) = 0.0;
  groebnerMatrix(31,133) = groebnerMatrix(31,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(31,182) = groebnerMatrix(31,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(31,121);
  groebnerMatrix(31,121) = 0.0;
  groebnerMatrix(31,129) = groebnerMatrix(31,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,138) = groebnerMatrix(31,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(31,122);
  groebnerMatrix(31,122) = 0.0;
  groebnerMatrix(31,128) = groebnerMatrix(31,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(31,180) = groebnerMatrix(31,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(31,123);
  groebnerMatrix(31,123) = 0.0;
  groebnerMatrix(31,136) = groebnerMatrix(31,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(31,179) = groebnerMatrix(31,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(31,127);
  groebnerMatrix(31,127) = 0.0;
  groebnerMatrix(31,134) = groebnerMatrix(31,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,181) = groebnerMatrix(31,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(31,130);
  groebnerMatrix(31,130) = 0.0;
  groebnerMatrix(31,137) = groebnerMatrix(31,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,178) = groebnerMatrix(31,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(31,142);
  groebnerMatrix(31,142) = 0.0;
  groebnerMatrix(31,144) = groebnerMatrix(31,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(31,147) = groebnerMatrix(31,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(31,196) = groebnerMatrix(31,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(31,143);
  groebnerMatrix(31,143) = 0.0;
  groebnerMatrix(31,155) = groebnerMatrix(31,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(31,176) = groebnerMatrix(31,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(31,144);
  groebnerMatrix(31,144) = 0.0;
  groebnerMatrix(31,156) = groebnerMatrix(31,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(31,177) = groebnerMatrix(31,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(31,196) = groebnerMatrix(31,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(31,146);
  groebnerMatrix(31,146) = 0.0;
  groebnerMatrix(31,161) = groebnerMatrix(31,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(31,185) = groebnerMatrix(31,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(31,147);
  groebnerMatrix(31,147) = 0.0;
  groebnerMatrix(31,162) = groebnerMatrix(31,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(31,186) = groebnerMatrix(31,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(31,196) = groebnerMatrix(31,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(31,148);
  groebnerMatrix(31,148) = 0.0;
  groebnerMatrix(31,153) = groebnerMatrix(31,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(31,159) = groebnerMatrix(31,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(31,149);
  groebnerMatrix(31,149) = 0.0;
  groebnerMatrix(31,152) = groebnerMatrix(31,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(31,195) = groebnerMatrix(31,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(31,150);
  groebnerMatrix(31,150) = 0.0;
  groebnerMatrix(31,157) = groebnerMatrix(31,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(31,194) = groebnerMatrix(31,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(31,151);
  groebnerMatrix(31,151) = 0.0;
  groebnerMatrix(31,156) = groebnerMatrix(31,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(31,162) = groebnerMatrix(31,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(31,196) = groebnerMatrix(31,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,31);
  factor = -groebnerMatrix(31,154);
  groebnerMatrix(31,154) = 0.0;
  groebnerMatrix(31,158) = groebnerMatrix(31,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(31,193) = groebnerMatrix(31,193) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(31,163);
  groebnerMatrix(31,163) = 0.0;
  groebnerMatrix(31,171) = groebnerMatrix(31,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(31,180) = groebnerMatrix(31,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(31,164);
  groebnerMatrix(31,164) = 0.0;
  groebnerMatrix(31,170) = groebnerMatrix(31,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(31,192) = groebnerMatrix(31,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(31,165);
  groebnerMatrix(31,165) = 0.0;
  groebnerMatrix(31,178) = groebnerMatrix(31,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(31,191) = groebnerMatrix(31,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(31,166);
  groebnerMatrix(31,166) = 0.0;
  groebnerMatrix(31,174) = groebnerMatrix(31,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(31,183) = groebnerMatrix(31,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(31,167);
  groebnerMatrix(31,167) = 0.0;
  groebnerMatrix(31,173) = groebnerMatrix(31,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(31,189) = groebnerMatrix(31,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(31,168);
  groebnerMatrix(31,168) = 0.0;
  groebnerMatrix(31,181) = groebnerMatrix(31,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(31,188) = groebnerMatrix(31,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(31,169);
  groebnerMatrix(31,169) = 0.0;
  groebnerMatrix(31,177) = groebnerMatrix(31,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(31,186) = groebnerMatrix(31,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(31,196) = groebnerMatrix(31,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(31,172);
  groebnerMatrix(31,172) = 0.0;
  groebnerMatrix(31,179) = groebnerMatrix(31,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(31,190) = groebnerMatrix(31,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(31,175);
  groebnerMatrix(31,175) = 0.0;
  groebnerMatrix(31,182) = groebnerMatrix(31,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(31,187) = groebnerMatrix(31,187) - factor * groebnerMatrix(18,187);

  sPolynomial32(groebnerMatrix);
  factor = -groebnerMatrix(32,1);
  groebnerMatrix(32,1) = 0.0;
  groebnerMatrix(32,8) = groebnerMatrix(32,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,179) = groebnerMatrix(32,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,2);
  groebnerMatrix(32,2) = 0.0;
  groebnerMatrix(32,11) = groebnerMatrix(32,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,24) = groebnerMatrix(32,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,3);
  groebnerMatrix(32,3) = 0.0;
  groebnerMatrix(32,10) = groebnerMatrix(32,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,180) = groebnerMatrix(32,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,4);
  groebnerMatrix(32,4) = 0.0;
  groebnerMatrix(32,36) = groebnerMatrix(32,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(32,136) = groebnerMatrix(32,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(32,190) = groebnerMatrix(32,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(32,5);
  groebnerMatrix(32,5) = 0.0;
  groebnerMatrix(32,17) = groebnerMatrix(32,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(32,34) = groebnerMatrix(32,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(32,188) = groebnerMatrix(32,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(32,6);
  groebnerMatrix(32,6) = 0.0;
  groebnerMatrix(32,18) = groebnerMatrix(32,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(32,35) = groebnerMatrix(32,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(32,189) = groebnerMatrix(32,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(32,10);
  groebnerMatrix(32,10) = 0.0;
  groebnerMatrix(32,20) = groebnerMatrix(32,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,163) = groebnerMatrix(32,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(32,11);
  groebnerMatrix(32,11) = 0.0;
  groebnerMatrix(32,21) = groebnerMatrix(32,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,164) = groebnerMatrix(32,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(32,12);
  groebnerMatrix(32,12) = 0.0;
  groebnerMatrix(32,23) = groebnerMatrix(32,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,165) = groebnerMatrix(32,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,13);
  groebnerMatrix(32,13) = 0.0;
  groebnerMatrix(32,17) = groebnerMatrix(32,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,30) = groebnerMatrix(32,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,14);
  groebnerMatrix(32,14) = 0.0;
  groebnerMatrix(32,16) = groebnerMatrix(32,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,182) = groebnerMatrix(32,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(32,15);
  groebnerMatrix(32,15) = 0.0;
  groebnerMatrix(32,26) = groebnerMatrix(32,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,166) = groebnerMatrix(32,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(32,18);
  groebnerMatrix(32,18) = 0.0;
  groebnerMatrix(32,29) = groebnerMatrix(32,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,167) = groebnerMatrix(32,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,19);
  groebnerMatrix(32,19) = 0.0;
  groebnerMatrix(32,21) = groebnerMatrix(32,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(32,24) = groebnerMatrix(32,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(32,192) = groebnerMatrix(32,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(32,22);
  groebnerMatrix(32,22) = 0.0;
  groebnerMatrix(32,36) = groebnerMatrix(32,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(32,123) = groebnerMatrix(32,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(32,25);
  groebnerMatrix(32,25) = 0.0;
  groebnerMatrix(32,29) = groebnerMatrix(32,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,35) = groebnerMatrix(32,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,26);
  groebnerMatrix(32,26) = 0.0;
  groebnerMatrix(32,28) = groebnerMatrix(32,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,183) = groebnerMatrix(32,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,27);
  groebnerMatrix(32,27) = 0.0;
  groebnerMatrix(32,33) = groebnerMatrix(32,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(32,175) = groebnerMatrix(32,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(32,30);
  groebnerMatrix(32,30) = 0.0;
  groebnerMatrix(32,34) = groebnerMatrix(32,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,168) = groebnerMatrix(32,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,39);
  groebnerMatrix(32,39) = 0.0;
  groebnerMatrix(32,63) = groebnerMatrix(32,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,101) = groebnerMatrix(32,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,40);
  groebnerMatrix(32,40) = 0.0;
  groebnerMatrix(32,62) = groebnerMatrix(32,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,158) = groebnerMatrix(32,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(32,41);
  groebnerMatrix(32,41) = 0.0;
  groebnerMatrix(32,65) = groebnerMatrix(32,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,102) = groebnerMatrix(32,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,42);
  groebnerMatrix(32,42) = 0.0;
  groebnerMatrix(32,64) = groebnerMatrix(32,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,159) = groebnerMatrix(32,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(32,43);
  groebnerMatrix(32,43) = 0.0;
  groebnerMatrix(32,56) = groebnerMatrix(32,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(32,139) = groebnerMatrix(32,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(32,193) = groebnerMatrix(32,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(32,44);
  groebnerMatrix(32,44) = 0.0;
  groebnerMatrix(32,72) = groebnerMatrix(32,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,113) = groebnerMatrix(32,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(32,45);
  groebnerMatrix(32,45) = 0.0;
  groebnerMatrix(32,73) = groebnerMatrix(32,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,114) = groebnerMatrix(32,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(32,46);
  groebnerMatrix(32,46) = 0.0;
  groebnerMatrix(32,72) = groebnerMatrix(32,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,109) = groebnerMatrix(32,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,47);
  groebnerMatrix(32,47) = 0.0;
  groebnerMatrix(32,71) = groebnerMatrix(32,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,161) = groebnerMatrix(32,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(32,48);
  groebnerMatrix(32,48) = 0.0;
  groebnerMatrix(32,52) = groebnerMatrix(32,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,169) = groebnerMatrix(32,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,49);
  groebnerMatrix(32,49) = 0.0;
  groebnerMatrix(32,75) = groebnerMatrix(32,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,116) = groebnerMatrix(32,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(32,50);
  groebnerMatrix(32,50) = 0.0;
  groebnerMatrix(32,74) = groebnerMatrix(32,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(32,154) = groebnerMatrix(32,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(32,51);
  groebnerMatrix(32,51) = 0.0;
  groebnerMatrix(32,77) = groebnerMatrix(32,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,114) = groebnerMatrix(32,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,52);
  groebnerMatrix(32,52) = 0.0;
  groebnerMatrix(32,76) = groebnerMatrix(32,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,162) = groebnerMatrix(32,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(32,53);
  groebnerMatrix(32,53) = 0.0;
  groebnerMatrix(32,105) = groebnerMatrix(32,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(32,146) = groebnerMatrix(32,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(32,54);
  groebnerMatrix(32,54) = 0.0;
  groebnerMatrix(32,80) = groebnerMatrix(32,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,117) = groebnerMatrix(32,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(32,55);
  groebnerMatrix(32,55) = 0.0;
  groebnerMatrix(32,79) = groebnerMatrix(32,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(32,159) = groebnerMatrix(32,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(32,56);
  groebnerMatrix(32,56) = 0.0;
  groebnerMatrix(32,115) = groebnerMatrix(32,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(32,158) = groebnerMatrix(32,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(32,57);
  groebnerMatrix(32,57) = 0.0;
  groebnerMatrix(32,90) = groebnerMatrix(32,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(32,134) = groebnerMatrix(32,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(32,188) = groebnerMatrix(32,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(32,58);
  groebnerMatrix(32,58) = 0.0;
  groebnerMatrix(32,91) = groebnerMatrix(32,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(32,135) = groebnerMatrix(32,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(32,189) = groebnerMatrix(32,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(32,59);
  groebnerMatrix(32,59) = 0.0;
  groebnerMatrix(32,93) = groebnerMatrix(32,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(32,137) = groebnerMatrix(32,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(32,191) = groebnerMatrix(32,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(32,60);
  groebnerMatrix(32,60) = 0.0;
  groebnerMatrix(32,94) = groebnerMatrix(32,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(32,138) = groebnerMatrix(32,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(32,192) = groebnerMatrix(32,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(32,61);
  groebnerMatrix(32,61) = 0.0;
  groebnerMatrix(32,63) = groebnerMatrix(32,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(32,66) = groebnerMatrix(32,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(32,194) = groebnerMatrix(32,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(32,64);
  groebnerMatrix(32,64) = 0.0;
  groebnerMatrix(32,98) = groebnerMatrix(32,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,148) = groebnerMatrix(32,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(32,65);
  groebnerMatrix(32,65) = 0.0;
  groebnerMatrix(32,99) = groebnerMatrix(32,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,149) = groebnerMatrix(32,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(32,66);
  groebnerMatrix(32,66) = 0.0;
  groebnerMatrix(32,101) = groebnerMatrix(32,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,150) = groebnerMatrix(32,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(32,67);
  groebnerMatrix(32,67) = 0.0;
  groebnerMatrix(32,72) = groebnerMatrix(32,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,78) = groebnerMatrix(32,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,68);
  groebnerMatrix(32,68) = 0.0;
  groebnerMatrix(32,71) = groebnerMatrix(32,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,185) = groebnerMatrix(32,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,69);
  groebnerMatrix(32,69) = 0.0;
  groebnerMatrix(32,104) = groebnerMatrix(32,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,151) = groebnerMatrix(32,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(32,70);
  groebnerMatrix(32,70) = 0.0;
  groebnerMatrix(32,75) = groebnerMatrix(32,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(32,81) = groebnerMatrix(32,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(32,194) = groebnerMatrix(32,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(32,73);
  groebnerMatrix(32,73) = 0.0;
  groebnerMatrix(32,77) = groebnerMatrix(32,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,176) = groebnerMatrix(32,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(32,76);
  groebnerMatrix(32,76) = 0.0;
  groebnerMatrix(32,107) = groebnerMatrix(32,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,142) = groebnerMatrix(32,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(32,77);
  groebnerMatrix(32,77) = 0.0;
  groebnerMatrix(32,108) = groebnerMatrix(32,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,143) = groebnerMatrix(32,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(32,78);
  groebnerMatrix(32,78) = 0.0;
  groebnerMatrix(32,113) = groebnerMatrix(32,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,160) = groebnerMatrix(32,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(32,79);
  groebnerMatrix(32,79) = 0.0;
  groebnerMatrix(32,110) = groebnerMatrix(32,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,148) = groebnerMatrix(32,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(32,80);
  groebnerMatrix(32,80) = 0.0;
  groebnerMatrix(32,111) = groebnerMatrix(32,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,152) = groebnerMatrix(32,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(32,81);
  groebnerMatrix(32,81) = 0.0;
  groebnerMatrix(32,116) = groebnerMatrix(32,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,157) = groebnerMatrix(32,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(32,82);
  groebnerMatrix(32,82) = 0.0;
  groebnerMatrix(32,90) = groebnerMatrix(32,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,127) = groebnerMatrix(32,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,83);
  groebnerMatrix(32,83) = 0.0;
  groebnerMatrix(32,89) = groebnerMatrix(32,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,175) = groebnerMatrix(32,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(32,84);
  groebnerMatrix(32,84) = 0.0;
  groebnerMatrix(32,119) = groebnerMatrix(32,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,166) = groebnerMatrix(32,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(32,85);
  groebnerMatrix(32,85) = 0.0;
  groebnerMatrix(32,93) = groebnerMatrix(32,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,130) = groebnerMatrix(32,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(32,86);
  groebnerMatrix(32,86) = 0.0;
  groebnerMatrix(32,92) = groebnerMatrix(32,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(32,172) = groebnerMatrix(32,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(32,87);
  groebnerMatrix(32,87) = 0.0;
  groebnerMatrix(32,122) = groebnerMatrix(32,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,163) = groebnerMatrix(32,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(32,91);
  groebnerMatrix(32,91) = 0.0;
  groebnerMatrix(32,126) = groebnerMatrix(32,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,173) = groebnerMatrix(32,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(32,94);
  groebnerMatrix(32,94) = 0.0;
  groebnerMatrix(32,129) = groebnerMatrix(32,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,170) = groebnerMatrix(32,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(32,97);
  groebnerMatrix(32,97) = 0.0;
  groebnerMatrix(32,99) = groebnerMatrix(32,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(32,102) = groebnerMatrix(32,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(32,195) = groebnerMatrix(32,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(32,100);
  groebnerMatrix(32,100) = 0.0;
  groebnerMatrix(32,115) = groebnerMatrix(32,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(32,139) = groebnerMatrix(32,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(32,103);
  groebnerMatrix(32,103) = 0.0;
  groebnerMatrix(32,108) = groebnerMatrix(32,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,114) = groebnerMatrix(32,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,104);
  groebnerMatrix(32,104) = 0.0;
  groebnerMatrix(32,107) = groebnerMatrix(32,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,186) = groebnerMatrix(32,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,105);
  groebnerMatrix(32,105) = 0.0;
  groebnerMatrix(32,112) = groebnerMatrix(32,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(32,185) = groebnerMatrix(32,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(32,106);
  groebnerMatrix(32,106) = 0.0;
  groebnerMatrix(32,111) = groebnerMatrix(32,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(32,117) = groebnerMatrix(32,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(32,195) = groebnerMatrix(32,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(32,109);
  groebnerMatrix(32,109) = 0.0;
  groebnerMatrix(32,113) = groebnerMatrix(32,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,184) = groebnerMatrix(32,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,118);
  groebnerMatrix(32,118) = 0.0;
  groebnerMatrix(32,126) = groebnerMatrix(32,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,135) = groebnerMatrix(32,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,119);
  groebnerMatrix(32,119) = 0.0;
  groebnerMatrix(32,125) = groebnerMatrix(32,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,183) = groebnerMatrix(32,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(32,120);
  groebnerMatrix(32,120) = 0.0;
  groebnerMatrix(32,133) = groebnerMatrix(32,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(32,182) = groebnerMatrix(32,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(32,121);
  groebnerMatrix(32,121) = 0.0;
  groebnerMatrix(32,129) = groebnerMatrix(32,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,138) = groebnerMatrix(32,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(32,122);
  groebnerMatrix(32,122) = 0.0;
  groebnerMatrix(32,128) = groebnerMatrix(32,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(32,180) = groebnerMatrix(32,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(32,123);
  groebnerMatrix(32,123) = 0.0;
  groebnerMatrix(32,136) = groebnerMatrix(32,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(32,179) = groebnerMatrix(32,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(32,127);
  groebnerMatrix(32,127) = 0.0;
  groebnerMatrix(32,134) = groebnerMatrix(32,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,181) = groebnerMatrix(32,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(32,130);
  groebnerMatrix(32,130) = 0.0;
  groebnerMatrix(32,137) = groebnerMatrix(32,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,178) = groebnerMatrix(32,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(32,142);
  groebnerMatrix(32,142) = 0.0;
  groebnerMatrix(32,144) = groebnerMatrix(32,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(32,147) = groebnerMatrix(32,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(32,196) = groebnerMatrix(32,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(32,143);
  groebnerMatrix(32,143) = 0.0;
  groebnerMatrix(32,155) = groebnerMatrix(32,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(32,176) = groebnerMatrix(32,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(32,144);
  groebnerMatrix(32,144) = 0.0;
  groebnerMatrix(32,156) = groebnerMatrix(32,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(32,177) = groebnerMatrix(32,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(32,196) = groebnerMatrix(32,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(32,146);
  groebnerMatrix(32,146) = 0.0;
  groebnerMatrix(32,161) = groebnerMatrix(32,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(32,185) = groebnerMatrix(32,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(32,147);
  groebnerMatrix(32,147) = 0.0;
  groebnerMatrix(32,162) = groebnerMatrix(32,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(32,186) = groebnerMatrix(32,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(32,196) = groebnerMatrix(32,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(32,148);
  groebnerMatrix(32,148) = 0.0;
  groebnerMatrix(32,153) = groebnerMatrix(32,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(32,159) = groebnerMatrix(32,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(32,149);
  groebnerMatrix(32,149) = 0.0;
  groebnerMatrix(32,152) = groebnerMatrix(32,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(32,195) = groebnerMatrix(32,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(32,150);
  groebnerMatrix(32,150) = 0.0;
  groebnerMatrix(32,157) = groebnerMatrix(32,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(32,194) = groebnerMatrix(32,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(32,151);
  groebnerMatrix(32,151) = 0.0;
  groebnerMatrix(32,156) = groebnerMatrix(32,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(32,162) = groebnerMatrix(32,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(32,196) = groebnerMatrix(32,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,32);
  groebnerRow31_000000000_f(groebnerMatrix,32);
  factor = -groebnerMatrix(32,154);
  groebnerMatrix(32,154) = 0.0;
  groebnerMatrix(32,158) = groebnerMatrix(32,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(32,193) = groebnerMatrix(32,193) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(32,163);
  groebnerMatrix(32,163) = 0.0;
  groebnerMatrix(32,171) = groebnerMatrix(32,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(32,180) = groebnerMatrix(32,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(32,164);
  groebnerMatrix(32,164) = 0.0;
  groebnerMatrix(32,170) = groebnerMatrix(32,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(32,192) = groebnerMatrix(32,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(32,165);
  groebnerMatrix(32,165) = 0.0;
  groebnerMatrix(32,178) = groebnerMatrix(32,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(32,191) = groebnerMatrix(32,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(32,166);
  groebnerMatrix(32,166) = 0.0;
  groebnerMatrix(32,174) = groebnerMatrix(32,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(32,183) = groebnerMatrix(32,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(32,167);
  groebnerMatrix(32,167) = 0.0;
  groebnerMatrix(32,173) = groebnerMatrix(32,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(32,189) = groebnerMatrix(32,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(32,168);
  groebnerMatrix(32,168) = 0.0;
  groebnerMatrix(32,181) = groebnerMatrix(32,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(32,188) = groebnerMatrix(32,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(32,169);
  groebnerMatrix(32,169) = 0.0;
  groebnerMatrix(32,177) = groebnerMatrix(32,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(32,186) = groebnerMatrix(32,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(32,196) = groebnerMatrix(32,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(32,172);
  groebnerMatrix(32,172) = 0.0;
  groebnerMatrix(32,179) = groebnerMatrix(32,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(32,190) = groebnerMatrix(32,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(32,175);
  groebnerMatrix(32,175) = 0.0;
  groebnerMatrix(32,182) = groebnerMatrix(32,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(32,187) = groebnerMatrix(32,187) - factor * groebnerMatrix(18,187);

  sPolynomial33(groebnerMatrix);
  factor = -groebnerMatrix(33,1);
  groebnerMatrix(33,1) = 0.0;
  groebnerMatrix(33,8) = groebnerMatrix(33,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,179) = groebnerMatrix(33,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,2);
  groebnerMatrix(33,2) = 0.0;
  groebnerMatrix(33,11) = groebnerMatrix(33,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,24) = groebnerMatrix(33,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,3);
  groebnerMatrix(33,3) = 0.0;
  groebnerMatrix(33,10) = groebnerMatrix(33,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,180) = groebnerMatrix(33,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,4);
  groebnerMatrix(33,4) = 0.0;
  groebnerMatrix(33,36) = groebnerMatrix(33,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(33,136) = groebnerMatrix(33,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(33,190) = groebnerMatrix(33,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(33,5);
  groebnerMatrix(33,5) = 0.0;
  groebnerMatrix(33,17) = groebnerMatrix(33,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(33,34) = groebnerMatrix(33,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(33,188) = groebnerMatrix(33,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(33,6);
  groebnerMatrix(33,6) = 0.0;
  groebnerMatrix(33,18) = groebnerMatrix(33,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(33,35) = groebnerMatrix(33,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(33,189) = groebnerMatrix(33,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(33,10);
  groebnerMatrix(33,10) = 0.0;
  groebnerMatrix(33,20) = groebnerMatrix(33,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,163) = groebnerMatrix(33,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(33,11);
  groebnerMatrix(33,11) = 0.0;
  groebnerMatrix(33,21) = groebnerMatrix(33,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,164) = groebnerMatrix(33,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(33,12);
  groebnerMatrix(33,12) = 0.0;
  groebnerMatrix(33,23) = groebnerMatrix(33,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,165) = groebnerMatrix(33,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(33,13);
  groebnerMatrix(33,13) = 0.0;
  groebnerMatrix(33,17) = groebnerMatrix(33,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,30) = groebnerMatrix(33,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,14);
  groebnerMatrix(33,14) = 0.0;
  groebnerMatrix(33,16) = groebnerMatrix(33,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,182) = groebnerMatrix(33,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(33,15);
  groebnerMatrix(33,15) = 0.0;
  groebnerMatrix(33,26) = groebnerMatrix(33,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,166) = groebnerMatrix(33,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(33,18);
  groebnerMatrix(33,18) = 0.0;
  groebnerMatrix(33,29) = groebnerMatrix(33,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,167) = groebnerMatrix(33,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(33,19);
  groebnerMatrix(33,19) = 0.0;
  groebnerMatrix(33,21) = groebnerMatrix(33,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(33,24) = groebnerMatrix(33,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(33,192) = groebnerMatrix(33,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(33,22);
  groebnerMatrix(33,22) = 0.0;
  groebnerMatrix(33,36) = groebnerMatrix(33,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(33,123) = groebnerMatrix(33,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(33,25);
  groebnerMatrix(33,25) = 0.0;
  groebnerMatrix(33,29) = groebnerMatrix(33,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,35) = groebnerMatrix(33,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,26);
  groebnerMatrix(33,26) = 0.0;
  groebnerMatrix(33,28) = groebnerMatrix(33,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,183) = groebnerMatrix(33,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,27);
  groebnerMatrix(33,27) = 0.0;
  groebnerMatrix(33,33) = groebnerMatrix(33,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(33,175) = groebnerMatrix(33,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(33,30);
  groebnerMatrix(33,30) = 0.0;
  groebnerMatrix(33,34) = groebnerMatrix(33,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,168) = groebnerMatrix(33,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(33,39);
  groebnerMatrix(33,39) = 0.0;
  groebnerMatrix(33,63) = groebnerMatrix(33,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,101) = groebnerMatrix(33,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,40);
  groebnerMatrix(33,40) = 0.0;
  groebnerMatrix(33,62) = groebnerMatrix(33,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,158) = groebnerMatrix(33,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(33,41);
  groebnerMatrix(33,41) = 0.0;
  groebnerMatrix(33,65) = groebnerMatrix(33,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,102) = groebnerMatrix(33,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,42);
  groebnerMatrix(33,42) = 0.0;
  groebnerMatrix(33,64) = groebnerMatrix(33,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,159) = groebnerMatrix(33,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(33,43);
  groebnerMatrix(33,43) = 0.0;
  groebnerMatrix(33,56) = groebnerMatrix(33,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(33,139) = groebnerMatrix(33,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(33,193) = groebnerMatrix(33,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(33,44);
  groebnerMatrix(33,44) = 0.0;
  groebnerMatrix(33,72) = groebnerMatrix(33,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,113) = groebnerMatrix(33,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(33,45);
  groebnerMatrix(33,45) = 0.0;
  groebnerMatrix(33,73) = groebnerMatrix(33,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,114) = groebnerMatrix(33,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(33,46);
  groebnerMatrix(33,46) = 0.0;
  groebnerMatrix(33,72) = groebnerMatrix(33,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,109) = groebnerMatrix(33,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,47);
  groebnerMatrix(33,47) = 0.0;
  groebnerMatrix(33,71) = groebnerMatrix(33,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,161) = groebnerMatrix(33,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(33,48);
  groebnerMatrix(33,48) = 0.0;
  groebnerMatrix(33,52) = groebnerMatrix(33,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,169) = groebnerMatrix(33,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(33,49);
  groebnerMatrix(33,49) = 0.0;
  groebnerMatrix(33,75) = groebnerMatrix(33,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,116) = groebnerMatrix(33,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(33,50);
  groebnerMatrix(33,50) = 0.0;
  groebnerMatrix(33,74) = groebnerMatrix(33,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(33,154) = groebnerMatrix(33,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(33,51);
  groebnerMatrix(33,51) = 0.0;
  groebnerMatrix(33,77) = groebnerMatrix(33,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,114) = groebnerMatrix(33,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,52);
  groebnerMatrix(33,52) = 0.0;
  groebnerMatrix(33,76) = groebnerMatrix(33,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,162) = groebnerMatrix(33,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(33,53);
  groebnerMatrix(33,53) = 0.0;
  groebnerMatrix(33,105) = groebnerMatrix(33,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(33,146) = groebnerMatrix(33,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(33,54);
  groebnerMatrix(33,54) = 0.0;
  groebnerMatrix(33,80) = groebnerMatrix(33,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,117) = groebnerMatrix(33,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(33,55);
  groebnerMatrix(33,55) = 0.0;
  groebnerMatrix(33,79) = groebnerMatrix(33,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(33,159) = groebnerMatrix(33,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(33,56);
  groebnerMatrix(33,56) = 0.0;
  groebnerMatrix(33,115) = groebnerMatrix(33,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(33,158) = groebnerMatrix(33,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(33,57);
  groebnerMatrix(33,57) = 0.0;
  groebnerMatrix(33,90) = groebnerMatrix(33,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(33,134) = groebnerMatrix(33,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(33,188) = groebnerMatrix(33,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(33,58);
  groebnerMatrix(33,58) = 0.0;
  groebnerMatrix(33,91) = groebnerMatrix(33,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(33,135) = groebnerMatrix(33,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(33,189) = groebnerMatrix(33,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(33,59);
  groebnerMatrix(33,59) = 0.0;
  groebnerMatrix(33,93) = groebnerMatrix(33,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(33,137) = groebnerMatrix(33,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(33,191) = groebnerMatrix(33,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(33,60);
  groebnerMatrix(33,60) = 0.0;
  groebnerMatrix(33,94) = groebnerMatrix(33,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(33,138) = groebnerMatrix(33,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(33,192) = groebnerMatrix(33,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(33,61);
  groebnerMatrix(33,61) = 0.0;
  groebnerMatrix(33,63) = groebnerMatrix(33,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(33,66) = groebnerMatrix(33,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(33,194) = groebnerMatrix(33,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(33,64);
  groebnerMatrix(33,64) = 0.0;
  groebnerMatrix(33,98) = groebnerMatrix(33,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,148) = groebnerMatrix(33,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(33,65);
  groebnerMatrix(33,65) = 0.0;
  groebnerMatrix(33,99) = groebnerMatrix(33,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,149) = groebnerMatrix(33,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(33,66);
  groebnerMatrix(33,66) = 0.0;
  groebnerMatrix(33,101) = groebnerMatrix(33,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,150) = groebnerMatrix(33,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(33,67);
  groebnerMatrix(33,67) = 0.0;
  groebnerMatrix(33,72) = groebnerMatrix(33,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,78) = groebnerMatrix(33,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,68);
  groebnerMatrix(33,68) = 0.0;
  groebnerMatrix(33,71) = groebnerMatrix(33,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,185) = groebnerMatrix(33,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,69);
  groebnerMatrix(33,69) = 0.0;
  groebnerMatrix(33,104) = groebnerMatrix(33,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,151) = groebnerMatrix(33,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(33,70);
  groebnerMatrix(33,70) = 0.0;
  groebnerMatrix(33,75) = groebnerMatrix(33,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(33,81) = groebnerMatrix(33,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(33,194) = groebnerMatrix(33,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(33,73);
  groebnerMatrix(33,73) = 0.0;
  groebnerMatrix(33,77) = groebnerMatrix(33,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,176) = groebnerMatrix(33,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(33,76);
  groebnerMatrix(33,76) = 0.0;
  groebnerMatrix(33,107) = groebnerMatrix(33,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,142) = groebnerMatrix(33,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(33,77);
  groebnerMatrix(33,77) = 0.0;
  groebnerMatrix(33,108) = groebnerMatrix(33,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,143) = groebnerMatrix(33,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(33,78);
  groebnerMatrix(33,78) = 0.0;
  groebnerMatrix(33,113) = groebnerMatrix(33,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,160) = groebnerMatrix(33,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(33,79);
  groebnerMatrix(33,79) = 0.0;
  groebnerMatrix(33,110) = groebnerMatrix(33,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,148) = groebnerMatrix(33,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(33,80);
  groebnerMatrix(33,80) = 0.0;
  groebnerMatrix(33,111) = groebnerMatrix(33,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,152) = groebnerMatrix(33,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(33,81);
  groebnerMatrix(33,81) = 0.0;
  groebnerMatrix(33,116) = groebnerMatrix(33,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,157) = groebnerMatrix(33,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(33,82);
  groebnerMatrix(33,82) = 0.0;
  groebnerMatrix(33,90) = groebnerMatrix(33,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,127) = groebnerMatrix(33,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,83);
  groebnerMatrix(33,83) = 0.0;
  groebnerMatrix(33,89) = groebnerMatrix(33,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,175) = groebnerMatrix(33,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(33,84);
  groebnerMatrix(33,84) = 0.0;
  groebnerMatrix(33,119) = groebnerMatrix(33,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,166) = groebnerMatrix(33,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(33,85);
  groebnerMatrix(33,85) = 0.0;
  groebnerMatrix(33,93) = groebnerMatrix(33,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,130) = groebnerMatrix(33,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(33,86);
  groebnerMatrix(33,86) = 0.0;
  groebnerMatrix(33,92) = groebnerMatrix(33,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(33,172) = groebnerMatrix(33,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(33,87);
  groebnerMatrix(33,87) = 0.0;
  groebnerMatrix(33,122) = groebnerMatrix(33,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,163) = groebnerMatrix(33,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(33,91);
  groebnerMatrix(33,91) = 0.0;
  groebnerMatrix(33,126) = groebnerMatrix(33,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,173) = groebnerMatrix(33,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(33,94);
  groebnerMatrix(33,94) = 0.0;
  groebnerMatrix(33,129) = groebnerMatrix(33,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,170) = groebnerMatrix(33,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(33,97);
  groebnerMatrix(33,97) = 0.0;
  groebnerMatrix(33,99) = groebnerMatrix(33,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(33,102) = groebnerMatrix(33,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(33,195) = groebnerMatrix(33,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(33,100);
  groebnerMatrix(33,100) = 0.0;
  groebnerMatrix(33,115) = groebnerMatrix(33,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(33,139) = groebnerMatrix(33,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(33,103);
  groebnerMatrix(33,103) = 0.0;
  groebnerMatrix(33,108) = groebnerMatrix(33,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,114) = groebnerMatrix(33,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,104);
  groebnerMatrix(33,104) = 0.0;
  groebnerMatrix(33,107) = groebnerMatrix(33,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,186) = groebnerMatrix(33,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,105);
  groebnerMatrix(33,105) = 0.0;
  groebnerMatrix(33,112) = groebnerMatrix(33,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(33,185) = groebnerMatrix(33,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(33,106);
  groebnerMatrix(33,106) = 0.0;
  groebnerMatrix(33,111) = groebnerMatrix(33,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(33,117) = groebnerMatrix(33,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(33,195) = groebnerMatrix(33,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(33,109);
  groebnerMatrix(33,109) = 0.0;
  groebnerMatrix(33,113) = groebnerMatrix(33,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,184) = groebnerMatrix(33,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(33,118);
  groebnerMatrix(33,118) = 0.0;
  groebnerMatrix(33,126) = groebnerMatrix(33,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,135) = groebnerMatrix(33,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,119);
  groebnerMatrix(33,119) = 0.0;
  groebnerMatrix(33,125) = groebnerMatrix(33,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,183) = groebnerMatrix(33,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(33,120);
  groebnerMatrix(33,120) = 0.0;
  groebnerMatrix(33,133) = groebnerMatrix(33,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(33,182) = groebnerMatrix(33,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(33,121);
  groebnerMatrix(33,121) = 0.0;
  groebnerMatrix(33,129) = groebnerMatrix(33,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,138) = groebnerMatrix(33,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(33,122);
  groebnerMatrix(33,122) = 0.0;
  groebnerMatrix(33,128) = groebnerMatrix(33,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(33,180) = groebnerMatrix(33,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(33,123);
  groebnerMatrix(33,123) = 0.0;
  groebnerMatrix(33,136) = groebnerMatrix(33,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(33,179) = groebnerMatrix(33,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(33,127);
  groebnerMatrix(33,127) = 0.0;
  groebnerMatrix(33,134) = groebnerMatrix(33,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,181) = groebnerMatrix(33,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(33,130);
  groebnerMatrix(33,130) = 0.0;
  groebnerMatrix(33,137) = groebnerMatrix(33,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,178) = groebnerMatrix(33,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(33,142);
  groebnerMatrix(33,142) = 0.0;
  groebnerMatrix(33,144) = groebnerMatrix(33,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(33,147) = groebnerMatrix(33,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(33,196) = groebnerMatrix(33,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(33,143);
  groebnerMatrix(33,143) = 0.0;
  groebnerMatrix(33,155) = groebnerMatrix(33,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(33,176) = groebnerMatrix(33,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(33,144);
  groebnerMatrix(33,144) = 0.0;
  groebnerMatrix(33,156) = groebnerMatrix(33,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(33,177) = groebnerMatrix(33,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(33,196) = groebnerMatrix(33,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(33,146);
  groebnerMatrix(33,146) = 0.0;
  groebnerMatrix(33,161) = groebnerMatrix(33,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(33,185) = groebnerMatrix(33,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(33,147);
  groebnerMatrix(33,147) = 0.0;
  groebnerMatrix(33,162) = groebnerMatrix(33,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(33,186) = groebnerMatrix(33,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(33,196) = groebnerMatrix(33,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(33,148);
  groebnerMatrix(33,148) = 0.0;
  groebnerMatrix(33,153) = groebnerMatrix(33,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(33,159) = groebnerMatrix(33,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(33,149);
  groebnerMatrix(33,149) = 0.0;
  groebnerMatrix(33,152) = groebnerMatrix(33,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(33,195) = groebnerMatrix(33,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(33,150);
  groebnerMatrix(33,150) = 0.0;
  groebnerMatrix(33,157) = groebnerMatrix(33,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(33,194) = groebnerMatrix(33,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(33,151);
  groebnerMatrix(33,151) = 0.0;
  groebnerMatrix(33,156) = groebnerMatrix(33,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(33,162) = groebnerMatrix(33,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(33,196) = groebnerMatrix(33,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,33);
  groebnerRow31_000000000_f(groebnerMatrix,33);
  factor = -groebnerMatrix(33,154);
  groebnerMatrix(33,154) = 0.0;
  groebnerMatrix(33,158) = groebnerMatrix(33,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(33,193) = groebnerMatrix(33,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,33);
  factor = groebnerMatrix(33,163);
  groebnerMatrix(33,163) = 0.0;
  groebnerMatrix(33,171) = groebnerMatrix(33,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(33,180) = groebnerMatrix(33,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(33,164);
  groebnerMatrix(33,164) = 0.0;
  groebnerMatrix(33,170) = groebnerMatrix(33,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(33,192) = groebnerMatrix(33,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(33,165);
  groebnerMatrix(33,165) = 0.0;
  groebnerMatrix(33,178) = groebnerMatrix(33,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(33,191) = groebnerMatrix(33,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(33,166);
  groebnerMatrix(33,166) = 0.0;
  groebnerMatrix(33,174) = groebnerMatrix(33,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(33,183) = groebnerMatrix(33,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(33,167);
  groebnerMatrix(33,167) = 0.0;
  groebnerMatrix(33,173) = groebnerMatrix(33,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(33,189) = groebnerMatrix(33,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(33,168);
  groebnerMatrix(33,168) = 0.0;
  groebnerMatrix(33,181) = groebnerMatrix(33,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(33,188) = groebnerMatrix(33,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(33,169);
  groebnerMatrix(33,169) = 0.0;
  groebnerMatrix(33,177) = groebnerMatrix(33,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(33,186) = groebnerMatrix(33,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(33,196) = groebnerMatrix(33,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(33,172);
  groebnerMatrix(33,172) = 0.0;
  groebnerMatrix(33,179) = groebnerMatrix(33,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(33,190) = groebnerMatrix(33,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(33,175);
  groebnerMatrix(33,175) = 0.0;
  groebnerMatrix(33,182) = groebnerMatrix(33,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(33,187) = groebnerMatrix(33,187) - factor * groebnerMatrix(18,187);

  sPolynomial34(groebnerMatrix);
  factor = -groebnerMatrix(34,1);
  groebnerMatrix(34,1) = 0.0;
  groebnerMatrix(34,8) = groebnerMatrix(34,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,179) = groebnerMatrix(34,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,2);
  groebnerMatrix(34,2) = 0.0;
  groebnerMatrix(34,11) = groebnerMatrix(34,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,24) = groebnerMatrix(34,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,3);
  groebnerMatrix(34,3) = 0.0;
  groebnerMatrix(34,10) = groebnerMatrix(34,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,180) = groebnerMatrix(34,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,4);
  groebnerMatrix(34,4) = 0.0;
  groebnerMatrix(34,36) = groebnerMatrix(34,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(34,136) = groebnerMatrix(34,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(34,190) = groebnerMatrix(34,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(34,5);
  groebnerMatrix(34,5) = 0.0;
  groebnerMatrix(34,17) = groebnerMatrix(34,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(34,34) = groebnerMatrix(34,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(34,188) = groebnerMatrix(34,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(34,6);
  groebnerMatrix(34,6) = 0.0;
  groebnerMatrix(34,18) = groebnerMatrix(34,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(34,35) = groebnerMatrix(34,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(34,189) = groebnerMatrix(34,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(34,10);
  groebnerMatrix(34,10) = 0.0;
  groebnerMatrix(34,20) = groebnerMatrix(34,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,163) = groebnerMatrix(34,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(34,11);
  groebnerMatrix(34,11) = 0.0;
  groebnerMatrix(34,21) = groebnerMatrix(34,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,164) = groebnerMatrix(34,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(34,12);
  groebnerMatrix(34,12) = 0.0;
  groebnerMatrix(34,23) = groebnerMatrix(34,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,165) = groebnerMatrix(34,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(34,13);
  groebnerMatrix(34,13) = 0.0;
  groebnerMatrix(34,17) = groebnerMatrix(34,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,30) = groebnerMatrix(34,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,14);
  groebnerMatrix(34,14) = 0.0;
  groebnerMatrix(34,16) = groebnerMatrix(34,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,182) = groebnerMatrix(34,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(34,15);
  groebnerMatrix(34,15) = 0.0;
  groebnerMatrix(34,26) = groebnerMatrix(34,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,166) = groebnerMatrix(34,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(34,18);
  groebnerMatrix(34,18) = 0.0;
  groebnerMatrix(34,29) = groebnerMatrix(34,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,167) = groebnerMatrix(34,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(34,19);
  groebnerMatrix(34,19) = 0.0;
  groebnerMatrix(34,21) = groebnerMatrix(34,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(34,24) = groebnerMatrix(34,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(34,192) = groebnerMatrix(34,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(34,22);
  groebnerMatrix(34,22) = 0.0;
  groebnerMatrix(34,36) = groebnerMatrix(34,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(34,123) = groebnerMatrix(34,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(34,25);
  groebnerMatrix(34,25) = 0.0;
  groebnerMatrix(34,29) = groebnerMatrix(34,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,35) = groebnerMatrix(34,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,26);
  groebnerMatrix(34,26) = 0.0;
  groebnerMatrix(34,28) = groebnerMatrix(34,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,183) = groebnerMatrix(34,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,27);
  groebnerMatrix(34,27) = 0.0;
  groebnerMatrix(34,33) = groebnerMatrix(34,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(34,175) = groebnerMatrix(34,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(34,30);
  groebnerMatrix(34,30) = 0.0;
  groebnerMatrix(34,34) = groebnerMatrix(34,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,168) = groebnerMatrix(34,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(34,39);
  groebnerMatrix(34,39) = 0.0;
  groebnerMatrix(34,63) = groebnerMatrix(34,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,101) = groebnerMatrix(34,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,40);
  groebnerMatrix(34,40) = 0.0;
  groebnerMatrix(34,62) = groebnerMatrix(34,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,158) = groebnerMatrix(34,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(34,41);
  groebnerMatrix(34,41) = 0.0;
  groebnerMatrix(34,65) = groebnerMatrix(34,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,102) = groebnerMatrix(34,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,42);
  groebnerMatrix(34,42) = 0.0;
  groebnerMatrix(34,64) = groebnerMatrix(34,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,159) = groebnerMatrix(34,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(34,43);
  groebnerMatrix(34,43) = 0.0;
  groebnerMatrix(34,56) = groebnerMatrix(34,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(34,139) = groebnerMatrix(34,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(34,193) = groebnerMatrix(34,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(34,44);
  groebnerMatrix(34,44) = 0.0;
  groebnerMatrix(34,72) = groebnerMatrix(34,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,113) = groebnerMatrix(34,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(34,45);
  groebnerMatrix(34,45) = 0.0;
  groebnerMatrix(34,73) = groebnerMatrix(34,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,114) = groebnerMatrix(34,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(34,46);
  groebnerMatrix(34,46) = 0.0;
  groebnerMatrix(34,72) = groebnerMatrix(34,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,109) = groebnerMatrix(34,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,47);
  groebnerMatrix(34,47) = 0.0;
  groebnerMatrix(34,71) = groebnerMatrix(34,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,161) = groebnerMatrix(34,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(34,48);
  groebnerMatrix(34,48) = 0.0;
  groebnerMatrix(34,52) = groebnerMatrix(34,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,169) = groebnerMatrix(34,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(34,49);
  groebnerMatrix(34,49) = 0.0;
  groebnerMatrix(34,75) = groebnerMatrix(34,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,116) = groebnerMatrix(34,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(34,50);
  groebnerMatrix(34,50) = 0.0;
  groebnerMatrix(34,74) = groebnerMatrix(34,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(34,154) = groebnerMatrix(34,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(34,51);
  groebnerMatrix(34,51) = 0.0;
  groebnerMatrix(34,77) = groebnerMatrix(34,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,114) = groebnerMatrix(34,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,52);
  groebnerMatrix(34,52) = 0.0;
  groebnerMatrix(34,76) = groebnerMatrix(34,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,162) = groebnerMatrix(34,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(34,53);
  groebnerMatrix(34,53) = 0.0;
  groebnerMatrix(34,105) = groebnerMatrix(34,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(34,146) = groebnerMatrix(34,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(34,54);
  groebnerMatrix(34,54) = 0.0;
  groebnerMatrix(34,80) = groebnerMatrix(34,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,117) = groebnerMatrix(34,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(34,55);
  groebnerMatrix(34,55) = 0.0;
  groebnerMatrix(34,79) = groebnerMatrix(34,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(34,159) = groebnerMatrix(34,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(34,56);
  groebnerMatrix(34,56) = 0.0;
  groebnerMatrix(34,115) = groebnerMatrix(34,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(34,158) = groebnerMatrix(34,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(34,57);
  groebnerMatrix(34,57) = 0.0;
  groebnerMatrix(34,90) = groebnerMatrix(34,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(34,134) = groebnerMatrix(34,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(34,188) = groebnerMatrix(34,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(34,58);
  groebnerMatrix(34,58) = 0.0;
  groebnerMatrix(34,91) = groebnerMatrix(34,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(34,135) = groebnerMatrix(34,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(34,189) = groebnerMatrix(34,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(34,59);
  groebnerMatrix(34,59) = 0.0;
  groebnerMatrix(34,93) = groebnerMatrix(34,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(34,137) = groebnerMatrix(34,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(34,191) = groebnerMatrix(34,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(34,60);
  groebnerMatrix(34,60) = 0.0;
  groebnerMatrix(34,94) = groebnerMatrix(34,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(34,138) = groebnerMatrix(34,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(34,192) = groebnerMatrix(34,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(34,61);
  groebnerMatrix(34,61) = 0.0;
  groebnerMatrix(34,63) = groebnerMatrix(34,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(34,66) = groebnerMatrix(34,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(34,194) = groebnerMatrix(34,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(34,64);
  groebnerMatrix(34,64) = 0.0;
  groebnerMatrix(34,98) = groebnerMatrix(34,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,148) = groebnerMatrix(34,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(34,65);
  groebnerMatrix(34,65) = 0.0;
  groebnerMatrix(34,99) = groebnerMatrix(34,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,149) = groebnerMatrix(34,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(34,66);
  groebnerMatrix(34,66) = 0.0;
  groebnerMatrix(34,101) = groebnerMatrix(34,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,150) = groebnerMatrix(34,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(34,67);
  groebnerMatrix(34,67) = 0.0;
  groebnerMatrix(34,72) = groebnerMatrix(34,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,78) = groebnerMatrix(34,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,68);
  groebnerMatrix(34,68) = 0.0;
  groebnerMatrix(34,71) = groebnerMatrix(34,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,185) = groebnerMatrix(34,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,69);
  groebnerMatrix(34,69) = 0.0;
  groebnerMatrix(34,104) = groebnerMatrix(34,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,151) = groebnerMatrix(34,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(34,70);
  groebnerMatrix(34,70) = 0.0;
  groebnerMatrix(34,75) = groebnerMatrix(34,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(34,81) = groebnerMatrix(34,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(34,194) = groebnerMatrix(34,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(34,73);
  groebnerMatrix(34,73) = 0.0;
  groebnerMatrix(34,77) = groebnerMatrix(34,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,176) = groebnerMatrix(34,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(34,76);
  groebnerMatrix(34,76) = 0.0;
  groebnerMatrix(34,107) = groebnerMatrix(34,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,142) = groebnerMatrix(34,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(34,77);
  groebnerMatrix(34,77) = 0.0;
  groebnerMatrix(34,108) = groebnerMatrix(34,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,143) = groebnerMatrix(34,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(34,78);
  groebnerMatrix(34,78) = 0.0;
  groebnerMatrix(34,113) = groebnerMatrix(34,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,160) = groebnerMatrix(34,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(34,79);
  groebnerMatrix(34,79) = 0.0;
  groebnerMatrix(34,110) = groebnerMatrix(34,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,148) = groebnerMatrix(34,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(34,80);
  groebnerMatrix(34,80) = 0.0;
  groebnerMatrix(34,111) = groebnerMatrix(34,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,152) = groebnerMatrix(34,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(34,81);
  groebnerMatrix(34,81) = 0.0;
  groebnerMatrix(34,116) = groebnerMatrix(34,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,157) = groebnerMatrix(34,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(34,82);
  groebnerMatrix(34,82) = 0.0;
  groebnerMatrix(34,90) = groebnerMatrix(34,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,127) = groebnerMatrix(34,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,83);
  groebnerMatrix(34,83) = 0.0;
  groebnerMatrix(34,89) = groebnerMatrix(34,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,175) = groebnerMatrix(34,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(34,84);
  groebnerMatrix(34,84) = 0.0;
  groebnerMatrix(34,119) = groebnerMatrix(34,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,166) = groebnerMatrix(34,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(34,85);
  groebnerMatrix(34,85) = 0.0;
  groebnerMatrix(34,93) = groebnerMatrix(34,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,130) = groebnerMatrix(34,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(34,86);
  groebnerMatrix(34,86) = 0.0;
  groebnerMatrix(34,92) = groebnerMatrix(34,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(34,172) = groebnerMatrix(34,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(34,87);
  groebnerMatrix(34,87) = 0.0;
  groebnerMatrix(34,122) = groebnerMatrix(34,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,163) = groebnerMatrix(34,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(34,91);
  groebnerMatrix(34,91) = 0.0;
  groebnerMatrix(34,126) = groebnerMatrix(34,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,173) = groebnerMatrix(34,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(34,94);
  groebnerMatrix(34,94) = 0.0;
  groebnerMatrix(34,129) = groebnerMatrix(34,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,170) = groebnerMatrix(34,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(34,97);
  groebnerMatrix(34,97) = 0.0;
  groebnerMatrix(34,99) = groebnerMatrix(34,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(34,102) = groebnerMatrix(34,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(34,195) = groebnerMatrix(34,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(34,100);
  groebnerMatrix(34,100) = 0.0;
  groebnerMatrix(34,115) = groebnerMatrix(34,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(34,139) = groebnerMatrix(34,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(34,103);
  groebnerMatrix(34,103) = 0.0;
  groebnerMatrix(34,108) = groebnerMatrix(34,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,114) = groebnerMatrix(34,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,104);
  groebnerMatrix(34,104) = 0.0;
  groebnerMatrix(34,107) = groebnerMatrix(34,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,186) = groebnerMatrix(34,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,105);
  groebnerMatrix(34,105) = 0.0;
  groebnerMatrix(34,112) = groebnerMatrix(34,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(34,185) = groebnerMatrix(34,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(34,106);
  groebnerMatrix(34,106) = 0.0;
  groebnerMatrix(34,111) = groebnerMatrix(34,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(34,117) = groebnerMatrix(34,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(34,195) = groebnerMatrix(34,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(34,109);
  groebnerMatrix(34,109) = 0.0;
  groebnerMatrix(34,113) = groebnerMatrix(34,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,184) = groebnerMatrix(34,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(34,118);
  groebnerMatrix(34,118) = 0.0;
  groebnerMatrix(34,126) = groebnerMatrix(34,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,135) = groebnerMatrix(34,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,119);
  groebnerMatrix(34,119) = 0.0;
  groebnerMatrix(34,125) = groebnerMatrix(34,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,183) = groebnerMatrix(34,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(34,120);
  groebnerMatrix(34,120) = 0.0;
  groebnerMatrix(34,133) = groebnerMatrix(34,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(34,182) = groebnerMatrix(34,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(34,121);
  groebnerMatrix(34,121) = 0.0;
  groebnerMatrix(34,129) = groebnerMatrix(34,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,138) = groebnerMatrix(34,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(34,122);
  groebnerMatrix(34,122) = 0.0;
  groebnerMatrix(34,128) = groebnerMatrix(34,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(34,180) = groebnerMatrix(34,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(34,123);
  groebnerMatrix(34,123) = 0.0;
  groebnerMatrix(34,136) = groebnerMatrix(34,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(34,179) = groebnerMatrix(34,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(34,127);
  groebnerMatrix(34,127) = 0.0;
  groebnerMatrix(34,134) = groebnerMatrix(34,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,181) = groebnerMatrix(34,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(34,130);
  groebnerMatrix(34,130) = 0.0;
  groebnerMatrix(34,137) = groebnerMatrix(34,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,178) = groebnerMatrix(34,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(34,142);
  groebnerMatrix(34,142) = 0.0;
  groebnerMatrix(34,144) = groebnerMatrix(34,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(34,147) = groebnerMatrix(34,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(34,196) = groebnerMatrix(34,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(34,143);
  groebnerMatrix(34,143) = 0.0;
  groebnerMatrix(34,155) = groebnerMatrix(34,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(34,176) = groebnerMatrix(34,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(34,144);
  groebnerMatrix(34,144) = 0.0;
  groebnerMatrix(34,156) = groebnerMatrix(34,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(34,177) = groebnerMatrix(34,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(34,196) = groebnerMatrix(34,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(34,146);
  groebnerMatrix(34,146) = 0.0;
  groebnerMatrix(34,161) = groebnerMatrix(34,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(34,185) = groebnerMatrix(34,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(34,147);
  groebnerMatrix(34,147) = 0.0;
  groebnerMatrix(34,162) = groebnerMatrix(34,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(34,186) = groebnerMatrix(34,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(34,196) = groebnerMatrix(34,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(34,148);
  groebnerMatrix(34,148) = 0.0;
  groebnerMatrix(34,153) = groebnerMatrix(34,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(34,159) = groebnerMatrix(34,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(34,149);
  groebnerMatrix(34,149) = 0.0;
  groebnerMatrix(34,152) = groebnerMatrix(34,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(34,195) = groebnerMatrix(34,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(34,150);
  groebnerMatrix(34,150) = 0.0;
  groebnerMatrix(34,157) = groebnerMatrix(34,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(34,194) = groebnerMatrix(34,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(34,151);
  groebnerMatrix(34,151) = 0.0;
  groebnerMatrix(34,156) = groebnerMatrix(34,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(34,162) = groebnerMatrix(34,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(34,196) = groebnerMatrix(34,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,34);
  groebnerRow31_000000000_f(groebnerMatrix,34);
  factor = -groebnerMatrix(34,154);
  groebnerMatrix(34,154) = 0.0;
  groebnerMatrix(34,158) = groebnerMatrix(34,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(34,193) = groebnerMatrix(34,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,34);
  groebnerRow33_000000000_f(groebnerMatrix,34);
  factor = groebnerMatrix(34,163);
  groebnerMatrix(34,163) = 0.0;
  groebnerMatrix(34,171) = groebnerMatrix(34,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(34,180) = groebnerMatrix(34,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(34,164);
  groebnerMatrix(34,164) = 0.0;
  groebnerMatrix(34,170) = groebnerMatrix(34,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(34,192) = groebnerMatrix(34,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(34,165);
  groebnerMatrix(34,165) = 0.0;
  groebnerMatrix(34,178) = groebnerMatrix(34,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(34,191) = groebnerMatrix(34,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(34,166);
  groebnerMatrix(34,166) = 0.0;
  groebnerMatrix(34,174) = groebnerMatrix(34,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(34,183) = groebnerMatrix(34,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(34,167);
  groebnerMatrix(34,167) = 0.0;
  groebnerMatrix(34,173) = groebnerMatrix(34,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(34,189) = groebnerMatrix(34,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(34,168);
  groebnerMatrix(34,168) = 0.0;
  groebnerMatrix(34,181) = groebnerMatrix(34,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(34,188) = groebnerMatrix(34,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(34,169);
  groebnerMatrix(34,169) = 0.0;
  groebnerMatrix(34,177) = groebnerMatrix(34,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(34,186) = groebnerMatrix(34,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(34,196) = groebnerMatrix(34,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(34,172);
  groebnerMatrix(34,172) = 0.0;
  groebnerMatrix(34,179) = groebnerMatrix(34,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(34,190) = groebnerMatrix(34,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(34,175);
  groebnerMatrix(34,175) = 0.0;
  groebnerMatrix(34,182) = groebnerMatrix(34,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(34,187) = groebnerMatrix(34,187) - factor * groebnerMatrix(18,187);

  sPolynomial35(groebnerMatrix);
  factor = -groebnerMatrix(35,1);
  groebnerMatrix(35,1) = 0.0;
  groebnerMatrix(35,8) = groebnerMatrix(35,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,179) = groebnerMatrix(35,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,2);
  groebnerMatrix(35,2) = 0.0;
  groebnerMatrix(35,11) = groebnerMatrix(35,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,24) = groebnerMatrix(35,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,3);
  groebnerMatrix(35,3) = 0.0;
  groebnerMatrix(35,10) = groebnerMatrix(35,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,180) = groebnerMatrix(35,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,4);
  groebnerMatrix(35,4) = 0.0;
  groebnerMatrix(35,36) = groebnerMatrix(35,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(35,136) = groebnerMatrix(35,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(35,190) = groebnerMatrix(35,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(35,5);
  groebnerMatrix(35,5) = 0.0;
  groebnerMatrix(35,17) = groebnerMatrix(35,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(35,34) = groebnerMatrix(35,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(35,188) = groebnerMatrix(35,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(35,6);
  groebnerMatrix(35,6) = 0.0;
  groebnerMatrix(35,18) = groebnerMatrix(35,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(35,35) = groebnerMatrix(35,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(35,189) = groebnerMatrix(35,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(35,10);
  groebnerMatrix(35,10) = 0.0;
  groebnerMatrix(35,20) = groebnerMatrix(35,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,163) = groebnerMatrix(35,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(35,11);
  groebnerMatrix(35,11) = 0.0;
  groebnerMatrix(35,21) = groebnerMatrix(35,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,164) = groebnerMatrix(35,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(35,12);
  groebnerMatrix(35,12) = 0.0;
  groebnerMatrix(35,23) = groebnerMatrix(35,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,165) = groebnerMatrix(35,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(35,13);
  groebnerMatrix(35,13) = 0.0;
  groebnerMatrix(35,17) = groebnerMatrix(35,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,30) = groebnerMatrix(35,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,14);
  groebnerMatrix(35,14) = 0.0;
  groebnerMatrix(35,16) = groebnerMatrix(35,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,182) = groebnerMatrix(35,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(35,15);
  groebnerMatrix(35,15) = 0.0;
  groebnerMatrix(35,26) = groebnerMatrix(35,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,166) = groebnerMatrix(35,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(35,18);
  groebnerMatrix(35,18) = 0.0;
  groebnerMatrix(35,29) = groebnerMatrix(35,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,167) = groebnerMatrix(35,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(35,19);
  groebnerMatrix(35,19) = 0.0;
  groebnerMatrix(35,21) = groebnerMatrix(35,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(35,24) = groebnerMatrix(35,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(35,192) = groebnerMatrix(35,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(35,22);
  groebnerMatrix(35,22) = 0.0;
  groebnerMatrix(35,36) = groebnerMatrix(35,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(35,123) = groebnerMatrix(35,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(35,25);
  groebnerMatrix(35,25) = 0.0;
  groebnerMatrix(35,29) = groebnerMatrix(35,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,35) = groebnerMatrix(35,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,26);
  groebnerMatrix(35,26) = 0.0;
  groebnerMatrix(35,28) = groebnerMatrix(35,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,183) = groebnerMatrix(35,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,27);
  groebnerMatrix(35,27) = 0.0;
  groebnerMatrix(35,33) = groebnerMatrix(35,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(35,175) = groebnerMatrix(35,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(35,30);
  groebnerMatrix(35,30) = 0.0;
  groebnerMatrix(35,34) = groebnerMatrix(35,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,168) = groebnerMatrix(35,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(35,39);
  groebnerMatrix(35,39) = 0.0;
  groebnerMatrix(35,63) = groebnerMatrix(35,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,101) = groebnerMatrix(35,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,40);
  groebnerMatrix(35,40) = 0.0;
  groebnerMatrix(35,62) = groebnerMatrix(35,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,158) = groebnerMatrix(35,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(35,41);
  groebnerMatrix(35,41) = 0.0;
  groebnerMatrix(35,65) = groebnerMatrix(35,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,102) = groebnerMatrix(35,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,42);
  groebnerMatrix(35,42) = 0.0;
  groebnerMatrix(35,64) = groebnerMatrix(35,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,159) = groebnerMatrix(35,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(35,43);
  groebnerMatrix(35,43) = 0.0;
  groebnerMatrix(35,56) = groebnerMatrix(35,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(35,139) = groebnerMatrix(35,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(35,193) = groebnerMatrix(35,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(35,44);
  groebnerMatrix(35,44) = 0.0;
  groebnerMatrix(35,72) = groebnerMatrix(35,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,113) = groebnerMatrix(35,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(35,45);
  groebnerMatrix(35,45) = 0.0;
  groebnerMatrix(35,73) = groebnerMatrix(35,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,114) = groebnerMatrix(35,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(35,46);
  groebnerMatrix(35,46) = 0.0;
  groebnerMatrix(35,72) = groebnerMatrix(35,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,109) = groebnerMatrix(35,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,47);
  groebnerMatrix(35,47) = 0.0;
  groebnerMatrix(35,71) = groebnerMatrix(35,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,161) = groebnerMatrix(35,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(35,48);
  groebnerMatrix(35,48) = 0.0;
  groebnerMatrix(35,52) = groebnerMatrix(35,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,169) = groebnerMatrix(35,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(35,49);
  groebnerMatrix(35,49) = 0.0;
  groebnerMatrix(35,75) = groebnerMatrix(35,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,116) = groebnerMatrix(35,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(35,50);
  groebnerMatrix(35,50) = 0.0;
  groebnerMatrix(35,74) = groebnerMatrix(35,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(35,154) = groebnerMatrix(35,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(35,51);
  groebnerMatrix(35,51) = 0.0;
  groebnerMatrix(35,77) = groebnerMatrix(35,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,114) = groebnerMatrix(35,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,52);
  groebnerMatrix(35,52) = 0.0;
  groebnerMatrix(35,76) = groebnerMatrix(35,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,162) = groebnerMatrix(35,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(35,53);
  groebnerMatrix(35,53) = 0.0;
  groebnerMatrix(35,105) = groebnerMatrix(35,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(35,146) = groebnerMatrix(35,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(35,54);
  groebnerMatrix(35,54) = 0.0;
  groebnerMatrix(35,80) = groebnerMatrix(35,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,117) = groebnerMatrix(35,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(35,55);
  groebnerMatrix(35,55) = 0.0;
  groebnerMatrix(35,79) = groebnerMatrix(35,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(35,159) = groebnerMatrix(35,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(35,56);
  groebnerMatrix(35,56) = 0.0;
  groebnerMatrix(35,115) = groebnerMatrix(35,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(35,158) = groebnerMatrix(35,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(35,57);
  groebnerMatrix(35,57) = 0.0;
  groebnerMatrix(35,90) = groebnerMatrix(35,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(35,134) = groebnerMatrix(35,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(35,188) = groebnerMatrix(35,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(35,58);
  groebnerMatrix(35,58) = 0.0;
  groebnerMatrix(35,91) = groebnerMatrix(35,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(35,135) = groebnerMatrix(35,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(35,189) = groebnerMatrix(35,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(35,59);
  groebnerMatrix(35,59) = 0.0;
  groebnerMatrix(35,93) = groebnerMatrix(35,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(35,137) = groebnerMatrix(35,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(35,191) = groebnerMatrix(35,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(35,60);
  groebnerMatrix(35,60) = 0.0;
  groebnerMatrix(35,94) = groebnerMatrix(35,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(35,138) = groebnerMatrix(35,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(35,192) = groebnerMatrix(35,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(35,61);
  groebnerMatrix(35,61) = 0.0;
  groebnerMatrix(35,63) = groebnerMatrix(35,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(35,66) = groebnerMatrix(35,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(35,194) = groebnerMatrix(35,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(35,64);
  groebnerMatrix(35,64) = 0.0;
  groebnerMatrix(35,98) = groebnerMatrix(35,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,148) = groebnerMatrix(35,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(35,65);
  groebnerMatrix(35,65) = 0.0;
  groebnerMatrix(35,99) = groebnerMatrix(35,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,149) = groebnerMatrix(35,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(35,66);
  groebnerMatrix(35,66) = 0.0;
  groebnerMatrix(35,101) = groebnerMatrix(35,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,150) = groebnerMatrix(35,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(35,67);
  groebnerMatrix(35,67) = 0.0;
  groebnerMatrix(35,72) = groebnerMatrix(35,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,78) = groebnerMatrix(35,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,68);
  groebnerMatrix(35,68) = 0.0;
  groebnerMatrix(35,71) = groebnerMatrix(35,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,185) = groebnerMatrix(35,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,69);
  groebnerMatrix(35,69) = 0.0;
  groebnerMatrix(35,104) = groebnerMatrix(35,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,151) = groebnerMatrix(35,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(35,70);
  groebnerMatrix(35,70) = 0.0;
  groebnerMatrix(35,75) = groebnerMatrix(35,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(35,81) = groebnerMatrix(35,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(35,194) = groebnerMatrix(35,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(35,73);
  groebnerMatrix(35,73) = 0.0;
  groebnerMatrix(35,77) = groebnerMatrix(35,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,176) = groebnerMatrix(35,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(35,76);
  groebnerMatrix(35,76) = 0.0;
  groebnerMatrix(35,107) = groebnerMatrix(35,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,142) = groebnerMatrix(35,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(35,77);
  groebnerMatrix(35,77) = 0.0;
  groebnerMatrix(35,108) = groebnerMatrix(35,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,143) = groebnerMatrix(35,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(35,78);
  groebnerMatrix(35,78) = 0.0;
  groebnerMatrix(35,113) = groebnerMatrix(35,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,160) = groebnerMatrix(35,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(35,79);
  groebnerMatrix(35,79) = 0.0;
  groebnerMatrix(35,110) = groebnerMatrix(35,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,148) = groebnerMatrix(35,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(35,80);
  groebnerMatrix(35,80) = 0.0;
  groebnerMatrix(35,111) = groebnerMatrix(35,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,152) = groebnerMatrix(35,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(35,81);
  groebnerMatrix(35,81) = 0.0;
  groebnerMatrix(35,116) = groebnerMatrix(35,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,157) = groebnerMatrix(35,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(35,82);
  groebnerMatrix(35,82) = 0.0;
  groebnerMatrix(35,90) = groebnerMatrix(35,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,127) = groebnerMatrix(35,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,83);
  groebnerMatrix(35,83) = 0.0;
  groebnerMatrix(35,89) = groebnerMatrix(35,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,175) = groebnerMatrix(35,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(35,84);
  groebnerMatrix(35,84) = 0.0;
  groebnerMatrix(35,119) = groebnerMatrix(35,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,166) = groebnerMatrix(35,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(35,85);
  groebnerMatrix(35,85) = 0.0;
  groebnerMatrix(35,93) = groebnerMatrix(35,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,130) = groebnerMatrix(35,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(35,86);
  groebnerMatrix(35,86) = 0.0;
  groebnerMatrix(35,92) = groebnerMatrix(35,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(35,172) = groebnerMatrix(35,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(35,87);
  groebnerMatrix(35,87) = 0.0;
  groebnerMatrix(35,122) = groebnerMatrix(35,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,163) = groebnerMatrix(35,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(35,91);
  groebnerMatrix(35,91) = 0.0;
  groebnerMatrix(35,126) = groebnerMatrix(35,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,173) = groebnerMatrix(35,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(35,94);
  groebnerMatrix(35,94) = 0.0;
  groebnerMatrix(35,129) = groebnerMatrix(35,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,170) = groebnerMatrix(35,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(35,97);
  groebnerMatrix(35,97) = 0.0;
  groebnerMatrix(35,99) = groebnerMatrix(35,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(35,102) = groebnerMatrix(35,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(35,195) = groebnerMatrix(35,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(35,100);
  groebnerMatrix(35,100) = 0.0;
  groebnerMatrix(35,115) = groebnerMatrix(35,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(35,139) = groebnerMatrix(35,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(35,103);
  groebnerMatrix(35,103) = 0.0;
  groebnerMatrix(35,108) = groebnerMatrix(35,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,114) = groebnerMatrix(35,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,104);
  groebnerMatrix(35,104) = 0.0;
  groebnerMatrix(35,107) = groebnerMatrix(35,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,186) = groebnerMatrix(35,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,105);
  groebnerMatrix(35,105) = 0.0;
  groebnerMatrix(35,112) = groebnerMatrix(35,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(35,185) = groebnerMatrix(35,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(35,106);
  groebnerMatrix(35,106) = 0.0;
  groebnerMatrix(35,111) = groebnerMatrix(35,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(35,117) = groebnerMatrix(35,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(35,195) = groebnerMatrix(35,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(35,109);
  groebnerMatrix(35,109) = 0.0;
  groebnerMatrix(35,113) = groebnerMatrix(35,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,184) = groebnerMatrix(35,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(35,118);
  groebnerMatrix(35,118) = 0.0;
  groebnerMatrix(35,126) = groebnerMatrix(35,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,135) = groebnerMatrix(35,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,119);
  groebnerMatrix(35,119) = 0.0;
  groebnerMatrix(35,125) = groebnerMatrix(35,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,183) = groebnerMatrix(35,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(35,120);
  groebnerMatrix(35,120) = 0.0;
  groebnerMatrix(35,133) = groebnerMatrix(35,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(35,182) = groebnerMatrix(35,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(35,121);
  groebnerMatrix(35,121) = 0.0;
  groebnerMatrix(35,129) = groebnerMatrix(35,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,138) = groebnerMatrix(35,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(35,122);
  groebnerMatrix(35,122) = 0.0;
  groebnerMatrix(35,128) = groebnerMatrix(35,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(35,180) = groebnerMatrix(35,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(35,123);
  groebnerMatrix(35,123) = 0.0;
  groebnerMatrix(35,136) = groebnerMatrix(35,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(35,179) = groebnerMatrix(35,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(35,127);
  groebnerMatrix(35,127) = 0.0;
  groebnerMatrix(35,134) = groebnerMatrix(35,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,181) = groebnerMatrix(35,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(35,130);
  groebnerMatrix(35,130) = 0.0;
  groebnerMatrix(35,137) = groebnerMatrix(35,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,178) = groebnerMatrix(35,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(35,142);
  groebnerMatrix(35,142) = 0.0;
  groebnerMatrix(35,144) = groebnerMatrix(35,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(35,147) = groebnerMatrix(35,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(35,196) = groebnerMatrix(35,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(35,143);
  groebnerMatrix(35,143) = 0.0;
  groebnerMatrix(35,155) = groebnerMatrix(35,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(35,176) = groebnerMatrix(35,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(35,144);
  groebnerMatrix(35,144) = 0.0;
  groebnerMatrix(35,156) = groebnerMatrix(35,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(35,177) = groebnerMatrix(35,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(35,196) = groebnerMatrix(35,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(35,146);
  groebnerMatrix(35,146) = 0.0;
  groebnerMatrix(35,161) = groebnerMatrix(35,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(35,185) = groebnerMatrix(35,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(35,147);
  groebnerMatrix(35,147) = 0.0;
  groebnerMatrix(35,162) = groebnerMatrix(35,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(35,186) = groebnerMatrix(35,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(35,196) = groebnerMatrix(35,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(35,148);
  groebnerMatrix(35,148) = 0.0;
  groebnerMatrix(35,153) = groebnerMatrix(35,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(35,159) = groebnerMatrix(35,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(35,149);
  groebnerMatrix(35,149) = 0.0;
  groebnerMatrix(35,152) = groebnerMatrix(35,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(35,195) = groebnerMatrix(35,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(35,150);
  groebnerMatrix(35,150) = 0.0;
  groebnerMatrix(35,157) = groebnerMatrix(35,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(35,194) = groebnerMatrix(35,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(35,151);
  groebnerMatrix(35,151) = 0.0;
  groebnerMatrix(35,156) = groebnerMatrix(35,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(35,162) = groebnerMatrix(35,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(35,196) = groebnerMatrix(35,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,35);
  groebnerRow31_000000000_f(groebnerMatrix,35);
  factor = -groebnerMatrix(35,154);
  groebnerMatrix(35,154) = 0.0;
  groebnerMatrix(35,158) = groebnerMatrix(35,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(35,193) = groebnerMatrix(35,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,35);
  groebnerRow33_000000000_f(groebnerMatrix,35);
  groebnerRow34_000000000_f(groebnerMatrix,35);
  factor = groebnerMatrix(35,163);
  groebnerMatrix(35,163) = 0.0;
  groebnerMatrix(35,171) = groebnerMatrix(35,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(35,180) = groebnerMatrix(35,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(35,164);
  groebnerMatrix(35,164) = 0.0;
  groebnerMatrix(35,170) = groebnerMatrix(35,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(35,192) = groebnerMatrix(35,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(35,165);
  groebnerMatrix(35,165) = 0.0;
  groebnerMatrix(35,178) = groebnerMatrix(35,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(35,191) = groebnerMatrix(35,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(35,166);
  groebnerMatrix(35,166) = 0.0;
  groebnerMatrix(35,174) = groebnerMatrix(35,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(35,183) = groebnerMatrix(35,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(35,167);
  groebnerMatrix(35,167) = 0.0;
  groebnerMatrix(35,173) = groebnerMatrix(35,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(35,189) = groebnerMatrix(35,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(35,168);
  groebnerMatrix(35,168) = 0.0;
  groebnerMatrix(35,181) = groebnerMatrix(35,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(35,188) = groebnerMatrix(35,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(35,169);
  groebnerMatrix(35,169) = 0.0;
  groebnerMatrix(35,177) = groebnerMatrix(35,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(35,186) = groebnerMatrix(35,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(35,196) = groebnerMatrix(35,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(35,172);
  groebnerMatrix(35,172) = 0.0;
  groebnerMatrix(35,179) = groebnerMatrix(35,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(35,190) = groebnerMatrix(35,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(35,175);
  groebnerMatrix(35,175) = 0.0;
  groebnerMatrix(35,182) = groebnerMatrix(35,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(35,187) = groebnerMatrix(35,187) - factor * groebnerMatrix(18,187);

  sPolynomial36(groebnerMatrix);
  factor = -groebnerMatrix(36,1);
  groebnerMatrix(36,1) = 0.0;
  groebnerMatrix(36,8) = groebnerMatrix(36,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,179) = groebnerMatrix(36,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,2);
  groebnerMatrix(36,2) = 0.0;
  groebnerMatrix(36,11) = groebnerMatrix(36,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,24) = groebnerMatrix(36,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,3);
  groebnerMatrix(36,3) = 0.0;
  groebnerMatrix(36,10) = groebnerMatrix(36,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,180) = groebnerMatrix(36,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,4);
  groebnerMatrix(36,4) = 0.0;
  groebnerMatrix(36,36) = groebnerMatrix(36,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(36,136) = groebnerMatrix(36,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(36,190) = groebnerMatrix(36,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(36,5);
  groebnerMatrix(36,5) = 0.0;
  groebnerMatrix(36,17) = groebnerMatrix(36,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(36,34) = groebnerMatrix(36,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(36,188) = groebnerMatrix(36,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(36,6);
  groebnerMatrix(36,6) = 0.0;
  groebnerMatrix(36,18) = groebnerMatrix(36,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(36,35) = groebnerMatrix(36,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(36,189) = groebnerMatrix(36,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(36,10);
  groebnerMatrix(36,10) = 0.0;
  groebnerMatrix(36,20) = groebnerMatrix(36,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,163) = groebnerMatrix(36,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(36,11);
  groebnerMatrix(36,11) = 0.0;
  groebnerMatrix(36,21) = groebnerMatrix(36,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,164) = groebnerMatrix(36,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(36,12);
  groebnerMatrix(36,12) = 0.0;
  groebnerMatrix(36,23) = groebnerMatrix(36,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,165) = groebnerMatrix(36,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(36,13);
  groebnerMatrix(36,13) = 0.0;
  groebnerMatrix(36,17) = groebnerMatrix(36,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,30) = groebnerMatrix(36,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,14);
  groebnerMatrix(36,14) = 0.0;
  groebnerMatrix(36,16) = groebnerMatrix(36,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,182) = groebnerMatrix(36,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(36,15);
  groebnerMatrix(36,15) = 0.0;
  groebnerMatrix(36,26) = groebnerMatrix(36,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,166) = groebnerMatrix(36,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(36,18);
  groebnerMatrix(36,18) = 0.0;
  groebnerMatrix(36,29) = groebnerMatrix(36,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,167) = groebnerMatrix(36,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(36,19);
  groebnerMatrix(36,19) = 0.0;
  groebnerMatrix(36,21) = groebnerMatrix(36,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(36,24) = groebnerMatrix(36,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(36,192) = groebnerMatrix(36,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(36,22);
  groebnerMatrix(36,22) = 0.0;
  groebnerMatrix(36,36) = groebnerMatrix(36,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(36,123) = groebnerMatrix(36,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(36,25);
  groebnerMatrix(36,25) = 0.0;
  groebnerMatrix(36,29) = groebnerMatrix(36,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,35) = groebnerMatrix(36,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,26);
  groebnerMatrix(36,26) = 0.0;
  groebnerMatrix(36,28) = groebnerMatrix(36,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,183) = groebnerMatrix(36,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,27);
  groebnerMatrix(36,27) = 0.0;
  groebnerMatrix(36,33) = groebnerMatrix(36,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(36,175) = groebnerMatrix(36,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(36,30);
  groebnerMatrix(36,30) = 0.0;
  groebnerMatrix(36,34) = groebnerMatrix(36,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,168) = groebnerMatrix(36,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(36,39);
  groebnerMatrix(36,39) = 0.0;
  groebnerMatrix(36,63) = groebnerMatrix(36,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,101) = groebnerMatrix(36,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,40);
  groebnerMatrix(36,40) = 0.0;
  groebnerMatrix(36,62) = groebnerMatrix(36,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,158) = groebnerMatrix(36,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(36,41);
  groebnerMatrix(36,41) = 0.0;
  groebnerMatrix(36,65) = groebnerMatrix(36,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,102) = groebnerMatrix(36,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,42);
  groebnerMatrix(36,42) = 0.0;
  groebnerMatrix(36,64) = groebnerMatrix(36,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,159) = groebnerMatrix(36,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(36,43);
  groebnerMatrix(36,43) = 0.0;
  groebnerMatrix(36,56) = groebnerMatrix(36,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(36,139) = groebnerMatrix(36,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(36,193) = groebnerMatrix(36,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(36,44);
  groebnerMatrix(36,44) = 0.0;
  groebnerMatrix(36,72) = groebnerMatrix(36,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,113) = groebnerMatrix(36,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(36,45);
  groebnerMatrix(36,45) = 0.0;
  groebnerMatrix(36,73) = groebnerMatrix(36,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,114) = groebnerMatrix(36,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(36,46);
  groebnerMatrix(36,46) = 0.0;
  groebnerMatrix(36,72) = groebnerMatrix(36,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,109) = groebnerMatrix(36,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,47);
  groebnerMatrix(36,47) = 0.0;
  groebnerMatrix(36,71) = groebnerMatrix(36,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,161) = groebnerMatrix(36,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(36,48);
  groebnerMatrix(36,48) = 0.0;
  groebnerMatrix(36,52) = groebnerMatrix(36,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,169) = groebnerMatrix(36,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(36,49);
  groebnerMatrix(36,49) = 0.0;
  groebnerMatrix(36,75) = groebnerMatrix(36,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,116) = groebnerMatrix(36,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(36,50);
  groebnerMatrix(36,50) = 0.0;
  groebnerMatrix(36,74) = groebnerMatrix(36,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(36,154) = groebnerMatrix(36,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(36,51);
  groebnerMatrix(36,51) = 0.0;
  groebnerMatrix(36,77) = groebnerMatrix(36,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,114) = groebnerMatrix(36,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,52);
  groebnerMatrix(36,52) = 0.0;
  groebnerMatrix(36,76) = groebnerMatrix(36,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,162) = groebnerMatrix(36,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(36,53);
  groebnerMatrix(36,53) = 0.0;
  groebnerMatrix(36,105) = groebnerMatrix(36,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(36,146) = groebnerMatrix(36,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(36,54);
  groebnerMatrix(36,54) = 0.0;
  groebnerMatrix(36,80) = groebnerMatrix(36,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,117) = groebnerMatrix(36,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(36,55);
  groebnerMatrix(36,55) = 0.0;
  groebnerMatrix(36,79) = groebnerMatrix(36,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(36,159) = groebnerMatrix(36,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(36,56);
  groebnerMatrix(36,56) = 0.0;
  groebnerMatrix(36,115) = groebnerMatrix(36,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(36,158) = groebnerMatrix(36,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(36,57);
  groebnerMatrix(36,57) = 0.0;
  groebnerMatrix(36,90) = groebnerMatrix(36,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(36,134) = groebnerMatrix(36,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(36,188) = groebnerMatrix(36,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(36,58);
  groebnerMatrix(36,58) = 0.0;
  groebnerMatrix(36,91) = groebnerMatrix(36,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(36,135) = groebnerMatrix(36,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(36,189) = groebnerMatrix(36,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(36,59);
  groebnerMatrix(36,59) = 0.0;
  groebnerMatrix(36,93) = groebnerMatrix(36,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(36,137) = groebnerMatrix(36,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(36,191) = groebnerMatrix(36,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(36,60);
  groebnerMatrix(36,60) = 0.0;
  groebnerMatrix(36,94) = groebnerMatrix(36,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(36,138) = groebnerMatrix(36,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(36,192) = groebnerMatrix(36,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(36,61);
  groebnerMatrix(36,61) = 0.0;
  groebnerMatrix(36,63) = groebnerMatrix(36,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(36,66) = groebnerMatrix(36,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(36,194) = groebnerMatrix(36,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(36,64);
  groebnerMatrix(36,64) = 0.0;
  groebnerMatrix(36,98) = groebnerMatrix(36,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,148) = groebnerMatrix(36,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(36,65);
  groebnerMatrix(36,65) = 0.0;
  groebnerMatrix(36,99) = groebnerMatrix(36,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,149) = groebnerMatrix(36,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(36,66);
  groebnerMatrix(36,66) = 0.0;
  groebnerMatrix(36,101) = groebnerMatrix(36,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,150) = groebnerMatrix(36,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(36,67);
  groebnerMatrix(36,67) = 0.0;
  groebnerMatrix(36,72) = groebnerMatrix(36,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,78) = groebnerMatrix(36,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,68);
  groebnerMatrix(36,68) = 0.0;
  groebnerMatrix(36,71) = groebnerMatrix(36,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,185) = groebnerMatrix(36,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,69);
  groebnerMatrix(36,69) = 0.0;
  groebnerMatrix(36,104) = groebnerMatrix(36,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,151) = groebnerMatrix(36,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(36,70);
  groebnerMatrix(36,70) = 0.0;
  groebnerMatrix(36,75) = groebnerMatrix(36,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(36,81) = groebnerMatrix(36,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(36,194) = groebnerMatrix(36,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(36,73);
  groebnerMatrix(36,73) = 0.0;
  groebnerMatrix(36,77) = groebnerMatrix(36,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,176) = groebnerMatrix(36,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(36,76);
  groebnerMatrix(36,76) = 0.0;
  groebnerMatrix(36,107) = groebnerMatrix(36,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,142) = groebnerMatrix(36,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(36,77);
  groebnerMatrix(36,77) = 0.0;
  groebnerMatrix(36,108) = groebnerMatrix(36,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,143) = groebnerMatrix(36,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(36,78);
  groebnerMatrix(36,78) = 0.0;
  groebnerMatrix(36,113) = groebnerMatrix(36,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,160) = groebnerMatrix(36,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(36,79);
  groebnerMatrix(36,79) = 0.0;
  groebnerMatrix(36,110) = groebnerMatrix(36,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,148) = groebnerMatrix(36,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(36,80);
  groebnerMatrix(36,80) = 0.0;
  groebnerMatrix(36,111) = groebnerMatrix(36,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,152) = groebnerMatrix(36,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(36,81);
  groebnerMatrix(36,81) = 0.0;
  groebnerMatrix(36,116) = groebnerMatrix(36,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,157) = groebnerMatrix(36,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(36,82);
  groebnerMatrix(36,82) = 0.0;
  groebnerMatrix(36,90) = groebnerMatrix(36,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,127) = groebnerMatrix(36,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,83);
  groebnerMatrix(36,83) = 0.0;
  groebnerMatrix(36,89) = groebnerMatrix(36,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,175) = groebnerMatrix(36,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(36,84);
  groebnerMatrix(36,84) = 0.0;
  groebnerMatrix(36,119) = groebnerMatrix(36,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,166) = groebnerMatrix(36,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(36,85);
  groebnerMatrix(36,85) = 0.0;
  groebnerMatrix(36,93) = groebnerMatrix(36,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,130) = groebnerMatrix(36,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(36,86);
  groebnerMatrix(36,86) = 0.0;
  groebnerMatrix(36,92) = groebnerMatrix(36,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(36,172) = groebnerMatrix(36,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(36,87);
  groebnerMatrix(36,87) = 0.0;
  groebnerMatrix(36,122) = groebnerMatrix(36,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,163) = groebnerMatrix(36,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(36,91);
  groebnerMatrix(36,91) = 0.0;
  groebnerMatrix(36,126) = groebnerMatrix(36,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,173) = groebnerMatrix(36,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(36,94);
  groebnerMatrix(36,94) = 0.0;
  groebnerMatrix(36,129) = groebnerMatrix(36,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,170) = groebnerMatrix(36,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(36,97);
  groebnerMatrix(36,97) = 0.0;
  groebnerMatrix(36,99) = groebnerMatrix(36,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(36,102) = groebnerMatrix(36,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(36,195) = groebnerMatrix(36,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(36,100);
  groebnerMatrix(36,100) = 0.0;
  groebnerMatrix(36,115) = groebnerMatrix(36,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(36,139) = groebnerMatrix(36,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(36,103);
  groebnerMatrix(36,103) = 0.0;
  groebnerMatrix(36,108) = groebnerMatrix(36,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,114) = groebnerMatrix(36,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,104);
  groebnerMatrix(36,104) = 0.0;
  groebnerMatrix(36,107) = groebnerMatrix(36,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,186) = groebnerMatrix(36,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,105);
  groebnerMatrix(36,105) = 0.0;
  groebnerMatrix(36,112) = groebnerMatrix(36,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(36,185) = groebnerMatrix(36,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(36,106);
  groebnerMatrix(36,106) = 0.0;
  groebnerMatrix(36,111) = groebnerMatrix(36,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(36,117) = groebnerMatrix(36,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(36,195) = groebnerMatrix(36,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(36,109);
  groebnerMatrix(36,109) = 0.0;
  groebnerMatrix(36,113) = groebnerMatrix(36,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,184) = groebnerMatrix(36,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(36,118);
  groebnerMatrix(36,118) = 0.0;
  groebnerMatrix(36,126) = groebnerMatrix(36,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,135) = groebnerMatrix(36,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,119);
  groebnerMatrix(36,119) = 0.0;
  groebnerMatrix(36,125) = groebnerMatrix(36,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,183) = groebnerMatrix(36,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(36,120);
  groebnerMatrix(36,120) = 0.0;
  groebnerMatrix(36,133) = groebnerMatrix(36,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(36,182) = groebnerMatrix(36,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(36,121);
  groebnerMatrix(36,121) = 0.0;
  groebnerMatrix(36,129) = groebnerMatrix(36,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,138) = groebnerMatrix(36,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(36,122);
  groebnerMatrix(36,122) = 0.0;
  groebnerMatrix(36,128) = groebnerMatrix(36,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(36,180) = groebnerMatrix(36,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(36,123);
  groebnerMatrix(36,123) = 0.0;
  groebnerMatrix(36,136) = groebnerMatrix(36,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(36,179) = groebnerMatrix(36,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(36,127);
  groebnerMatrix(36,127) = 0.0;
  groebnerMatrix(36,134) = groebnerMatrix(36,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,181) = groebnerMatrix(36,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(36,130);
  groebnerMatrix(36,130) = 0.0;
  groebnerMatrix(36,137) = groebnerMatrix(36,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,178) = groebnerMatrix(36,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(36,142);
  groebnerMatrix(36,142) = 0.0;
  groebnerMatrix(36,144) = groebnerMatrix(36,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(36,147) = groebnerMatrix(36,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(36,196) = groebnerMatrix(36,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(36,143);
  groebnerMatrix(36,143) = 0.0;
  groebnerMatrix(36,155) = groebnerMatrix(36,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(36,176) = groebnerMatrix(36,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(36,144);
  groebnerMatrix(36,144) = 0.0;
  groebnerMatrix(36,156) = groebnerMatrix(36,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(36,177) = groebnerMatrix(36,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(36,196) = groebnerMatrix(36,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(36,146);
  groebnerMatrix(36,146) = 0.0;
  groebnerMatrix(36,161) = groebnerMatrix(36,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(36,185) = groebnerMatrix(36,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(36,147);
  groebnerMatrix(36,147) = 0.0;
  groebnerMatrix(36,162) = groebnerMatrix(36,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(36,186) = groebnerMatrix(36,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(36,196) = groebnerMatrix(36,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(36,148);
  groebnerMatrix(36,148) = 0.0;
  groebnerMatrix(36,153) = groebnerMatrix(36,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(36,159) = groebnerMatrix(36,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(36,149);
  groebnerMatrix(36,149) = 0.0;
  groebnerMatrix(36,152) = groebnerMatrix(36,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(36,195) = groebnerMatrix(36,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(36,150);
  groebnerMatrix(36,150) = 0.0;
  groebnerMatrix(36,157) = groebnerMatrix(36,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(36,194) = groebnerMatrix(36,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(36,151);
  groebnerMatrix(36,151) = 0.0;
  groebnerMatrix(36,156) = groebnerMatrix(36,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(36,162) = groebnerMatrix(36,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(36,196) = groebnerMatrix(36,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,36);
  groebnerRow31_000000000_f(groebnerMatrix,36);
  factor = -groebnerMatrix(36,154);
  groebnerMatrix(36,154) = 0.0;
  groebnerMatrix(36,158) = groebnerMatrix(36,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(36,193) = groebnerMatrix(36,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,36);
  groebnerRow33_000000000_f(groebnerMatrix,36);
  groebnerRow34_000000000_f(groebnerMatrix,36);
  groebnerRow35_000000000_f(groebnerMatrix,36);
  factor = groebnerMatrix(36,163);
  groebnerMatrix(36,163) = 0.0;
  groebnerMatrix(36,171) = groebnerMatrix(36,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(36,180) = groebnerMatrix(36,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(36,164);
  groebnerMatrix(36,164) = 0.0;
  groebnerMatrix(36,170) = groebnerMatrix(36,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(36,192) = groebnerMatrix(36,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(36,165);
  groebnerMatrix(36,165) = 0.0;
  groebnerMatrix(36,178) = groebnerMatrix(36,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(36,191) = groebnerMatrix(36,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(36,166);
  groebnerMatrix(36,166) = 0.0;
  groebnerMatrix(36,174) = groebnerMatrix(36,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(36,183) = groebnerMatrix(36,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(36,167);
  groebnerMatrix(36,167) = 0.0;
  groebnerMatrix(36,173) = groebnerMatrix(36,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(36,189) = groebnerMatrix(36,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(36,168);
  groebnerMatrix(36,168) = 0.0;
  groebnerMatrix(36,181) = groebnerMatrix(36,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(36,188) = groebnerMatrix(36,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(36,169);
  groebnerMatrix(36,169) = 0.0;
  groebnerMatrix(36,177) = groebnerMatrix(36,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(36,186) = groebnerMatrix(36,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(36,196) = groebnerMatrix(36,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(36,172);
  groebnerMatrix(36,172) = 0.0;
  groebnerMatrix(36,179) = groebnerMatrix(36,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(36,190) = groebnerMatrix(36,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(36,175);
  groebnerMatrix(36,175) = 0.0;
  groebnerMatrix(36,182) = groebnerMatrix(36,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(36,187) = groebnerMatrix(36,187) - factor * groebnerMatrix(18,187);

  sPolynomial37(groebnerMatrix);
  factor = -groebnerMatrix(37,1);
  groebnerMatrix(37,1) = 0.0;
  groebnerMatrix(37,8) = groebnerMatrix(37,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,179) = groebnerMatrix(37,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,2);
  groebnerMatrix(37,2) = 0.0;
  groebnerMatrix(37,11) = groebnerMatrix(37,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,24) = groebnerMatrix(37,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,3);
  groebnerMatrix(37,3) = 0.0;
  groebnerMatrix(37,10) = groebnerMatrix(37,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,180) = groebnerMatrix(37,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,4);
  groebnerMatrix(37,4) = 0.0;
  groebnerMatrix(37,36) = groebnerMatrix(37,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(37,136) = groebnerMatrix(37,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(37,190) = groebnerMatrix(37,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(37,5);
  groebnerMatrix(37,5) = 0.0;
  groebnerMatrix(37,17) = groebnerMatrix(37,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(37,34) = groebnerMatrix(37,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(37,188) = groebnerMatrix(37,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(37,6);
  groebnerMatrix(37,6) = 0.0;
  groebnerMatrix(37,18) = groebnerMatrix(37,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(37,35) = groebnerMatrix(37,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(37,189) = groebnerMatrix(37,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(37,10);
  groebnerMatrix(37,10) = 0.0;
  groebnerMatrix(37,20) = groebnerMatrix(37,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,163) = groebnerMatrix(37,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(37,11);
  groebnerMatrix(37,11) = 0.0;
  groebnerMatrix(37,21) = groebnerMatrix(37,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,164) = groebnerMatrix(37,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(37,12);
  groebnerMatrix(37,12) = 0.0;
  groebnerMatrix(37,23) = groebnerMatrix(37,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,165) = groebnerMatrix(37,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(37,13);
  groebnerMatrix(37,13) = 0.0;
  groebnerMatrix(37,17) = groebnerMatrix(37,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,30) = groebnerMatrix(37,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,14);
  groebnerMatrix(37,14) = 0.0;
  groebnerMatrix(37,16) = groebnerMatrix(37,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,182) = groebnerMatrix(37,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(37,15);
  groebnerMatrix(37,15) = 0.0;
  groebnerMatrix(37,26) = groebnerMatrix(37,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,166) = groebnerMatrix(37,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(37,18);
  groebnerMatrix(37,18) = 0.0;
  groebnerMatrix(37,29) = groebnerMatrix(37,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,167) = groebnerMatrix(37,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(37,19);
  groebnerMatrix(37,19) = 0.0;
  groebnerMatrix(37,21) = groebnerMatrix(37,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(37,24) = groebnerMatrix(37,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(37,192) = groebnerMatrix(37,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(37,22);
  groebnerMatrix(37,22) = 0.0;
  groebnerMatrix(37,36) = groebnerMatrix(37,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(37,123) = groebnerMatrix(37,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(37,25);
  groebnerMatrix(37,25) = 0.0;
  groebnerMatrix(37,29) = groebnerMatrix(37,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,35) = groebnerMatrix(37,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,26);
  groebnerMatrix(37,26) = 0.0;
  groebnerMatrix(37,28) = groebnerMatrix(37,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,183) = groebnerMatrix(37,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,27);
  groebnerMatrix(37,27) = 0.0;
  groebnerMatrix(37,33) = groebnerMatrix(37,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(37,175) = groebnerMatrix(37,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(37,30);
  groebnerMatrix(37,30) = 0.0;
  groebnerMatrix(37,34) = groebnerMatrix(37,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,168) = groebnerMatrix(37,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(37,39);
  groebnerMatrix(37,39) = 0.0;
  groebnerMatrix(37,63) = groebnerMatrix(37,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,101) = groebnerMatrix(37,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,40);
  groebnerMatrix(37,40) = 0.0;
  groebnerMatrix(37,62) = groebnerMatrix(37,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,158) = groebnerMatrix(37,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(37,41);
  groebnerMatrix(37,41) = 0.0;
  groebnerMatrix(37,65) = groebnerMatrix(37,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,102) = groebnerMatrix(37,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,42);
  groebnerMatrix(37,42) = 0.0;
  groebnerMatrix(37,64) = groebnerMatrix(37,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,159) = groebnerMatrix(37,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(37,43);
  groebnerMatrix(37,43) = 0.0;
  groebnerMatrix(37,56) = groebnerMatrix(37,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(37,139) = groebnerMatrix(37,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(37,193) = groebnerMatrix(37,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(37,44);
  groebnerMatrix(37,44) = 0.0;
  groebnerMatrix(37,72) = groebnerMatrix(37,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,113) = groebnerMatrix(37,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(37,45);
  groebnerMatrix(37,45) = 0.0;
  groebnerMatrix(37,73) = groebnerMatrix(37,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,114) = groebnerMatrix(37,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(37,46);
  groebnerMatrix(37,46) = 0.0;
  groebnerMatrix(37,72) = groebnerMatrix(37,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,109) = groebnerMatrix(37,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,47);
  groebnerMatrix(37,47) = 0.0;
  groebnerMatrix(37,71) = groebnerMatrix(37,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,161) = groebnerMatrix(37,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(37,48);
  groebnerMatrix(37,48) = 0.0;
  groebnerMatrix(37,52) = groebnerMatrix(37,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,169) = groebnerMatrix(37,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(37,49);
  groebnerMatrix(37,49) = 0.0;
  groebnerMatrix(37,75) = groebnerMatrix(37,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,116) = groebnerMatrix(37,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(37,50);
  groebnerMatrix(37,50) = 0.0;
  groebnerMatrix(37,74) = groebnerMatrix(37,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(37,154) = groebnerMatrix(37,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(37,51);
  groebnerMatrix(37,51) = 0.0;
  groebnerMatrix(37,77) = groebnerMatrix(37,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,114) = groebnerMatrix(37,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,52);
  groebnerMatrix(37,52) = 0.0;
  groebnerMatrix(37,76) = groebnerMatrix(37,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,162) = groebnerMatrix(37,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(37,53);
  groebnerMatrix(37,53) = 0.0;
  groebnerMatrix(37,105) = groebnerMatrix(37,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(37,146) = groebnerMatrix(37,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(37,54);
  groebnerMatrix(37,54) = 0.0;
  groebnerMatrix(37,80) = groebnerMatrix(37,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,117) = groebnerMatrix(37,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(37,55);
  groebnerMatrix(37,55) = 0.0;
  groebnerMatrix(37,79) = groebnerMatrix(37,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(37,159) = groebnerMatrix(37,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(37,56);
  groebnerMatrix(37,56) = 0.0;
  groebnerMatrix(37,115) = groebnerMatrix(37,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(37,158) = groebnerMatrix(37,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(37,57);
  groebnerMatrix(37,57) = 0.0;
  groebnerMatrix(37,90) = groebnerMatrix(37,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(37,134) = groebnerMatrix(37,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(37,188) = groebnerMatrix(37,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(37,58);
  groebnerMatrix(37,58) = 0.0;
  groebnerMatrix(37,91) = groebnerMatrix(37,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(37,135) = groebnerMatrix(37,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(37,189) = groebnerMatrix(37,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(37,59);
  groebnerMatrix(37,59) = 0.0;
  groebnerMatrix(37,93) = groebnerMatrix(37,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(37,137) = groebnerMatrix(37,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(37,191) = groebnerMatrix(37,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(37,60);
  groebnerMatrix(37,60) = 0.0;
  groebnerMatrix(37,94) = groebnerMatrix(37,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(37,138) = groebnerMatrix(37,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(37,192) = groebnerMatrix(37,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(37,61);
  groebnerMatrix(37,61) = 0.0;
  groebnerMatrix(37,63) = groebnerMatrix(37,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(37,66) = groebnerMatrix(37,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(37,194) = groebnerMatrix(37,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(37,64);
  groebnerMatrix(37,64) = 0.0;
  groebnerMatrix(37,98) = groebnerMatrix(37,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,148) = groebnerMatrix(37,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(37,65);
  groebnerMatrix(37,65) = 0.0;
  groebnerMatrix(37,99) = groebnerMatrix(37,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,149) = groebnerMatrix(37,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(37,66);
  groebnerMatrix(37,66) = 0.0;
  groebnerMatrix(37,101) = groebnerMatrix(37,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,150) = groebnerMatrix(37,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(37,67);
  groebnerMatrix(37,67) = 0.0;
  groebnerMatrix(37,72) = groebnerMatrix(37,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,78) = groebnerMatrix(37,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,68);
  groebnerMatrix(37,68) = 0.0;
  groebnerMatrix(37,71) = groebnerMatrix(37,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,185) = groebnerMatrix(37,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,69);
  groebnerMatrix(37,69) = 0.0;
  groebnerMatrix(37,104) = groebnerMatrix(37,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,151) = groebnerMatrix(37,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(37,70);
  groebnerMatrix(37,70) = 0.0;
  groebnerMatrix(37,75) = groebnerMatrix(37,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(37,81) = groebnerMatrix(37,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(37,194) = groebnerMatrix(37,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(37,73);
  groebnerMatrix(37,73) = 0.0;
  groebnerMatrix(37,77) = groebnerMatrix(37,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,176) = groebnerMatrix(37,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(37,76);
  groebnerMatrix(37,76) = 0.0;
  groebnerMatrix(37,107) = groebnerMatrix(37,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,142) = groebnerMatrix(37,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(37,77);
  groebnerMatrix(37,77) = 0.0;
  groebnerMatrix(37,108) = groebnerMatrix(37,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,143) = groebnerMatrix(37,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(37,78);
  groebnerMatrix(37,78) = 0.0;
  groebnerMatrix(37,113) = groebnerMatrix(37,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,160) = groebnerMatrix(37,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(37,79);
  groebnerMatrix(37,79) = 0.0;
  groebnerMatrix(37,110) = groebnerMatrix(37,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,148) = groebnerMatrix(37,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(37,80);
  groebnerMatrix(37,80) = 0.0;
  groebnerMatrix(37,111) = groebnerMatrix(37,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,152) = groebnerMatrix(37,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(37,81);
  groebnerMatrix(37,81) = 0.0;
  groebnerMatrix(37,116) = groebnerMatrix(37,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,157) = groebnerMatrix(37,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(37,82);
  groebnerMatrix(37,82) = 0.0;
  groebnerMatrix(37,90) = groebnerMatrix(37,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,127) = groebnerMatrix(37,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,83);
  groebnerMatrix(37,83) = 0.0;
  groebnerMatrix(37,89) = groebnerMatrix(37,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,175) = groebnerMatrix(37,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(37,84);
  groebnerMatrix(37,84) = 0.0;
  groebnerMatrix(37,119) = groebnerMatrix(37,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,166) = groebnerMatrix(37,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(37,85);
  groebnerMatrix(37,85) = 0.0;
  groebnerMatrix(37,93) = groebnerMatrix(37,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,130) = groebnerMatrix(37,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(37,86);
  groebnerMatrix(37,86) = 0.0;
  groebnerMatrix(37,92) = groebnerMatrix(37,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(37,172) = groebnerMatrix(37,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(37,87);
  groebnerMatrix(37,87) = 0.0;
  groebnerMatrix(37,122) = groebnerMatrix(37,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,163) = groebnerMatrix(37,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(37,91);
  groebnerMatrix(37,91) = 0.0;
  groebnerMatrix(37,126) = groebnerMatrix(37,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,173) = groebnerMatrix(37,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(37,94);
  groebnerMatrix(37,94) = 0.0;
  groebnerMatrix(37,129) = groebnerMatrix(37,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,170) = groebnerMatrix(37,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(37,97);
  groebnerMatrix(37,97) = 0.0;
  groebnerMatrix(37,99) = groebnerMatrix(37,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(37,102) = groebnerMatrix(37,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(37,195) = groebnerMatrix(37,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(37,100);
  groebnerMatrix(37,100) = 0.0;
  groebnerMatrix(37,115) = groebnerMatrix(37,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(37,139) = groebnerMatrix(37,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(37,103);
  groebnerMatrix(37,103) = 0.0;
  groebnerMatrix(37,108) = groebnerMatrix(37,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,114) = groebnerMatrix(37,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,104);
  groebnerMatrix(37,104) = 0.0;
  groebnerMatrix(37,107) = groebnerMatrix(37,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,186) = groebnerMatrix(37,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,105);
  groebnerMatrix(37,105) = 0.0;
  groebnerMatrix(37,112) = groebnerMatrix(37,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(37,185) = groebnerMatrix(37,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(37,106);
  groebnerMatrix(37,106) = 0.0;
  groebnerMatrix(37,111) = groebnerMatrix(37,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(37,117) = groebnerMatrix(37,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(37,195) = groebnerMatrix(37,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(37,109);
  groebnerMatrix(37,109) = 0.0;
  groebnerMatrix(37,113) = groebnerMatrix(37,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,184) = groebnerMatrix(37,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(37,118);
  groebnerMatrix(37,118) = 0.0;
  groebnerMatrix(37,126) = groebnerMatrix(37,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,135) = groebnerMatrix(37,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,119);
  groebnerMatrix(37,119) = 0.0;
  groebnerMatrix(37,125) = groebnerMatrix(37,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,183) = groebnerMatrix(37,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(37,120);
  groebnerMatrix(37,120) = 0.0;
  groebnerMatrix(37,133) = groebnerMatrix(37,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(37,182) = groebnerMatrix(37,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(37,121);
  groebnerMatrix(37,121) = 0.0;
  groebnerMatrix(37,129) = groebnerMatrix(37,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,138) = groebnerMatrix(37,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(37,122);
  groebnerMatrix(37,122) = 0.0;
  groebnerMatrix(37,128) = groebnerMatrix(37,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(37,180) = groebnerMatrix(37,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(37,123);
  groebnerMatrix(37,123) = 0.0;
  groebnerMatrix(37,136) = groebnerMatrix(37,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(37,179) = groebnerMatrix(37,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(37,127);
  groebnerMatrix(37,127) = 0.0;
  groebnerMatrix(37,134) = groebnerMatrix(37,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,181) = groebnerMatrix(37,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(37,130);
  groebnerMatrix(37,130) = 0.0;
  groebnerMatrix(37,137) = groebnerMatrix(37,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,178) = groebnerMatrix(37,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(37,142);
  groebnerMatrix(37,142) = 0.0;
  groebnerMatrix(37,144) = groebnerMatrix(37,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(37,147) = groebnerMatrix(37,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(37,196) = groebnerMatrix(37,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(37,143);
  groebnerMatrix(37,143) = 0.0;
  groebnerMatrix(37,155) = groebnerMatrix(37,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(37,176) = groebnerMatrix(37,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(37,144);
  groebnerMatrix(37,144) = 0.0;
  groebnerMatrix(37,156) = groebnerMatrix(37,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(37,177) = groebnerMatrix(37,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(37,196) = groebnerMatrix(37,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(37,146);
  groebnerMatrix(37,146) = 0.0;
  groebnerMatrix(37,161) = groebnerMatrix(37,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(37,185) = groebnerMatrix(37,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(37,147);
  groebnerMatrix(37,147) = 0.0;
  groebnerMatrix(37,162) = groebnerMatrix(37,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(37,186) = groebnerMatrix(37,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(37,196) = groebnerMatrix(37,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(37,148);
  groebnerMatrix(37,148) = 0.0;
  groebnerMatrix(37,153) = groebnerMatrix(37,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(37,159) = groebnerMatrix(37,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(37,149);
  groebnerMatrix(37,149) = 0.0;
  groebnerMatrix(37,152) = groebnerMatrix(37,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(37,195) = groebnerMatrix(37,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(37,150);
  groebnerMatrix(37,150) = 0.0;
  groebnerMatrix(37,157) = groebnerMatrix(37,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(37,194) = groebnerMatrix(37,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(37,151);
  groebnerMatrix(37,151) = 0.0;
  groebnerMatrix(37,156) = groebnerMatrix(37,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(37,162) = groebnerMatrix(37,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(37,196) = groebnerMatrix(37,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,37);
  groebnerRow31_000000000_f(groebnerMatrix,37);
  factor = -groebnerMatrix(37,154);
  groebnerMatrix(37,154) = 0.0;
  groebnerMatrix(37,158) = groebnerMatrix(37,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(37,193) = groebnerMatrix(37,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,37);
  groebnerRow33_000000000_f(groebnerMatrix,37);
  groebnerRow34_000000000_f(groebnerMatrix,37);
  groebnerRow35_000000000_f(groebnerMatrix,37);
  groebnerRow36_000000000_f(groebnerMatrix,37);
  factor = groebnerMatrix(37,163);
  groebnerMatrix(37,163) = 0.0;
  groebnerMatrix(37,171) = groebnerMatrix(37,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(37,180) = groebnerMatrix(37,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(37,164);
  groebnerMatrix(37,164) = 0.0;
  groebnerMatrix(37,170) = groebnerMatrix(37,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(37,192) = groebnerMatrix(37,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(37,165);
  groebnerMatrix(37,165) = 0.0;
  groebnerMatrix(37,178) = groebnerMatrix(37,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(37,191) = groebnerMatrix(37,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(37,166);
  groebnerMatrix(37,166) = 0.0;
  groebnerMatrix(37,174) = groebnerMatrix(37,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(37,183) = groebnerMatrix(37,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(37,167);
  groebnerMatrix(37,167) = 0.0;
  groebnerMatrix(37,173) = groebnerMatrix(37,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(37,189) = groebnerMatrix(37,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(37,168);
  groebnerMatrix(37,168) = 0.0;
  groebnerMatrix(37,181) = groebnerMatrix(37,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(37,188) = groebnerMatrix(37,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(37,169);
  groebnerMatrix(37,169) = 0.0;
  groebnerMatrix(37,177) = groebnerMatrix(37,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(37,186) = groebnerMatrix(37,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(37,196) = groebnerMatrix(37,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(37,172);
  groebnerMatrix(37,172) = 0.0;
  groebnerMatrix(37,179) = groebnerMatrix(37,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(37,190) = groebnerMatrix(37,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(37,175);
  groebnerMatrix(37,175) = 0.0;
  groebnerMatrix(37,182) = groebnerMatrix(37,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(37,187) = groebnerMatrix(37,187) - factor * groebnerMatrix(18,187);

  sPolynomial38(groebnerMatrix);
  factor = -groebnerMatrix(38,1);
  groebnerMatrix(38,1) = 0.0;
  groebnerMatrix(38,8) = groebnerMatrix(38,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,179) = groebnerMatrix(38,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,2);
  groebnerMatrix(38,2) = 0.0;
  groebnerMatrix(38,11) = groebnerMatrix(38,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,24) = groebnerMatrix(38,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,3);
  groebnerMatrix(38,3) = 0.0;
  groebnerMatrix(38,10) = groebnerMatrix(38,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,180) = groebnerMatrix(38,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,4);
  groebnerMatrix(38,4) = 0.0;
  groebnerMatrix(38,36) = groebnerMatrix(38,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(38,136) = groebnerMatrix(38,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(38,190) = groebnerMatrix(38,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(38,5);
  groebnerMatrix(38,5) = 0.0;
  groebnerMatrix(38,17) = groebnerMatrix(38,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(38,34) = groebnerMatrix(38,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(38,188) = groebnerMatrix(38,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(38,6);
  groebnerMatrix(38,6) = 0.0;
  groebnerMatrix(38,18) = groebnerMatrix(38,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(38,35) = groebnerMatrix(38,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(38,189) = groebnerMatrix(38,189) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(38,10);
  groebnerMatrix(38,10) = 0.0;
  groebnerMatrix(38,20) = groebnerMatrix(38,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,163) = groebnerMatrix(38,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(38,11);
  groebnerMatrix(38,11) = 0.0;
  groebnerMatrix(38,21) = groebnerMatrix(38,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,164) = groebnerMatrix(38,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(38,12);
  groebnerMatrix(38,12) = 0.0;
  groebnerMatrix(38,23) = groebnerMatrix(38,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,165) = groebnerMatrix(38,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(38,13);
  groebnerMatrix(38,13) = 0.0;
  groebnerMatrix(38,17) = groebnerMatrix(38,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,30) = groebnerMatrix(38,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,14);
  groebnerMatrix(38,14) = 0.0;
  groebnerMatrix(38,16) = groebnerMatrix(38,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,182) = groebnerMatrix(38,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(38,15);
  groebnerMatrix(38,15) = 0.0;
  groebnerMatrix(38,26) = groebnerMatrix(38,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,166) = groebnerMatrix(38,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(38,18);
  groebnerMatrix(38,18) = 0.0;
  groebnerMatrix(38,29) = groebnerMatrix(38,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,167) = groebnerMatrix(38,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(38,19);
  groebnerMatrix(38,19) = 0.0;
  groebnerMatrix(38,21) = groebnerMatrix(38,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(38,24) = groebnerMatrix(38,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(38,192) = groebnerMatrix(38,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(38,22);
  groebnerMatrix(38,22) = 0.0;
  groebnerMatrix(38,36) = groebnerMatrix(38,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(38,123) = groebnerMatrix(38,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(38,25);
  groebnerMatrix(38,25) = 0.0;
  groebnerMatrix(38,29) = groebnerMatrix(38,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,35) = groebnerMatrix(38,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,26);
  groebnerMatrix(38,26) = 0.0;
  groebnerMatrix(38,28) = groebnerMatrix(38,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,183) = groebnerMatrix(38,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,27);
  groebnerMatrix(38,27) = 0.0;
  groebnerMatrix(38,33) = groebnerMatrix(38,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(38,175) = groebnerMatrix(38,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(38,30);
  groebnerMatrix(38,30) = 0.0;
  groebnerMatrix(38,34) = groebnerMatrix(38,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,168) = groebnerMatrix(38,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(38,39);
  groebnerMatrix(38,39) = 0.0;
  groebnerMatrix(38,63) = groebnerMatrix(38,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,101) = groebnerMatrix(38,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,40);
  groebnerMatrix(38,40) = 0.0;
  groebnerMatrix(38,62) = groebnerMatrix(38,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,158) = groebnerMatrix(38,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(38,41);
  groebnerMatrix(38,41) = 0.0;
  groebnerMatrix(38,65) = groebnerMatrix(38,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,102) = groebnerMatrix(38,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,42);
  groebnerMatrix(38,42) = 0.0;
  groebnerMatrix(38,64) = groebnerMatrix(38,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,159) = groebnerMatrix(38,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(38,43);
  groebnerMatrix(38,43) = 0.0;
  groebnerMatrix(38,56) = groebnerMatrix(38,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(38,139) = groebnerMatrix(38,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(38,193) = groebnerMatrix(38,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(38,44);
  groebnerMatrix(38,44) = 0.0;
  groebnerMatrix(38,72) = groebnerMatrix(38,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,113) = groebnerMatrix(38,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(38,45);
  groebnerMatrix(38,45) = 0.0;
  groebnerMatrix(38,73) = groebnerMatrix(38,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,114) = groebnerMatrix(38,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(38,46);
  groebnerMatrix(38,46) = 0.0;
  groebnerMatrix(38,72) = groebnerMatrix(38,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,109) = groebnerMatrix(38,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,47);
  groebnerMatrix(38,47) = 0.0;
  groebnerMatrix(38,71) = groebnerMatrix(38,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,161) = groebnerMatrix(38,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(38,48);
  groebnerMatrix(38,48) = 0.0;
  groebnerMatrix(38,52) = groebnerMatrix(38,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,169) = groebnerMatrix(38,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(38,49);
  groebnerMatrix(38,49) = 0.0;
  groebnerMatrix(38,75) = groebnerMatrix(38,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,116) = groebnerMatrix(38,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(38,50);
  groebnerMatrix(38,50) = 0.0;
  groebnerMatrix(38,74) = groebnerMatrix(38,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(38,154) = groebnerMatrix(38,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(38,51);
  groebnerMatrix(38,51) = 0.0;
  groebnerMatrix(38,77) = groebnerMatrix(38,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,114) = groebnerMatrix(38,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,52);
  groebnerMatrix(38,52) = 0.0;
  groebnerMatrix(38,76) = groebnerMatrix(38,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,162) = groebnerMatrix(38,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(38,53);
  groebnerMatrix(38,53) = 0.0;
  groebnerMatrix(38,105) = groebnerMatrix(38,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(38,146) = groebnerMatrix(38,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(38,54);
  groebnerMatrix(38,54) = 0.0;
  groebnerMatrix(38,80) = groebnerMatrix(38,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,117) = groebnerMatrix(38,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(38,55);
  groebnerMatrix(38,55) = 0.0;
  groebnerMatrix(38,79) = groebnerMatrix(38,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(38,159) = groebnerMatrix(38,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(38,56);
  groebnerMatrix(38,56) = 0.0;
  groebnerMatrix(38,115) = groebnerMatrix(38,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(38,158) = groebnerMatrix(38,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(38,57);
  groebnerMatrix(38,57) = 0.0;
  groebnerMatrix(38,90) = groebnerMatrix(38,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(38,134) = groebnerMatrix(38,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(38,188) = groebnerMatrix(38,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(38,58);
  groebnerMatrix(38,58) = 0.0;
  groebnerMatrix(38,91) = groebnerMatrix(38,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(38,135) = groebnerMatrix(38,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(38,189) = groebnerMatrix(38,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(38,59);
  groebnerMatrix(38,59) = 0.0;
  groebnerMatrix(38,93) = groebnerMatrix(38,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(38,137) = groebnerMatrix(38,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(38,191) = groebnerMatrix(38,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(38,60);
  groebnerMatrix(38,60) = 0.0;
  groebnerMatrix(38,94) = groebnerMatrix(38,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(38,138) = groebnerMatrix(38,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(38,192) = groebnerMatrix(38,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(38,61);
  groebnerMatrix(38,61) = 0.0;
  groebnerMatrix(38,63) = groebnerMatrix(38,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(38,66) = groebnerMatrix(38,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(38,194) = groebnerMatrix(38,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(38,64);
  groebnerMatrix(38,64) = 0.0;
  groebnerMatrix(38,98) = groebnerMatrix(38,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,148) = groebnerMatrix(38,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(38,65);
  groebnerMatrix(38,65) = 0.0;
  groebnerMatrix(38,99) = groebnerMatrix(38,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,149) = groebnerMatrix(38,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(38,66);
  groebnerMatrix(38,66) = 0.0;
  groebnerMatrix(38,101) = groebnerMatrix(38,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,150) = groebnerMatrix(38,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(38,67);
  groebnerMatrix(38,67) = 0.0;
  groebnerMatrix(38,72) = groebnerMatrix(38,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,78) = groebnerMatrix(38,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,68);
  groebnerMatrix(38,68) = 0.0;
  groebnerMatrix(38,71) = groebnerMatrix(38,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,185) = groebnerMatrix(38,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,69);
  groebnerMatrix(38,69) = 0.0;
  groebnerMatrix(38,104) = groebnerMatrix(38,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,151) = groebnerMatrix(38,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(38,70);
  groebnerMatrix(38,70) = 0.0;
  groebnerMatrix(38,75) = groebnerMatrix(38,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(38,81) = groebnerMatrix(38,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(38,194) = groebnerMatrix(38,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(38,73);
  groebnerMatrix(38,73) = 0.0;
  groebnerMatrix(38,77) = groebnerMatrix(38,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,176) = groebnerMatrix(38,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(38,76);
  groebnerMatrix(38,76) = 0.0;
  groebnerMatrix(38,107) = groebnerMatrix(38,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,142) = groebnerMatrix(38,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(38,77);
  groebnerMatrix(38,77) = 0.0;
  groebnerMatrix(38,108) = groebnerMatrix(38,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,143) = groebnerMatrix(38,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(38,78);
  groebnerMatrix(38,78) = 0.0;
  groebnerMatrix(38,113) = groebnerMatrix(38,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,160) = groebnerMatrix(38,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(38,79);
  groebnerMatrix(38,79) = 0.0;
  groebnerMatrix(38,110) = groebnerMatrix(38,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,148) = groebnerMatrix(38,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(38,80);
  groebnerMatrix(38,80) = 0.0;
  groebnerMatrix(38,111) = groebnerMatrix(38,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,152) = groebnerMatrix(38,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(38,81);
  groebnerMatrix(38,81) = 0.0;
  groebnerMatrix(38,116) = groebnerMatrix(38,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,157) = groebnerMatrix(38,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(38,82);
  groebnerMatrix(38,82) = 0.0;
  groebnerMatrix(38,90) = groebnerMatrix(38,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,127) = groebnerMatrix(38,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,83);
  groebnerMatrix(38,83) = 0.0;
  groebnerMatrix(38,89) = groebnerMatrix(38,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,175) = groebnerMatrix(38,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(38,84);
  groebnerMatrix(38,84) = 0.0;
  groebnerMatrix(38,119) = groebnerMatrix(38,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,166) = groebnerMatrix(38,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(38,85);
  groebnerMatrix(38,85) = 0.0;
  groebnerMatrix(38,93) = groebnerMatrix(38,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,130) = groebnerMatrix(38,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(38,86);
  groebnerMatrix(38,86) = 0.0;
  groebnerMatrix(38,92) = groebnerMatrix(38,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(38,172) = groebnerMatrix(38,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(38,87);
  groebnerMatrix(38,87) = 0.0;
  groebnerMatrix(38,122) = groebnerMatrix(38,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,163) = groebnerMatrix(38,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(38,91);
  groebnerMatrix(38,91) = 0.0;
  groebnerMatrix(38,126) = groebnerMatrix(38,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,173) = groebnerMatrix(38,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(38,94);
  groebnerMatrix(38,94) = 0.0;
  groebnerMatrix(38,129) = groebnerMatrix(38,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,170) = groebnerMatrix(38,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(38,97);
  groebnerMatrix(38,97) = 0.0;
  groebnerMatrix(38,99) = groebnerMatrix(38,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(38,102) = groebnerMatrix(38,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(38,195) = groebnerMatrix(38,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(38,100);
  groebnerMatrix(38,100) = 0.0;
  groebnerMatrix(38,115) = groebnerMatrix(38,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(38,139) = groebnerMatrix(38,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(38,103);
  groebnerMatrix(38,103) = 0.0;
  groebnerMatrix(38,108) = groebnerMatrix(38,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,114) = groebnerMatrix(38,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,104);
  groebnerMatrix(38,104) = 0.0;
  groebnerMatrix(38,107) = groebnerMatrix(38,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,186) = groebnerMatrix(38,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,105);
  groebnerMatrix(38,105) = 0.0;
  groebnerMatrix(38,112) = groebnerMatrix(38,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(38,185) = groebnerMatrix(38,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(38,106);
  groebnerMatrix(38,106) = 0.0;
  groebnerMatrix(38,111) = groebnerMatrix(38,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(38,117) = groebnerMatrix(38,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(38,195) = groebnerMatrix(38,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(38,109);
  groebnerMatrix(38,109) = 0.0;
  groebnerMatrix(38,113) = groebnerMatrix(38,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,184) = groebnerMatrix(38,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(38,118);
  groebnerMatrix(38,118) = 0.0;
  groebnerMatrix(38,126) = groebnerMatrix(38,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,135) = groebnerMatrix(38,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,119);
  groebnerMatrix(38,119) = 0.0;
  groebnerMatrix(38,125) = groebnerMatrix(38,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,183) = groebnerMatrix(38,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(38,120);
  groebnerMatrix(38,120) = 0.0;
  groebnerMatrix(38,133) = groebnerMatrix(38,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(38,182) = groebnerMatrix(38,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(38,121);
  groebnerMatrix(38,121) = 0.0;
  groebnerMatrix(38,129) = groebnerMatrix(38,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,138) = groebnerMatrix(38,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(38,122);
  groebnerMatrix(38,122) = 0.0;
  groebnerMatrix(38,128) = groebnerMatrix(38,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(38,180) = groebnerMatrix(38,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(38,123);
  groebnerMatrix(38,123) = 0.0;
  groebnerMatrix(38,136) = groebnerMatrix(38,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(38,179) = groebnerMatrix(38,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(38,127);
  groebnerMatrix(38,127) = 0.0;
  groebnerMatrix(38,134) = groebnerMatrix(38,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,181) = groebnerMatrix(38,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(38,130);
  groebnerMatrix(38,130) = 0.0;
  groebnerMatrix(38,137) = groebnerMatrix(38,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,178) = groebnerMatrix(38,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(38,142);
  groebnerMatrix(38,142) = 0.0;
  groebnerMatrix(38,144) = groebnerMatrix(38,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(38,147) = groebnerMatrix(38,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(38,196) = groebnerMatrix(38,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(38,143);
  groebnerMatrix(38,143) = 0.0;
  groebnerMatrix(38,155) = groebnerMatrix(38,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(38,176) = groebnerMatrix(38,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(38,144);
  groebnerMatrix(38,144) = 0.0;
  groebnerMatrix(38,156) = groebnerMatrix(38,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(38,177) = groebnerMatrix(38,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(38,196) = groebnerMatrix(38,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(38,146);
  groebnerMatrix(38,146) = 0.0;
  groebnerMatrix(38,161) = groebnerMatrix(38,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(38,185) = groebnerMatrix(38,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(38,147);
  groebnerMatrix(38,147) = 0.0;
  groebnerMatrix(38,162) = groebnerMatrix(38,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(38,186) = groebnerMatrix(38,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(38,196) = groebnerMatrix(38,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(38,148);
  groebnerMatrix(38,148) = 0.0;
  groebnerMatrix(38,153) = groebnerMatrix(38,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(38,159) = groebnerMatrix(38,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(38,149);
  groebnerMatrix(38,149) = 0.0;
  groebnerMatrix(38,152) = groebnerMatrix(38,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(38,195) = groebnerMatrix(38,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(38,150);
  groebnerMatrix(38,150) = 0.0;
  groebnerMatrix(38,157) = groebnerMatrix(38,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(38,194) = groebnerMatrix(38,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(38,151);
  groebnerMatrix(38,151) = 0.0;
  groebnerMatrix(38,156) = groebnerMatrix(38,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(38,162) = groebnerMatrix(38,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(38,196) = groebnerMatrix(38,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,38);
  groebnerRow31_000000000_f(groebnerMatrix,38);
  factor = -groebnerMatrix(38,154);
  groebnerMatrix(38,154) = 0.0;
  groebnerMatrix(38,158) = groebnerMatrix(38,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(38,193) = groebnerMatrix(38,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,38);
  groebnerRow33_000000000_f(groebnerMatrix,38);
  groebnerRow34_000000000_f(groebnerMatrix,38);
  groebnerRow35_000000000_f(groebnerMatrix,38);
  groebnerRow36_000000000_f(groebnerMatrix,38);
  groebnerRow37_000000000_f(groebnerMatrix,38);
  factor = groebnerMatrix(38,163);
  groebnerMatrix(38,163) = 0.0;
  groebnerMatrix(38,171) = groebnerMatrix(38,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(38,180) = groebnerMatrix(38,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(38,164);
  groebnerMatrix(38,164) = 0.0;
  groebnerMatrix(38,170) = groebnerMatrix(38,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(38,192) = groebnerMatrix(38,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(38,165);
  groebnerMatrix(38,165) = 0.0;
  groebnerMatrix(38,178) = groebnerMatrix(38,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(38,191) = groebnerMatrix(38,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(38,166);
  groebnerMatrix(38,166) = 0.0;
  groebnerMatrix(38,174) = groebnerMatrix(38,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(38,183) = groebnerMatrix(38,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(38,167);
  groebnerMatrix(38,167) = 0.0;
  groebnerMatrix(38,173) = groebnerMatrix(38,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(38,189) = groebnerMatrix(38,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(38,168);
  groebnerMatrix(38,168) = 0.0;
  groebnerMatrix(38,181) = groebnerMatrix(38,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(38,188) = groebnerMatrix(38,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(38,169);
  groebnerMatrix(38,169) = 0.0;
  groebnerMatrix(38,177) = groebnerMatrix(38,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(38,186) = groebnerMatrix(38,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(38,196) = groebnerMatrix(38,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(38,172);
  groebnerMatrix(38,172) = 0.0;
  groebnerMatrix(38,179) = groebnerMatrix(38,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(38,190) = groebnerMatrix(38,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(38,175);
  groebnerMatrix(38,175) = 0.0;
  groebnerMatrix(38,182) = groebnerMatrix(38,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(38,187) = groebnerMatrix(38,187) - factor * groebnerMatrix(18,187);

  sPolynomial39(groebnerMatrix);
  factor = -groebnerMatrix(39,1);
  groebnerMatrix(39,1) = 0.0;
  groebnerMatrix(39,8) = groebnerMatrix(39,8) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,179) = groebnerMatrix(39,179) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,2);
  groebnerMatrix(39,2) = 0.0;
  groebnerMatrix(39,11) = groebnerMatrix(39,11) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,24) = groebnerMatrix(39,24) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,3);
  groebnerMatrix(39,3) = 0.0;
  groebnerMatrix(39,10) = groebnerMatrix(39,10) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,180) = groebnerMatrix(39,180) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,4);
  groebnerMatrix(39,4) = 0.0;
  groebnerMatrix(39,36) = groebnerMatrix(39,36) - factor * groebnerMatrix(22,162);
  groebnerMatrix(39,136) = groebnerMatrix(39,136) - factor * groebnerMatrix(22,186);
  groebnerMatrix(39,190) = groebnerMatrix(39,190) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(39,5);
  groebnerMatrix(39,5) = 0.0;
  groebnerMatrix(39,17) = groebnerMatrix(39,17) - factor * groebnerMatrix(13,156);
  groebnerMatrix(39,34) = groebnerMatrix(39,34) - factor * groebnerMatrix(13,162);
  groebnerMatrix(39,188) = groebnerMatrix(39,188) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(39,6);
  groebnerMatrix(39,6) = 0.0;
  groebnerMatrix(39,18) = groebnerMatrix(39,18) - factor * groebnerMatrix(13,156);
  groebnerMatrix(39,35) = groebnerMatrix(39,35) - factor * groebnerMatrix(13,162);
  groebnerMatrix(39,189) = groebnerMatrix(39,189) - factor * groebnerMatrix(13,196);
  factor = groebnerMatrix(39,7);
  groebnerMatrix(39,7) = 0.0;
  groebnerMatrix(39,9) = groebnerMatrix(39,9) - factor * groebnerMatrix(15,144);
  groebnerMatrix(39,12) = groebnerMatrix(39,12) - factor * groebnerMatrix(15,147);
  groebnerMatrix(39,191) = groebnerMatrix(39,191) - factor * groebnerMatrix(15,196);
  factor = -groebnerMatrix(39,10);
  groebnerMatrix(39,10) = 0.0;
  groebnerMatrix(39,20) = groebnerMatrix(39,20) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,163) = groebnerMatrix(39,163) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(39,11);
  groebnerMatrix(39,11) = 0.0;
  groebnerMatrix(39,21) = groebnerMatrix(39,21) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,164) = groebnerMatrix(39,164) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(39,12);
  groebnerMatrix(39,12) = 0.0;
  groebnerMatrix(39,23) = groebnerMatrix(39,23) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,165) = groebnerMatrix(39,165) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(39,13);
  groebnerMatrix(39,13) = 0.0;
  groebnerMatrix(39,17) = groebnerMatrix(39,17) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,30) = groebnerMatrix(39,30) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,14);
  groebnerMatrix(39,14) = 0.0;
  groebnerMatrix(39,16) = groebnerMatrix(39,16) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,182) = groebnerMatrix(39,182) - factor * groebnerMatrix(19,195);
  factor = -groebnerMatrix(39,15);
  groebnerMatrix(39,15) = 0.0;
  groebnerMatrix(39,26) = groebnerMatrix(39,26) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,166) = groebnerMatrix(39,166) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(39,18);
  groebnerMatrix(39,18) = 0.0;
  groebnerMatrix(39,29) = groebnerMatrix(39,29) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,167) = groebnerMatrix(39,167) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(39,19);
  groebnerMatrix(39,19) = 0.0;
  groebnerMatrix(39,21) = groebnerMatrix(39,21) - factor * groebnerMatrix(15,144);
  groebnerMatrix(39,24) = groebnerMatrix(39,24) - factor * groebnerMatrix(15,147);
  groebnerMatrix(39,192) = groebnerMatrix(39,192) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(39,22);
  groebnerMatrix(39,22) = 0.0;
  groebnerMatrix(39,36) = groebnerMatrix(39,36) - factor * groebnerMatrix(24,160);
  groebnerMatrix(39,123) = groebnerMatrix(39,123) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(39,25);
  groebnerMatrix(39,25) = 0.0;
  groebnerMatrix(39,29) = groebnerMatrix(39,29) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,35) = groebnerMatrix(39,35) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,26);
  groebnerMatrix(39,26) = 0.0;
  groebnerMatrix(39,28) = groebnerMatrix(39,28) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,183) = groebnerMatrix(39,183) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,27);
  groebnerMatrix(39,27) = 0.0;
  groebnerMatrix(39,33) = groebnerMatrix(39,33) - factor * groebnerMatrix(28,157);
  groebnerMatrix(39,175) = groebnerMatrix(39,175) - factor * groebnerMatrix(28,194);
  factor = -groebnerMatrix(39,30);
  groebnerMatrix(39,30) = 0.0;
  groebnerMatrix(39,34) = groebnerMatrix(39,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,168) = groebnerMatrix(39,168) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(39,39);
  groebnerMatrix(39,39) = 0.0;
  groebnerMatrix(39,63) = groebnerMatrix(39,63) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,101) = groebnerMatrix(39,101) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,40);
  groebnerMatrix(39,40) = 0.0;
  groebnerMatrix(39,62) = groebnerMatrix(39,62) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,158) = groebnerMatrix(39,158) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(39,41);
  groebnerMatrix(39,41) = 0.0;
  groebnerMatrix(39,65) = groebnerMatrix(39,65) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,102) = groebnerMatrix(39,102) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,42);
  groebnerMatrix(39,42) = 0.0;
  groebnerMatrix(39,64) = groebnerMatrix(39,64) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,159) = groebnerMatrix(39,159) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(39,43);
  groebnerMatrix(39,43) = 0.0;
  groebnerMatrix(39,56) = groebnerMatrix(39,56) - factor * groebnerMatrix(22,162);
  groebnerMatrix(39,139) = groebnerMatrix(39,139) - factor * groebnerMatrix(22,186);
  groebnerMatrix(39,193) = groebnerMatrix(39,193) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(39,44);
  groebnerMatrix(39,44) = 0.0;
  groebnerMatrix(39,72) = groebnerMatrix(39,72) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,113) = groebnerMatrix(39,113) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(39,45);
  groebnerMatrix(39,45) = 0.0;
  groebnerMatrix(39,73) = groebnerMatrix(39,73) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,114) = groebnerMatrix(39,114) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(39,46);
  groebnerMatrix(39,46) = 0.0;
  groebnerMatrix(39,72) = groebnerMatrix(39,72) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,109) = groebnerMatrix(39,109) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,47);
  groebnerMatrix(39,47) = 0.0;
  groebnerMatrix(39,71) = groebnerMatrix(39,71) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,161) = groebnerMatrix(39,161) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(39,48);
  groebnerMatrix(39,48) = 0.0;
  groebnerMatrix(39,52) = groebnerMatrix(39,52) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,169) = groebnerMatrix(39,169) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(39,49);
  groebnerMatrix(39,49) = 0.0;
  groebnerMatrix(39,75) = groebnerMatrix(39,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,116) = groebnerMatrix(39,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(39,50);
  groebnerMatrix(39,50) = 0.0;
  groebnerMatrix(39,74) = groebnerMatrix(39,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(39,154) = groebnerMatrix(39,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(39,51);
  groebnerMatrix(39,51) = 0.0;
  groebnerMatrix(39,77) = groebnerMatrix(39,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,114) = groebnerMatrix(39,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,52);
  groebnerMatrix(39,52) = 0.0;
  groebnerMatrix(39,76) = groebnerMatrix(39,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,162) = groebnerMatrix(39,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(39,53);
  groebnerMatrix(39,53) = 0.0;
  groebnerMatrix(39,105) = groebnerMatrix(39,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(39,146) = groebnerMatrix(39,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(39,54);
  groebnerMatrix(39,54) = 0.0;
  groebnerMatrix(39,80) = groebnerMatrix(39,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,117) = groebnerMatrix(39,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(39,55);
  groebnerMatrix(39,55) = 0.0;
  groebnerMatrix(39,79) = groebnerMatrix(39,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(39,159) = groebnerMatrix(39,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(39,56);
  groebnerMatrix(39,56) = 0.0;
  groebnerMatrix(39,115) = groebnerMatrix(39,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(39,158) = groebnerMatrix(39,158) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(39,57);
  groebnerMatrix(39,57) = 0.0;
  groebnerMatrix(39,90) = groebnerMatrix(39,90) - factor * groebnerMatrix(10,177);
  groebnerMatrix(39,134) = groebnerMatrix(39,134) - factor * groebnerMatrix(10,186);
  groebnerMatrix(39,188) = groebnerMatrix(39,188) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(39,58);
  groebnerMatrix(39,58) = 0.0;
  groebnerMatrix(39,91) = groebnerMatrix(39,91) - factor * groebnerMatrix(10,177);
  groebnerMatrix(39,135) = groebnerMatrix(39,135) - factor * groebnerMatrix(10,186);
  groebnerMatrix(39,189) = groebnerMatrix(39,189) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(39,59);
  groebnerMatrix(39,59) = 0.0;
  groebnerMatrix(39,93) = groebnerMatrix(39,93) - factor * groebnerMatrix(10,177);
  groebnerMatrix(39,137) = groebnerMatrix(39,137) - factor * groebnerMatrix(10,186);
  groebnerMatrix(39,191) = groebnerMatrix(39,191) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(39,60);
  groebnerMatrix(39,60) = 0.0;
  groebnerMatrix(39,94) = groebnerMatrix(39,94) - factor * groebnerMatrix(10,177);
  groebnerMatrix(39,138) = groebnerMatrix(39,138) - factor * groebnerMatrix(10,186);
  groebnerMatrix(39,192) = groebnerMatrix(39,192) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(39,61);
  groebnerMatrix(39,61) = 0.0;
  groebnerMatrix(39,63) = groebnerMatrix(39,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(39,66) = groebnerMatrix(39,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(39,194) = groebnerMatrix(39,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(39,64);
  groebnerMatrix(39,64) = 0.0;
  groebnerMatrix(39,98) = groebnerMatrix(39,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,148) = groebnerMatrix(39,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(39,65);
  groebnerMatrix(39,65) = 0.0;
  groebnerMatrix(39,99) = groebnerMatrix(39,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,149) = groebnerMatrix(39,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(39,66);
  groebnerMatrix(39,66) = 0.0;
  groebnerMatrix(39,101) = groebnerMatrix(39,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,150) = groebnerMatrix(39,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(39,67);
  groebnerMatrix(39,67) = 0.0;
  groebnerMatrix(39,72) = groebnerMatrix(39,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,78) = groebnerMatrix(39,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,68);
  groebnerMatrix(39,68) = 0.0;
  groebnerMatrix(39,71) = groebnerMatrix(39,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,185) = groebnerMatrix(39,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,69);
  groebnerMatrix(39,69) = 0.0;
  groebnerMatrix(39,104) = groebnerMatrix(39,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,151) = groebnerMatrix(39,151) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(39,70);
  groebnerMatrix(39,70) = 0.0;
  groebnerMatrix(39,75) = groebnerMatrix(39,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(39,81) = groebnerMatrix(39,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(39,194) = groebnerMatrix(39,194) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(39,73);
  groebnerMatrix(39,73) = 0.0;
  groebnerMatrix(39,77) = groebnerMatrix(39,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,176) = groebnerMatrix(39,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(39,76);
  groebnerMatrix(39,76) = 0.0;
  groebnerMatrix(39,107) = groebnerMatrix(39,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,142) = groebnerMatrix(39,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(39,77);
  groebnerMatrix(39,77) = 0.0;
  groebnerMatrix(39,108) = groebnerMatrix(39,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,143) = groebnerMatrix(39,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(39,78);
  groebnerMatrix(39,78) = 0.0;
  groebnerMatrix(39,113) = groebnerMatrix(39,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,160) = groebnerMatrix(39,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(39,79);
  groebnerMatrix(39,79) = 0.0;
  groebnerMatrix(39,110) = groebnerMatrix(39,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,148) = groebnerMatrix(39,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(39,80);
  groebnerMatrix(39,80) = 0.0;
  groebnerMatrix(39,111) = groebnerMatrix(39,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,152) = groebnerMatrix(39,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(39,81);
  groebnerMatrix(39,81) = 0.0;
  groebnerMatrix(39,116) = groebnerMatrix(39,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,157) = groebnerMatrix(39,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(39,82);
  groebnerMatrix(39,82) = 0.0;
  groebnerMatrix(39,90) = groebnerMatrix(39,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,127) = groebnerMatrix(39,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,83);
  groebnerMatrix(39,83) = 0.0;
  groebnerMatrix(39,89) = groebnerMatrix(39,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,175) = groebnerMatrix(39,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(39,84);
  groebnerMatrix(39,84) = 0.0;
  groebnerMatrix(39,119) = groebnerMatrix(39,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,166) = groebnerMatrix(39,166) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(39,85);
  groebnerMatrix(39,85) = 0.0;
  groebnerMatrix(39,93) = groebnerMatrix(39,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,130) = groebnerMatrix(39,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(39,86);
  groebnerMatrix(39,86) = 0.0;
  groebnerMatrix(39,92) = groebnerMatrix(39,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(39,172) = groebnerMatrix(39,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(39,87);
  groebnerMatrix(39,87) = 0.0;
  groebnerMatrix(39,122) = groebnerMatrix(39,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,163) = groebnerMatrix(39,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(39,91);
  groebnerMatrix(39,91) = 0.0;
  groebnerMatrix(39,126) = groebnerMatrix(39,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,173) = groebnerMatrix(39,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(39,94);
  groebnerMatrix(39,94) = 0.0;
  groebnerMatrix(39,129) = groebnerMatrix(39,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,170) = groebnerMatrix(39,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(39,97);
  groebnerMatrix(39,97) = 0.0;
  groebnerMatrix(39,99) = groebnerMatrix(39,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(39,102) = groebnerMatrix(39,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(39,195) = groebnerMatrix(39,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(39,100);
  groebnerMatrix(39,100) = 0.0;
  groebnerMatrix(39,115) = groebnerMatrix(39,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(39,139) = groebnerMatrix(39,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(39,103);
  groebnerMatrix(39,103) = 0.0;
  groebnerMatrix(39,108) = groebnerMatrix(39,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,114) = groebnerMatrix(39,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,104);
  groebnerMatrix(39,104) = 0.0;
  groebnerMatrix(39,107) = groebnerMatrix(39,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,186) = groebnerMatrix(39,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,105);
  groebnerMatrix(39,105) = 0.0;
  groebnerMatrix(39,112) = groebnerMatrix(39,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(39,185) = groebnerMatrix(39,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(39,106);
  groebnerMatrix(39,106) = 0.0;
  groebnerMatrix(39,111) = groebnerMatrix(39,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(39,117) = groebnerMatrix(39,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(39,195) = groebnerMatrix(39,195) - factor * groebnerMatrix(13,196);
  factor = -groebnerMatrix(39,109);
  groebnerMatrix(39,109) = 0.0;
  groebnerMatrix(39,113) = groebnerMatrix(39,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,184) = groebnerMatrix(39,184) - factor * groebnerMatrix(16,193);
  factor = groebnerMatrix(39,118);
  groebnerMatrix(39,118) = 0.0;
  groebnerMatrix(39,126) = groebnerMatrix(39,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,135) = groebnerMatrix(39,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,119);
  groebnerMatrix(39,119) = 0.0;
  groebnerMatrix(39,125) = groebnerMatrix(39,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,183) = groebnerMatrix(39,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(39,120);
  groebnerMatrix(39,120) = 0.0;
  groebnerMatrix(39,133) = groebnerMatrix(39,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(39,182) = groebnerMatrix(39,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(39,121);
  groebnerMatrix(39,121) = 0.0;
  groebnerMatrix(39,129) = groebnerMatrix(39,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,138) = groebnerMatrix(39,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(39,122);
  groebnerMatrix(39,122) = 0.0;
  groebnerMatrix(39,128) = groebnerMatrix(39,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(39,180) = groebnerMatrix(39,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(39,123);
  groebnerMatrix(39,123) = 0.0;
  groebnerMatrix(39,136) = groebnerMatrix(39,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(39,179) = groebnerMatrix(39,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(39,127);
  groebnerMatrix(39,127) = 0.0;
  groebnerMatrix(39,134) = groebnerMatrix(39,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,181) = groebnerMatrix(39,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(39,130);
  groebnerMatrix(39,130) = 0.0;
  groebnerMatrix(39,137) = groebnerMatrix(39,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,178) = groebnerMatrix(39,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(39,142);
  groebnerMatrix(39,142) = 0.0;
  groebnerMatrix(39,144) = groebnerMatrix(39,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(39,147) = groebnerMatrix(39,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(39,196) = groebnerMatrix(39,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(39,143);
  groebnerMatrix(39,143) = 0.0;
  groebnerMatrix(39,155) = groebnerMatrix(39,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(39,176) = groebnerMatrix(39,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(39,144);
  groebnerMatrix(39,144) = 0.0;
  groebnerMatrix(39,156) = groebnerMatrix(39,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(39,177) = groebnerMatrix(39,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(39,196) = groebnerMatrix(39,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(39,146);
  groebnerMatrix(39,146) = 0.0;
  groebnerMatrix(39,161) = groebnerMatrix(39,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(39,185) = groebnerMatrix(39,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(39,147);
  groebnerMatrix(39,147) = 0.0;
  groebnerMatrix(39,162) = groebnerMatrix(39,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(39,186) = groebnerMatrix(39,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(39,196) = groebnerMatrix(39,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(39,148);
  groebnerMatrix(39,148) = 0.0;
  groebnerMatrix(39,153) = groebnerMatrix(39,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(39,159) = groebnerMatrix(39,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(39,149);
  groebnerMatrix(39,149) = 0.0;
  groebnerMatrix(39,152) = groebnerMatrix(39,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(39,195) = groebnerMatrix(39,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(39,150);
  groebnerMatrix(39,150) = 0.0;
  groebnerMatrix(39,157) = groebnerMatrix(39,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(39,194) = groebnerMatrix(39,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(39,151);
  groebnerMatrix(39,151) = 0.0;
  groebnerMatrix(39,156) = groebnerMatrix(39,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(39,162) = groebnerMatrix(39,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(39,196) = groebnerMatrix(39,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,39);
  groebnerRow31_000000000_f(groebnerMatrix,39);
  factor = -groebnerMatrix(39,154);
  groebnerMatrix(39,154) = 0.0;
  groebnerMatrix(39,158) = groebnerMatrix(39,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(39,193) = groebnerMatrix(39,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,39);
  groebnerRow33_000000000_f(groebnerMatrix,39);
  groebnerRow34_000000000_f(groebnerMatrix,39);
  groebnerRow35_000000000_f(groebnerMatrix,39);
  groebnerRow36_000000000_f(groebnerMatrix,39);
  groebnerRow37_000000000_f(groebnerMatrix,39);
  groebnerRow38_000000000_f(groebnerMatrix,39);
  factor = groebnerMatrix(39,163);
  groebnerMatrix(39,163) = 0.0;
  groebnerMatrix(39,171) = groebnerMatrix(39,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(39,180) = groebnerMatrix(39,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(39,164);
  groebnerMatrix(39,164) = 0.0;
  groebnerMatrix(39,170) = groebnerMatrix(39,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(39,192) = groebnerMatrix(39,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(39,165);
  groebnerMatrix(39,165) = 0.0;
  groebnerMatrix(39,178) = groebnerMatrix(39,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(39,191) = groebnerMatrix(39,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(39,166);
  groebnerMatrix(39,166) = 0.0;
  groebnerMatrix(39,174) = groebnerMatrix(39,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(39,183) = groebnerMatrix(39,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(39,167);
  groebnerMatrix(39,167) = 0.0;
  groebnerMatrix(39,173) = groebnerMatrix(39,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(39,189) = groebnerMatrix(39,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(39,168);
  groebnerMatrix(39,168) = 0.0;
  groebnerMatrix(39,181) = groebnerMatrix(39,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(39,188) = groebnerMatrix(39,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(39,169);
  groebnerMatrix(39,169) = 0.0;
  groebnerMatrix(39,177) = groebnerMatrix(39,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(39,186) = groebnerMatrix(39,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(39,196) = groebnerMatrix(39,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(39,172);
  groebnerMatrix(39,172) = 0.0;
  groebnerMatrix(39,179) = groebnerMatrix(39,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(39,190) = groebnerMatrix(39,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(39,175);
  groebnerMatrix(39,175) = 0.0;
  groebnerMatrix(39,182) = groebnerMatrix(39,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(39,187) = groebnerMatrix(39,187) - factor * groebnerMatrix(18,187);

  sPolynomial40(groebnerMatrix);
  groebnerRow38_100000000_f(groebnerMatrix,40);
  groebnerRow39_100000000_f(groebnerMatrix,40);
  factor = groebnerMatrix(40,127);
  groebnerMatrix(40,127) = 0.0;
  groebnerMatrix(40,134) = groebnerMatrix(40,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(40,181) = groebnerMatrix(40,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(40,130);
  groebnerMatrix(40,130) = 0.0;
  groebnerMatrix(40,137) = groebnerMatrix(40,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(40,178) = groebnerMatrix(40,178) - factor * groebnerMatrix(18,187);
  groebnerRow34_000000000_f(groebnerMatrix,40);
  groebnerRow35_000000000_f(groebnerMatrix,40);
  groebnerRow36_000000000_f(groebnerMatrix,40);
  groebnerRow37_000000000_f(groebnerMatrix,40);
  groebnerRow38_000000000_f(groebnerMatrix,40);
  groebnerRow39_000000000_f(groebnerMatrix,40);
  factor = groebnerMatrix(40,172);
  groebnerMatrix(40,172) = 0.0;
  groebnerMatrix(40,179) = groebnerMatrix(40,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(40,190) = groebnerMatrix(40,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(40,175);
  groebnerMatrix(40,175) = 0.0;
  groebnerMatrix(40,182) = groebnerMatrix(40,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(40,187) = groebnerMatrix(40,187) - factor * groebnerMatrix(18,187);

  sPolynomial41(groebnerMatrix);
  factor = -groebnerMatrix(41,81);
  groebnerMatrix(41,81) = 0.0;
  groebnerMatrix(41,116) = groebnerMatrix(41,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(41,157) = groebnerMatrix(41,157) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,41);
  groebnerRow33_100000000_f(groebnerMatrix,41);
  groebnerRow34_100000000_f(groebnerMatrix,41);
  groebnerRow35_100000000_f(groebnerMatrix,41);
  groebnerRow36_100000000_f(groebnerMatrix,41);
  groebnerRow37_100000000_f(groebnerMatrix,41);
  groebnerRow38_100000000_f(groebnerMatrix,41);
  groebnerRow39_100000000_f(groebnerMatrix,41);
  factor = groebnerMatrix(41,127);
  groebnerMatrix(41,127) = 0.0;
  groebnerMatrix(41,134) = groebnerMatrix(41,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(41,181) = groebnerMatrix(41,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(41,130);
  groebnerMatrix(41,130) = 0.0;
  groebnerMatrix(41,137) = groebnerMatrix(41,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(41,178) = groebnerMatrix(41,178) - factor * groebnerMatrix(18,187);
  groebnerRow30_000000000_f(groebnerMatrix,41);
  groebnerRow31_000000000_f(groebnerMatrix,41);
  groebnerRow32_000000000_f(groebnerMatrix,41);
  groebnerRow33_000000000_f(groebnerMatrix,41);
  groebnerRow34_000000000_f(groebnerMatrix,41);
  groebnerRow35_000000000_f(groebnerMatrix,41);
  groebnerRow36_000000000_f(groebnerMatrix,41);
  groebnerRow37_000000000_f(groebnerMatrix,41);
  groebnerRow38_000000000_f(groebnerMatrix,41);
  groebnerRow39_000000000_f(groebnerMatrix,41);
  factor = groebnerMatrix(41,172);
  groebnerMatrix(41,172) = 0.0;
  groebnerMatrix(41,179) = groebnerMatrix(41,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(41,190) = groebnerMatrix(41,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(41,175);
  groebnerMatrix(41,175) = 0.0;
  groebnerMatrix(41,182) = groebnerMatrix(41,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(41,187) = groebnerMatrix(41,187) - factor * groebnerMatrix(18,187);

  sPolynomial42(groebnerMatrix);
  factor = -groebnerMatrix(42,80);
  groebnerMatrix(42,80) = 0.0;
  groebnerMatrix(42,111) = groebnerMatrix(42,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(42,152) = groebnerMatrix(42,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(42,81);
  groebnerMatrix(42,81) = 0.0;
  groebnerMatrix(42,116) = groebnerMatrix(42,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(42,157) = groebnerMatrix(42,157) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,42);
  groebnerRow41_000000000_f(groebnerMatrix,42);
  groebnerRow32_100000000_f(groebnerMatrix,42);
  groebnerRow33_100000000_f(groebnerMatrix,42);
  groebnerRow34_100000000_f(groebnerMatrix,42);
  groebnerRow35_100000000_f(groebnerMatrix,42);
  groebnerRow36_100000000_f(groebnerMatrix,42);
  groebnerRow37_100000000_f(groebnerMatrix,42);
  groebnerRow38_100000000_f(groebnerMatrix,42);
  groebnerRow39_100000000_f(groebnerMatrix,42);
  factor = groebnerMatrix(42,127);
  groebnerMatrix(42,127) = 0.0;
  groebnerMatrix(42,134) = groebnerMatrix(42,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(42,181) = groebnerMatrix(42,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(42,130);
  groebnerMatrix(42,130) = 0.0;
  groebnerMatrix(42,137) = groebnerMatrix(42,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(42,178) = groebnerMatrix(42,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(42,148);
  groebnerMatrix(42,148) = 0.0;
  groebnerMatrix(42,153) = groebnerMatrix(42,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(42,159) = groebnerMatrix(42,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,42);
  groebnerRow31_000000000_f(groebnerMatrix,42);
  groebnerRow32_000000000_f(groebnerMatrix,42);
  groebnerRow33_000000000_f(groebnerMatrix,42);
  groebnerRow34_000000000_f(groebnerMatrix,42);
  groebnerRow35_000000000_f(groebnerMatrix,42);
  groebnerRow36_000000000_f(groebnerMatrix,42);
  groebnerRow37_000000000_f(groebnerMatrix,42);
  groebnerRow38_000000000_f(groebnerMatrix,42);
  groebnerRow39_000000000_f(groebnerMatrix,42);
  factor = groebnerMatrix(42,172);
  groebnerMatrix(42,172) = 0.0;
  groebnerMatrix(42,179) = groebnerMatrix(42,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(42,190) = groebnerMatrix(42,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(42,175);
  groebnerMatrix(42,175) = 0.0;
  groebnerMatrix(42,182) = groebnerMatrix(42,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(42,187) = groebnerMatrix(42,187) - factor * groebnerMatrix(18,187);

  sPolynomial43(groebnerMatrix);
  factor = -groebnerMatrix(43,79);
  groebnerMatrix(43,79) = 0.0;
  groebnerMatrix(43,110) = groebnerMatrix(43,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(43,148) = groebnerMatrix(43,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(43,80);
  groebnerMatrix(43,80) = 0.0;
  groebnerMatrix(43,111) = groebnerMatrix(43,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(43,152) = groebnerMatrix(43,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(43,81);
  groebnerMatrix(43,81) = 0.0;
  groebnerMatrix(43,116) = groebnerMatrix(43,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(43,157) = groebnerMatrix(43,157) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,43);
  groebnerRow41_000000000_f(groebnerMatrix,43);
  groebnerRow42_000000000_f(groebnerMatrix,43);
  groebnerRow32_100000000_f(groebnerMatrix,43);
  groebnerRow33_100000000_f(groebnerMatrix,43);
  groebnerRow34_100000000_f(groebnerMatrix,43);
  groebnerRow35_100000000_f(groebnerMatrix,43);
  groebnerRow36_100000000_f(groebnerMatrix,43);
  groebnerRow37_100000000_f(groebnerMatrix,43);
  groebnerRow38_100000000_f(groebnerMatrix,43);
  groebnerRow39_100000000_f(groebnerMatrix,43);
  factor = groebnerMatrix(43,127);
  groebnerMatrix(43,127) = 0.0;
  groebnerMatrix(43,134) = groebnerMatrix(43,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(43,181) = groebnerMatrix(43,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(43,130);
  groebnerMatrix(43,130) = 0.0;
  groebnerMatrix(43,137) = groebnerMatrix(43,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(43,178) = groebnerMatrix(43,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(43,148);
  groebnerMatrix(43,148) = 0.0;
  groebnerMatrix(43,153) = groebnerMatrix(43,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(43,159) = groebnerMatrix(43,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,43);
  groebnerRow31_000000000_f(groebnerMatrix,43);
  groebnerRow32_000000000_f(groebnerMatrix,43);
  groebnerRow33_000000000_f(groebnerMatrix,43);
  groebnerRow34_000000000_f(groebnerMatrix,43);
  groebnerRow35_000000000_f(groebnerMatrix,43);
  groebnerRow36_000000000_f(groebnerMatrix,43);
  groebnerRow37_000000000_f(groebnerMatrix,43);
  groebnerRow38_000000000_f(groebnerMatrix,43);
  groebnerRow39_000000000_f(groebnerMatrix,43);
  factor = groebnerMatrix(43,172);
  groebnerMatrix(43,172) = 0.0;
  groebnerMatrix(43,179) = groebnerMatrix(43,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(43,190) = groebnerMatrix(43,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(43,175);
  groebnerMatrix(43,175) = 0.0;
  groebnerMatrix(43,182) = groebnerMatrix(43,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(43,187) = groebnerMatrix(43,187) - factor * groebnerMatrix(18,187);

  sPolynomial44(groebnerMatrix);
  factor = groebnerMatrix(44,78);
  groebnerMatrix(44,78) = 0.0;
  groebnerMatrix(44,113) = groebnerMatrix(44,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(44,160) = groebnerMatrix(44,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(44,79);
  groebnerMatrix(44,79) = 0.0;
  groebnerMatrix(44,110) = groebnerMatrix(44,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(44,148) = groebnerMatrix(44,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(44,80);
  groebnerMatrix(44,80) = 0.0;
  groebnerMatrix(44,111) = groebnerMatrix(44,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(44,152) = groebnerMatrix(44,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(44,81);
  groebnerMatrix(44,81) = 0.0;
  groebnerMatrix(44,116) = groebnerMatrix(44,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(44,157) = groebnerMatrix(44,157) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,44);
  groebnerRow41_000000000_f(groebnerMatrix,44);
  groebnerRow42_000000000_f(groebnerMatrix,44);
  groebnerRow43_000000000_f(groebnerMatrix,44);
  groebnerRow31_100000000_f(groebnerMatrix,44);
  groebnerRow32_100000000_f(groebnerMatrix,44);
  groebnerRow33_100000000_f(groebnerMatrix,44);
  groebnerRow34_100000000_f(groebnerMatrix,44);
  groebnerRow35_100000000_f(groebnerMatrix,44);
  groebnerRow36_100000000_f(groebnerMatrix,44);
  groebnerRow37_100000000_f(groebnerMatrix,44);
  groebnerRow38_100000000_f(groebnerMatrix,44);
  groebnerRow39_100000000_f(groebnerMatrix,44);
  factor = groebnerMatrix(44,127);
  groebnerMatrix(44,127) = 0.0;
  groebnerMatrix(44,134) = groebnerMatrix(44,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(44,181) = groebnerMatrix(44,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(44,130);
  groebnerMatrix(44,130) = 0.0;
  groebnerMatrix(44,137) = groebnerMatrix(44,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(44,178) = groebnerMatrix(44,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(44,143);
  groebnerMatrix(44,143) = 0.0;
  groebnerMatrix(44,155) = groebnerMatrix(44,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(44,176) = groebnerMatrix(44,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(44,148);
  groebnerMatrix(44,148) = 0.0;
  groebnerMatrix(44,153) = groebnerMatrix(44,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(44,159) = groebnerMatrix(44,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,44);
  groebnerRow31_000000000_f(groebnerMatrix,44);
  groebnerRow32_000000000_f(groebnerMatrix,44);
  groebnerRow33_000000000_f(groebnerMatrix,44);
  groebnerRow34_000000000_f(groebnerMatrix,44);
  groebnerRow35_000000000_f(groebnerMatrix,44);
  groebnerRow36_000000000_f(groebnerMatrix,44);
  groebnerRow37_000000000_f(groebnerMatrix,44);
  groebnerRow38_000000000_f(groebnerMatrix,44);
  groebnerRow39_000000000_f(groebnerMatrix,44);
  factor = groebnerMatrix(44,172);
  groebnerMatrix(44,172) = 0.0;
  groebnerMatrix(44,179) = groebnerMatrix(44,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(44,190) = groebnerMatrix(44,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(44,175);
  groebnerMatrix(44,175) = 0.0;
  groebnerMatrix(44,182) = groebnerMatrix(44,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(44,187) = groebnerMatrix(44,187) - factor * groebnerMatrix(18,187);

  sPolynomial45(groebnerMatrix);
  factor = -groebnerMatrix(45,77);
  groebnerMatrix(45,77) = 0.0;
  groebnerMatrix(45,108) = groebnerMatrix(45,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,143) = groebnerMatrix(45,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(45,78);
  groebnerMatrix(45,78) = 0.0;
  groebnerMatrix(45,113) = groebnerMatrix(45,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(45,160) = groebnerMatrix(45,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(45,79);
  groebnerMatrix(45,79) = 0.0;
  groebnerMatrix(45,110) = groebnerMatrix(45,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,148) = groebnerMatrix(45,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(45,80);
  groebnerMatrix(45,80) = 0.0;
  groebnerMatrix(45,111) = groebnerMatrix(45,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,152) = groebnerMatrix(45,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(45,81);
  groebnerMatrix(45,81) = 0.0;
  groebnerMatrix(45,116) = groebnerMatrix(45,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,157) = groebnerMatrix(45,157) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,45);
  groebnerRow41_000000000_f(groebnerMatrix,45);
  groebnerRow42_000000000_f(groebnerMatrix,45);
  groebnerRow43_000000000_f(groebnerMatrix,45);
  groebnerRow44_000000000_f(groebnerMatrix,45);
  groebnerRow30_100000000_f(groebnerMatrix,45);
  groebnerRow31_100000000_f(groebnerMatrix,45);
  groebnerRow32_100000000_f(groebnerMatrix,45);
  groebnerRow33_100000000_f(groebnerMatrix,45);
  groebnerRow34_100000000_f(groebnerMatrix,45);
  groebnerRow35_100000000_f(groebnerMatrix,45);
  groebnerRow36_100000000_f(groebnerMatrix,45);
  groebnerRow37_100000000_f(groebnerMatrix,45);
  groebnerRow38_100000000_f(groebnerMatrix,45);
  groebnerRow39_100000000_f(groebnerMatrix,45);
  factor = groebnerMatrix(45,127);
  groebnerMatrix(45,127) = 0.0;
  groebnerMatrix(45,134) = groebnerMatrix(45,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(45,181) = groebnerMatrix(45,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(45,130);
  groebnerMatrix(45,130) = 0.0;
  groebnerMatrix(45,137) = groebnerMatrix(45,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,178) = groebnerMatrix(45,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(45,142);
  groebnerMatrix(45,142) = 0.0;
  groebnerMatrix(45,144) = groebnerMatrix(45,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(45,147) = groebnerMatrix(45,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(45,196) = groebnerMatrix(45,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(45,143);
  groebnerMatrix(45,143) = 0.0;
  groebnerMatrix(45,155) = groebnerMatrix(45,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(45,176) = groebnerMatrix(45,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(45,144);
  groebnerMatrix(45,144) = 0.0;
  groebnerMatrix(45,156) = groebnerMatrix(45,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(45,177) = groebnerMatrix(45,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(45,196) = groebnerMatrix(45,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(45,147);
  groebnerMatrix(45,147) = 0.0;
  groebnerMatrix(45,162) = groebnerMatrix(45,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(45,186) = groebnerMatrix(45,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(45,196) = groebnerMatrix(45,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(45,148);
  groebnerMatrix(45,148) = 0.0;
  groebnerMatrix(45,153) = groebnerMatrix(45,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(45,159) = groebnerMatrix(45,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,45);
  groebnerRow31_000000000_f(groebnerMatrix,45);
  groebnerRow32_000000000_f(groebnerMatrix,45);
  groebnerRow33_000000000_f(groebnerMatrix,45);
  groebnerRow34_000000000_f(groebnerMatrix,45);
  groebnerRow35_000000000_f(groebnerMatrix,45);
  groebnerRow36_000000000_f(groebnerMatrix,45);
  groebnerRow37_000000000_f(groebnerMatrix,45);
  groebnerRow38_000000000_f(groebnerMatrix,45);
  groebnerRow39_000000000_f(groebnerMatrix,45);
  factor = groebnerMatrix(45,172);
  groebnerMatrix(45,172) = 0.0;
  groebnerMatrix(45,179) = groebnerMatrix(45,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(45,190) = groebnerMatrix(45,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(45,175);
  groebnerMatrix(45,175) = 0.0;
  groebnerMatrix(45,182) = groebnerMatrix(45,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(45,187) = groebnerMatrix(45,187) - factor * groebnerMatrix(18,187);

  sPolynomial46(groebnerMatrix);
  factor = groebnerMatrix(46,82);
  groebnerMatrix(46,82) = 0.0;
  groebnerMatrix(46,90) = groebnerMatrix(46,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(46,127) = groebnerMatrix(46,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(46,83);
  groebnerMatrix(46,83) = 0.0;
  groebnerMatrix(46,89) = groebnerMatrix(46,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(46,175) = groebnerMatrix(46,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(46,85);
  groebnerMatrix(46,85) = 0.0;
  groebnerMatrix(46,93) = groebnerMatrix(46,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(46,130) = groebnerMatrix(46,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(46,86);
  groebnerMatrix(46,86) = 0.0;
  groebnerMatrix(46,92) = groebnerMatrix(46,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(46,172) = groebnerMatrix(46,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(46,88);
  groebnerMatrix(46,88) = 0.0;
  groebnerMatrix(46,96) = groebnerMatrix(46,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(46,140) = groebnerMatrix(46,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(46,194) = groebnerMatrix(46,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,46);
  groebnerRow41_000000000_f(groebnerMatrix,46);
  groebnerRow42_000000000_f(groebnerMatrix,46);
  groebnerRow43_000000000_f(groebnerMatrix,46);
  groebnerRow44_000000000_f(groebnerMatrix,46);
  groebnerRow45_000000000_f(groebnerMatrix,46);
  groebnerRow37_100000000_f(groebnerMatrix,46);
  groebnerRow38_100000000_f(groebnerMatrix,46);
  groebnerRow39_100000000_f(groebnerMatrix,46);
  factor = groebnerMatrix(46,118);
  groebnerMatrix(46,118) = 0.0;
  groebnerMatrix(46,126) = groebnerMatrix(46,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(46,135) = groebnerMatrix(46,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(46,119);
  groebnerMatrix(46,119) = 0.0;
  groebnerMatrix(46,125) = groebnerMatrix(46,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(46,183) = groebnerMatrix(46,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(46,120);
  groebnerMatrix(46,120) = 0.0;
  groebnerMatrix(46,133) = groebnerMatrix(46,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(46,182) = groebnerMatrix(46,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(46,121);
  groebnerMatrix(46,121) = 0.0;
  groebnerMatrix(46,129) = groebnerMatrix(46,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(46,138) = groebnerMatrix(46,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(46,122);
  groebnerMatrix(46,122) = 0.0;
  groebnerMatrix(46,128) = groebnerMatrix(46,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(46,180) = groebnerMatrix(46,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(46,123);
  groebnerMatrix(46,123) = 0.0;
  groebnerMatrix(46,136) = groebnerMatrix(46,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(46,179) = groebnerMatrix(46,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(46,124);
  groebnerMatrix(46,124) = 0.0;
  groebnerMatrix(46,132) = groebnerMatrix(46,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(46,141) = groebnerMatrix(46,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(46,195) = groebnerMatrix(46,195) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(46,127);
  groebnerMatrix(46,127) = 0.0;
  groebnerMatrix(46,134) = groebnerMatrix(46,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(46,181) = groebnerMatrix(46,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(46,130);
  groebnerMatrix(46,130) = 0.0;
  groebnerMatrix(46,137) = groebnerMatrix(46,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(46,178) = groebnerMatrix(46,178) - factor * groebnerMatrix(18,187);
  groebnerRow35_000000000_f(groebnerMatrix,46);
  groebnerRow36_000000000_f(groebnerMatrix,46);
  groebnerRow37_000000000_f(groebnerMatrix,46);
  groebnerRow38_000000000_f(groebnerMatrix,46);
  groebnerRow39_000000000_f(groebnerMatrix,46);
  factor = groebnerMatrix(46,163);
  groebnerMatrix(46,163) = 0.0;
  groebnerMatrix(46,171) = groebnerMatrix(46,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(46,180) = groebnerMatrix(46,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(46,164);
  groebnerMatrix(46,164) = 0.0;
  groebnerMatrix(46,170) = groebnerMatrix(46,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(46,192) = groebnerMatrix(46,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(46,165);
  groebnerMatrix(46,165) = 0.0;
  groebnerMatrix(46,178) = groebnerMatrix(46,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(46,191) = groebnerMatrix(46,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(46,166);
  groebnerMatrix(46,166) = 0.0;
  groebnerMatrix(46,174) = groebnerMatrix(46,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(46,183) = groebnerMatrix(46,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(46,167);
  groebnerMatrix(46,167) = 0.0;
  groebnerMatrix(46,173) = groebnerMatrix(46,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(46,189) = groebnerMatrix(46,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(46,168);
  groebnerMatrix(46,168) = 0.0;
  groebnerMatrix(46,181) = groebnerMatrix(46,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(46,188) = groebnerMatrix(46,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(46,169);
  groebnerMatrix(46,169) = 0.0;
  groebnerMatrix(46,177) = groebnerMatrix(46,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(46,186) = groebnerMatrix(46,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(46,196) = groebnerMatrix(46,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(46,172);
  groebnerMatrix(46,172) = 0.0;
  groebnerMatrix(46,179) = groebnerMatrix(46,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(46,190) = groebnerMatrix(46,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(46,175);
  groebnerMatrix(46,175) = 0.0;
  groebnerMatrix(46,182) = groebnerMatrix(46,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(46,187) = groebnerMatrix(46,187) - factor * groebnerMatrix(18,187);

  sPolynomial47(groebnerMatrix);
  factor = groebnerMatrix(47,56);
  groebnerMatrix(47,56) = 0.0;
  groebnerMatrix(47,115) = groebnerMatrix(47,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(47,158) = groebnerMatrix(47,158) - factor * groebnerMatrix(27,188);
  factor = -groebnerMatrix(47,79);
  groebnerMatrix(47,79) = 0.0;
  groebnerMatrix(47,110) = groebnerMatrix(47,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(47,148) = groebnerMatrix(47,148) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(47,82);
  groebnerMatrix(47,82) = 0.0;
  groebnerMatrix(47,90) = groebnerMatrix(47,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(47,127) = groebnerMatrix(47,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(47,83);
  groebnerMatrix(47,83) = 0.0;
  groebnerMatrix(47,89) = groebnerMatrix(47,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(47,175) = groebnerMatrix(47,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(47,85);
  groebnerMatrix(47,85) = 0.0;
  groebnerMatrix(47,93) = groebnerMatrix(47,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(47,130) = groebnerMatrix(47,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(47,86);
  groebnerMatrix(47,86) = 0.0;
  groebnerMatrix(47,92) = groebnerMatrix(47,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(47,172) = groebnerMatrix(47,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(47,88);
  groebnerMatrix(47,88) = 0.0;
  groebnerMatrix(47,96) = groebnerMatrix(47,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(47,140) = groebnerMatrix(47,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(47,194) = groebnerMatrix(47,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,47);
  groebnerRow41_000000000_f(groebnerMatrix,47);
  groebnerRow42_000000000_f(groebnerMatrix,47);
  groebnerRow43_000000000_f(groebnerMatrix,47);
  groebnerRow44_000000000_f(groebnerMatrix,47);
  groebnerRow45_000000000_f(groebnerMatrix,47);
  groebnerRow32_100000000_f(groebnerMatrix,47);
  groebnerRow33_100000000_f(groebnerMatrix,47);
  groebnerRow34_100000000_f(groebnerMatrix,47);
  groebnerRow35_100000000_f(groebnerMatrix,47);
  groebnerRow36_100000000_f(groebnerMatrix,47);
  groebnerRow37_100000000_f(groebnerMatrix,47);
  groebnerRow38_100000000_f(groebnerMatrix,47);
  groebnerRow39_100000000_f(groebnerMatrix,47);
  factor = groebnerMatrix(47,118);
  groebnerMatrix(47,118) = 0.0;
  groebnerMatrix(47,126) = groebnerMatrix(47,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(47,135) = groebnerMatrix(47,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(47,119);
  groebnerMatrix(47,119) = 0.0;
  groebnerMatrix(47,125) = groebnerMatrix(47,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(47,183) = groebnerMatrix(47,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(47,120);
  groebnerMatrix(47,120) = 0.0;
  groebnerMatrix(47,133) = groebnerMatrix(47,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(47,182) = groebnerMatrix(47,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(47,121);
  groebnerMatrix(47,121) = 0.0;
  groebnerMatrix(47,129) = groebnerMatrix(47,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(47,138) = groebnerMatrix(47,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(47,122);
  groebnerMatrix(47,122) = 0.0;
  groebnerMatrix(47,128) = groebnerMatrix(47,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(47,180) = groebnerMatrix(47,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(47,123);
  groebnerMatrix(47,123) = 0.0;
  groebnerMatrix(47,136) = groebnerMatrix(47,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(47,179) = groebnerMatrix(47,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(47,124);
  groebnerMatrix(47,124) = 0.0;
  groebnerMatrix(47,132) = groebnerMatrix(47,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(47,141) = groebnerMatrix(47,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(47,195) = groebnerMatrix(47,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,47);
  factor = groebnerMatrix(47,127);
  groebnerMatrix(47,127) = 0.0;
  groebnerMatrix(47,134) = groebnerMatrix(47,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(47,181) = groebnerMatrix(47,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(47,130);
  groebnerMatrix(47,130) = 0.0;
  groebnerMatrix(47,137) = groebnerMatrix(47,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(47,178) = groebnerMatrix(47,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(47,148);
  groebnerMatrix(47,148) = 0.0;
  groebnerMatrix(47,153) = groebnerMatrix(47,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(47,159) = groebnerMatrix(47,159) - factor * groebnerMatrix(14,159);
  groebnerRow31_000000000_f(groebnerMatrix,47);
  groebnerRow32_000000000_f(groebnerMatrix,47);
  groebnerRow33_000000000_f(groebnerMatrix,47);
  groebnerRow34_000000000_f(groebnerMatrix,47);
  groebnerRow35_000000000_f(groebnerMatrix,47);
  groebnerRow36_000000000_f(groebnerMatrix,47);
  groebnerRow37_000000000_f(groebnerMatrix,47);
  groebnerRow38_000000000_f(groebnerMatrix,47);
  groebnerRow39_000000000_f(groebnerMatrix,47);
  factor = groebnerMatrix(47,163);
  groebnerMatrix(47,163) = 0.0;
  groebnerMatrix(47,171) = groebnerMatrix(47,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(47,180) = groebnerMatrix(47,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(47,164);
  groebnerMatrix(47,164) = 0.0;
  groebnerMatrix(47,170) = groebnerMatrix(47,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(47,192) = groebnerMatrix(47,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(47,165);
  groebnerMatrix(47,165) = 0.0;
  groebnerMatrix(47,178) = groebnerMatrix(47,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(47,191) = groebnerMatrix(47,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(47,166);
  groebnerMatrix(47,166) = 0.0;
  groebnerMatrix(47,174) = groebnerMatrix(47,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(47,183) = groebnerMatrix(47,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(47,167);
  groebnerMatrix(47,167) = 0.0;
  groebnerMatrix(47,173) = groebnerMatrix(47,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(47,189) = groebnerMatrix(47,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(47,168);
  groebnerMatrix(47,168) = 0.0;
  groebnerMatrix(47,181) = groebnerMatrix(47,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(47,188) = groebnerMatrix(47,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(47,169);
  groebnerMatrix(47,169) = 0.0;
  groebnerMatrix(47,177) = groebnerMatrix(47,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(47,186) = groebnerMatrix(47,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(47,196) = groebnerMatrix(47,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(47,172);
  groebnerMatrix(47,172) = 0.0;
  groebnerMatrix(47,179) = groebnerMatrix(47,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(47,190) = groebnerMatrix(47,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(47,175);
  groebnerMatrix(47,175) = 0.0;
  groebnerMatrix(47,182) = groebnerMatrix(47,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(47,187) = groebnerMatrix(47,187) - factor * groebnerMatrix(18,187);

  sPolynomial48(groebnerMatrix);
  factor = -groebnerMatrix(48,55);
  groebnerMatrix(48,55) = 0.0;
  groebnerMatrix(48,79) = groebnerMatrix(48,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(48,159) = groebnerMatrix(48,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(48,56);
  groebnerMatrix(48,56) = 0.0;
  groebnerMatrix(48,115) = groebnerMatrix(48,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(48,158) = groebnerMatrix(48,158) - factor * groebnerMatrix(27,188);
  factor = -groebnerMatrix(48,79);
  groebnerMatrix(48,79) = 0.0;
  groebnerMatrix(48,110) = groebnerMatrix(48,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(48,148) = groebnerMatrix(48,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(48,80);
  groebnerMatrix(48,80) = 0.0;
  groebnerMatrix(48,111) = groebnerMatrix(48,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(48,152) = groebnerMatrix(48,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(48,82);
  groebnerMatrix(48,82) = 0.0;
  groebnerMatrix(48,90) = groebnerMatrix(48,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(48,127) = groebnerMatrix(48,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(48,83);
  groebnerMatrix(48,83) = 0.0;
  groebnerMatrix(48,89) = groebnerMatrix(48,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(48,175) = groebnerMatrix(48,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(48,85);
  groebnerMatrix(48,85) = 0.0;
  groebnerMatrix(48,93) = groebnerMatrix(48,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(48,130) = groebnerMatrix(48,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(48,86);
  groebnerMatrix(48,86) = 0.0;
  groebnerMatrix(48,92) = groebnerMatrix(48,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(48,172) = groebnerMatrix(48,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(48,88);
  groebnerMatrix(48,88) = 0.0;
  groebnerMatrix(48,96) = groebnerMatrix(48,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(48,140) = groebnerMatrix(48,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(48,194) = groebnerMatrix(48,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,48);
  groebnerRow41_000000000_f(groebnerMatrix,48);
  groebnerRow42_000000000_f(groebnerMatrix,48);
  groebnerRow43_000000000_f(groebnerMatrix,48);
  groebnerRow44_000000000_f(groebnerMatrix,48);
  groebnerRow45_000000000_f(groebnerMatrix,48);
  groebnerRow32_100000000_f(groebnerMatrix,48);
  groebnerRow33_100000000_f(groebnerMatrix,48);
  groebnerRow34_100000000_f(groebnerMatrix,48);
  groebnerRow35_100000000_f(groebnerMatrix,48);
  groebnerRow36_100000000_f(groebnerMatrix,48);
  groebnerRow37_100000000_f(groebnerMatrix,48);
  groebnerRow38_100000000_f(groebnerMatrix,48);
  groebnerRow39_100000000_f(groebnerMatrix,48);
  factor = groebnerMatrix(48,118);
  groebnerMatrix(48,118) = 0.0;
  groebnerMatrix(48,126) = groebnerMatrix(48,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(48,135) = groebnerMatrix(48,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(48,119);
  groebnerMatrix(48,119) = 0.0;
  groebnerMatrix(48,125) = groebnerMatrix(48,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(48,183) = groebnerMatrix(48,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(48,120);
  groebnerMatrix(48,120) = 0.0;
  groebnerMatrix(48,133) = groebnerMatrix(48,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(48,182) = groebnerMatrix(48,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(48,121);
  groebnerMatrix(48,121) = 0.0;
  groebnerMatrix(48,129) = groebnerMatrix(48,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(48,138) = groebnerMatrix(48,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(48,122);
  groebnerMatrix(48,122) = 0.0;
  groebnerMatrix(48,128) = groebnerMatrix(48,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(48,180) = groebnerMatrix(48,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(48,123);
  groebnerMatrix(48,123) = 0.0;
  groebnerMatrix(48,136) = groebnerMatrix(48,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(48,179) = groebnerMatrix(48,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(48,124);
  groebnerMatrix(48,124) = 0.0;
  groebnerMatrix(48,132) = groebnerMatrix(48,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(48,141) = groebnerMatrix(48,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(48,195) = groebnerMatrix(48,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,48);
  groebnerRow47_000000000_f(groebnerMatrix,48);
  factor = groebnerMatrix(48,127);
  groebnerMatrix(48,127) = 0.0;
  groebnerMatrix(48,134) = groebnerMatrix(48,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(48,181) = groebnerMatrix(48,181) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(48,130);
  groebnerMatrix(48,130) = 0.0;
  groebnerMatrix(48,137) = groebnerMatrix(48,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(48,178) = groebnerMatrix(48,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(48,148);
  groebnerMatrix(48,148) = 0.0;
  groebnerMatrix(48,153) = groebnerMatrix(48,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(48,159) = groebnerMatrix(48,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,48);
  groebnerRow31_000000000_f(groebnerMatrix,48);
  groebnerRow32_000000000_f(groebnerMatrix,48);
  groebnerRow33_000000000_f(groebnerMatrix,48);
  groebnerRow34_000000000_f(groebnerMatrix,48);
  groebnerRow35_000000000_f(groebnerMatrix,48);
  groebnerRow36_000000000_f(groebnerMatrix,48);
  groebnerRow37_000000000_f(groebnerMatrix,48);
  groebnerRow38_000000000_f(groebnerMatrix,48);
  groebnerRow39_000000000_f(groebnerMatrix,48);
  factor = groebnerMatrix(48,163);
  groebnerMatrix(48,163) = 0.0;
  groebnerMatrix(48,171) = groebnerMatrix(48,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(48,180) = groebnerMatrix(48,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(48,164);
  groebnerMatrix(48,164) = 0.0;
  groebnerMatrix(48,170) = groebnerMatrix(48,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(48,192) = groebnerMatrix(48,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(48,165);
  groebnerMatrix(48,165) = 0.0;
  groebnerMatrix(48,178) = groebnerMatrix(48,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(48,191) = groebnerMatrix(48,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(48,166);
  groebnerMatrix(48,166) = 0.0;
  groebnerMatrix(48,174) = groebnerMatrix(48,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(48,183) = groebnerMatrix(48,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(48,167);
  groebnerMatrix(48,167) = 0.0;
  groebnerMatrix(48,173) = groebnerMatrix(48,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(48,189) = groebnerMatrix(48,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(48,168);
  groebnerMatrix(48,168) = 0.0;
  groebnerMatrix(48,181) = groebnerMatrix(48,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(48,188) = groebnerMatrix(48,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(48,169);
  groebnerMatrix(48,169) = 0.0;
  groebnerMatrix(48,177) = groebnerMatrix(48,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(48,186) = groebnerMatrix(48,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(48,196) = groebnerMatrix(48,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(48,172);
  groebnerMatrix(48,172) = 0.0;
  groebnerMatrix(48,179) = groebnerMatrix(48,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(48,190) = groebnerMatrix(48,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(48,175);
  groebnerMatrix(48,175) = 0.0;
  groebnerMatrix(48,182) = groebnerMatrix(48,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(48,187) = groebnerMatrix(48,187) - factor * groebnerMatrix(18,187);

  sPolynomial49(groebnerMatrix);
  factor = groebnerMatrix(49,54);
  groebnerMatrix(49,54) = 0.0;
  groebnerMatrix(49,80) = groebnerMatrix(49,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(49,117) = groebnerMatrix(49,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(49,55);
  groebnerMatrix(49,55) = 0.0;
  groebnerMatrix(49,79) = groebnerMatrix(49,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(49,159) = groebnerMatrix(49,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(49,56);
  groebnerMatrix(49,56) = 0.0;
  groebnerMatrix(49,115) = groebnerMatrix(49,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(49,158) = groebnerMatrix(49,158) - factor * groebnerMatrix(27,188);
  factor = -groebnerMatrix(49,79);
  groebnerMatrix(49,79) = 0.0;
  groebnerMatrix(49,110) = groebnerMatrix(49,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(49,148) = groebnerMatrix(49,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(49,80);
  groebnerMatrix(49,80) = 0.0;
  groebnerMatrix(49,111) = groebnerMatrix(49,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(49,152) = groebnerMatrix(49,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(49,82);
  groebnerMatrix(49,82) = 0.0;
  groebnerMatrix(49,90) = groebnerMatrix(49,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(49,127) = groebnerMatrix(49,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(49,83);
  groebnerMatrix(49,83) = 0.0;
  groebnerMatrix(49,89) = groebnerMatrix(49,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(49,175) = groebnerMatrix(49,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(49,85);
  groebnerMatrix(49,85) = 0.0;
  groebnerMatrix(49,93) = groebnerMatrix(49,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(49,130) = groebnerMatrix(49,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(49,86);
  groebnerMatrix(49,86) = 0.0;
  groebnerMatrix(49,92) = groebnerMatrix(49,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(49,172) = groebnerMatrix(49,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(49,88);
  groebnerMatrix(49,88) = 0.0;
  groebnerMatrix(49,96) = groebnerMatrix(49,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(49,140) = groebnerMatrix(49,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(49,194) = groebnerMatrix(49,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,49);
  groebnerRow41_000000000_f(groebnerMatrix,49);
  groebnerRow42_000000000_f(groebnerMatrix,49);
  groebnerRow43_000000000_f(groebnerMatrix,49);
  groebnerRow44_000000000_f(groebnerMatrix,49);
  groebnerRow45_000000000_f(groebnerMatrix,49);
  factor = groebnerMatrix(49,105);
  groebnerMatrix(49,105) = 0.0;
  groebnerMatrix(49,112) = groebnerMatrix(49,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(49,185) = groebnerMatrix(49,185) - factor * groebnerMatrix(28,194);
  groebnerRow32_100000000_f(groebnerMatrix,49);
  groebnerRow33_100000000_f(groebnerMatrix,49);
  groebnerRow34_100000000_f(groebnerMatrix,49);
  groebnerRow35_100000000_f(groebnerMatrix,49);
  groebnerRow36_100000000_f(groebnerMatrix,49);
  groebnerRow37_100000000_f(groebnerMatrix,49);
  groebnerRow38_100000000_f(groebnerMatrix,49);
  groebnerRow39_100000000_f(groebnerMatrix,49);
  factor = groebnerMatrix(49,118);
  groebnerMatrix(49,118) = 0.0;
  groebnerMatrix(49,126) = groebnerMatrix(49,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(49,135) = groebnerMatrix(49,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(49,119);
  groebnerMatrix(49,119) = 0.0;
  groebnerMatrix(49,125) = groebnerMatrix(49,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(49,183) = groebnerMatrix(49,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(49,120);
  groebnerMatrix(49,120) = 0.0;
  groebnerMatrix(49,133) = groebnerMatrix(49,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(49,182) = groebnerMatrix(49,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(49,121);
  groebnerMatrix(49,121) = 0.0;
  groebnerMatrix(49,129) = groebnerMatrix(49,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(49,138) = groebnerMatrix(49,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(49,122);
  groebnerMatrix(49,122) = 0.0;
  groebnerMatrix(49,128) = groebnerMatrix(49,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(49,180) = groebnerMatrix(49,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(49,123);
  groebnerMatrix(49,123) = 0.0;
  groebnerMatrix(49,136) = groebnerMatrix(49,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(49,179) = groebnerMatrix(49,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(49,124);
  groebnerMatrix(49,124) = 0.0;
  groebnerMatrix(49,132) = groebnerMatrix(49,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(49,141) = groebnerMatrix(49,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(49,195) = groebnerMatrix(49,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,49);
  groebnerRow47_000000000_f(groebnerMatrix,49);
  factor = groebnerMatrix(49,127);
  groebnerMatrix(49,127) = 0.0;
  groebnerMatrix(49,134) = groebnerMatrix(49,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(49,181) = groebnerMatrix(49,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,49);
  factor = -groebnerMatrix(49,130);
  groebnerMatrix(49,130) = 0.0;
  groebnerMatrix(49,137) = groebnerMatrix(49,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(49,178) = groebnerMatrix(49,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(49,146);
  groebnerMatrix(49,146) = 0.0;
  groebnerMatrix(49,161) = groebnerMatrix(49,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(49,185) = groebnerMatrix(49,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(49,148);
  groebnerMatrix(49,148) = 0.0;
  groebnerMatrix(49,153) = groebnerMatrix(49,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(49,159) = groebnerMatrix(49,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,49);
  groebnerRow31_000000000_f(groebnerMatrix,49);
  groebnerRow32_000000000_f(groebnerMatrix,49);
  groebnerRow33_000000000_f(groebnerMatrix,49);
  groebnerRow34_000000000_f(groebnerMatrix,49);
  groebnerRow35_000000000_f(groebnerMatrix,49);
  groebnerRow36_000000000_f(groebnerMatrix,49);
  groebnerRow37_000000000_f(groebnerMatrix,49);
  groebnerRow38_000000000_f(groebnerMatrix,49);
  groebnerRow39_000000000_f(groebnerMatrix,49);
  factor = groebnerMatrix(49,163);
  groebnerMatrix(49,163) = 0.0;
  groebnerMatrix(49,171) = groebnerMatrix(49,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(49,180) = groebnerMatrix(49,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(49,164);
  groebnerMatrix(49,164) = 0.0;
  groebnerMatrix(49,170) = groebnerMatrix(49,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(49,192) = groebnerMatrix(49,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(49,165);
  groebnerMatrix(49,165) = 0.0;
  groebnerMatrix(49,178) = groebnerMatrix(49,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(49,191) = groebnerMatrix(49,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(49,166);
  groebnerMatrix(49,166) = 0.0;
  groebnerMatrix(49,174) = groebnerMatrix(49,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(49,183) = groebnerMatrix(49,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(49,167);
  groebnerMatrix(49,167) = 0.0;
  groebnerMatrix(49,173) = groebnerMatrix(49,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(49,189) = groebnerMatrix(49,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(49,168);
  groebnerMatrix(49,168) = 0.0;
  groebnerMatrix(49,181) = groebnerMatrix(49,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(49,188) = groebnerMatrix(49,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(49,169);
  groebnerMatrix(49,169) = 0.0;
  groebnerMatrix(49,177) = groebnerMatrix(49,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(49,186) = groebnerMatrix(49,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(49,196) = groebnerMatrix(49,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(49,172);
  groebnerMatrix(49,172) = 0.0;
  groebnerMatrix(49,179) = groebnerMatrix(49,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(49,190) = groebnerMatrix(49,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(49,175);
  groebnerMatrix(49,175) = 0.0;
  groebnerMatrix(49,182) = groebnerMatrix(49,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(49,187) = groebnerMatrix(49,187) - factor * groebnerMatrix(18,187);

  sPolynomial50(groebnerMatrix);
  factor = groebnerMatrix(50,53);
  groebnerMatrix(50,53) = 0.0;
  groebnerMatrix(50,105) = groebnerMatrix(50,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(50,146) = groebnerMatrix(50,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(50,54);
  groebnerMatrix(50,54) = 0.0;
  groebnerMatrix(50,80) = groebnerMatrix(50,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(50,117) = groebnerMatrix(50,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(50,55);
  groebnerMatrix(50,55) = 0.0;
  groebnerMatrix(50,79) = groebnerMatrix(50,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(50,159) = groebnerMatrix(50,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(50,56);
  groebnerMatrix(50,56) = 0.0;
  groebnerMatrix(50,115) = groebnerMatrix(50,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(50,158) = groebnerMatrix(50,158) - factor * groebnerMatrix(27,188);
  factor = -groebnerMatrix(50,76);
  groebnerMatrix(50,76) = 0.0;
  groebnerMatrix(50,107) = groebnerMatrix(50,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(50,142) = groebnerMatrix(50,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(50,79);
  groebnerMatrix(50,79) = 0.0;
  groebnerMatrix(50,110) = groebnerMatrix(50,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(50,148) = groebnerMatrix(50,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(50,80);
  groebnerMatrix(50,80) = 0.0;
  groebnerMatrix(50,111) = groebnerMatrix(50,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(50,152) = groebnerMatrix(50,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(50,82);
  groebnerMatrix(50,82) = 0.0;
  groebnerMatrix(50,90) = groebnerMatrix(50,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(50,127) = groebnerMatrix(50,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(50,83);
  groebnerMatrix(50,83) = 0.0;
  groebnerMatrix(50,89) = groebnerMatrix(50,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(50,175) = groebnerMatrix(50,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(50,85);
  groebnerMatrix(50,85) = 0.0;
  groebnerMatrix(50,93) = groebnerMatrix(50,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(50,130) = groebnerMatrix(50,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(50,86);
  groebnerMatrix(50,86) = 0.0;
  groebnerMatrix(50,92) = groebnerMatrix(50,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(50,172) = groebnerMatrix(50,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(50,88);
  groebnerMatrix(50,88) = 0.0;
  groebnerMatrix(50,96) = groebnerMatrix(50,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(50,140) = groebnerMatrix(50,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(50,194) = groebnerMatrix(50,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,50);
  groebnerRow41_000000000_f(groebnerMatrix,50);
  groebnerRow42_000000000_f(groebnerMatrix,50);
  groebnerRow43_000000000_f(groebnerMatrix,50);
  groebnerRow44_000000000_f(groebnerMatrix,50);
  groebnerRow45_000000000_f(groebnerMatrix,50);
  factor = groebnerMatrix(50,105);
  groebnerMatrix(50,105) = 0.0;
  groebnerMatrix(50,112) = groebnerMatrix(50,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(50,185) = groebnerMatrix(50,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,50);
  groebnerRow31_100000000_f(groebnerMatrix,50);
  groebnerRow32_100000000_f(groebnerMatrix,50);
  groebnerRow33_100000000_f(groebnerMatrix,50);
  groebnerRow34_100000000_f(groebnerMatrix,50);
  groebnerRow35_100000000_f(groebnerMatrix,50);
  groebnerRow36_100000000_f(groebnerMatrix,50);
  groebnerRow37_100000000_f(groebnerMatrix,50);
  groebnerRow38_100000000_f(groebnerMatrix,50);
  groebnerRow39_100000000_f(groebnerMatrix,50);
  factor = groebnerMatrix(50,118);
  groebnerMatrix(50,118) = 0.0;
  groebnerMatrix(50,126) = groebnerMatrix(50,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(50,135) = groebnerMatrix(50,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(50,119);
  groebnerMatrix(50,119) = 0.0;
  groebnerMatrix(50,125) = groebnerMatrix(50,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(50,183) = groebnerMatrix(50,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(50,120);
  groebnerMatrix(50,120) = 0.0;
  groebnerMatrix(50,133) = groebnerMatrix(50,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(50,182) = groebnerMatrix(50,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(50,121);
  groebnerMatrix(50,121) = 0.0;
  groebnerMatrix(50,129) = groebnerMatrix(50,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(50,138) = groebnerMatrix(50,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(50,122);
  groebnerMatrix(50,122) = 0.0;
  groebnerMatrix(50,128) = groebnerMatrix(50,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(50,180) = groebnerMatrix(50,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(50,123);
  groebnerMatrix(50,123) = 0.0;
  groebnerMatrix(50,136) = groebnerMatrix(50,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(50,179) = groebnerMatrix(50,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(50,124);
  groebnerMatrix(50,124) = 0.0;
  groebnerMatrix(50,132) = groebnerMatrix(50,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(50,141) = groebnerMatrix(50,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(50,195) = groebnerMatrix(50,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,50);
  groebnerRow47_000000000_f(groebnerMatrix,50);
  factor = groebnerMatrix(50,127);
  groebnerMatrix(50,127) = 0.0;
  groebnerMatrix(50,134) = groebnerMatrix(50,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(50,181) = groebnerMatrix(50,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,50);
  groebnerRow49_000000000_f(groebnerMatrix,50);
  factor = -groebnerMatrix(50,130);
  groebnerMatrix(50,130) = 0.0;
  groebnerMatrix(50,137) = groebnerMatrix(50,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(50,178) = groebnerMatrix(50,178) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(50,142);
  groebnerMatrix(50,142) = 0.0;
  groebnerMatrix(50,144) = groebnerMatrix(50,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(50,147) = groebnerMatrix(50,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(50,196) = groebnerMatrix(50,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(50,144);
  groebnerMatrix(50,144) = 0.0;
  groebnerMatrix(50,156) = groebnerMatrix(50,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(50,177) = groebnerMatrix(50,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(50,196) = groebnerMatrix(50,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(50,146);
  groebnerMatrix(50,146) = 0.0;
  groebnerMatrix(50,161) = groebnerMatrix(50,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(50,185) = groebnerMatrix(50,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(50,147);
  groebnerMatrix(50,147) = 0.0;
  groebnerMatrix(50,162) = groebnerMatrix(50,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(50,186) = groebnerMatrix(50,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(50,196) = groebnerMatrix(50,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(50,148);
  groebnerMatrix(50,148) = 0.0;
  groebnerMatrix(50,153) = groebnerMatrix(50,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(50,159) = groebnerMatrix(50,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,50);
  groebnerRow31_000000000_f(groebnerMatrix,50);
  groebnerRow32_000000000_f(groebnerMatrix,50);
  groebnerRow33_000000000_f(groebnerMatrix,50);
  groebnerRow34_000000000_f(groebnerMatrix,50);
  groebnerRow35_000000000_f(groebnerMatrix,50);
  groebnerRow36_000000000_f(groebnerMatrix,50);
  groebnerRow37_000000000_f(groebnerMatrix,50);
  groebnerRow38_000000000_f(groebnerMatrix,50);
  groebnerRow39_000000000_f(groebnerMatrix,50);
  factor = groebnerMatrix(50,163);
  groebnerMatrix(50,163) = 0.0;
  groebnerMatrix(50,171) = groebnerMatrix(50,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(50,180) = groebnerMatrix(50,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(50,164);
  groebnerMatrix(50,164) = 0.0;
  groebnerMatrix(50,170) = groebnerMatrix(50,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(50,192) = groebnerMatrix(50,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(50,165);
  groebnerMatrix(50,165) = 0.0;
  groebnerMatrix(50,178) = groebnerMatrix(50,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(50,191) = groebnerMatrix(50,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(50,166);
  groebnerMatrix(50,166) = 0.0;
  groebnerMatrix(50,174) = groebnerMatrix(50,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(50,183) = groebnerMatrix(50,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(50,167);
  groebnerMatrix(50,167) = 0.0;
  groebnerMatrix(50,173) = groebnerMatrix(50,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(50,189) = groebnerMatrix(50,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(50,168);
  groebnerMatrix(50,168) = 0.0;
  groebnerMatrix(50,181) = groebnerMatrix(50,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(50,188) = groebnerMatrix(50,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(50,169);
  groebnerMatrix(50,169) = 0.0;
  groebnerMatrix(50,177) = groebnerMatrix(50,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(50,186) = groebnerMatrix(50,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(50,196) = groebnerMatrix(50,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(50,172);
  groebnerMatrix(50,172) = 0.0;
  groebnerMatrix(50,179) = groebnerMatrix(50,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(50,190) = groebnerMatrix(50,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(50,175);
  groebnerMatrix(50,175) = 0.0;
  groebnerMatrix(50,182) = groebnerMatrix(50,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(50,187) = groebnerMatrix(50,187) - factor * groebnerMatrix(18,187);

  sPolynomial51(groebnerMatrix);
  factor = groebnerMatrix(51,52);
  groebnerMatrix(51,52) = 0.0;
  groebnerMatrix(51,76) = groebnerMatrix(51,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(51,162) = groebnerMatrix(51,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(51,53);
  groebnerMatrix(51,53) = 0.0;
  groebnerMatrix(51,105) = groebnerMatrix(51,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(51,146) = groebnerMatrix(51,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(51,54);
  groebnerMatrix(51,54) = 0.0;
  groebnerMatrix(51,80) = groebnerMatrix(51,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(51,117) = groebnerMatrix(51,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(51,55);
  groebnerMatrix(51,55) = 0.0;
  groebnerMatrix(51,79) = groebnerMatrix(51,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(51,159) = groebnerMatrix(51,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(51,56);
  groebnerMatrix(51,56) = 0.0;
  groebnerMatrix(51,115) = groebnerMatrix(51,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(51,158) = groebnerMatrix(51,158) - factor * groebnerMatrix(27,188);
  factor = -groebnerMatrix(51,76);
  groebnerMatrix(51,76) = 0.0;
  groebnerMatrix(51,107) = groebnerMatrix(51,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,142) = groebnerMatrix(51,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(51,77);
  groebnerMatrix(51,77) = 0.0;
  groebnerMatrix(51,108) = groebnerMatrix(51,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,143) = groebnerMatrix(51,143) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(51,79);
  groebnerMatrix(51,79) = 0.0;
  groebnerMatrix(51,110) = groebnerMatrix(51,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,148) = groebnerMatrix(51,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(51,80);
  groebnerMatrix(51,80) = 0.0;
  groebnerMatrix(51,111) = groebnerMatrix(51,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,152) = groebnerMatrix(51,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(51,82);
  groebnerMatrix(51,82) = 0.0;
  groebnerMatrix(51,90) = groebnerMatrix(51,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(51,127) = groebnerMatrix(51,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(51,83);
  groebnerMatrix(51,83) = 0.0;
  groebnerMatrix(51,89) = groebnerMatrix(51,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(51,175) = groebnerMatrix(51,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(51,85);
  groebnerMatrix(51,85) = 0.0;
  groebnerMatrix(51,93) = groebnerMatrix(51,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(51,130) = groebnerMatrix(51,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(51,86);
  groebnerMatrix(51,86) = 0.0;
  groebnerMatrix(51,92) = groebnerMatrix(51,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(51,172) = groebnerMatrix(51,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(51,88);
  groebnerMatrix(51,88) = 0.0;
  groebnerMatrix(51,96) = groebnerMatrix(51,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(51,140) = groebnerMatrix(51,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(51,194) = groebnerMatrix(51,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,51);
  groebnerRow41_000000000_f(groebnerMatrix,51);
  groebnerRow42_000000000_f(groebnerMatrix,51);
  groebnerRow43_000000000_f(groebnerMatrix,51);
  groebnerRow44_000000000_f(groebnerMatrix,51);
  groebnerRow45_000000000_f(groebnerMatrix,51);
  factor = groebnerMatrix(51,105);
  groebnerMatrix(51,105) = 0.0;
  groebnerMatrix(51,112) = groebnerMatrix(51,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(51,185) = groebnerMatrix(51,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,51);
  groebnerRow31_100000000_f(groebnerMatrix,51);
  groebnerRow32_100000000_f(groebnerMatrix,51);
  groebnerRow33_100000000_f(groebnerMatrix,51);
  groebnerRow34_100000000_f(groebnerMatrix,51);
  groebnerRow35_100000000_f(groebnerMatrix,51);
  groebnerRow36_100000000_f(groebnerMatrix,51);
  groebnerRow37_100000000_f(groebnerMatrix,51);
  groebnerRow38_100000000_f(groebnerMatrix,51);
  groebnerRow39_100000000_f(groebnerMatrix,51);
  factor = groebnerMatrix(51,118);
  groebnerMatrix(51,118) = 0.0;
  groebnerMatrix(51,126) = groebnerMatrix(51,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(51,135) = groebnerMatrix(51,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(51,119);
  groebnerMatrix(51,119) = 0.0;
  groebnerMatrix(51,125) = groebnerMatrix(51,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(51,183) = groebnerMatrix(51,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(51,120);
  groebnerMatrix(51,120) = 0.0;
  groebnerMatrix(51,133) = groebnerMatrix(51,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(51,182) = groebnerMatrix(51,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(51,121);
  groebnerMatrix(51,121) = 0.0;
  groebnerMatrix(51,129) = groebnerMatrix(51,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(51,138) = groebnerMatrix(51,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(51,122);
  groebnerMatrix(51,122) = 0.0;
  groebnerMatrix(51,128) = groebnerMatrix(51,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(51,180) = groebnerMatrix(51,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(51,123);
  groebnerMatrix(51,123) = 0.0;
  groebnerMatrix(51,136) = groebnerMatrix(51,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(51,179) = groebnerMatrix(51,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(51,124);
  groebnerMatrix(51,124) = 0.0;
  groebnerMatrix(51,132) = groebnerMatrix(51,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(51,141) = groebnerMatrix(51,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(51,195) = groebnerMatrix(51,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,51);
  groebnerRow47_000000000_f(groebnerMatrix,51);
  factor = groebnerMatrix(51,127);
  groebnerMatrix(51,127) = 0.0;
  groebnerMatrix(51,134) = groebnerMatrix(51,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(51,181) = groebnerMatrix(51,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,51);
  groebnerRow49_000000000_f(groebnerMatrix,51);
  factor = -groebnerMatrix(51,130);
  groebnerMatrix(51,130) = 0.0;
  groebnerMatrix(51,137) = groebnerMatrix(51,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,178) = groebnerMatrix(51,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,51);
  factor = groebnerMatrix(51,142);
  groebnerMatrix(51,142) = 0.0;
  groebnerMatrix(51,144) = groebnerMatrix(51,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(51,147) = groebnerMatrix(51,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(51,196) = groebnerMatrix(51,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(51,143);
  groebnerMatrix(51,143) = 0.0;
  groebnerMatrix(51,155) = groebnerMatrix(51,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(51,176) = groebnerMatrix(51,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(51,144);
  groebnerMatrix(51,144) = 0.0;
  groebnerMatrix(51,156) = groebnerMatrix(51,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(51,177) = groebnerMatrix(51,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(51,196) = groebnerMatrix(51,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(51,146);
  groebnerMatrix(51,146) = 0.0;
  groebnerMatrix(51,161) = groebnerMatrix(51,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(51,185) = groebnerMatrix(51,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(51,147);
  groebnerMatrix(51,147) = 0.0;
  groebnerMatrix(51,162) = groebnerMatrix(51,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(51,186) = groebnerMatrix(51,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(51,196) = groebnerMatrix(51,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(51,148);
  groebnerMatrix(51,148) = 0.0;
  groebnerMatrix(51,153) = groebnerMatrix(51,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(51,159) = groebnerMatrix(51,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,51);
  groebnerRow31_000000000_f(groebnerMatrix,51);
  groebnerRow32_000000000_f(groebnerMatrix,51);
  groebnerRow33_000000000_f(groebnerMatrix,51);
  groebnerRow34_000000000_f(groebnerMatrix,51);
  groebnerRow35_000000000_f(groebnerMatrix,51);
  groebnerRow36_000000000_f(groebnerMatrix,51);
  groebnerRow37_000000000_f(groebnerMatrix,51);
  groebnerRow38_000000000_f(groebnerMatrix,51);
  groebnerRow39_000000000_f(groebnerMatrix,51);
  factor = groebnerMatrix(51,163);
  groebnerMatrix(51,163) = 0.0;
  groebnerMatrix(51,171) = groebnerMatrix(51,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(51,180) = groebnerMatrix(51,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(51,164);
  groebnerMatrix(51,164) = 0.0;
  groebnerMatrix(51,170) = groebnerMatrix(51,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(51,192) = groebnerMatrix(51,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(51,165);
  groebnerMatrix(51,165) = 0.0;
  groebnerMatrix(51,178) = groebnerMatrix(51,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(51,191) = groebnerMatrix(51,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(51,166);
  groebnerMatrix(51,166) = 0.0;
  groebnerMatrix(51,174) = groebnerMatrix(51,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(51,183) = groebnerMatrix(51,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(51,167);
  groebnerMatrix(51,167) = 0.0;
  groebnerMatrix(51,173) = groebnerMatrix(51,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(51,189) = groebnerMatrix(51,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(51,168);
  groebnerMatrix(51,168) = 0.0;
  groebnerMatrix(51,181) = groebnerMatrix(51,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(51,188) = groebnerMatrix(51,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(51,169);
  groebnerMatrix(51,169) = 0.0;
  groebnerMatrix(51,177) = groebnerMatrix(51,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(51,186) = groebnerMatrix(51,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(51,196) = groebnerMatrix(51,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(51,172);
  groebnerMatrix(51,172) = 0.0;
  groebnerMatrix(51,179) = groebnerMatrix(51,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(51,190) = groebnerMatrix(51,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(51,175);
  groebnerMatrix(51,175) = 0.0;
  groebnerMatrix(51,182) = groebnerMatrix(51,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(51,187) = groebnerMatrix(51,187) - factor * groebnerMatrix(18,187);

  sPolynomial52(groebnerMatrix);
  factor = groebnerMatrix(52,51);
  groebnerMatrix(52,51) = 0.0;
  groebnerMatrix(52,77) = groebnerMatrix(52,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(52,114) = groebnerMatrix(52,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(52,52);
  groebnerMatrix(52,52) = 0.0;
  groebnerMatrix(52,76) = groebnerMatrix(52,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(52,162) = groebnerMatrix(52,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(52,53);
  groebnerMatrix(52,53) = 0.0;
  groebnerMatrix(52,105) = groebnerMatrix(52,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(52,146) = groebnerMatrix(52,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(52,54);
  groebnerMatrix(52,54) = 0.0;
  groebnerMatrix(52,80) = groebnerMatrix(52,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(52,117) = groebnerMatrix(52,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(52,55);
  groebnerMatrix(52,55) = 0.0;
  groebnerMatrix(52,79) = groebnerMatrix(52,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(52,159) = groebnerMatrix(52,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(52,56);
  groebnerMatrix(52,56) = 0.0;
  groebnerMatrix(52,115) = groebnerMatrix(52,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(52,158) = groebnerMatrix(52,158) - factor * groebnerMatrix(27,188);
  groebnerRow32_010000000_f(groebnerMatrix,52);
  groebnerRow33_010000000_f(groebnerMatrix,52);
  factor = -groebnerMatrix(52,76);
  groebnerMatrix(52,76) = 0.0;
  groebnerMatrix(52,107) = groebnerMatrix(52,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,142) = groebnerMatrix(52,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(52,77);
  groebnerMatrix(52,77) = 0.0;
  groebnerMatrix(52,108) = groebnerMatrix(52,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,143) = groebnerMatrix(52,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(52,78);
  groebnerMatrix(52,78) = 0.0;
  groebnerMatrix(52,113) = groebnerMatrix(52,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(52,160) = groebnerMatrix(52,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(52,79);
  groebnerMatrix(52,79) = 0.0;
  groebnerMatrix(52,110) = groebnerMatrix(52,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,148) = groebnerMatrix(52,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(52,80);
  groebnerMatrix(52,80) = 0.0;
  groebnerMatrix(52,111) = groebnerMatrix(52,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,152) = groebnerMatrix(52,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(52,81);
  groebnerMatrix(52,81) = 0.0;
  groebnerMatrix(52,116) = groebnerMatrix(52,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,157) = groebnerMatrix(52,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(52,82);
  groebnerMatrix(52,82) = 0.0;
  groebnerMatrix(52,90) = groebnerMatrix(52,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(52,127) = groebnerMatrix(52,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(52,83);
  groebnerMatrix(52,83) = 0.0;
  groebnerMatrix(52,89) = groebnerMatrix(52,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(52,175) = groebnerMatrix(52,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(52,85);
  groebnerMatrix(52,85) = 0.0;
  groebnerMatrix(52,93) = groebnerMatrix(52,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(52,130) = groebnerMatrix(52,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(52,86);
  groebnerMatrix(52,86) = 0.0;
  groebnerMatrix(52,92) = groebnerMatrix(52,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(52,172) = groebnerMatrix(52,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(52,88);
  groebnerMatrix(52,88) = 0.0;
  groebnerMatrix(52,96) = groebnerMatrix(52,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(52,140) = groebnerMatrix(52,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(52,194) = groebnerMatrix(52,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,52);
  groebnerRow41_000000000_f(groebnerMatrix,52);
  groebnerRow42_000000000_f(groebnerMatrix,52);
  groebnerRow43_000000000_f(groebnerMatrix,52);
  groebnerRow44_000000000_f(groebnerMatrix,52);
  groebnerRow45_000000000_f(groebnerMatrix,52);
  factor = groebnerMatrix(52,105);
  groebnerMatrix(52,105) = 0.0;
  groebnerMatrix(52,112) = groebnerMatrix(52,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(52,185) = groebnerMatrix(52,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,52);
  groebnerRow31_100000000_f(groebnerMatrix,52);
  groebnerRow32_100000000_f(groebnerMatrix,52);
  groebnerRow33_100000000_f(groebnerMatrix,52);
  groebnerRow34_100000000_f(groebnerMatrix,52);
  groebnerRow35_100000000_f(groebnerMatrix,52);
  groebnerRow36_100000000_f(groebnerMatrix,52);
  groebnerRow37_100000000_f(groebnerMatrix,52);
  groebnerRow38_100000000_f(groebnerMatrix,52);
  groebnerRow39_100000000_f(groebnerMatrix,52);
  factor = groebnerMatrix(52,118);
  groebnerMatrix(52,118) = 0.0;
  groebnerMatrix(52,126) = groebnerMatrix(52,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(52,135) = groebnerMatrix(52,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(52,119);
  groebnerMatrix(52,119) = 0.0;
  groebnerMatrix(52,125) = groebnerMatrix(52,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(52,183) = groebnerMatrix(52,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(52,120);
  groebnerMatrix(52,120) = 0.0;
  groebnerMatrix(52,133) = groebnerMatrix(52,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(52,182) = groebnerMatrix(52,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(52,121);
  groebnerMatrix(52,121) = 0.0;
  groebnerMatrix(52,129) = groebnerMatrix(52,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(52,138) = groebnerMatrix(52,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(52,122);
  groebnerMatrix(52,122) = 0.0;
  groebnerMatrix(52,128) = groebnerMatrix(52,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(52,180) = groebnerMatrix(52,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(52,123);
  groebnerMatrix(52,123) = 0.0;
  groebnerMatrix(52,136) = groebnerMatrix(52,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(52,179) = groebnerMatrix(52,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(52,124);
  groebnerMatrix(52,124) = 0.0;
  groebnerMatrix(52,132) = groebnerMatrix(52,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(52,141) = groebnerMatrix(52,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(52,195) = groebnerMatrix(52,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,52);
  groebnerRow47_000000000_f(groebnerMatrix,52);
  factor = groebnerMatrix(52,127);
  groebnerMatrix(52,127) = 0.0;
  groebnerMatrix(52,134) = groebnerMatrix(52,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(52,181) = groebnerMatrix(52,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,52);
  groebnerRow49_000000000_f(groebnerMatrix,52);
  factor = -groebnerMatrix(52,130);
  groebnerMatrix(52,130) = 0.0;
  groebnerMatrix(52,137) = groebnerMatrix(52,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,178) = groebnerMatrix(52,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,52);
  groebnerRow51_000000000_f(groebnerMatrix,52);
  factor = groebnerMatrix(52,142);
  groebnerMatrix(52,142) = 0.0;
  groebnerMatrix(52,144) = groebnerMatrix(52,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(52,147) = groebnerMatrix(52,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(52,196) = groebnerMatrix(52,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(52,143);
  groebnerMatrix(52,143) = 0.0;
  groebnerMatrix(52,155) = groebnerMatrix(52,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(52,176) = groebnerMatrix(52,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(52,144);
  groebnerMatrix(52,144) = 0.0;
  groebnerMatrix(52,156) = groebnerMatrix(52,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(52,177) = groebnerMatrix(52,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(52,196) = groebnerMatrix(52,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(52,146);
  groebnerMatrix(52,146) = 0.0;
  groebnerMatrix(52,161) = groebnerMatrix(52,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(52,185) = groebnerMatrix(52,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(52,147);
  groebnerMatrix(52,147) = 0.0;
  groebnerMatrix(52,162) = groebnerMatrix(52,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(52,186) = groebnerMatrix(52,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(52,196) = groebnerMatrix(52,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(52,148);
  groebnerMatrix(52,148) = 0.0;
  groebnerMatrix(52,153) = groebnerMatrix(52,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(52,159) = groebnerMatrix(52,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,52);
  groebnerRow31_000000000_f(groebnerMatrix,52);
  factor = -groebnerMatrix(52,154);
  groebnerMatrix(52,154) = 0.0;
  groebnerMatrix(52,158) = groebnerMatrix(52,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(52,193) = groebnerMatrix(52,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,52);
  groebnerRow33_000000000_f(groebnerMatrix,52);
  groebnerRow34_000000000_f(groebnerMatrix,52);
  groebnerRow35_000000000_f(groebnerMatrix,52);
  groebnerRow36_000000000_f(groebnerMatrix,52);
  groebnerRow37_000000000_f(groebnerMatrix,52);
  groebnerRow38_000000000_f(groebnerMatrix,52);
  groebnerRow39_000000000_f(groebnerMatrix,52);
  factor = groebnerMatrix(52,163);
  groebnerMatrix(52,163) = 0.0;
  groebnerMatrix(52,171) = groebnerMatrix(52,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(52,180) = groebnerMatrix(52,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(52,164);
  groebnerMatrix(52,164) = 0.0;
  groebnerMatrix(52,170) = groebnerMatrix(52,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(52,192) = groebnerMatrix(52,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(52,165);
  groebnerMatrix(52,165) = 0.0;
  groebnerMatrix(52,178) = groebnerMatrix(52,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(52,191) = groebnerMatrix(52,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(52,166);
  groebnerMatrix(52,166) = 0.0;
  groebnerMatrix(52,174) = groebnerMatrix(52,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(52,183) = groebnerMatrix(52,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(52,167);
  groebnerMatrix(52,167) = 0.0;
  groebnerMatrix(52,173) = groebnerMatrix(52,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(52,189) = groebnerMatrix(52,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(52,168);
  groebnerMatrix(52,168) = 0.0;
  groebnerMatrix(52,181) = groebnerMatrix(52,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(52,188) = groebnerMatrix(52,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(52,169);
  groebnerMatrix(52,169) = 0.0;
  groebnerMatrix(52,177) = groebnerMatrix(52,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(52,186) = groebnerMatrix(52,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(52,196) = groebnerMatrix(52,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(52,172);
  groebnerMatrix(52,172) = 0.0;
  groebnerMatrix(52,179) = groebnerMatrix(52,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(52,190) = groebnerMatrix(52,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(52,175);
  groebnerMatrix(52,175) = 0.0;
  groebnerMatrix(52,182) = groebnerMatrix(52,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(52,187) = groebnerMatrix(52,187) - factor * groebnerMatrix(18,187);

  sPolynomial53(groebnerMatrix);
  factor = -groebnerMatrix(53,50);
  groebnerMatrix(53,50) = 0.0;
  groebnerMatrix(53,74) = groebnerMatrix(53,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(53,154) = groebnerMatrix(53,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(53,51);
  groebnerMatrix(53,51) = 0.0;
  groebnerMatrix(53,77) = groebnerMatrix(53,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(53,114) = groebnerMatrix(53,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(53,52);
  groebnerMatrix(53,52) = 0.0;
  groebnerMatrix(53,76) = groebnerMatrix(53,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(53,162) = groebnerMatrix(53,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(53,53);
  groebnerMatrix(53,53) = 0.0;
  groebnerMatrix(53,105) = groebnerMatrix(53,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(53,146) = groebnerMatrix(53,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(53,54);
  groebnerMatrix(53,54) = 0.0;
  groebnerMatrix(53,80) = groebnerMatrix(53,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(53,117) = groebnerMatrix(53,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(53,55);
  groebnerMatrix(53,55) = 0.0;
  groebnerMatrix(53,79) = groebnerMatrix(53,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(53,159) = groebnerMatrix(53,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(53,56);
  groebnerMatrix(53,56) = 0.0;
  groebnerMatrix(53,115) = groebnerMatrix(53,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(53,158) = groebnerMatrix(53,158) - factor * groebnerMatrix(27,188);
  groebnerRow32_010000000_f(groebnerMatrix,53);
  groebnerRow33_010000000_f(groebnerMatrix,53);
  factor = -groebnerMatrix(53,76);
  groebnerMatrix(53,76) = 0.0;
  groebnerMatrix(53,107) = groebnerMatrix(53,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,142) = groebnerMatrix(53,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(53,77);
  groebnerMatrix(53,77) = 0.0;
  groebnerMatrix(53,108) = groebnerMatrix(53,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,143) = groebnerMatrix(53,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(53,78);
  groebnerMatrix(53,78) = 0.0;
  groebnerMatrix(53,113) = groebnerMatrix(53,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(53,160) = groebnerMatrix(53,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(53,79);
  groebnerMatrix(53,79) = 0.0;
  groebnerMatrix(53,110) = groebnerMatrix(53,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,148) = groebnerMatrix(53,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(53,80);
  groebnerMatrix(53,80) = 0.0;
  groebnerMatrix(53,111) = groebnerMatrix(53,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,152) = groebnerMatrix(53,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(53,81);
  groebnerMatrix(53,81) = 0.0;
  groebnerMatrix(53,116) = groebnerMatrix(53,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,157) = groebnerMatrix(53,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(53,82);
  groebnerMatrix(53,82) = 0.0;
  groebnerMatrix(53,90) = groebnerMatrix(53,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(53,127) = groebnerMatrix(53,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(53,83);
  groebnerMatrix(53,83) = 0.0;
  groebnerMatrix(53,89) = groebnerMatrix(53,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(53,175) = groebnerMatrix(53,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(53,85);
  groebnerMatrix(53,85) = 0.0;
  groebnerMatrix(53,93) = groebnerMatrix(53,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(53,130) = groebnerMatrix(53,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(53,86);
  groebnerMatrix(53,86) = 0.0;
  groebnerMatrix(53,92) = groebnerMatrix(53,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(53,172) = groebnerMatrix(53,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(53,88);
  groebnerMatrix(53,88) = 0.0;
  groebnerMatrix(53,96) = groebnerMatrix(53,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(53,140) = groebnerMatrix(53,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(53,194) = groebnerMatrix(53,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,53);
  groebnerRow41_000000000_f(groebnerMatrix,53);
  groebnerRow42_000000000_f(groebnerMatrix,53);
  groebnerRow43_000000000_f(groebnerMatrix,53);
  groebnerRow44_000000000_f(groebnerMatrix,53);
  groebnerRow45_000000000_f(groebnerMatrix,53);
  factor = groebnerMatrix(53,105);
  groebnerMatrix(53,105) = 0.0;
  groebnerMatrix(53,112) = groebnerMatrix(53,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(53,185) = groebnerMatrix(53,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,53);
  groebnerRow31_100000000_f(groebnerMatrix,53);
  groebnerRow32_100000000_f(groebnerMatrix,53);
  groebnerRow33_100000000_f(groebnerMatrix,53);
  groebnerRow34_100000000_f(groebnerMatrix,53);
  groebnerRow35_100000000_f(groebnerMatrix,53);
  groebnerRow36_100000000_f(groebnerMatrix,53);
  groebnerRow37_100000000_f(groebnerMatrix,53);
  groebnerRow38_100000000_f(groebnerMatrix,53);
  groebnerRow39_100000000_f(groebnerMatrix,53);
  factor = groebnerMatrix(53,118);
  groebnerMatrix(53,118) = 0.0;
  groebnerMatrix(53,126) = groebnerMatrix(53,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(53,135) = groebnerMatrix(53,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(53,119);
  groebnerMatrix(53,119) = 0.0;
  groebnerMatrix(53,125) = groebnerMatrix(53,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(53,183) = groebnerMatrix(53,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(53,120);
  groebnerMatrix(53,120) = 0.0;
  groebnerMatrix(53,133) = groebnerMatrix(53,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(53,182) = groebnerMatrix(53,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(53,121);
  groebnerMatrix(53,121) = 0.0;
  groebnerMatrix(53,129) = groebnerMatrix(53,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(53,138) = groebnerMatrix(53,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(53,122);
  groebnerMatrix(53,122) = 0.0;
  groebnerMatrix(53,128) = groebnerMatrix(53,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(53,180) = groebnerMatrix(53,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(53,123);
  groebnerMatrix(53,123) = 0.0;
  groebnerMatrix(53,136) = groebnerMatrix(53,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(53,179) = groebnerMatrix(53,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(53,124);
  groebnerMatrix(53,124) = 0.0;
  groebnerMatrix(53,132) = groebnerMatrix(53,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(53,141) = groebnerMatrix(53,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(53,195) = groebnerMatrix(53,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,53);
  groebnerRow47_000000000_f(groebnerMatrix,53);
  factor = groebnerMatrix(53,127);
  groebnerMatrix(53,127) = 0.0;
  groebnerMatrix(53,134) = groebnerMatrix(53,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(53,181) = groebnerMatrix(53,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,53);
  groebnerRow49_000000000_f(groebnerMatrix,53);
  factor = -groebnerMatrix(53,130);
  groebnerMatrix(53,130) = 0.0;
  groebnerMatrix(53,137) = groebnerMatrix(53,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,178) = groebnerMatrix(53,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,53);
  groebnerRow51_000000000_f(groebnerMatrix,53);
  groebnerRow52_000000000_f(groebnerMatrix,53);
  factor = groebnerMatrix(53,142);
  groebnerMatrix(53,142) = 0.0;
  groebnerMatrix(53,144) = groebnerMatrix(53,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(53,147) = groebnerMatrix(53,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(53,196) = groebnerMatrix(53,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(53,143);
  groebnerMatrix(53,143) = 0.0;
  groebnerMatrix(53,155) = groebnerMatrix(53,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(53,176) = groebnerMatrix(53,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(53,144);
  groebnerMatrix(53,144) = 0.0;
  groebnerMatrix(53,156) = groebnerMatrix(53,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(53,177) = groebnerMatrix(53,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(53,196) = groebnerMatrix(53,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(53,146);
  groebnerMatrix(53,146) = 0.0;
  groebnerMatrix(53,161) = groebnerMatrix(53,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(53,185) = groebnerMatrix(53,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(53,147);
  groebnerMatrix(53,147) = 0.0;
  groebnerMatrix(53,162) = groebnerMatrix(53,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(53,186) = groebnerMatrix(53,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(53,196) = groebnerMatrix(53,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(53,148);
  groebnerMatrix(53,148) = 0.0;
  groebnerMatrix(53,153) = groebnerMatrix(53,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(53,159) = groebnerMatrix(53,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,53);
  groebnerRow31_000000000_f(groebnerMatrix,53);
  factor = -groebnerMatrix(53,154);
  groebnerMatrix(53,154) = 0.0;
  groebnerMatrix(53,158) = groebnerMatrix(53,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(53,193) = groebnerMatrix(53,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,53);
  groebnerRow33_000000000_f(groebnerMatrix,53);
  groebnerRow34_000000000_f(groebnerMatrix,53);
  groebnerRow35_000000000_f(groebnerMatrix,53);
  groebnerRow36_000000000_f(groebnerMatrix,53);
  groebnerRow37_000000000_f(groebnerMatrix,53);
  groebnerRow38_000000000_f(groebnerMatrix,53);
  groebnerRow39_000000000_f(groebnerMatrix,53);
  factor = groebnerMatrix(53,163);
  groebnerMatrix(53,163) = 0.0;
  groebnerMatrix(53,171) = groebnerMatrix(53,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(53,180) = groebnerMatrix(53,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(53,164);
  groebnerMatrix(53,164) = 0.0;
  groebnerMatrix(53,170) = groebnerMatrix(53,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(53,192) = groebnerMatrix(53,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(53,165);
  groebnerMatrix(53,165) = 0.0;
  groebnerMatrix(53,178) = groebnerMatrix(53,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(53,191) = groebnerMatrix(53,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(53,166);
  groebnerMatrix(53,166) = 0.0;
  groebnerMatrix(53,174) = groebnerMatrix(53,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(53,183) = groebnerMatrix(53,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(53,167);
  groebnerMatrix(53,167) = 0.0;
  groebnerMatrix(53,173) = groebnerMatrix(53,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(53,189) = groebnerMatrix(53,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(53,168);
  groebnerMatrix(53,168) = 0.0;
  groebnerMatrix(53,181) = groebnerMatrix(53,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(53,188) = groebnerMatrix(53,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(53,169);
  groebnerMatrix(53,169) = 0.0;
  groebnerMatrix(53,177) = groebnerMatrix(53,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(53,186) = groebnerMatrix(53,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(53,196) = groebnerMatrix(53,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(53,172);
  groebnerMatrix(53,172) = 0.0;
  groebnerMatrix(53,179) = groebnerMatrix(53,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(53,190) = groebnerMatrix(53,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(53,175);
  groebnerMatrix(53,175) = 0.0;
  groebnerMatrix(53,182) = groebnerMatrix(53,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(53,187) = groebnerMatrix(53,187) - factor * groebnerMatrix(18,187);

  sPolynomial54(groebnerMatrix);
  factor = groebnerMatrix(54,49);
  groebnerMatrix(54,49) = 0.0;
  groebnerMatrix(54,75) = groebnerMatrix(54,75) - factor * groebnerMatrix(11,174);
  groebnerMatrix(54,116) = groebnerMatrix(54,116) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(54,50);
  groebnerMatrix(54,50) = 0.0;
  groebnerMatrix(54,74) = groebnerMatrix(54,74) - factor * groebnerMatrix(21,173);
  groebnerMatrix(54,154) = groebnerMatrix(54,154) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(54,51);
  groebnerMatrix(54,51) = 0.0;
  groebnerMatrix(54,77) = groebnerMatrix(54,77) - factor * groebnerMatrix(12,171);
  groebnerMatrix(54,114) = groebnerMatrix(54,114) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(54,52);
  groebnerMatrix(54,52) = 0.0;
  groebnerMatrix(54,76) = groebnerMatrix(54,76) - factor * groebnerMatrix(20,170);
  groebnerMatrix(54,162) = groebnerMatrix(54,162) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(54,53);
  groebnerMatrix(54,53) = 0.0;
  groebnerMatrix(54,105) = groebnerMatrix(54,105) - factor * groebnerMatrix(27,181);
  groebnerMatrix(54,146) = groebnerMatrix(54,146) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(54,54);
  groebnerMatrix(54,54) = 0.0;
  groebnerMatrix(54,80) = groebnerMatrix(54,80) - factor * groebnerMatrix(11,174);
  groebnerMatrix(54,117) = groebnerMatrix(54,117) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(54,55);
  groebnerMatrix(54,55) = 0.0;
  groebnerMatrix(54,79) = groebnerMatrix(54,79) - factor * groebnerMatrix(21,173);
  groebnerMatrix(54,159) = groebnerMatrix(54,159) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(54,56);
  groebnerMatrix(54,56) = 0.0;
  groebnerMatrix(54,115) = groebnerMatrix(54,115) - factor * groebnerMatrix(27,181);
  groebnerMatrix(54,158) = groebnerMatrix(54,158) - factor * groebnerMatrix(27,188);
  groebnerRow30_010000000_f(groebnerMatrix,54);
  groebnerRow31_010000000_f(groebnerMatrix,54);
  groebnerRow32_010000000_f(groebnerMatrix,54);
  groebnerRow33_010000000_f(groebnerMatrix,54);
  factor = -groebnerMatrix(54,76);
  groebnerMatrix(54,76) = 0.0;
  groebnerMatrix(54,107) = groebnerMatrix(54,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,142) = groebnerMatrix(54,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(54,77);
  groebnerMatrix(54,77) = 0.0;
  groebnerMatrix(54,108) = groebnerMatrix(54,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,143) = groebnerMatrix(54,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(54,78);
  groebnerMatrix(54,78) = 0.0;
  groebnerMatrix(54,113) = groebnerMatrix(54,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(54,160) = groebnerMatrix(54,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(54,79);
  groebnerMatrix(54,79) = 0.0;
  groebnerMatrix(54,110) = groebnerMatrix(54,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,148) = groebnerMatrix(54,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(54,80);
  groebnerMatrix(54,80) = 0.0;
  groebnerMatrix(54,111) = groebnerMatrix(54,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,152) = groebnerMatrix(54,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(54,81);
  groebnerMatrix(54,81) = 0.0;
  groebnerMatrix(54,116) = groebnerMatrix(54,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,157) = groebnerMatrix(54,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(54,82);
  groebnerMatrix(54,82) = 0.0;
  groebnerMatrix(54,90) = groebnerMatrix(54,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(54,127) = groebnerMatrix(54,127) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(54,83);
  groebnerMatrix(54,83) = 0.0;
  groebnerMatrix(54,89) = groebnerMatrix(54,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(54,175) = groebnerMatrix(54,175) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(54,85);
  groebnerMatrix(54,85) = 0.0;
  groebnerMatrix(54,93) = groebnerMatrix(54,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(54,130) = groebnerMatrix(54,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(54,86);
  groebnerMatrix(54,86) = 0.0;
  groebnerMatrix(54,92) = groebnerMatrix(54,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(54,172) = groebnerMatrix(54,172) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(54,88);
  groebnerMatrix(54,88) = 0.0;
  groebnerMatrix(54,96) = groebnerMatrix(54,96) - factor * groebnerMatrix(10,177);
  groebnerMatrix(54,140) = groebnerMatrix(54,140) - factor * groebnerMatrix(10,186);
  groebnerMatrix(54,194) = groebnerMatrix(54,194) - factor * groebnerMatrix(10,196);
  groebnerRow40_000000000_f(groebnerMatrix,54);
  groebnerRow41_000000000_f(groebnerMatrix,54);
  groebnerRow42_000000000_f(groebnerMatrix,54);
  groebnerRow43_000000000_f(groebnerMatrix,54);
  groebnerRow44_000000000_f(groebnerMatrix,54);
  groebnerRow45_000000000_f(groebnerMatrix,54);
  factor = groebnerMatrix(54,105);
  groebnerMatrix(54,105) = 0.0;
  groebnerMatrix(54,112) = groebnerMatrix(54,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(54,185) = groebnerMatrix(54,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,54);
  groebnerRow31_100000000_f(groebnerMatrix,54);
  groebnerRow32_100000000_f(groebnerMatrix,54);
  groebnerRow33_100000000_f(groebnerMatrix,54);
  groebnerRow34_100000000_f(groebnerMatrix,54);
  groebnerRow35_100000000_f(groebnerMatrix,54);
  groebnerRow36_100000000_f(groebnerMatrix,54);
  groebnerRow37_100000000_f(groebnerMatrix,54);
  groebnerRow38_100000000_f(groebnerMatrix,54);
  groebnerRow39_100000000_f(groebnerMatrix,54);
  factor = groebnerMatrix(54,118);
  groebnerMatrix(54,118) = 0.0;
  groebnerMatrix(54,126) = groebnerMatrix(54,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(54,135) = groebnerMatrix(54,135) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(54,119);
  groebnerMatrix(54,119) = 0.0;
  groebnerMatrix(54,125) = groebnerMatrix(54,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(54,183) = groebnerMatrix(54,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(54,120);
  groebnerMatrix(54,120) = 0.0;
  groebnerMatrix(54,133) = groebnerMatrix(54,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(54,182) = groebnerMatrix(54,182) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(54,121);
  groebnerMatrix(54,121) = 0.0;
  groebnerMatrix(54,129) = groebnerMatrix(54,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(54,138) = groebnerMatrix(54,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(54,122);
  groebnerMatrix(54,122) = 0.0;
  groebnerMatrix(54,128) = groebnerMatrix(54,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(54,180) = groebnerMatrix(54,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(54,123);
  groebnerMatrix(54,123) = 0.0;
  groebnerMatrix(54,136) = groebnerMatrix(54,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(54,179) = groebnerMatrix(54,179) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(54,124);
  groebnerMatrix(54,124) = 0.0;
  groebnerMatrix(54,132) = groebnerMatrix(54,132) - factor * groebnerMatrix(10,177);
  groebnerMatrix(54,141) = groebnerMatrix(54,141) - factor * groebnerMatrix(10,186);
  groebnerMatrix(54,195) = groebnerMatrix(54,195) - factor * groebnerMatrix(10,196);
  groebnerRow46_000000000_f(groebnerMatrix,54);
  groebnerRow47_000000000_f(groebnerMatrix,54);
  factor = groebnerMatrix(54,127);
  groebnerMatrix(54,127) = 0.0;
  groebnerMatrix(54,134) = groebnerMatrix(54,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(54,181) = groebnerMatrix(54,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,54);
  groebnerRow49_000000000_f(groebnerMatrix,54);
  factor = -groebnerMatrix(54,130);
  groebnerMatrix(54,130) = 0.0;
  groebnerMatrix(54,137) = groebnerMatrix(54,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,178) = groebnerMatrix(54,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,54);
  groebnerRow51_000000000_f(groebnerMatrix,54);
  groebnerRow52_000000000_f(groebnerMatrix,54);
  groebnerRow53_000000000_f(groebnerMatrix,54);
  factor = groebnerMatrix(54,142);
  groebnerMatrix(54,142) = 0.0;
  groebnerMatrix(54,144) = groebnerMatrix(54,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(54,147) = groebnerMatrix(54,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(54,196) = groebnerMatrix(54,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(54,143);
  groebnerMatrix(54,143) = 0.0;
  groebnerMatrix(54,155) = groebnerMatrix(54,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(54,176) = groebnerMatrix(54,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(54,144);
  groebnerMatrix(54,144) = 0.0;
  groebnerMatrix(54,156) = groebnerMatrix(54,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(54,177) = groebnerMatrix(54,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(54,196) = groebnerMatrix(54,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(54,146);
  groebnerMatrix(54,146) = 0.0;
  groebnerMatrix(54,161) = groebnerMatrix(54,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(54,185) = groebnerMatrix(54,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(54,147);
  groebnerMatrix(54,147) = 0.0;
  groebnerMatrix(54,162) = groebnerMatrix(54,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(54,186) = groebnerMatrix(54,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(54,196) = groebnerMatrix(54,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(54,148);
  groebnerMatrix(54,148) = 0.0;
  groebnerMatrix(54,153) = groebnerMatrix(54,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(54,159) = groebnerMatrix(54,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,54);
  groebnerRow31_000000000_f(groebnerMatrix,54);
  factor = -groebnerMatrix(54,154);
  groebnerMatrix(54,154) = 0.0;
  groebnerMatrix(54,158) = groebnerMatrix(54,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(54,193) = groebnerMatrix(54,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,54);
  groebnerRow33_000000000_f(groebnerMatrix,54);
  groebnerRow34_000000000_f(groebnerMatrix,54);
  groebnerRow35_000000000_f(groebnerMatrix,54);
  groebnerRow36_000000000_f(groebnerMatrix,54);
  groebnerRow37_000000000_f(groebnerMatrix,54);
  groebnerRow38_000000000_f(groebnerMatrix,54);
  groebnerRow39_000000000_f(groebnerMatrix,54);
  factor = groebnerMatrix(54,163);
  groebnerMatrix(54,163) = 0.0;
  groebnerMatrix(54,171) = groebnerMatrix(54,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(54,180) = groebnerMatrix(54,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(54,164);
  groebnerMatrix(54,164) = 0.0;
  groebnerMatrix(54,170) = groebnerMatrix(54,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(54,192) = groebnerMatrix(54,192) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(54,165);
  groebnerMatrix(54,165) = 0.0;
  groebnerMatrix(54,178) = groebnerMatrix(54,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(54,191) = groebnerMatrix(54,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(54,166);
  groebnerMatrix(54,166) = 0.0;
  groebnerMatrix(54,174) = groebnerMatrix(54,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(54,183) = groebnerMatrix(54,183) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(54,167);
  groebnerMatrix(54,167) = 0.0;
  groebnerMatrix(54,173) = groebnerMatrix(54,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(54,189) = groebnerMatrix(54,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(54,168);
  groebnerMatrix(54,168) = 0.0;
  groebnerMatrix(54,181) = groebnerMatrix(54,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(54,188) = groebnerMatrix(54,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(54,169);
  groebnerMatrix(54,169) = 0.0;
  groebnerMatrix(54,177) = groebnerMatrix(54,177) - factor * groebnerMatrix(10,177);
  groebnerMatrix(54,186) = groebnerMatrix(54,186) - factor * groebnerMatrix(10,186);
  groebnerMatrix(54,196) = groebnerMatrix(54,196) - factor * groebnerMatrix(10,196);
  factor = groebnerMatrix(54,172);
  groebnerMatrix(54,172) = 0.0;
  groebnerMatrix(54,179) = groebnerMatrix(54,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(54,190) = groebnerMatrix(54,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(54,175);
  groebnerMatrix(54,175) = 0.0;
  groebnerMatrix(54,182) = groebnerMatrix(54,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(54,187) = groebnerMatrix(54,187) - factor * groebnerMatrix(18,187);

  sPolynomial55(groebnerMatrix);
  groebnerRow39_000100000_f(groebnerMatrix,55);
  groebnerRow30_010000000_f(groebnerMatrix,55);
  groebnerRow31_010000000_f(groebnerMatrix,55);
  groebnerRow32_010000000_f(groebnerMatrix,55);
  groebnerRow33_010000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,76);
  groebnerMatrix(55,76) = 0.0;
  groebnerMatrix(55,107) = groebnerMatrix(55,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,142) = groebnerMatrix(55,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(55,77);
  groebnerMatrix(55,77) = 0.0;
  groebnerMatrix(55,108) = groebnerMatrix(55,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,143) = groebnerMatrix(55,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(55,78);
  groebnerMatrix(55,78) = 0.0;
  groebnerMatrix(55,113) = groebnerMatrix(55,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(55,160) = groebnerMatrix(55,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(55,79);
  groebnerMatrix(55,79) = 0.0;
  groebnerMatrix(55,110) = groebnerMatrix(55,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,148) = groebnerMatrix(55,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(55,80);
  groebnerMatrix(55,80) = 0.0;
  groebnerMatrix(55,111) = groebnerMatrix(55,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,152) = groebnerMatrix(55,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(55,81);
  groebnerMatrix(55,81) = 0.0;
  groebnerMatrix(55,116) = groebnerMatrix(55,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,157) = groebnerMatrix(55,157) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(55,86);
  groebnerMatrix(55,86) = 0.0;
  groebnerMatrix(55,92) = groebnerMatrix(55,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(55,172) = groebnerMatrix(55,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(55,87);
  groebnerMatrix(55,87) = 0.0;
  groebnerMatrix(55,122) = groebnerMatrix(55,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,163) = groebnerMatrix(55,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,55);
  groebnerRow41_000000000_f(groebnerMatrix,55);
  groebnerRow42_000000000_f(groebnerMatrix,55);
  groebnerRow43_000000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,94);
  groebnerMatrix(55,94) = 0.0;
  groebnerMatrix(55,129) = groebnerMatrix(55,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,170) = groebnerMatrix(55,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,55);
  groebnerRow45_000000000_f(groebnerMatrix,55);
  groebnerRow30_100000000_f(groebnerMatrix,55);
  groebnerRow31_100000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,109);
  groebnerMatrix(55,109) = 0.0;
  groebnerMatrix(55,113) = groebnerMatrix(55,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(55,184) = groebnerMatrix(55,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,55);
  groebnerRow33_100000000_f(groebnerMatrix,55);
  groebnerRow34_100000000_f(groebnerMatrix,55);
  groebnerRow35_100000000_f(groebnerMatrix,55);
  groebnerRow36_100000000_f(groebnerMatrix,55);
  groebnerRow37_100000000_f(groebnerMatrix,55);
  groebnerRow38_100000000_f(groebnerMatrix,55);
  groebnerRow39_100000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,122);
  groebnerMatrix(55,122) = 0.0;
  groebnerMatrix(55,128) = groebnerMatrix(55,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(55,180) = groebnerMatrix(55,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(55,123);
  groebnerMatrix(55,123) = 0.0;
  groebnerMatrix(55,136) = groebnerMatrix(55,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(55,179) = groebnerMatrix(55,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,55);
  groebnerRow47_000000000_f(groebnerMatrix,55);
  factor = groebnerMatrix(55,127);
  groebnerMatrix(55,127) = 0.0;
  groebnerMatrix(55,134) = groebnerMatrix(55,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(55,181) = groebnerMatrix(55,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,55);
  groebnerRow49_000000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,130);
  groebnerMatrix(55,130) = 0.0;
  groebnerMatrix(55,137) = groebnerMatrix(55,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,178) = groebnerMatrix(55,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,55);
  groebnerRow51_000000000_f(groebnerMatrix,55);
  groebnerRow52_000000000_f(groebnerMatrix,55);
  groebnerRow53_000000000_f(groebnerMatrix,55);
  groebnerRow54_000000000_f(groebnerMatrix,55);
  factor = groebnerMatrix(55,142);
  groebnerMatrix(55,142) = 0.0;
  groebnerMatrix(55,144) = groebnerMatrix(55,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(55,147) = groebnerMatrix(55,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(55,196) = groebnerMatrix(55,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(55,143);
  groebnerMatrix(55,143) = 0.0;
  groebnerMatrix(55,155) = groebnerMatrix(55,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(55,176) = groebnerMatrix(55,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(55,144);
  groebnerMatrix(55,144) = 0.0;
  groebnerMatrix(55,156) = groebnerMatrix(55,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(55,177) = groebnerMatrix(55,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(55,196) = groebnerMatrix(55,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(55,147);
  groebnerMatrix(55,147) = 0.0;
  groebnerMatrix(55,162) = groebnerMatrix(55,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(55,186) = groebnerMatrix(55,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(55,196) = groebnerMatrix(55,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(55,148);
  groebnerMatrix(55,148) = 0.0;
  groebnerMatrix(55,153) = groebnerMatrix(55,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(55,159) = groebnerMatrix(55,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,55);
  groebnerRow31_000000000_f(groebnerMatrix,55);
  factor = -groebnerMatrix(55,154);
  groebnerMatrix(55,154) = 0.0;
  groebnerMatrix(55,158) = groebnerMatrix(55,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(55,193) = groebnerMatrix(55,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,55);
  groebnerRow33_000000000_f(groebnerMatrix,55);
  groebnerRow34_000000000_f(groebnerMatrix,55);
  groebnerRow35_000000000_f(groebnerMatrix,55);
  groebnerRow36_000000000_f(groebnerMatrix,55);
  groebnerRow37_000000000_f(groebnerMatrix,55);
  groebnerRow38_000000000_f(groebnerMatrix,55);
  groebnerRow39_000000000_f(groebnerMatrix,55);
  factor = groebnerMatrix(55,163);
  groebnerMatrix(55,163) = 0.0;
  groebnerMatrix(55,171) = groebnerMatrix(55,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(55,180) = groebnerMatrix(55,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(55,167);
  groebnerMatrix(55,167) = 0.0;
  groebnerMatrix(55,173) = groebnerMatrix(55,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(55,189) = groebnerMatrix(55,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(55,168);
  groebnerMatrix(55,168) = 0.0;
  groebnerMatrix(55,181) = groebnerMatrix(55,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(55,188) = groebnerMatrix(55,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(55,172);
  groebnerMatrix(55,172) = 0.0;
  groebnerMatrix(55,179) = groebnerMatrix(55,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(55,190) = groebnerMatrix(55,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(55,175);
  groebnerMatrix(55,175) = 0.0;
  groebnerMatrix(55,182) = groebnerMatrix(55,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(55,187) = groebnerMatrix(55,187) - factor * groebnerMatrix(18,187);

  sPolynomial56(groebnerMatrix);
  groebnerRow38_000100000_f(groebnerMatrix,56);
  groebnerRow39_000100000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,67);
  groebnerMatrix(56,67) = 0.0;
  groebnerMatrix(56,72) = groebnerMatrix(56,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(56,78) = groebnerMatrix(56,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(56,68);
  groebnerMatrix(56,68) = 0.0;
  groebnerMatrix(56,71) = groebnerMatrix(56,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(56,185) = groebnerMatrix(56,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(56,70);
  groebnerMatrix(56,70) = 0.0;
  groebnerMatrix(56,75) = groebnerMatrix(56,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(56,81) = groebnerMatrix(56,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(56,194) = groebnerMatrix(56,194) - factor * groebnerMatrix(13,196);
  groebnerRow30_010000000_f(groebnerMatrix,56);
  groebnerRow31_010000000_f(groebnerMatrix,56);
  groebnerRow32_010000000_f(groebnerMatrix,56);
  groebnerRow33_010000000_f(groebnerMatrix,56);
  factor = -groebnerMatrix(56,76);
  groebnerMatrix(56,76) = 0.0;
  groebnerMatrix(56,107) = groebnerMatrix(56,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,142) = groebnerMatrix(56,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(56,77);
  groebnerMatrix(56,77) = 0.0;
  groebnerMatrix(56,108) = groebnerMatrix(56,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,143) = groebnerMatrix(56,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(56,78);
  groebnerMatrix(56,78) = 0.0;
  groebnerMatrix(56,113) = groebnerMatrix(56,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(56,160) = groebnerMatrix(56,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(56,79);
  groebnerMatrix(56,79) = 0.0;
  groebnerMatrix(56,110) = groebnerMatrix(56,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,148) = groebnerMatrix(56,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(56,80);
  groebnerMatrix(56,80) = 0.0;
  groebnerMatrix(56,111) = groebnerMatrix(56,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,152) = groebnerMatrix(56,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(56,81);
  groebnerMatrix(56,81) = 0.0;
  groebnerMatrix(56,116) = groebnerMatrix(56,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,157) = groebnerMatrix(56,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(56,85);
  groebnerMatrix(56,85) = 0.0;
  groebnerMatrix(56,93) = groebnerMatrix(56,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(56,130) = groebnerMatrix(56,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(56,87);
  groebnerMatrix(56,87) = 0.0;
  groebnerMatrix(56,122) = groebnerMatrix(56,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,163) = groebnerMatrix(56,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,56);
  groebnerRow41_000000000_f(groebnerMatrix,56);
  groebnerRow42_000000000_f(groebnerMatrix,56);
  groebnerRow43_000000000_f(groebnerMatrix,56);
  factor = -groebnerMatrix(56,94);
  groebnerMatrix(56,94) = 0.0;
  groebnerMatrix(56,129) = groebnerMatrix(56,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,170) = groebnerMatrix(56,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,56);
  groebnerRow45_000000000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,103);
  groebnerMatrix(56,103) = 0.0;
  groebnerMatrix(56,108) = groebnerMatrix(56,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(56,114) = groebnerMatrix(56,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(56,104);
  groebnerMatrix(56,104) = 0.0;
  groebnerMatrix(56,107) = groebnerMatrix(56,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(56,186) = groebnerMatrix(56,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(56,105);
  groebnerMatrix(56,105) = 0.0;
  groebnerMatrix(56,112) = groebnerMatrix(56,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(56,185) = groebnerMatrix(56,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(56,106);
  groebnerMatrix(56,106) = 0.0;
  groebnerMatrix(56,111) = groebnerMatrix(56,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(56,117) = groebnerMatrix(56,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(56,195) = groebnerMatrix(56,195) - factor * groebnerMatrix(13,196);
  groebnerRow30_100000000_f(groebnerMatrix,56);
  groebnerRow31_100000000_f(groebnerMatrix,56);
  groebnerRow32_100000000_f(groebnerMatrix,56);
  groebnerRow33_100000000_f(groebnerMatrix,56);
  groebnerRow34_100000000_f(groebnerMatrix,56);
  groebnerRow35_100000000_f(groebnerMatrix,56);
  groebnerRow36_100000000_f(groebnerMatrix,56);
  groebnerRow37_100000000_f(groebnerMatrix,56);
  groebnerRow38_100000000_f(groebnerMatrix,56);
  groebnerRow39_100000000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,121);
  groebnerMatrix(56,121) = 0.0;
  groebnerMatrix(56,129) = groebnerMatrix(56,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(56,138) = groebnerMatrix(56,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(56,122);
  groebnerMatrix(56,122) = 0.0;
  groebnerMatrix(56,128) = groebnerMatrix(56,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(56,180) = groebnerMatrix(56,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(56,123);
  groebnerMatrix(56,123) = 0.0;
  groebnerMatrix(56,136) = groebnerMatrix(56,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(56,179) = groebnerMatrix(56,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,56);
  groebnerRow47_000000000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,127);
  groebnerMatrix(56,127) = 0.0;
  groebnerMatrix(56,134) = groebnerMatrix(56,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(56,181) = groebnerMatrix(56,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,56);
  groebnerRow49_000000000_f(groebnerMatrix,56);
  factor = -groebnerMatrix(56,130);
  groebnerMatrix(56,130) = 0.0;
  groebnerMatrix(56,137) = groebnerMatrix(56,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,178) = groebnerMatrix(56,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,56);
  groebnerRow51_000000000_f(groebnerMatrix,56);
  groebnerRow52_000000000_f(groebnerMatrix,56);
  groebnerRow53_000000000_f(groebnerMatrix,56);
  groebnerRow54_000000000_f(groebnerMatrix,56);
  groebnerRow55_000000000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,142);
  groebnerMatrix(56,142) = 0.0;
  groebnerMatrix(56,144) = groebnerMatrix(56,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(56,147) = groebnerMatrix(56,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(56,196) = groebnerMatrix(56,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(56,143);
  groebnerMatrix(56,143) = 0.0;
  groebnerMatrix(56,155) = groebnerMatrix(56,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(56,176) = groebnerMatrix(56,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(56,144);
  groebnerMatrix(56,144) = 0.0;
  groebnerMatrix(56,156) = groebnerMatrix(56,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(56,177) = groebnerMatrix(56,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(56,196) = groebnerMatrix(56,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(56,147);
  groebnerMatrix(56,147) = 0.0;
  groebnerMatrix(56,162) = groebnerMatrix(56,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(56,186) = groebnerMatrix(56,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(56,196) = groebnerMatrix(56,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(56,148);
  groebnerMatrix(56,148) = 0.0;
  groebnerMatrix(56,153) = groebnerMatrix(56,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(56,159) = groebnerMatrix(56,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(56,149);
  groebnerMatrix(56,149) = 0.0;
  groebnerMatrix(56,152) = groebnerMatrix(56,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(56,195) = groebnerMatrix(56,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(56,150);
  groebnerMatrix(56,150) = 0.0;
  groebnerMatrix(56,157) = groebnerMatrix(56,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(56,194) = groebnerMatrix(56,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(56,151);
  groebnerMatrix(56,151) = 0.0;
  groebnerMatrix(56,156) = groebnerMatrix(56,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(56,162) = groebnerMatrix(56,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(56,196) = groebnerMatrix(56,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,56);
  groebnerRow31_000000000_f(groebnerMatrix,56);
  groebnerRow32_000000000_f(groebnerMatrix,56);
  groebnerRow33_000000000_f(groebnerMatrix,56);
  groebnerRow34_000000000_f(groebnerMatrix,56);
  groebnerRow35_000000000_f(groebnerMatrix,56);
  groebnerRow36_000000000_f(groebnerMatrix,56);
  groebnerRow37_000000000_f(groebnerMatrix,56);
  groebnerRow38_000000000_f(groebnerMatrix,56);
  groebnerRow39_000000000_f(groebnerMatrix,56);
  factor = groebnerMatrix(56,163);
  groebnerMatrix(56,163) = 0.0;
  groebnerMatrix(56,171) = groebnerMatrix(56,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(56,180) = groebnerMatrix(56,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(56,166);
  groebnerMatrix(56,166) = 0.0;
  groebnerMatrix(56,174) = groebnerMatrix(56,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(56,183) = groebnerMatrix(56,183) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(56,168);
  groebnerMatrix(56,168) = 0.0;
  groebnerMatrix(56,181) = groebnerMatrix(56,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(56,188) = groebnerMatrix(56,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(56,172);
  groebnerMatrix(56,172) = 0.0;
  groebnerMatrix(56,179) = groebnerMatrix(56,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(56,190) = groebnerMatrix(56,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(56,175);
  groebnerMatrix(56,175) = 0.0;
  groebnerMatrix(56,182) = groebnerMatrix(56,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(56,187) = groebnerMatrix(56,187) - factor * groebnerMatrix(18,187);

  sPolynomial57(groebnerMatrix);
  groebnerRow37_000100000_f(groebnerMatrix,57);
  groebnerRow38_000100000_f(groebnerMatrix,57);
  groebnerRow39_000100000_f(groebnerMatrix,57);
  factor = groebnerMatrix(57,64);
  groebnerMatrix(57,64) = 0.0;
  groebnerMatrix(57,98) = groebnerMatrix(57,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,148) = groebnerMatrix(57,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(57,65);
  groebnerMatrix(57,65) = 0.0;
  groebnerMatrix(57,99) = groebnerMatrix(57,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,149) = groebnerMatrix(57,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(57,69);
  groebnerMatrix(57,69) = 0.0;
  groebnerMatrix(57,104) = groebnerMatrix(57,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,151) = groebnerMatrix(57,151) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(57,73);
  groebnerMatrix(57,73) = 0.0;
  groebnerMatrix(57,77) = groebnerMatrix(57,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(57,176) = groebnerMatrix(57,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(57,76);
  groebnerMatrix(57,76) = 0.0;
  groebnerMatrix(57,107) = groebnerMatrix(57,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,142) = groebnerMatrix(57,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(57,77);
  groebnerMatrix(57,77) = 0.0;
  groebnerMatrix(57,108) = groebnerMatrix(57,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,143) = groebnerMatrix(57,143) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(57,79);
  groebnerMatrix(57,79) = 0.0;
  groebnerMatrix(57,110) = groebnerMatrix(57,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,148) = groebnerMatrix(57,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(57,80);
  groebnerMatrix(57,80) = 0.0;
  groebnerMatrix(57,111) = groebnerMatrix(57,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,152) = groebnerMatrix(57,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(57,84);
  groebnerMatrix(57,84) = 0.0;
  groebnerMatrix(57,119) = groebnerMatrix(57,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,166) = groebnerMatrix(57,166) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(57,87);
  groebnerMatrix(57,87) = 0.0;
  groebnerMatrix(57,122) = groebnerMatrix(57,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,163) = groebnerMatrix(57,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(57,91);
  groebnerMatrix(57,91) = 0.0;
  groebnerMatrix(57,126) = groebnerMatrix(57,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,173) = groebnerMatrix(57,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(57,94);
  groebnerMatrix(57,94) = 0.0;
  groebnerMatrix(57,129) = groebnerMatrix(57,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,170) = groebnerMatrix(57,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(57,98);
  groebnerMatrix(57,98) = 0.0;
  groebnerMatrix(57,110) = groebnerMatrix(57,110) - factor * groebnerMatrix(26,155);
  groebnerMatrix(57,131) = groebnerMatrix(57,131) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(57,99);
  groebnerMatrix(57,99) = 0.0;
  groebnerMatrix(57,111) = groebnerMatrix(57,111) - factor * groebnerMatrix(25,156);
  groebnerMatrix(57,132) = groebnerMatrix(57,132) - factor * groebnerMatrix(25,177);
  groebnerMatrix(57,195) = groebnerMatrix(57,195) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(57,100);
  groebnerMatrix(57,100) = 0.0;
  groebnerMatrix(57,115) = groebnerMatrix(57,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(57,139) = groebnerMatrix(57,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(57,101);
  groebnerMatrix(57,101) = 0.0;
  groebnerMatrix(57,116) = groebnerMatrix(57,116) - factor * groebnerMatrix(23,161);
  groebnerMatrix(57,140) = groebnerMatrix(57,140) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(57,102);
  groebnerMatrix(57,102) = 0.0;
  groebnerMatrix(57,117) = groebnerMatrix(57,117) - factor * groebnerMatrix(22,162);
  groebnerMatrix(57,141) = groebnerMatrix(57,141) - factor * groebnerMatrix(22,186);
  groebnerMatrix(57,195) = groebnerMatrix(57,195) - factor * groebnerMatrix(22,196);
  factor = -groebnerMatrix(57,104);
  groebnerMatrix(57,104) = 0.0;
  groebnerMatrix(57,107) = groebnerMatrix(57,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(57,186) = groebnerMatrix(57,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(57,105);
  groebnerMatrix(57,105) = 0.0;
  groebnerMatrix(57,112) = groebnerMatrix(57,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(57,185) = groebnerMatrix(57,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,57);
  groebnerRow31_100000000_f(groebnerMatrix,57);
  factor = -groebnerMatrix(57,109);
  groebnerMatrix(57,109) = 0.0;
  groebnerMatrix(57,113) = groebnerMatrix(57,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(57,184) = groebnerMatrix(57,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,57);
  groebnerRow33_100000000_f(groebnerMatrix,57);
  groebnerRow34_100000000_f(groebnerMatrix,57);
  groebnerRow35_100000000_f(groebnerMatrix,57);
  groebnerRow36_100000000_f(groebnerMatrix,57);
  groebnerRow37_100000000_f(groebnerMatrix,57);
  groebnerRow38_100000000_f(groebnerMatrix,57);
  groebnerRow39_100000000_f(groebnerMatrix,57);
  factor = groebnerMatrix(57,119);
  groebnerMatrix(57,119) = 0.0;
  groebnerMatrix(57,125) = groebnerMatrix(57,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(57,183) = groebnerMatrix(57,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(57,120);
  groebnerMatrix(57,120) = 0.0;
  groebnerMatrix(57,133) = groebnerMatrix(57,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(57,182) = groebnerMatrix(57,182) - factor * groebnerMatrix(29,191);
  factor = -groebnerMatrix(57,122);
  groebnerMatrix(57,122) = 0.0;
  groebnerMatrix(57,128) = groebnerMatrix(57,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(57,180) = groebnerMatrix(57,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(57,123);
  groebnerMatrix(57,123) = 0.0;
  groebnerMatrix(57,136) = groebnerMatrix(57,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(57,179) = groebnerMatrix(57,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,57);
  groebnerRow47_000000000_f(groebnerMatrix,57);
  factor = groebnerMatrix(57,127);
  groebnerMatrix(57,127) = 0.0;
  groebnerMatrix(57,134) = groebnerMatrix(57,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,181) = groebnerMatrix(57,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,57);
  groebnerRow49_000000000_f(groebnerMatrix,57);
  factor = -groebnerMatrix(57,130);
  groebnerMatrix(57,130) = 0.0;
  groebnerMatrix(57,137) = groebnerMatrix(57,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,178) = groebnerMatrix(57,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,57);
  groebnerRow51_000000000_f(groebnerMatrix,57);
  groebnerRow52_000000000_f(groebnerMatrix,57);
  groebnerRow53_000000000_f(groebnerMatrix,57);
  groebnerRow54_000000000_f(groebnerMatrix,57);
  groebnerRow55_000000000_f(groebnerMatrix,57);
  groebnerRow56_000000000_f(groebnerMatrix,57);
  factor = groebnerMatrix(57,142);
  groebnerMatrix(57,142) = 0.0;
  groebnerMatrix(57,144) = groebnerMatrix(57,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(57,147) = groebnerMatrix(57,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(57,196) = groebnerMatrix(57,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(57,143);
  groebnerMatrix(57,143) = 0.0;
  groebnerMatrix(57,155) = groebnerMatrix(57,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(57,176) = groebnerMatrix(57,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(57,144);
  groebnerMatrix(57,144) = 0.0;
  groebnerMatrix(57,156) = groebnerMatrix(57,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(57,177) = groebnerMatrix(57,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(57,196) = groebnerMatrix(57,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(57,145);
  groebnerMatrix(57,145) = 0.0;
  groebnerMatrix(57,160) = groebnerMatrix(57,160) - factor * groebnerMatrix(24,160);
  groebnerMatrix(57,184) = groebnerMatrix(57,184) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(57,146);
  groebnerMatrix(57,146) = 0.0;
  groebnerMatrix(57,161) = groebnerMatrix(57,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(57,185) = groebnerMatrix(57,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(57,147);
  groebnerMatrix(57,147) = 0.0;
  groebnerMatrix(57,162) = groebnerMatrix(57,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(57,186) = groebnerMatrix(57,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(57,196) = groebnerMatrix(57,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(57,148);
  groebnerMatrix(57,148) = 0.0;
  groebnerMatrix(57,153) = groebnerMatrix(57,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(57,159) = groebnerMatrix(57,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(57,149);
  groebnerMatrix(57,149) = 0.0;
  groebnerMatrix(57,152) = groebnerMatrix(57,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(57,195) = groebnerMatrix(57,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(57,150);
  groebnerMatrix(57,150) = 0.0;
  groebnerMatrix(57,157) = groebnerMatrix(57,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(57,194) = groebnerMatrix(57,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(57,151);
  groebnerMatrix(57,151) = 0.0;
  groebnerMatrix(57,156) = groebnerMatrix(57,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(57,162) = groebnerMatrix(57,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(57,196) = groebnerMatrix(57,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,57);
  groebnerRow31_000000000_f(groebnerMatrix,57);
  factor = -groebnerMatrix(57,154);
  groebnerMatrix(57,154) = 0.0;
  groebnerMatrix(57,158) = groebnerMatrix(57,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(57,193) = groebnerMatrix(57,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,57);
  groebnerRow33_000000000_f(groebnerMatrix,57);
  groebnerRow34_000000000_f(groebnerMatrix,57);
  groebnerRow35_000000000_f(groebnerMatrix,57);
  groebnerRow36_000000000_f(groebnerMatrix,57);
  groebnerRow37_000000000_f(groebnerMatrix,57);
  groebnerRow38_000000000_f(groebnerMatrix,57);
  groebnerRow39_000000000_f(groebnerMatrix,57);
  factor = groebnerMatrix(57,163);
  groebnerMatrix(57,163) = 0.0;
  groebnerMatrix(57,171) = groebnerMatrix(57,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(57,180) = groebnerMatrix(57,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(57,165);
  groebnerMatrix(57,165) = 0.0;
  groebnerMatrix(57,178) = groebnerMatrix(57,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(57,191) = groebnerMatrix(57,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(57,166);
  groebnerMatrix(57,166) = 0.0;
  groebnerMatrix(57,174) = groebnerMatrix(57,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(57,183) = groebnerMatrix(57,183) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(57,168);
  groebnerMatrix(57,168) = 0.0;
  groebnerMatrix(57,181) = groebnerMatrix(57,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(57,188) = groebnerMatrix(57,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(57,172);
  groebnerMatrix(57,172) = 0.0;
  groebnerMatrix(57,179) = groebnerMatrix(57,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(57,190) = groebnerMatrix(57,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(57,175);
  groebnerMatrix(57,175) = 0.0;
  groebnerMatrix(57,182) = groebnerMatrix(57,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(57,187) = groebnerMatrix(57,187) - factor * groebnerMatrix(18,187);

  sPolynomial58(groebnerMatrix);
  groebnerRow36_000100000_f(groebnerMatrix,58);
  groebnerRow37_000100000_f(groebnerMatrix,58);
  groebnerRow38_000100000_f(groebnerMatrix,58);
  groebnerRow39_000100000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,62);
  groebnerMatrix(58,62) = 0.0;
  groebnerMatrix(58,74) = groebnerMatrix(58,74) - factor * groebnerMatrix(26,155);
  groebnerMatrix(58,95) = groebnerMatrix(58,95) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(58,63);
  groebnerMatrix(58,63) = 0.0;
  groebnerMatrix(58,75) = groebnerMatrix(58,75) - factor * groebnerMatrix(25,156);
  groebnerMatrix(58,96) = groebnerMatrix(58,96) - factor * groebnerMatrix(25,177);
  groebnerMatrix(58,194) = groebnerMatrix(58,194) - factor * groebnerMatrix(25,196);
  factor = -groebnerMatrix(58,68);
  groebnerMatrix(58,68) = 0.0;
  groebnerMatrix(58,71) = groebnerMatrix(58,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(58,185) = groebnerMatrix(58,185) - factor * groebnerMatrix(19,195);
  groebnerRow30_010000000_f(groebnerMatrix,58);
  groebnerRow31_010000000_f(groebnerMatrix,58);
  groebnerRow32_010000000_f(groebnerMatrix,58);
  groebnerRow33_010000000_f(groebnerMatrix,58);
  factor = -groebnerMatrix(58,76);
  groebnerMatrix(58,76) = 0.0;
  groebnerMatrix(58,107) = groebnerMatrix(58,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,142) = groebnerMatrix(58,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(58,77);
  groebnerMatrix(58,77) = 0.0;
  groebnerMatrix(58,108) = groebnerMatrix(58,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,143) = groebnerMatrix(58,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(58,78);
  groebnerMatrix(58,78) = 0.0;
  groebnerMatrix(58,113) = groebnerMatrix(58,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(58,160) = groebnerMatrix(58,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(58,79);
  groebnerMatrix(58,79) = 0.0;
  groebnerMatrix(58,110) = groebnerMatrix(58,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,148) = groebnerMatrix(58,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(58,80);
  groebnerMatrix(58,80) = 0.0;
  groebnerMatrix(58,111) = groebnerMatrix(58,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,152) = groebnerMatrix(58,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(58,81);
  groebnerMatrix(58,81) = 0.0;
  groebnerMatrix(58,116) = groebnerMatrix(58,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,157) = groebnerMatrix(58,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(58,83);
  groebnerMatrix(58,83) = 0.0;
  groebnerMatrix(58,89) = groebnerMatrix(58,89) - factor * groebnerMatrix(20,170);
  groebnerMatrix(58,175) = groebnerMatrix(58,175) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(58,87);
  groebnerMatrix(58,87) = 0.0;
  groebnerMatrix(58,122) = groebnerMatrix(58,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,163) = groebnerMatrix(58,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,58);
  groebnerRow41_000000000_f(groebnerMatrix,58);
  groebnerRow42_000000000_f(groebnerMatrix,58);
  groebnerRow43_000000000_f(groebnerMatrix,58);
  factor = -groebnerMatrix(58,94);
  groebnerMatrix(58,94) = 0.0;
  groebnerMatrix(58,129) = groebnerMatrix(58,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,170) = groebnerMatrix(58,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,58);
  groebnerRow45_000000000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,98);
  groebnerMatrix(58,98) = 0.0;
  groebnerMatrix(58,110) = groebnerMatrix(58,110) - factor * groebnerMatrix(26,155);
  groebnerMatrix(58,131) = groebnerMatrix(58,131) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(58,99);
  groebnerMatrix(58,99) = 0.0;
  groebnerMatrix(58,111) = groebnerMatrix(58,111) - factor * groebnerMatrix(25,156);
  groebnerMatrix(58,132) = groebnerMatrix(58,132) - factor * groebnerMatrix(25,177);
  groebnerMatrix(58,195) = groebnerMatrix(58,195) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(58,101);
  groebnerMatrix(58,101) = 0.0;
  groebnerMatrix(58,116) = groebnerMatrix(58,116) - factor * groebnerMatrix(23,161);
  groebnerMatrix(58,140) = groebnerMatrix(58,140) - factor * groebnerMatrix(23,185);
  factor = -groebnerMatrix(58,104);
  groebnerMatrix(58,104) = 0.0;
  groebnerMatrix(58,107) = groebnerMatrix(58,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(58,186) = groebnerMatrix(58,186) - factor * groebnerMatrix(19,195);
  groebnerRow30_100000000_f(groebnerMatrix,58);
  groebnerRow31_100000000_f(groebnerMatrix,58);
  groebnerRow32_100000000_f(groebnerMatrix,58);
  groebnerRow33_100000000_f(groebnerMatrix,58);
  groebnerRow34_100000000_f(groebnerMatrix,58);
  groebnerRow35_100000000_f(groebnerMatrix,58);
  groebnerRow36_100000000_f(groebnerMatrix,58);
  groebnerRow37_100000000_f(groebnerMatrix,58);
  groebnerRow38_100000000_f(groebnerMatrix,58);
  groebnerRow39_100000000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,119);
  groebnerMatrix(58,119) = 0.0;
  groebnerMatrix(58,125) = groebnerMatrix(58,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(58,183) = groebnerMatrix(58,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(58,122);
  groebnerMatrix(58,122) = 0.0;
  groebnerMatrix(58,128) = groebnerMatrix(58,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(58,180) = groebnerMatrix(58,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(58,123);
  groebnerMatrix(58,123) = 0.0;
  groebnerMatrix(58,136) = groebnerMatrix(58,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(58,179) = groebnerMatrix(58,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,58);
  groebnerRow47_000000000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,127);
  groebnerMatrix(58,127) = 0.0;
  groebnerMatrix(58,134) = groebnerMatrix(58,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(58,181) = groebnerMatrix(58,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,58);
  groebnerRow49_000000000_f(groebnerMatrix,58);
  factor = -groebnerMatrix(58,130);
  groebnerMatrix(58,130) = 0.0;
  groebnerMatrix(58,137) = groebnerMatrix(58,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,178) = groebnerMatrix(58,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,58);
  groebnerRow51_000000000_f(groebnerMatrix,58);
  groebnerRow52_000000000_f(groebnerMatrix,58);
  groebnerRow53_000000000_f(groebnerMatrix,58);
  groebnerRow54_000000000_f(groebnerMatrix,58);
  groebnerRow55_000000000_f(groebnerMatrix,58);
  groebnerRow56_000000000_f(groebnerMatrix,58);
  groebnerRow57_000000000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,142);
  groebnerMatrix(58,142) = 0.0;
  groebnerMatrix(58,144) = groebnerMatrix(58,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(58,147) = groebnerMatrix(58,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(58,196) = groebnerMatrix(58,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(58,143);
  groebnerMatrix(58,143) = 0.0;
  groebnerMatrix(58,155) = groebnerMatrix(58,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(58,176) = groebnerMatrix(58,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(58,144);
  groebnerMatrix(58,144) = 0.0;
  groebnerMatrix(58,156) = groebnerMatrix(58,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(58,177) = groebnerMatrix(58,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(58,196) = groebnerMatrix(58,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(58,146);
  groebnerMatrix(58,146) = 0.0;
  groebnerMatrix(58,161) = groebnerMatrix(58,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(58,185) = groebnerMatrix(58,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(58,147);
  groebnerMatrix(58,147) = 0.0;
  groebnerMatrix(58,162) = groebnerMatrix(58,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(58,186) = groebnerMatrix(58,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(58,196) = groebnerMatrix(58,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(58,148);
  groebnerMatrix(58,148) = 0.0;
  groebnerMatrix(58,153) = groebnerMatrix(58,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(58,159) = groebnerMatrix(58,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(58,149);
  groebnerMatrix(58,149) = 0.0;
  groebnerMatrix(58,152) = groebnerMatrix(58,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(58,195) = groebnerMatrix(58,195) - factor * groebnerMatrix(19,195);
  groebnerRow30_000000000_f(groebnerMatrix,58);
  groebnerRow31_000000000_f(groebnerMatrix,58);
  groebnerRow32_000000000_f(groebnerMatrix,58);
  groebnerRow33_000000000_f(groebnerMatrix,58);
  groebnerRow34_000000000_f(groebnerMatrix,58);
  groebnerRow35_000000000_f(groebnerMatrix,58);
  groebnerRow36_000000000_f(groebnerMatrix,58);
  groebnerRow37_000000000_f(groebnerMatrix,58);
  groebnerRow38_000000000_f(groebnerMatrix,58);
  groebnerRow39_000000000_f(groebnerMatrix,58);
  factor = groebnerMatrix(58,163);
  groebnerMatrix(58,163) = 0.0;
  groebnerMatrix(58,171) = groebnerMatrix(58,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(58,180) = groebnerMatrix(58,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(58,164);
  groebnerMatrix(58,164) = 0.0;
  groebnerMatrix(58,170) = groebnerMatrix(58,170) - factor * groebnerMatrix(20,170);
  groebnerMatrix(58,192) = groebnerMatrix(58,192) - factor * groebnerMatrix(20,192);
  factor = groebnerMatrix(58,168);
  groebnerMatrix(58,168) = 0.0;
  groebnerMatrix(58,181) = groebnerMatrix(58,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(58,188) = groebnerMatrix(58,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(58,172);
  groebnerMatrix(58,172) = 0.0;
  groebnerMatrix(58,179) = groebnerMatrix(58,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(58,190) = groebnerMatrix(58,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(58,175);
  groebnerMatrix(58,175) = 0.0;
  groebnerMatrix(58,182) = groebnerMatrix(58,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(58,187) = groebnerMatrix(58,187) - factor * groebnerMatrix(18,187);

  sPolynomial59(groebnerMatrix);
  groebnerRow35_000100000_f(groebnerMatrix,59);
  groebnerRow36_000100000_f(groebnerMatrix,59);
  groebnerRow37_000100000_f(groebnerMatrix,59);
  groebnerRow38_000100000_f(groebnerMatrix,59);
  groebnerRow39_000100000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,61);
  groebnerMatrix(59,61) = 0.0;
  groebnerMatrix(59,63) = groebnerMatrix(59,63) - factor * groebnerMatrix(15,144);
  groebnerMatrix(59,66) = groebnerMatrix(59,66) - factor * groebnerMatrix(15,147);
  groebnerMatrix(59,194) = groebnerMatrix(59,194) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(59,62);
  groebnerMatrix(59,62) = 0.0;
  groebnerMatrix(59,74) = groebnerMatrix(59,74) - factor * groebnerMatrix(26,155);
  groebnerMatrix(59,95) = groebnerMatrix(59,95) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(59,63);
  groebnerMatrix(59,63) = 0.0;
  groebnerMatrix(59,75) = groebnerMatrix(59,75) - factor * groebnerMatrix(25,156);
  groebnerMatrix(59,96) = groebnerMatrix(59,96) - factor * groebnerMatrix(25,177);
  groebnerMatrix(59,194) = groebnerMatrix(59,194) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(59,66);
  groebnerMatrix(59,66) = 0.0;
  groebnerMatrix(59,101) = groebnerMatrix(59,101) - factor * groebnerMatrix(17,179);
  groebnerMatrix(59,150) = groebnerMatrix(59,150) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(59,67);
  groebnerMatrix(59,67) = 0.0;
  groebnerMatrix(59,72) = groebnerMatrix(59,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(59,78) = groebnerMatrix(59,78) - factor * groebnerMatrix(14,159);
  groebnerRow30_010000000_f(groebnerMatrix,59);
  groebnerRow31_010000000_f(groebnerMatrix,59);
  groebnerRow32_010000000_f(groebnerMatrix,59);
  groebnerRow33_010000000_f(groebnerMatrix,59);
  factor = -groebnerMatrix(59,76);
  groebnerMatrix(59,76) = 0.0;
  groebnerMatrix(59,107) = groebnerMatrix(59,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,142) = groebnerMatrix(59,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(59,77);
  groebnerMatrix(59,77) = 0.0;
  groebnerMatrix(59,108) = groebnerMatrix(59,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,143) = groebnerMatrix(59,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(59,78);
  groebnerMatrix(59,78) = 0.0;
  groebnerMatrix(59,113) = groebnerMatrix(59,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(59,160) = groebnerMatrix(59,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(59,79);
  groebnerMatrix(59,79) = 0.0;
  groebnerMatrix(59,110) = groebnerMatrix(59,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,148) = groebnerMatrix(59,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(59,80);
  groebnerMatrix(59,80) = 0.0;
  groebnerMatrix(59,111) = groebnerMatrix(59,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,152) = groebnerMatrix(59,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(59,81);
  groebnerMatrix(59,81) = 0.0;
  groebnerMatrix(59,116) = groebnerMatrix(59,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,157) = groebnerMatrix(59,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(59,82);
  groebnerMatrix(59,82) = 0.0;
  groebnerMatrix(59,90) = groebnerMatrix(59,90) - factor * groebnerMatrix(12,171);
  groebnerMatrix(59,127) = groebnerMatrix(59,127) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(59,87);
  groebnerMatrix(59,87) = 0.0;
  groebnerMatrix(59,122) = groebnerMatrix(59,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,163) = groebnerMatrix(59,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,59);
  groebnerRow41_000000000_f(groebnerMatrix,59);
  groebnerRow42_000000000_f(groebnerMatrix,59);
  groebnerRow43_000000000_f(groebnerMatrix,59);
  factor = -groebnerMatrix(59,94);
  groebnerMatrix(59,94) = 0.0;
  groebnerMatrix(59,129) = groebnerMatrix(59,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,170) = groebnerMatrix(59,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,59);
  groebnerRow45_000000000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,97);
  groebnerMatrix(59,97) = 0.0;
  groebnerMatrix(59,99) = groebnerMatrix(59,99) - factor * groebnerMatrix(15,144);
  groebnerMatrix(59,102) = groebnerMatrix(59,102) - factor * groebnerMatrix(15,147);
  groebnerMatrix(59,195) = groebnerMatrix(59,195) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(59,98);
  groebnerMatrix(59,98) = 0.0;
  groebnerMatrix(59,110) = groebnerMatrix(59,110) - factor * groebnerMatrix(26,155);
  groebnerMatrix(59,131) = groebnerMatrix(59,131) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(59,99);
  groebnerMatrix(59,99) = 0.0;
  groebnerMatrix(59,111) = groebnerMatrix(59,111) - factor * groebnerMatrix(25,156);
  groebnerMatrix(59,132) = groebnerMatrix(59,132) - factor * groebnerMatrix(25,177);
  groebnerMatrix(59,195) = groebnerMatrix(59,195) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(59,100);
  groebnerMatrix(59,100) = 0.0;
  groebnerMatrix(59,115) = groebnerMatrix(59,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(59,139) = groebnerMatrix(59,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(59,101);
  groebnerMatrix(59,101) = 0.0;
  groebnerMatrix(59,116) = groebnerMatrix(59,116) - factor * groebnerMatrix(23,161);
  groebnerMatrix(59,140) = groebnerMatrix(59,140) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(59,102);
  groebnerMatrix(59,102) = 0.0;
  groebnerMatrix(59,117) = groebnerMatrix(59,117) - factor * groebnerMatrix(22,162);
  groebnerMatrix(59,141) = groebnerMatrix(59,141) - factor * groebnerMatrix(22,186);
  groebnerMatrix(59,195) = groebnerMatrix(59,195) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(59,103);
  groebnerMatrix(59,103) = 0.0;
  groebnerMatrix(59,108) = groebnerMatrix(59,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(59,114) = groebnerMatrix(59,114) - factor * groebnerMatrix(14,159);
  groebnerRow30_100000000_f(groebnerMatrix,59);
  groebnerRow31_100000000_f(groebnerMatrix,59);
  groebnerRow32_100000000_f(groebnerMatrix,59);
  groebnerRow33_100000000_f(groebnerMatrix,59);
  groebnerRow34_100000000_f(groebnerMatrix,59);
  groebnerRow35_100000000_f(groebnerMatrix,59);
  groebnerRow36_100000000_f(groebnerMatrix,59);
  groebnerRow37_100000000_f(groebnerMatrix,59);
  groebnerRow38_100000000_f(groebnerMatrix,59);
  groebnerRow39_100000000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,118);
  groebnerMatrix(59,118) = 0.0;
  groebnerMatrix(59,126) = groebnerMatrix(59,126) - factor * groebnerMatrix(12,171);
  groebnerMatrix(59,135) = groebnerMatrix(59,135) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(59,122);
  groebnerMatrix(59,122) = 0.0;
  groebnerMatrix(59,128) = groebnerMatrix(59,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(59,180) = groebnerMatrix(59,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(59,123);
  groebnerMatrix(59,123) = 0.0;
  groebnerMatrix(59,136) = groebnerMatrix(59,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(59,179) = groebnerMatrix(59,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,59);
  groebnerRow47_000000000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,127);
  groebnerMatrix(59,127) = 0.0;
  groebnerMatrix(59,134) = groebnerMatrix(59,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(59,181) = groebnerMatrix(59,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,59);
  groebnerRow49_000000000_f(groebnerMatrix,59);
  factor = -groebnerMatrix(59,130);
  groebnerMatrix(59,130) = 0.0;
  groebnerMatrix(59,137) = groebnerMatrix(59,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,178) = groebnerMatrix(59,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,59);
  groebnerRow51_000000000_f(groebnerMatrix,59);
  groebnerRow52_000000000_f(groebnerMatrix,59);
  groebnerRow53_000000000_f(groebnerMatrix,59);
  groebnerRow54_000000000_f(groebnerMatrix,59);
  groebnerRow55_000000000_f(groebnerMatrix,59);
  groebnerRow56_000000000_f(groebnerMatrix,59);
  groebnerRow57_000000000_f(groebnerMatrix,59);
  groebnerRow58_000000000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,142);
  groebnerMatrix(59,142) = 0.0;
  groebnerMatrix(59,144) = groebnerMatrix(59,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(59,147) = groebnerMatrix(59,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(59,196) = groebnerMatrix(59,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(59,143);
  groebnerMatrix(59,143) = 0.0;
  groebnerMatrix(59,155) = groebnerMatrix(59,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(59,176) = groebnerMatrix(59,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(59,144);
  groebnerMatrix(59,144) = 0.0;
  groebnerMatrix(59,156) = groebnerMatrix(59,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(59,177) = groebnerMatrix(59,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(59,196) = groebnerMatrix(59,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(59,145);
  groebnerMatrix(59,145) = 0.0;
  groebnerMatrix(59,160) = groebnerMatrix(59,160) - factor * groebnerMatrix(24,160);
  groebnerMatrix(59,184) = groebnerMatrix(59,184) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(59,147);
  groebnerMatrix(59,147) = 0.0;
  groebnerMatrix(59,162) = groebnerMatrix(59,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(59,186) = groebnerMatrix(59,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(59,196) = groebnerMatrix(59,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(59,148);
  groebnerMatrix(59,148) = 0.0;
  groebnerMatrix(59,153) = groebnerMatrix(59,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(59,159) = groebnerMatrix(59,159) - factor * groebnerMatrix(14,159);
  factor = groebnerMatrix(59,150);
  groebnerMatrix(59,150) = 0.0;
  groebnerMatrix(59,157) = groebnerMatrix(59,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(59,194) = groebnerMatrix(59,194) - factor * groebnerMatrix(28,194);
  groebnerRow30_000000000_f(groebnerMatrix,59);
  groebnerRow31_000000000_f(groebnerMatrix,59);
  groebnerRow32_000000000_f(groebnerMatrix,59);
  groebnerRow33_000000000_f(groebnerMatrix,59);
  groebnerRow34_000000000_f(groebnerMatrix,59);
  groebnerRow35_000000000_f(groebnerMatrix,59);
  groebnerRow36_000000000_f(groebnerMatrix,59);
  groebnerRow37_000000000_f(groebnerMatrix,59);
  groebnerRow38_000000000_f(groebnerMatrix,59);
  groebnerRow39_000000000_f(groebnerMatrix,59);
  factor = groebnerMatrix(59,163);
  groebnerMatrix(59,163) = 0.0;
  groebnerMatrix(59,171) = groebnerMatrix(59,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(59,180) = groebnerMatrix(59,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(59,168);
  groebnerMatrix(59,168) = 0.0;
  groebnerMatrix(59,181) = groebnerMatrix(59,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(59,188) = groebnerMatrix(59,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(59,172);
  groebnerMatrix(59,172) = 0.0;
  groebnerMatrix(59,179) = groebnerMatrix(59,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(59,190) = groebnerMatrix(59,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(59,175);
  groebnerMatrix(59,175) = 0.0;
  groebnerMatrix(59,182) = groebnerMatrix(59,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(59,187) = groebnerMatrix(59,187) - factor * groebnerMatrix(18,187);

  sPolynomial60(groebnerMatrix);
  groebnerRow34_000100000_f(groebnerMatrix,60);
  groebnerRow35_000100000_f(groebnerMatrix,60);
  groebnerRow36_000100000_f(groebnerMatrix,60);
  groebnerRow37_000100000_f(groebnerMatrix,60);
  groebnerRow38_000100000_f(groebnerMatrix,60);
  groebnerRow39_000100000_f(groebnerMatrix,60);
  groebnerRow30_010000000_f(groebnerMatrix,60);
  groebnerRow31_010000000_f(groebnerMatrix,60);
  groebnerRow32_010000000_f(groebnerMatrix,60);
  groebnerRow33_010000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,76);
  groebnerMatrix(60,76) = 0.0;
  groebnerMatrix(60,107) = groebnerMatrix(60,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,142) = groebnerMatrix(60,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(60,77);
  groebnerMatrix(60,77) = 0.0;
  groebnerMatrix(60,108) = groebnerMatrix(60,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,143) = groebnerMatrix(60,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(60,78);
  groebnerMatrix(60,78) = 0.0;
  groebnerMatrix(60,113) = groebnerMatrix(60,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(60,160) = groebnerMatrix(60,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(60,79);
  groebnerMatrix(60,79) = 0.0;
  groebnerMatrix(60,110) = groebnerMatrix(60,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,148) = groebnerMatrix(60,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(60,80);
  groebnerMatrix(60,80) = 0.0;
  groebnerMatrix(60,111) = groebnerMatrix(60,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,152) = groebnerMatrix(60,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(60,81);
  groebnerMatrix(60,81) = 0.0;
  groebnerMatrix(60,116) = groebnerMatrix(60,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,157) = groebnerMatrix(60,157) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(60,86);
  groebnerMatrix(60,86) = 0.0;
  groebnerMatrix(60,92) = groebnerMatrix(60,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(60,172) = groebnerMatrix(60,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(60,87);
  groebnerMatrix(60,87) = 0.0;
  groebnerMatrix(60,122) = groebnerMatrix(60,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,163) = groebnerMatrix(60,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,60);
  groebnerRow41_000000000_f(groebnerMatrix,60);
  groebnerRow42_000000000_f(groebnerMatrix,60);
  groebnerRow43_000000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,94);
  groebnerMatrix(60,94) = 0.0;
  groebnerMatrix(60,129) = groebnerMatrix(60,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,170) = groebnerMatrix(60,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,60);
  groebnerRow45_000000000_f(groebnerMatrix,60);
  groebnerRow30_100000000_f(groebnerMatrix,60);
  groebnerRow31_100000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,109);
  groebnerMatrix(60,109) = 0.0;
  groebnerMatrix(60,113) = groebnerMatrix(60,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(60,184) = groebnerMatrix(60,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,60);
  groebnerRow33_100000000_f(groebnerMatrix,60);
  groebnerRow34_100000000_f(groebnerMatrix,60);
  groebnerRow35_100000000_f(groebnerMatrix,60);
  groebnerRow36_100000000_f(groebnerMatrix,60);
  groebnerRow37_100000000_f(groebnerMatrix,60);
  groebnerRow38_100000000_f(groebnerMatrix,60);
  groebnerRow39_100000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,122);
  groebnerMatrix(60,122) = 0.0;
  groebnerMatrix(60,128) = groebnerMatrix(60,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(60,180) = groebnerMatrix(60,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(60,123);
  groebnerMatrix(60,123) = 0.0;
  groebnerMatrix(60,136) = groebnerMatrix(60,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(60,179) = groebnerMatrix(60,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,60);
  groebnerRow47_000000000_f(groebnerMatrix,60);
  factor = groebnerMatrix(60,127);
  groebnerMatrix(60,127) = 0.0;
  groebnerMatrix(60,134) = groebnerMatrix(60,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(60,181) = groebnerMatrix(60,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,60);
  groebnerRow49_000000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,130);
  groebnerMatrix(60,130) = 0.0;
  groebnerMatrix(60,137) = groebnerMatrix(60,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,178) = groebnerMatrix(60,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,60);
  groebnerRow51_000000000_f(groebnerMatrix,60);
  groebnerRow52_000000000_f(groebnerMatrix,60);
  groebnerRow53_000000000_f(groebnerMatrix,60);
  groebnerRow54_000000000_f(groebnerMatrix,60);
  groebnerRow55_000000000_f(groebnerMatrix,60);
  groebnerRow56_000000000_f(groebnerMatrix,60);
  groebnerRow57_000000000_f(groebnerMatrix,60);
  groebnerRow58_000000000_f(groebnerMatrix,60);
  groebnerRow59_000000000_f(groebnerMatrix,60);
  factor = groebnerMatrix(60,142);
  groebnerMatrix(60,142) = 0.0;
  groebnerMatrix(60,144) = groebnerMatrix(60,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(60,147) = groebnerMatrix(60,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(60,196) = groebnerMatrix(60,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(60,143);
  groebnerMatrix(60,143) = 0.0;
  groebnerMatrix(60,155) = groebnerMatrix(60,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(60,176) = groebnerMatrix(60,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(60,144);
  groebnerMatrix(60,144) = 0.0;
  groebnerMatrix(60,156) = groebnerMatrix(60,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(60,177) = groebnerMatrix(60,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(60,196) = groebnerMatrix(60,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(60,147);
  groebnerMatrix(60,147) = 0.0;
  groebnerMatrix(60,162) = groebnerMatrix(60,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(60,186) = groebnerMatrix(60,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(60,196) = groebnerMatrix(60,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(60,148);
  groebnerMatrix(60,148) = 0.0;
  groebnerMatrix(60,153) = groebnerMatrix(60,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(60,159) = groebnerMatrix(60,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,60);
  groebnerRow31_000000000_f(groebnerMatrix,60);
  factor = -groebnerMatrix(60,154);
  groebnerMatrix(60,154) = 0.0;
  groebnerMatrix(60,158) = groebnerMatrix(60,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(60,193) = groebnerMatrix(60,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,60);
  groebnerRow33_000000000_f(groebnerMatrix,60);
  groebnerRow34_000000000_f(groebnerMatrix,60);
  groebnerRow35_000000000_f(groebnerMatrix,60);
  groebnerRow36_000000000_f(groebnerMatrix,60);
  groebnerRow37_000000000_f(groebnerMatrix,60);
  groebnerRow38_000000000_f(groebnerMatrix,60);
  groebnerRow39_000000000_f(groebnerMatrix,60);
  factor = groebnerMatrix(60,163);
  groebnerMatrix(60,163) = 0.0;
  groebnerMatrix(60,171) = groebnerMatrix(60,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(60,180) = groebnerMatrix(60,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(60,167);
  groebnerMatrix(60,167) = 0.0;
  groebnerMatrix(60,173) = groebnerMatrix(60,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(60,189) = groebnerMatrix(60,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(60,168);
  groebnerMatrix(60,168) = 0.0;
  groebnerMatrix(60,181) = groebnerMatrix(60,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(60,188) = groebnerMatrix(60,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(60,172);
  groebnerMatrix(60,172) = 0.0;
  groebnerMatrix(60,179) = groebnerMatrix(60,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(60,190) = groebnerMatrix(60,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(60,175);
  groebnerMatrix(60,175) = 0.0;
  groebnerMatrix(60,182) = groebnerMatrix(60,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(60,187) = groebnerMatrix(60,187) - factor * groebnerMatrix(18,187);

  sPolynomial61(groebnerMatrix);
  groebnerRow33_000100000_f(groebnerMatrix,61);
  groebnerRow34_000100000_f(groebnerMatrix,61);
  groebnerRow35_000100000_f(groebnerMatrix,61);
  groebnerRow36_000100000_f(groebnerMatrix,61);
  groebnerRow37_000100000_f(groebnerMatrix,61);
  groebnerRow38_000100000_f(groebnerMatrix,61);
  groebnerRow39_000100000_f(groebnerMatrix,61);
  groebnerRow30_010000000_f(groebnerMatrix,61);
  groebnerRow31_010000000_f(groebnerMatrix,61);
  groebnerRow32_010000000_f(groebnerMatrix,61);
  groebnerRow33_010000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,76);
  groebnerMatrix(61,76) = 0.0;
  groebnerMatrix(61,107) = groebnerMatrix(61,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,142) = groebnerMatrix(61,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(61,77);
  groebnerMatrix(61,77) = 0.0;
  groebnerMatrix(61,108) = groebnerMatrix(61,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,143) = groebnerMatrix(61,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(61,78);
  groebnerMatrix(61,78) = 0.0;
  groebnerMatrix(61,113) = groebnerMatrix(61,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(61,160) = groebnerMatrix(61,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(61,79);
  groebnerMatrix(61,79) = 0.0;
  groebnerMatrix(61,110) = groebnerMatrix(61,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,148) = groebnerMatrix(61,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(61,80);
  groebnerMatrix(61,80) = 0.0;
  groebnerMatrix(61,111) = groebnerMatrix(61,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,152) = groebnerMatrix(61,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(61,81);
  groebnerMatrix(61,81) = 0.0;
  groebnerMatrix(61,116) = groebnerMatrix(61,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,157) = groebnerMatrix(61,157) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(61,86);
  groebnerMatrix(61,86) = 0.0;
  groebnerMatrix(61,92) = groebnerMatrix(61,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(61,172) = groebnerMatrix(61,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(61,87);
  groebnerMatrix(61,87) = 0.0;
  groebnerMatrix(61,122) = groebnerMatrix(61,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,163) = groebnerMatrix(61,163) - factor * groebnerMatrix(18,187);
  groebnerRow40_000000000_f(groebnerMatrix,61);
  groebnerRow41_000000000_f(groebnerMatrix,61);
  groebnerRow42_000000000_f(groebnerMatrix,61);
  groebnerRow43_000000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,94);
  groebnerMatrix(61,94) = 0.0;
  groebnerMatrix(61,129) = groebnerMatrix(61,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,170) = groebnerMatrix(61,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,61);
  groebnerRow45_000000000_f(groebnerMatrix,61);
  groebnerRow30_100000000_f(groebnerMatrix,61);
  groebnerRow31_100000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,109);
  groebnerMatrix(61,109) = 0.0;
  groebnerMatrix(61,113) = groebnerMatrix(61,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(61,184) = groebnerMatrix(61,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,61);
  groebnerRow33_100000000_f(groebnerMatrix,61);
  groebnerRow34_100000000_f(groebnerMatrix,61);
  groebnerRow35_100000000_f(groebnerMatrix,61);
  groebnerRow36_100000000_f(groebnerMatrix,61);
  groebnerRow37_100000000_f(groebnerMatrix,61);
  groebnerRow38_100000000_f(groebnerMatrix,61);
  groebnerRow39_100000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,122);
  groebnerMatrix(61,122) = 0.0;
  groebnerMatrix(61,128) = groebnerMatrix(61,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(61,180) = groebnerMatrix(61,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(61,123);
  groebnerMatrix(61,123) = 0.0;
  groebnerMatrix(61,136) = groebnerMatrix(61,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(61,179) = groebnerMatrix(61,179) - factor * groebnerMatrix(27,188);
  groebnerRow46_000000000_f(groebnerMatrix,61);
  groebnerRow47_000000000_f(groebnerMatrix,61);
  factor = groebnerMatrix(61,127);
  groebnerMatrix(61,127) = 0.0;
  groebnerMatrix(61,134) = groebnerMatrix(61,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(61,181) = groebnerMatrix(61,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,61);
  groebnerRow49_000000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,130);
  groebnerMatrix(61,130) = 0.0;
  groebnerMatrix(61,137) = groebnerMatrix(61,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,178) = groebnerMatrix(61,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,61);
  groebnerRow51_000000000_f(groebnerMatrix,61);
  groebnerRow52_000000000_f(groebnerMatrix,61);
  groebnerRow53_000000000_f(groebnerMatrix,61);
  groebnerRow54_000000000_f(groebnerMatrix,61);
  groebnerRow55_000000000_f(groebnerMatrix,61);
  groebnerRow56_000000000_f(groebnerMatrix,61);
  groebnerRow57_000000000_f(groebnerMatrix,61);
  groebnerRow58_000000000_f(groebnerMatrix,61);
  groebnerRow59_000000000_f(groebnerMatrix,61);
  groebnerRow60_000000000_f(groebnerMatrix,61);
  factor = groebnerMatrix(61,142);
  groebnerMatrix(61,142) = 0.0;
  groebnerMatrix(61,144) = groebnerMatrix(61,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(61,147) = groebnerMatrix(61,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(61,196) = groebnerMatrix(61,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(61,143);
  groebnerMatrix(61,143) = 0.0;
  groebnerMatrix(61,155) = groebnerMatrix(61,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(61,176) = groebnerMatrix(61,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(61,144);
  groebnerMatrix(61,144) = 0.0;
  groebnerMatrix(61,156) = groebnerMatrix(61,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(61,177) = groebnerMatrix(61,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(61,196) = groebnerMatrix(61,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(61,147);
  groebnerMatrix(61,147) = 0.0;
  groebnerMatrix(61,162) = groebnerMatrix(61,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(61,186) = groebnerMatrix(61,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(61,196) = groebnerMatrix(61,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(61,148);
  groebnerMatrix(61,148) = 0.0;
  groebnerMatrix(61,153) = groebnerMatrix(61,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(61,159) = groebnerMatrix(61,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,61);
  groebnerRow31_000000000_f(groebnerMatrix,61);
  factor = -groebnerMatrix(61,154);
  groebnerMatrix(61,154) = 0.0;
  groebnerMatrix(61,158) = groebnerMatrix(61,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(61,193) = groebnerMatrix(61,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,61);
  groebnerRow33_000000000_f(groebnerMatrix,61);
  groebnerRow34_000000000_f(groebnerMatrix,61);
  groebnerRow35_000000000_f(groebnerMatrix,61);
  groebnerRow36_000000000_f(groebnerMatrix,61);
  groebnerRow37_000000000_f(groebnerMatrix,61);
  groebnerRow38_000000000_f(groebnerMatrix,61);
  groebnerRow39_000000000_f(groebnerMatrix,61);
  factor = groebnerMatrix(61,163);
  groebnerMatrix(61,163) = 0.0;
  groebnerMatrix(61,171) = groebnerMatrix(61,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(61,180) = groebnerMatrix(61,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(61,167);
  groebnerMatrix(61,167) = 0.0;
  groebnerMatrix(61,173) = groebnerMatrix(61,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(61,189) = groebnerMatrix(61,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(61,168);
  groebnerMatrix(61,168) = 0.0;
  groebnerMatrix(61,181) = groebnerMatrix(61,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(61,188) = groebnerMatrix(61,188) - factor * groebnerMatrix(27,188);
  factor = groebnerMatrix(61,172);
  groebnerMatrix(61,172) = 0.0;
  groebnerMatrix(61,179) = groebnerMatrix(61,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(61,190) = groebnerMatrix(61,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(61,175);
  groebnerMatrix(61,175) = 0.0;
  groebnerMatrix(61,182) = groebnerMatrix(61,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(61,187) = groebnerMatrix(61,187) - factor * groebnerMatrix(18,187);

  sPolynomial62(groebnerMatrix);
  groebnerRow33_000100000_f(groebnerMatrix,62);
  groebnerRow34_000100000_f(groebnerMatrix,62);
  groebnerRow35_000100000_f(groebnerMatrix,62);
  groebnerRow36_000100000_f(groebnerMatrix,62);
  groebnerRow37_000100000_f(groebnerMatrix,62);
  groebnerRow38_000100000_f(groebnerMatrix,62);
  groebnerRow39_000100000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,67);
  groebnerMatrix(62,67) = 0.0;
  groebnerMatrix(62,72) = groebnerMatrix(62,72) - factor * groebnerMatrix(14,153);
  groebnerMatrix(62,78) = groebnerMatrix(62,78) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(62,68);
  groebnerMatrix(62,68) = 0.0;
  groebnerMatrix(62,71) = groebnerMatrix(62,71) - factor * groebnerMatrix(19,152);
  groebnerMatrix(62,185) = groebnerMatrix(62,185) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(62,70);
  groebnerMatrix(62,70) = 0.0;
  groebnerMatrix(62,75) = groebnerMatrix(62,75) - factor * groebnerMatrix(13,156);
  groebnerMatrix(62,81) = groebnerMatrix(62,81) - factor * groebnerMatrix(13,162);
  groebnerMatrix(62,194) = groebnerMatrix(62,194) - factor * groebnerMatrix(13,196);
  groebnerRow30_010000000_f(groebnerMatrix,62);
  groebnerRow31_010000000_f(groebnerMatrix,62);
  groebnerRow32_010000000_f(groebnerMatrix,62);
  groebnerRow33_010000000_f(groebnerMatrix,62);
  factor = -groebnerMatrix(62,76);
  groebnerMatrix(62,76) = 0.0;
  groebnerMatrix(62,107) = groebnerMatrix(62,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,142) = groebnerMatrix(62,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(62,77);
  groebnerMatrix(62,77) = 0.0;
  groebnerMatrix(62,108) = groebnerMatrix(62,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,143) = groebnerMatrix(62,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(62,78);
  groebnerMatrix(62,78) = 0.0;
  groebnerMatrix(62,113) = groebnerMatrix(62,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(62,160) = groebnerMatrix(62,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(62,79);
  groebnerMatrix(62,79) = 0.0;
  groebnerMatrix(62,110) = groebnerMatrix(62,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,148) = groebnerMatrix(62,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(62,80);
  groebnerMatrix(62,80) = 0.0;
  groebnerMatrix(62,111) = groebnerMatrix(62,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,152) = groebnerMatrix(62,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(62,81);
  groebnerMatrix(62,81) = 0.0;
  groebnerMatrix(62,116) = groebnerMatrix(62,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,157) = groebnerMatrix(62,157) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(62,85);
  groebnerMatrix(62,85) = 0.0;
  groebnerMatrix(62,93) = groebnerMatrix(62,93) - factor * groebnerMatrix(11,174);
  groebnerMatrix(62,130) = groebnerMatrix(62,130) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(62,87);
  groebnerMatrix(62,87) = 0.0;
  groebnerMatrix(62,122) = groebnerMatrix(62,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,163) = groebnerMatrix(62,163) - factor * groebnerMatrix(18,187);
  groebnerRow61_010000000_f(groebnerMatrix,62);
  groebnerRow41_000000000_f(groebnerMatrix,62);
  groebnerRow42_000000000_f(groebnerMatrix,62);
  groebnerRow43_000000000_f(groebnerMatrix,62);
  factor = -groebnerMatrix(62,94);
  groebnerMatrix(62,94) = 0.0;
  groebnerMatrix(62,129) = groebnerMatrix(62,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,170) = groebnerMatrix(62,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,62);
  groebnerRow45_000000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,103);
  groebnerMatrix(62,103) = 0.0;
  groebnerMatrix(62,108) = groebnerMatrix(62,108) - factor * groebnerMatrix(14,153);
  groebnerMatrix(62,114) = groebnerMatrix(62,114) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(62,104);
  groebnerMatrix(62,104) = 0.0;
  groebnerMatrix(62,107) = groebnerMatrix(62,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(62,186) = groebnerMatrix(62,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(62,105);
  groebnerMatrix(62,105) = 0.0;
  groebnerMatrix(62,112) = groebnerMatrix(62,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(62,185) = groebnerMatrix(62,185) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(62,106);
  groebnerMatrix(62,106) = 0.0;
  groebnerMatrix(62,111) = groebnerMatrix(62,111) - factor * groebnerMatrix(13,156);
  groebnerMatrix(62,117) = groebnerMatrix(62,117) - factor * groebnerMatrix(13,162);
  groebnerMatrix(62,195) = groebnerMatrix(62,195) - factor * groebnerMatrix(13,196);
  groebnerRow30_100000000_f(groebnerMatrix,62);
  groebnerRow31_100000000_f(groebnerMatrix,62);
  groebnerRow32_100000000_f(groebnerMatrix,62);
  groebnerRow33_100000000_f(groebnerMatrix,62);
  groebnerRow34_100000000_f(groebnerMatrix,62);
  groebnerRow35_100000000_f(groebnerMatrix,62);
  groebnerRow36_100000000_f(groebnerMatrix,62);
  groebnerRow37_100000000_f(groebnerMatrix,62);
  groebnerRow38_100000000_f(groebnerMatrix,62);
  groebnerRow39_100000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,121);
  groebnerMatrix(62,121) = 0.0;
  groebnerMatrix(62,129) = groebnerMatrix(62,129) - factor * groebnerMatrix(11,174);
  groebnerMatrix(62,138) = groebnerMatrix(62,138) - factor * groebnerMatrix(11,183);
  factor = -groebnerMatrix(62,122);
  groebnerMatrix(62,122) = 0.0;
  groebnerMatrix(62,128) = groebnerMatrix(62,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(62,180) = groebnerMatrix(62,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(62,123);
  groebnerMatrix(62,123) = 0.0;
  groebnerMatrix(62,136) = groebnerMatrix(62,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(62,179) = groebnerMatrix(62,179) - factor * groebnerMatrix(27,188);
  groebnerRow61_100000000_f(groebnerMatrix,62);
  groebnerRow47_000000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,127);
  groebnerMatrix(62,127) = 0.0;
  groebnerMatrix(62,134) = groebnerMatrix(62,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(62,181) = groebnerMatrix(62,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,62);
  groebnerRow49_000000000_f(groebnerMatrix,62);
  factor = -groebnerMatrix(62,130);
  groebnerMatrix(62,130) = 0.0;
  groebnerMatrix(62,137) = groebnerMatrix(62,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,178) = groebnerMatrix(62,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,62);
  groebnerRow51_000000000_f(groebnerMatrix,62);
  groebnerRow52_000000000_f(groebnerMatrix,62);
  groebnerRow53_000000000_f(groebnerMatrix,62);
  groebnerRow54_000000000_f(groebnerMatrix,62);
  groebnerRow55_000000000_f(groebnerMatrix,62);
  groebnerRow56_000000000_f(groebnerMatrix,62);
  groebnerRow57_000000000_f(groebnerMatrix,62);
  groebnerRow58_000000000_f(groebnerMatrix,62);
  groebnerRow59_000000000_f(groebnerMatrix,62);
  groebnerRow60_000000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,142);
  groebnerMatrix(62,142) = 0.0;
  groebnerMatrix(62,144) = groebnerMatrix(62,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(62,147) = groebnerMatrix(62,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(62,196) = groebnerMatrix(62,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(62,143);
  groebnerMatrix(62,143) = 0.0;
  groebnerMatrix(62,155) = groebnerMatrix(62,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(62,176) = groebnerMatrix(62,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(62,144);
  groebnerMatrix(62,144) = 0.0;
  groebnerMatrix(62,156) = groebnerMatrix(62,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(62,177) = groebnerMatrix(62,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(62,196) = groebnerMatrix(62,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(62,147);
  groebnerMatrix(62,147) = 0.0;
  groebnerMatrix(62,162) = groebnerMatrix(62,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(62,186) = groebnerMatrix(62,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(62,196) = groebnerMatrix(62,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(62,148);
  groebnerMatrix(62,148) = 0.0;
  groebnerMatrix(62,153) = groebnerMatrix(62,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(62,159) = groebnerMatrix(62,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(62,149);
  groebnerMatrix(62,149) = 0.0;
  groebnerMatrix(62,152) = groebnerMatrix(62,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(62,195) = groebnerMatrix(62,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(62,150);
  groebnerMatrix(62,150) = 0.0;
  groebnerMatrix(62,157) = groebnerMatrix(62,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(62,194) = groebnerMatrix(62,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(62,151);
  groebnerMatrix(62,151) = 0.0;
  groebnerMatrix(62,156) = groebnerMatrix(62,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(62,162) = groebnerMatrix(62,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(62,196) = groebnerMatrix(62,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,62);
  groebnerRow31_000000000_f(groebnerMatrix,62);
  groebnerRow32_000000000_f(groebnerMatrix,62);
  groebnerRow33_000000000_f(groebnerMatrix,62);
  groebnerRow34_000000000_f(groebnerMatrix,62);
  groebnerRow35_000000000_f(groebnerMatrix,62);
  groebnerRow36_000000000_f(groebnerMatrix,62);
  groebnerRow37_000000000_f(groebnerMatrix,62);
  groebnerRow38_000000000_f(groebnerMatrix,62);
  groebnerRow39_000000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,163);
  groebnerMatrix(62,163) = 0.0;
  groebnerMatrix(62,171) = groebnerMatrix(62,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(62,180) = groebnerMatrix(62,180) - factor * groebnerMatrix(12,180);
  factor = groebnerMatrix(62,166);
  groebnerMatrix(62,166) = 0.0;
  groebnerMatrix(62,174) = groebnerMatrix(62,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(62,183) = groebnerMatrix(62,183) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(62,168);
  groebnerMatrix(62,168) = 0.0;
  groebnerMatrix(62,181) = groebnerMatrix(62,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(62,188) = groebnerMatrix(62,188) - factor * groebnerMatrix(27,188);
  groebnerRow61_000000000_f(groebnerMatrix,62);
  factor = groebnerMatrix(62,172);
  groebnerMatrix(62,172) = 0.0;
  groebnerMatrix(62,179) = groebnerMatrix(62,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(62,190) = groebnerMatrix(62,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(62,175);
  groebnerMatrix(62,175) = 0.0;
  groebnerMatrix(62,182) = groebnerMatrix(62,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(62,187) = groebnerMatrix(62,187) - factor * groebnerMatrix(18,187);

  sPolynomial63(groebnerMatrix);
  groebnerRow32_000100000_f(groebnerMatrix,63);
  groebnerRow33_000100000_f(groebnerMatrix,63);
  groebnerRow34_000100000_f(groebnerMatrix,63);
  groebnerRow35_000100000_f(groebnerMatrix,63);
  groebnerRow36_000100000_f(groebnerMatrix,63);
  groebnerRow37_000100000_f(groebnerMatrix,63);
  groebnerRow38_000100000_f(groebnerMatrix,63);
  groebnerRow39_000100000_f(groebnerMatrix,63);
  groebnerRow30_010000000_f(groebnerMatrix,63);
  groebnerRow31_010000000_f(groebnerMatrix,63);
  groebnerRow32_010000000_f(groebnerMatrix,63);
  groebnerRow33_010000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,76);
  groebnerMatrix(63,76) = 0.0;
  groebnerMatrix(63,107) = groebnerMatrix(63,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,142) = groebnerMatrix(63,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(63,77);
  groebnerMatrix(63,77) = 0.0;
  groebnerMatrix(63,108) = groebnerMatrix(63,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,143) = groebnerMatrix(63,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(63,78);
  groebnerMatrix(63,78) = 0.0;
  groebnerMatrix(63,113) = groebnerMatrix(63,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(63,160) = groebnerMatrix(63,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(63,79);
  groebnerMatrix(63,79) = 0.0;
  groebnerMatrix(63,110) = groebnerMatrix(63,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,148) = groebnerMatrix(63,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(63,80);
  groebnerMatrix(63,80) = 0.0;
  groebnerMatrix(63,111) = groebnerMatrix(63,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,152) = groebnerMatrix(63,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(63,81);
  groebnerMatrix(63,81) = 0.0;
  groebnerMatrix(63,116) = groebnerMatrix(63,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,157) = groebnerMatrix(63,157) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(63,86);
  groebnerMatrix(63,86) = 0.0;
  groebnerMatrix(63,92) = groebnerMatrix(63,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(63,172) = groebnerMatrix(63,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(63,87);
  groebnerMatrix(63,87) = 0.0;
  groebnerMatrix(63,122) = groebnerMatrix(63,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,163) = groebnerMatrix(63,163) - factor * groebnerMatrix(18,187);
  groebnerRow61_010000000_f(groebnerMatrix,63);
  groebnerRow62_010000000_f(groebnerMatrix,63);
  groebnerRow42_000000000_f(groebnerMatrix,63);
  groebnerRow43_000000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,94);
  groebnerMatrix(63,94) = 0.0;
  groebnerMatrix(63,129) = groebnerMatrix(63,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,170) = groebnerMatrix(63,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,63);
  groebnerRow45_000000000_f(groebnerMatrix,63);
  groebnerRow30_100000000_f(groebnerMatrix,63);
  groebnerRow31_100000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,109);
  groebnerMatrix(63,109) = 0.0;
  groebnerMatrix(63,113) = groebnerMatrix(63,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(63,184) = groebnerMatrix(63,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,63);
  groebnerRow33_100000000_f(groebnerMatrix,63);
  groebnerRow34_100000000_f(groebnerMatrix,63);
  groebnerRow35_100000000_f(groebnerMatrix,63);
  groebnerRow36_100000000_f(groebnerMatrix,63);
  groebnerRow37_100000000_f(groebnerMatrix,63);
  groebnerRow38_100000000_f(groebnerMatrix,63);
  groebnerRow39_100000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,122);
  groebnerMatrix(63,122) = 0.0;
  groebnerMatrix(63,128) = groebnerMatrix(63,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(63,180) = groebnerMatrix(63,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(63,123);
  groebnerMatrix(63,123) = 0.0;
  groebnerMatrix(63,136) = groebnerMatrix(63,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(63,179) = groebnerMatrix(63,179) - factor * groebnerMatrix(27,188);
  groebnerRow61_100000000_f(groebnerMatrix,63);
  groebnerRow62_100000000_f(groebnerMatrix,63);
  factor = groebnerMatrix(63,127);
  groebnerMatrix(63,127) = 0.0;
  groebnerMatrix(63,134) = groebnerMatrix(63,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(63,181) = groebnerMatrix(63,181) - factor * groebnerMatrix(17,190);
  groebnerRow48_000000000_f(groebnerMatrix,63);
  groebnerRow49_000000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,130);
  groebnerMatrix(63,130) = 0.0;
  groebnerMatrix(63,137) = groebnerMatrix(63,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,178) = groebnerMatrix(63,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,63);
  groebnerRow51_000000000_f(groebnerMatrix,63);
  groebnerRow52_000000000_f(groebnerMatrix,63);
  groebnerRow53_000000000_f(groebnerMatrix,63);
  groebnerRow54_000000000_f(groebnerMatrix,63);
  groebnerRow55_000000000_f(groebnerMatrix,63);
  groebnerRow56_000000000_f(groebnerMatrix,63);
  groebnerRow57_000000000_f(groebnerMatrix,63);
  groebnerRow58_000000000_f(groebnerMatrix,63);
  groebnerRow59_000000000_f(groebnerMatrix,63);
  groebnerRow60_000000000_f(groebnerMatrix,63);
  factor = groebnerMatrix(63,142);
  groebnerMatrix(63,142) = 0.0;
  groebnerMatrix(63,144) = groebnerMatrix(63,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(63,147) = groebnerMatrix(63,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(63,196) = groebnerMatrix(63,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(63,143);
  groebnerMatrix(63,143) = 0.0;
  groebnerMatrix(63,155) = groebnerMatrix(63,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(63,176) = groebnerMatrix(63,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(63,144);
  groebnerMatrix(63,144) = 0.0;
  groebnerMatrix(63,156) = groebnerMatrix(63,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(63,177) = groebnerMatrix(63,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(63,196) = groebnerMatrix(63,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(63,147);
  groebnerMatrix(63,147) = 0.0;
  groebnerMatrix(63,162) = groebnerMatrix(63,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(63,186) = groebnerMatrix(63,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(63,196) = groebnerMatrix(63,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(63,148);
  groebnerMatrix(63,148) = 0.0;
  groebnerMatrix(63,153) = groebnerMatrix(63,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(63,159) = groebnerMatrix(63,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,63);
  groebnerRow31_000000000_f(groebnerMatrix,63);
  factor = -groebnerMatrix(63,154);
  groebnerMatrix(63,154) = 0.0;
  groebnerMatrix(63,158) = groebnerMatrix(63,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(63,193) = groebnerMatrix(63,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,63);
  groebnerRow33_000000000_f(groebnerMatrix,63);
  groebnerRow34_000000000_f(groebnerMatrix,63);
  groebnerRow35_000000000_f(groebnerMatrix,63);
  groebnerRow36_000000000_f(groebnerMatrix,63);
  groebnerRow37_000000000_f(groebnerMatrix,63);
  groebnerRow38_000000000_f(groebnerMatrix,63);
  groebnerRow39_000000000_f(groebnerMatrix,63);
  factor = groebnerMatrix(63,163);
  groebnerMatrix(63,163) = 0.0;
  groebnerMatrix(63,171) = groebnerMatrix(63,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(63,180) = groebnerMatrix(63,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(63,167);
  groebnerMatrix(63,167) = 0.0;
  groebnerMatrix(63,173) = groebnerMatrix(63,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(63,189) = groebnerMatrix(63,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(63,168);
  groebnerMatrix(63,168) = 0.0;
  groebnerMatrix(63,181) = groebnerMatrix(63,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(63,188) = groebnerMatrix(63,188) - factor * groebnerMatrix(27,188);
  groebnerRow61_000000000_f(groebnerMatrix,63);
  groebnerRow62_000000000_f(groebnerMatrix,63);
  factor = groebnerMatrix(63,172);
  groebnerMatrix(63,172) = 0.0;
  groebnerMatrix(63,179) = groebnerMatrix(63,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(63,190) = groebnerMatrix(63,190) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(63,175);
  groebnerMatrix(63,175) = 0.0;
  groebnerMatrix(63,182) = groebnerMatrix(63,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(63,187) = groebnerMatrix(63,187) - factor * groebnerMatrix(18,187);

  sPolynomial64(groebnerMatrix);
  groebnerRow35_000100000_f(groebnerMatrix,64);
  groebnerRow36_000100000_f(groebnerMatrix,64);
  groebnerRow37_000100000_f(groebnerMatrix,64);
  groebnerRow38_000100000_f(groebnerMatrix,64);
  groebnerRow39_000100000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,64);
  groebnerMatrix(64,64) = 0.0;
  groebnerMatrix(64,98) = groebnerMatrix(64,98) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,148) = groebnerMatrix(64,148) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(64,65);
  groebnerMatrix(64,65) = 0.0;
  groebnerMatrix(64,99) = groebnerMatrix(64,99) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,149) = groebnerMatrix(64,149) - factor * groebnerMatrix(17,190);
  factor = groebnerMatrix(64,69);
  groebnerMatrix(64,69) = 0.0;
  groebnerMatrix(64,104) = groebnerMatrix(64,104) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,151) = groebnerMatrix(64,151) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(64,73);
  groebnerMatrix(64,73) = 0.0;
  groebnerMatrix(64,77) = groebnerMatrix(64,77) - factor * groebnerMatrix(16,158);
  groebnerMatrix(64,176) = groebnerMatrix(64,176) - factor * groebnerMatrix(16,193);
  factor = -groebnerMatrix(64,76);
  groebnerMatrix(64,76) = 0.0;
  groebnerMatrix(64,107) = groebnerMatrix(64,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,142) = groebnerMatrix(64,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(64,77);
  groebnerMatrix(64,77) = 0.0;
  groebnerMatrix(64,108) = groebnerMatrix(64,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,143) = groebnerMatrix(64,143) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(64,79);
  groebnerMatrix(64,79) = 0.0;
  groebnerMatrix(64,110) = groebnerMatrix(64,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,148) = groebnerMatrix(64,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(64,80);
  groebnerMatrix(64,80) = 0.0;
  groebnerMatrix(64,111) = groebnerMatrix(64,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,152) = groebnerMatrix(64,152) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(64,84);
  groebnerMatrix(64,84) = 0.0;
  groebnerMatrix(64,119) = groebnerMatrix(64,119) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,166) = groebnerMatrix(64,166) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(64,87);
  groebnerMatrix(64,87) = 0.0;
  groebnerMatrix(64,122) = groebnerMatrix(64,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,163) = groebnerMatrix(64,163) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(64,91);
  groebnerMatrix(64,91) = 0.0;
  groebnerMatrix(64,126) = groebnerMatrix(64,126) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,173) = groebnerMatrix(64,173) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(64,94);
  groebnerMatrix(64,94) = 0.0;
  groebnerMatrix(64,129) = groebnerMatrix(64,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,170) = groebnerMatrix(64,170) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(64,98);
  groebnerMatrix(64,98) = 0.0;
  groebnerMatrix(64,110) = groebnerMatrix(64,110) - factor * groebnerMatrix(26,155);
  groebnerMatrix(64,131) = groebnerMatrix(64,131) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(64,99);
  groebnerMatrix(64,99) = 0.0;
  groebnerMatrix(64,111) = groebnerMatrix(64,111) - factor * groebnerMatrix(25,156);
  groebnerMatrix(64,132) = groebnerMatrix(64,132) - factor * groebnerMatrix(25,177);
  groebnerMatrix(64,195) = groebnerMatrix(64,195) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(64,100);
  groebnerMatrix(64,100) = 0.0;
  groebnerMatrix(64,115) = groebnerMatrix(64,115) - factor * groebnerMatrix(24,160);
  groebnerMatrix(64,139) = groebnerMatrix(64,139) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(64,101);
  groebnerMatrix(64,101) = 0.0;
  groebnerMatrix(64,116) = groebnerMatrix(64,116) - factor * groebnerMatrix(23,161);
  groebnerMatrix(64,140) = groebnerMatrix(64,140) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(64,102);
  groebnerMatrix(64,102) = 0.0;
  groebnerMatrix(64,117) = groebnerMatrix(64,117) - factor * groebnerMatrix(22,162);
  groebnerMatrix(64,141) = groebnerMatrix(64,141) - factor * groebnerMatrix(22,186);
  groebnerMatrix(64,195) = groebnerMatrix(64,195) - factor * groebnerMatrix(22,196);
  factor = -groebnerMatrix(64,104);
  groebnerMatrix(64,104) = 0.0;
  groebnerMatrix(64,107) = groebnerMatrix(64,107) - factor * groebnerMatrix(19,152);
  groebnerMatrix(64,186) = groebnerMatrix(64,186) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(64,105);
  groebnerMatrix(64,105) = 0.0;
  groebnerMatrix(64,112) = groebnerMatrix(64,112) - factor * groebnerMatrix(28,157);
  groebnerMatrix(64,185) = groebnerMatrix(64,185) - factor * groebnerMatrix(28,194);
  groebnerRow30_100000000_f(groebnerMatrix,64);
  groebnerRow31_100000000_f(groebnerMatrix,64);
  factor = -groebnerMatrix(64,109);
  groebnerMatrix(64,109) = 0.0;
  groebnerMatrix(64,113) = groebnerMatrix(64,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(64,184) = groebnerMatrix(64,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,64);
  groebnerRow33_100000000_f(groebnerMatrix,64);
  groebnerRow34_100000000_f(groebnerMatrix,64);
  groebnerRow35_100000000_f(groebnerMatrix,64);
  groebnerRow36_100000000_f(groebnerMatrix,64);
  groebnerRow37_100000000_f(groebnerMatrix,64);
  groebnerRow38_100000000_f(groebnerMatrix,64);
  groebnerRow39_100000000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,119);
  groebnerMatrix(64,119) = 0.0;
  groebnerMatrix(64,125) = groebnerMatrix(64,125) - factor * groebnerMatrix(20,170);
  groebnerMatrix(64,183) = groebnerMatrix(64,183) - factor * groebnerMatrix(20,192);
  factor = -groebnerMatrix(64,120);
  groebnerMatrix(64,120) = 0.0;
  groebnerMatrix(64,133) = groebnerMatrix(64,133) - factor * groebnerMatrix(29,178);
  groebnerMatrix(64,182) = groebnerMatrix(64,182) - factor * groebnerMatrix(29,191);
  factor = -groebnerMatrix(64,122);
  groebnerMatrix(64,122) = 0.0;
  groebnerMatrix(64,128) = groebnerMatrix(64,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(64,180) = groebnerMatrix(64,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(64,123);
  groebnerMatrix(64,123) = 0.0;
  groebnerMatrix(64,136) = groebnerMatrix(64,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(64,179) = groebnerMatrix(64,179) - factor * groebnerMatrix(27,188);
  groebnerRow61_100000000_f(groebnerMatrix,64);
  groebnerRow62_100000000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,127);
  groebnerMatrix(64,127) = 0.0;
  groebnerMatrix(64,134) = groebnerMatrix(64,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,181) = groebnerMatrix(64,181) - factor * groebnerMatrix(17,190);
  groebnerRow63_100000000_f(groebnerMatrix,64);
  groebnerRow49_000000000_f(groebnerMatrix,64);
  factor = -groebnerMatrix(64,130);
  groebnerMatrix(64,130) = 0.0;
  groebnerMatrix(64,137) = groebnerMatrix(64,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,178) = groebnerMatrix(64,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,64);
  groebnerRow51_000000000_f(groebnerMatrix,64);
  groebnerRow52_000000000_f(groebnerMatrix,64);
  groebnerRow53_000000000_f(groebnerMatrix,64);
  groebnerRow54_000000000_f(groebnerMatrix,64);
  groebnerRow55_000000000_f(groebnerMatrix,64);
  groebnerRow56_000000000_f(groebnerMatrix,64);
  groebnerRow57_000000000_f(groebnerMatrix,64);
  groebnerRow58_000000000_f(groebnerMatrix,64);
  groebnerRow59_000000000_f(groebnerMatrix,64);
  groebnerRow60_000000000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,142);
  groebnerMatrix(64,142) = 0.0;
  groebnerMatrix(64,144) = groebnerMatrix(64,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(64,147) = groebnerMatrix(64,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(64,196) = groebnerMatrix(64,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(64,143);
  groebnerMatrix(64,143) = 0.0;
  groebnerMatrix(64,155) = groebnerMatrix(64,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(64,176) = groebnerMatrix(64,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(64,144);
  groebnerMatrix(64,144) = 0.0;
  groebnerMatrix(64,156) = groebnerMatrix(64,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(64,177) = groebnerMatrix(64,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(64,196) = groebnerMatrix(64,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(64,145);
  groebnerMatrix(64,145) = 0.0;
  groebnerMatrix(64,160) = groebnerMatrix(64,160) - factor * groebnerMatrix(24,160);
  groebnerMatrix(64,184) = groebnerMatrix(64,184) - factor * groebnerMatrix(24,184);
  factor = groebnerMatrix(64,146);
  groebnerMatrix(64,146) = 0.0;
  groebnerMatrix(64,161) = groebnerMatrix(64,161) - factor * groebnerMatrix(23,161);
  groebnerMatrix(64,185) = groebnerMatrix(64,185) - factor * groebnerMatrix(23,185);
  factor = groebnerMatrix(64,147);
  groebnerMatrix(64,147) = 0.0;
  groebnerMatrix(64,162) = groebnerMatrix(64,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(64,186) = groebnerMatrix(64,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(64,196) = groebnerMatrix(64,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(64,148);
  groebnerMatrix(64,148) = 0.0;
  groebnerMatrix(64,153) = groebnerMatrix(64,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(64,159) = groebnerMatrix(64,159) - factor * groebnerMatrix(14,159);
  factor = -groebnerMatrix(64,149);
  groebnerMatrix(64,149) = 0.0;
  groebnerMatrix(64,152) = groebnerMatrix(64,152) - factor * groebnerMatrix(19,152);
  groebnerMatrix(64,195) = groebnerMatrix(64,195) - factor * groebnerMatrix(19,195);
  factor = groebnerMatrix(64,150);
  groebnerMatrix(64,150) = 0.0;
  groebnerMatrix(64,157) = groebnerMatrix(64,157) - factor * groebnerMatrix(28,157);
  groebnerMatrix(64,194) = groebnerMatrix(64,194) - factor * groebnerMatrix(28,194);
  factor = groebnerMatrix(64,151);
  groebnerMatrix(64,151) = 0.0;
  groebnerMatrix(64,156) = groebnerMatrix(64,156) - factor * groebnerMatrix(13,156);
  groebnerMatrix(64,162) = groebnerMatrix(64,162) - factor * groebnerMatrix(13,162);
  groebnerMatrix(64,196) = groebnerMatrix(64,196) - factor * groebnerMatrix(13,196);
  groebnerRow30_000000000_f(groebnerMatrix,64);
  groebnerRow31_000000000_f(groebnerMatrix,64);
  factor = -groebnerMatrix(64,154);
  groebnerMatrix(64,154) = 0.0;
  groebnerMatrix(64,158) = groebnerMatrix(64,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(64,193) = groebnerMatrix(64,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,64);
  groebnerRow33_000000000_f(groebnerMatrix,64);
  groebnerRow34_000000000_f(groebnerMatrix,64);
  groebnerRow35_000000000_f(groebnerMatrix,64);
  groebnerRow36_000000000_f(groebnerMatrix,64);
  groebnerRow37_000000000_f(groebnerMatrix,64);
  groebnerRow38_000000000_f(groebnerMatrix,64);
  groebnerRow39_000000000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,163);
  groebnerMatrix(64,163) = 0.0;
  groebnerMatrix(64,171) = groebnerMatrix(64,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(64,180) = groebnerMatrix(64,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(64,165);
  groebnerMatrix(64,165) = 0.0;
  groebnerMatrix(64,178) = groebnerMatrix(64,178) - factor * groebnerMatrix(29,178);
  groebnerMatrix(64,191) = groebnerMatrix(64,191) - factor * groebnerMatrix(29,191);
  factor = groebnerMatrix(64,166);
  groebnerMatrix(64,166) = 0.0;
  groebnerMatrix(64,174) = groebnerMatrix(64,174) - factor * groebnerMatrix(11,174);
  groebnerMatrix(64,183) = groebnerMatrix(64,183) - factor * groebnerMatrix(11,183);
  factor = groebnerMatrix(64,168);
  groebnerMatrix(64,168) = 0.0;
  groebnerMatrix(64,181) = groebnerMatrix(64,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(64,188) = groebnerMatrix(64,188) - factor * groebnerMatrix(27,188);
  groebnerRow61_000000000_f(groebnerMatrix,64);
  groebnerRow62_000000000_f(groebnerMatrix,64);
  factor = groebnerMatrix(64,172);
  groebnerMatrix(64,172) = 0.0;
  groebnerMatrix(64,179) = groebnerMatrix(64,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(64,190) = groebnerMatrix(64,190) - factor * groebnerMatrix(17,190);
  groebnerRow63_000000000_f(groebnerMatrix,64);
  factor = -groebnerMatrix(64,175);
  groebnerMatrix(64,175) = 0.0;
  groebnerMatrix(64,182) = groebnerMatrix(64,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(64,187) = groebnerMatrix(64,187) - factor * groebnerMatrix(18,187);

  sPolynomial65(groebnerMatrix);
  factor = -groebnerMatrix(65,30);
  groebnerMatrix(65,30) = 0.0;
  groebnerMatrix(65,34) = groebnerMatrix(65,34) - factor * groebnerMatrix(16,158);
  groebnerMatrix(65,168) = groebnerMatrix(65,168) - factor * groebnerMatrix(16,193);
  groebnerRow32_000100000_f(groebnerMatrix,65);
  groebnerRow33_000100000_f(groebnerMatrix,65);
  groebnerRow34_000100000_f(groebnerMatrix,65);
  groebnerRow35_000100000_f(groebnerMatrix,65);
  groebnerRow36_000100000_f(groebnerMatrix,65);
  groebnerRow37_000100000_f(groebnerMatrix,65);
  groebnerRow38_000100000_f(groebnerMatrix,65);
  groebnerRow39_000100000_f(groebnerMatrix,65);
  groebnerRow30_010000000_f(groebnerMatrix,65);
  groebnerRow31_010000000_f(groebnerMatrix,65);
  groebnerRow32_010000000_f(groebnerMatrix,65);
  groebnerRow33_010000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,76);
  groebnerMatrix(65,76) = 0.0;
  groebnerMatrix(65,107) = groebnerMatrix(65,107) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,142) = groebnerMatrix(65,142) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(65,77);
  groebnerMatrix(65,77) = 0.0;
  groebnerMatrix(65,108) = groebnerMatrix(65,108) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,143) = groebnerMatrix(65,143) - factor * groebnerMatrix(18,187);
  factor = groebnerMatrix(65,78);
  groebnerMatrix(65,78) = 0.0;
  groebnerMatrix(65,113) = groebnerMatrix(65,113) - factor * groebnerMatrix(17,179);
  groebnerMatrix(65,160) = groebnerMatrix(65,160) - factor * groebnerMatrix(17,190);
  factor = -groebnerMatrix(65,79);
  groebnerMatrix(65,79) = 0.0;
  groebnerMatrix(65,110) = groebnerMatrix(65,110) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,148) = groebnerMatrix(65,148) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(65,80);
  groebnerMatrix(65,80) = 0.0;
  groebnerMatrix(65,111) = groebnerMatrix(65,111) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,152) = groebnerMatrix(65,152) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(65,81);
  groebnerMatrix(65,81) = 0.0;
  groebnerMatrix(65,116) = groebnerMatrix(65,116) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,157) = groebnerMatrix(65,157) - factor * groebnerMatrix(18,187);
  factor = -groebnerMatrix(65,86);
  groebnerMatrix(65,86) = 0.0;
  groebnerMatrix(65,92) = groebnerMatrix(65,92) - factor * groebnerMatrix(21,173);
  groebnerMatrix(65,172) = groebnerMatrix(65,172) - factor * groebnerMatrix(21,189);
  factor = -groebnerMatrix(65,87);
  groebnerMatrix(65,87) = 0.0;
  groebnerMatrix(65,122) = groebnerMatrix(65,122) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,163) = groebnerMatrix(65,163) - factor * groebnerMatrix(18,187);
  groebnerRow61_010000000_f(groebnerMatrix,65);
  groebnerRow62_010000000_f(groebnerMatrix,65);
  groebnerRow63_010000000_f(groebnerMatrix,65);
  groebnerRow64_010000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,94);
  groebnerMatrix(65,94) = 0.0;
  groebnerMatrix(65,129) = groebnerMatrix(65,129) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,170) = groebnerMatrix(65,170) - factor * groebnerMatrix(18,187);
  groebnerRow44_000000000_f(groebnerMatrix,65);
  groebnerRow45_000000000_f(groebnerMatrix,65);
  groebnerRow30_100000000_f(groebnerMatrix,65);
  groebnerRow31_100000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,109);
  groebnerMatrix(65,109) = 0.0;
  groebnerMatrix(65,113) = groebnerMatrix(65,113) - factor * groebnerMatrix(16,158);
  groebnerMatrix(65,184) = groebnerMatrix(65,184) - factor * groebnerMatrix(16,193);
  groebnerRow32_100000000_f(groebnerMatrix,65);
  groebnerRow33_100000000_f(groebnerMatrix,65);
  groebnerRow34_100000000_f(groebnerMatrix,65);
  groebnerRow35_100000000_f(groebnerMatrix,65);
  groebnerRow36_100000000_f(groebnerMatrix,65);
  groebnerRow37_100000000_f(groebnerMatrix,65);
  groebnerRow38_100000000_f(groebnerMatrix,65);
  groebnerRow39_100000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,122);
  groebnerMatrix(65,122) = 0.0;
  groebnerMatrix(65,128) = groebnerMatrix(65,128) - factor * groebnerMatrix(21,173);
  groebnerMatrix(65,180) = groebnerMatrix(65,180) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(65,123);
  groebnerMatrix(65,123) = 0.0;
  groebnerMatrix(65,136) = groebnerMatrix(65,136) - factor * groebnerMatrix(27,181);
  groebnerMatrix(65,179) = groebnerMatrix(65,179) - factor * groebnerMatrix(27,188);
  groebnerRow61_100000000_f(groebnerMatrix,65);
  groebnerRow62_100000000_f(groebnerMatrix,65);
  factor = groebnerMatrix(65,127);
  groebnerMatrix(65,127) = 0.0;
  groebnerMatrix(65,134) = groebnerMatrix(65,134) - factor * groebnerMatrix(17,179);
  groebnerMatrix(65,181) = groebnerMatrix(65,181) - factor * groebnerMatrix(17,190);
  groebnerRow63_100000000_f(groebnerMatrix,65);
  groebnerRow64_100000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,130);
  groebnerMatrix(65,130) = 0.0;
  groebnerMatrix(65,137) = groebnerMatrix(65,137) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,178) = groebnerMatrix(65,178) - factor * groebnerMatrix(18,187);
  groebnerRow50_000000000_f(groebnerMatrix,65);
  groebnerRow51_000000000_f(groebnerMatrix,65);
  groebnerRow52_000000000_f(groebnerMatrix,65);
  groebnerRow53_000000000_f(groebnerMatrix,65);
  groebnerRow54_000000000_f(groebnerMatrix,65);
  groebnerRow55_000000000_f(groebnerMatrix,65);
  groebnerRow56_000000000_f(groebnerMatrix,65);
  groebnerRow57_000000000_f(groebnerMatrix,65);
  groebnerRow58_000000000_f(groebnerMatrix,65);
  groebnerRow59_000000000_f(groebnerMatrix,65);
  groebnerRow60_000000000_f(groebnerMatrix,65);
  factor = groebnerMatrix(65,142);
  groebnerMatrix(65,142) = 0.0;
  groebnerMatrix(65,144) = groebnerMatrix(65,144) - factor * groebnerMatrix(15,144);
  groebnerMatrix(65,147) = groebnerMatrix(65,147) - factor * groebnerMatrix(15,147);
  groebnerMatrix(65,196) = groebnerMatrix(65,196) - factor * groebnerMatrix(15,196);
  factor = groebnerMatrix(65,143);
  groebnerMatrix(65,143) = 0.0;
  groebnerMatrix(65,155) = groebnerMatrix(65,155) - factor * groebnerMatrix(26,155);
  groebnerMatrix(65,176) = groebnerMatrix(65,176) - factor * groebnerMatrix(26,176);
  factor = groebnerMatrix(65,144);
  groebnerMatrix(65,144) = 0.0;
  groebnerMatrix(65,156) = groebnerMatrix(65,156) - factor * groebnerMatrix(25,156);
  groebnerMatrix(65,177) = groebnerMatrix(65,177) - factor * groebnerMatrix(25,177);
  groebnerMatrix(65,196) = groebnerMatrix(65,196) - factor * groebnerMatrix(25,196);
  factor = groebnerMatrix(65,147);
  groebnerMatrix(65,147) = 0.0;
  groebnerMatrix(65,162) = groebnerMatrix(65,162) - factor * groebnerMatrix(22,162);
  groebnerMatrix(65,186) = groebnerMatrix(65,186) - factor * groebnerMatrix(22,186);
  groebnerMatrix(65,196) = groebnerMatrix(65,196) - factor * groebnerMatrix(22,196);
  factor = groebnerMatrix(65,148);
  groebnerMatrix(65,148) = 0.0;
  groebnerMatrix(65,153) = groebnerMatrix(65,153) - factor * groebnerMatrix(14,153);
  groebnerMatrix(65,159) = groebnerMatrix(65,159) - factor * groebnerMatrix(14,159);
  groebnerRow30_000000000_f(groebnerMatrix,65);
  groebnerRow31_000000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,154);
  groebnerMatrix(65,154) = 0.0;
  groebnerMatrix(65,158) = groebnerMatrix(65,158) - factor * groebnerMatrix(16,158);
  groebnerMatrix(65,193) = groebnerMatrix(65,193) - factor * groebnerMatrix(16,193);
  groebnerRow32_000000000_f(groebnerMatrix,65);
  groebnerRow33_000000000_f(groebnerMatrix,65);
  groebnerRow34_000000000_f(groebnerMatrix,65);
  groebnerRow35_000000000_f(groebnerMatrix,65);
  groebnerRow36_000000000_f(groebnerMatrix,65);
  groebnerRow37_000000000_f(groebnerMatrix,65);
  groebnerRow38_000000000_f(groebnerMatrix,65);
  groebnerRow39_000000000_f(groebnerMatrix,65);
  factor = groebnerMatrix(65,163);
  groebnerMatrix(65,163) = 0.0;
  groebnerMatrix(65,171) = groebnerMatrix(65,171) - factor * groebnerMatrix(12,171);
  groebnerMatrix(65,180) = groebnerMatrix(65,180) - factor * groebnerMatrix(12,180);
  factor = -groebnerMatrix(65,167);
  groebnerMatrix(65,167) = 0.0;
  groebnerMatrix(65,173) = groebnerMatrix(65,173) - factor * groebnerMatrix(21,173);
  groebnerMatrix(65,189) = groebnerMatrix(65,189) - factor * groebnerMatrix(21,189);
  factor = groebnerMatrix(65,168);
  groebnerMatrix(65,168) = 0.0;
  groebnerMatrix(65,181) = groebnerMatrix(65,181) - factor * groebnerMatrix(27,181);
  groebnerMatrix(65,188) = groebnerMatrix(65,188) - factor * groebnerMatrix(27,188);
  groebnerRow61_000000000_f(groebnerMatrix,65);
  groebnerRow62_000000000_f(groebnerMatrix,65);
  factor = groebnerMatrix(65,172);
  groebnerMatrix(65,172) = 0.0;
  groebnerMatrix(65,179) = groebnerMatrix(65,179) - factor * groebnerMatrix(17,179);
  groebnerMatrix(65,190) = groebnerMatrix(65,190) - factor * groebnerMatrix(17,190);
  groebnerRow63_000000000_f(groebnerMatrix,65);
  groebnerRow64_000000000_f(groebnerMatrix,65);
  factor = -groebnerMatrix(65,175);
  groebnerMatrix(65,175) = 0.0;
  groebnerMatrix(65,182) = groebnerMatrix(65,182) - factor * groebnerMatrix(18,182);
  groebnerMatrix(65,187) = groebnerMatrix(65,187) - factor * groebnerMatrix(18,187);

  factor = 1.0 / groebnerMatrix(10,169);
  groebnerMatrix.row(10) = factor * groebnerMatrix.row(10);
  factor = 1.0 / groebnerMatrix(11,166);
  groebnerMatrix.row(11) = factor * groebnerMatrix.row(11);
  factor = 1.0 / groebnerMatrix(12,163);
  groebnerMatrix.row(12) = factor * groebnerMatrix.row(12);
  factor = 1.0 / groebnerMatrix(13,151);
  groebnerMatrix.row(13) = factor * groebnerMatrix.row(13);
  factor = 1.0 / groebnerMatrix(14,148);
  groebnerMatrix.row(14) = factor * groebnerMatrix.row(14);
  factor = 1.0 / groebnerMatrix(15,142);
  groebnerMatrix.row(15) = factor * groebnerMatrix.row(15);
  factor = 1.0 / groebnerMatrix(16,154);
  groebnerMatrix.row(16) = factor * groebnerMatrix.row(16);
  factor = 1.0 / groebnerMatrix(17,172);
  groebnerMatrix.row(17) = factor * groebnerMatrix.row(17);
  factor = 1.0 / groebnerMatrix(18,175);
  groebnerMatrix.row(18) = factor * groebnerMatrix.row(18);
  factor = 1.0 / groebnerMatrix(19,149);
  groebnerMatrix.row(19) = factor * groebnerMatrix.row(19);
  factor = 1.0 / groebnerMatrix(20,164);
  groebnerMatrix.row(20) = factor * groebnerMatrix.row(20);
  factor = 1.0 / groebnerMatrix(21,167);
  groebnerMatrix.row(21) = factor * groebnerMatrix.row(21);
  factor = 1.0 / groebnerMatrix(22,147);
  groebnerMatrix.row(22) = factor * groebnerMatrix.row(22);
  factor = 1.0 / groebnerMatrix(23,146);
  groebnerMatrix.row(23) = factor * groebnerMatrix.row(23);
  factor = 1.0 / groebnerMatrix(24,145);
  groebnerMatrix.row(24) = factor * groebnerMatrix.row(24);
  factor = 1.0 / groebnerMatrix(25,144);
  groebnerMatrix.row(25) = factor * groebnerMatrix.row(25);
  factor = 1.0 / groebnerMatrix(26,143);
  groebnerMatrix.row(26) = factor * groebnerMatrix.row(26);
  factor = 1.0 / groebnerMatrix(27,168);
  groebnerMatrix.row(27) = factor * groebnerMatrix.row(27);
  factor = 1.0 / groebnerMatrix(28,150);
  groebnerMatrix.row(28) = factor * groebnerMatrix.row(28);
  factor = 1.0 / groebnerMatrix(29,165);
  groebnerMatrix.row(29) = factor * groebnerMatrix.row(29);
  factor = 1.0 / groebnerMatrix(30,152);
  groebnerMatrix.row(30) = factor * groebnerMatrix.row(30);
  factor = 1.0 / groebnerMatrix(31,153);
  groebnerMatrix.row(31) = factor * groebnerMatrix.row(31);
  factor = 1.0 / groebnerMatrix(32,155);
  groebnerMatrix.row(32) = factor * groebnerMatrix.row(32);
  factor = 1.0 / groebnerMatrix(33,156);
  groebnerMatrix.row(33) = factor * groebnerMatrix.row(33);
  factor = 1.0 / groebnerMatrix(34,157);
  groebnerMatrix.row(34) = factor * groebnerMatrix.row(34);
  factor = 1.0 / groebnerMatrix(35,158);
  groebnerMatrix.row(35) = factor * groebnerMatrix.row(35);
  factor = 1.0 / groebnerMatrix(36,159);
  groebnerMatrix.row(36) = factor * groebnerMatrix.row(36);
  factor = 1.0 / groebnerMatrix(37,160);
  groebnerMatrix.row(37) = factor * groebnerMatrix.row(37);
  factor = 1.0 / groebnerMatrix(38,161);
  groebnerMatrix.row(38) = factor * groebnerMatrix.row(38);
  factor = 1.0 / groebnerMatrix(39,162);
  groebnerMatrix.row(39) = factor * groebnerMatrix.row(39);
  factor = 1.0 / groebnerMatrix(45,96);
  groebnerMatrix.row(45) = factor * groebnerMatrix.row(45);
  factor = 1.0 / groebnerMatrix(51,132);
  groebnerMatrix.row(51) = factor * groebnerMatrix.row(51);
  factor = 1.0 / groebnerMatrix(52,133);
  groebnerMatrix.row(52) = factor * groebnerMatrix.row(52);
  factor = 1.0 / groebnerMatrix(53,134);
  groebnerMatrix.row(53) = factor * groebnerMatrix.row(53);
  factor = 1.0 / groebnerMatrix(54,135);
  groebnerMatrix.row(54) = factor * groebnerMatrix.row(54);
  factor = 1.0 / groebnerMatrix(55,136);
  groebnerMatrix.row(55) = factor * groebnerMatrix.row(55);
  factor = 1.0 / groebnerMatrix(56,137);
  groebnerMatrix.row(56) = factor * groebnerMatrix.row(56);
  factor = 1.0 / groebnerMatrix(57,138);
  groebnerMatrix.row(57) = factor * groebnerMatrix.row(57);
  factor = 1.0 / groebnerMatrix(58,139);
  groebnerMatrix.row(58) = factor * groebnerMatrix.row(58);
  factor = 1.0 / groebnerMatrix(59,140);
  groebnerMatrix.row(59) = factor * groebnerMatrix.row(59);
  factor = 1.0 / groebnerMatrix(60,141);
  groebnerMatrix.row(60) = factor * groebnerMatrix.row(60);
  factor = 1.0 / groebnerMatrix(61,170);
  groebnerMatrix.row(61) = factor * groebnerMatrix.row(61);
  factor = 1.0 / groebnerMatrix(62,171);
  groebnerMatrix.row(62) = factor * groebnerMatrix.row(62);
  factor = 1.0 / groebnerMatrix(63,173);
  groebnerMatrix.row(63) = factor * groebnerMatrix.row(63);
  factor = 1.0 / groebnerMatrix(64,174);
  groebnerMatrix.row(64) = factor * groebnerMatrix.row(64);
  factor = 1.0 / groebnerMatrix(65,176);
  groebnerMatrix.row(65) = factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(11,174);
  groebnerMatrix.row(11) = groebnerMatrix.row(11) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(11,176);
  groebnerMatrix.row(11) = groebnerMatrix.row(11) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(12,171);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(12,173);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(12,174);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(12,176);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(13,156);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(13,157);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(13,158);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(13,159);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(13,160);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(13,161);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(13,162);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(13,170);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(13,171);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(13,173);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(13,174);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(13,176);
  groebnerMatrix.row(13) = groebnerMatrix.row(13) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(14,153);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(31);
  factor = groebnerMatrix(14,155);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(14,156);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(14,157);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(14,158);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(14,159);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(14,160);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(14,161);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(14,162);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(14,170);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(14,171);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(14,173);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(14,174);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(14,176);
  groebnerMatrix.row(14) = groebnerMatrix.row(14) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(15,144);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(25);
  factor = groebnerMatrix(15,147);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(22);
  factor = groebnerMatrix(15,156);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(15,157);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(15,158);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(15,159);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(15,160);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(15,161);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(15,162);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(15,170);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(15,171);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(15,173);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(15,174);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(15,176);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(16,158);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(16,159);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(16,160);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(16,161);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(16,162);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(16,170);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(16,171);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(16,173);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(16,174);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(16,176);
  groebnerMatrix.row(16) = groebnerMatrix.row(16) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(19,152);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(30);
  factor = groebnerMatrix(19,153);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(31);
  factor = groebnerMatrix(19,155);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(19,156);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(19,157);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(19,158);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(19,159);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(19,160);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(19,161);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(19,162);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(19,170);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(19,171);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(19,173);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(19,174);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(19,176);
  groebnerMatrix.row(19) = groebnerMatrix.row(19) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(20,170);
  groebnerMatrix.row(20) = groebnerMatrix.row(20) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(20,171);
  groebnerMatrix.row(20) = groebnerMatrix.row(20) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(20,173);
  groebnerMatrix.row(20) = groebnerMatrix.row(20) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(20,174);
  groebnerMatrix.row(20) = groebnerMatrix.row(20) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(20,176);
  groebnerMatrix.row(20) = groebnerMatrix.row(20) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(21,173);
  groebnerMatrix.row(21) = groebnerMatrix.row(21) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(21,174);
  groebnerMatrix.row(21) = groebnerMatrix.row(21) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(21,176);
  groebnerMatrix.row(21) = groebnerMatrix.row(21) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(22,162);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(22,170);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(22,171);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(22,173);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(22,174);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(22,176);
  groebnerMatrix.row(22) = groebnerMatrix.row(22) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(23,161);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(23,162);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(23,170);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(23,171);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(23,173);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(23,174);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(23,176);
  groebnerMatrix.row(23) = groebnerMatrix.row(23) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(24,160);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(24,161);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(24,162);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(24,170);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(24,171);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(24,173);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(24,174);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(24,176);
  groebnerMatrix.row(24) = groebnerMatrix.row(24) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(25,156);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(25,157);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(25,158);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(25,159);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(25,160);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(25,161);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(25,162);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(25,170);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(25,171);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(25,173);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(25,174);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(25,176);
  groebnerMatrix.row(25) = groebnerMatrix.row(25) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(26,155);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(26,156);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(26,157);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(26,158);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(26,159);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(26,160);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(26,161);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(26,162);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(26,170);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(26,171);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(26,173);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(26,174);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(26,176);
  groebnerMatrix.row(26) = groebnerMatrix.row(26) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(28,157);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(28,158);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(28,159);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(28,160);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(28,161);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(28,162);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(28,170);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(28,171);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(28,173);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(28,174);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(28,176);
  groebnerMatrix.row(28) = groebnerMatrix.row(28) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(30,153);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(31);
  factor = groebnerMatrix(30,155);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(30,156);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(30,157);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(30,158);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(30,159);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(30,160);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(30,161);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(30,162);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(30,170);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(30,171);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(30,173);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(30,174);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(30,176);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(31,155);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(31,156);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(31,157);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(31,158);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(31,159);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(31,160);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(31,161);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(31,162);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(31,170);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(31,171);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(31,173);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(31,174);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(31,176);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(32,156);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(32,157);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(32,158);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(32,159);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(32,160);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(32,161);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(32,162);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(32,170);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(32,171);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(32,173);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(32,174);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(32,176);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(33,157);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(33,158);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(33,159);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(33,160);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(33,161);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(33,162);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(33,170);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(33,171);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(33,173);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(33,174);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(33,176);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(34,158);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(34,159);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(34,160);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(34,161);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(34,162);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(34,170);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(34,171);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(34,173);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(34,174);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(34,176);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(35,159);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(36);
  factor = groebnerMatrix(35,160);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(35,161);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(35,162);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(35,170);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(35,171);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(35,173);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(35,174);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(35,176);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(36,160);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(36,161);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(36,162);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(36,170);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(36,171);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(36,173);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(36,174);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(36,176);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(37,161);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(37,162);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(37,170);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(37,171);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(37,173);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(37,174);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(37,176);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(38,162);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(38,170);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(38,171);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(38,173);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(38,174);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(38,176);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(39,170);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(39,171);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(39,173);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(39,174);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(39,176);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(45,170);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(45,171);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(45,173);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(45,174);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(45,176);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(45,132);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(51);
  factor = groebnerMatrix(45,133);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(52);
  factor = groebnerMatrix(45,134);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(53);
  factor = groebnerMatrix(45,135);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(54);
  factor = groebnerMatrix(45,136);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(55);
  factor = groebnerMatrix(45,137);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(45,138);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(45,139);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(45,140);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(45,141);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(45,170);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(45,171);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(45,173);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(45,174);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(45,176);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(51,133);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(52);
  factor = groebnerMatrix(51,134);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(53);
  factor = groebnerMatrix(51,135);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(54);
  factor = groebnerMatrix(51,136);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(55);
  factor = groebnerMatrix(51,137);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(51,138);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(51,139);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(51,140);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(51,141);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(51,170);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(51,171);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(51,173);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(51,174);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(51,176);
  groebnerMatrix.row(51) = groebnerMatrix.row(51) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(52,134);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(53);
  factor = groebnerMatrix(52,135);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(54);
  factor = groebnerMatrix(52,136);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(55);
  factor = groebnerMatrix(52,137);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(52,138);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(52,139);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(52,140);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(52,141);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(52,170);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(52,171);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(52,173);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(52,174);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(52,176);
  groebnerMatrix.row(52) = groebnerMatrix.row(52) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(53,135);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(54);
  factor = groebnerMatrix(53,136);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(55);
  factor = groebnerMatrix(53,137);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(53,138);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(53,139);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(53,140);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(53,141);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(53,170);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(53,171);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(53,173);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(53,174);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(53,176);
  groebnerMatrix.row(53) = groebnerMatrix.row(53) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(54,136);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(55);
  factor = groebnerMatrix(54,137);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(54,138);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(54,139);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(54,140);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(54,141);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(54,170);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(54,171);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(54,173);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(54,174);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(54,176);
  groebnerMatrix.row(54) = groebnerMatrix.row(54) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(55,137);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(56);
  factor = groebnerMatrix(55,138);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(55,139);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(55,140);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(55,141);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(55,170);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(55,171);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(55,173);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(55,174);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(55,176);
  groebnerMatrix.row(55) = groebnerMatrix.row(55) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(56,138);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(57);
  factor = groebnerMatrix(56,139);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(56,140);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(56,141);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(56,170);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(56,171);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(56,173);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(56,174);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(56,176);
  groebnerMatrix.row(56) = groebnerMatrix.row(56) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(57,139);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(58);
  factor = groebnerMatrix(57,140);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(57,141);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(57,170);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(57,171);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(57,173);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(57,174);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(57,176);
  groebnerMatrix.row(57) = groebnerMatrix.row(57) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(58,140);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(59);
  factor = groebnerMatrix(58,141);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(58,170);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(58,171);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(58,173);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(58,174);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(58,176);
  groebnerMatrix.row(58) = groebnerMatrix.row(58) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(59,141);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(60);
  factor = groebnerMatrix(59,170);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(59,171);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(59,173);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(59,174);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(59,176);
  groebnerMatrix.row(59) = groebnerMatrix.row(59) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(60,170);
  groebnerMatrix.row(60) = groebnerMatrix.row(60) - factor * groebnerMatrix.row(61);
  factor = groebnerMatrix(60,171);
  groebnerMatrix.row(60) = groebnerMatrix.row(60) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(60,173);
  groebnerMatrix.row(60) = groebnerMatrix.row(60) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(60,174);
  groebnerMatrix.row(60) = groebnerMatrix.row(60) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(60,176);
  groebnerMatrix.row(60) = groebnerMatrix.row(60) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(61,171);
  groebnerMatrix.row(61) = groebnerMatrix.row(61) - factor * groebnerMatrix.row(62);
  factor = groebnerMatrix(61,173);
  groebnerMatrix.row(61) = groebnerMatrix.row(61) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(61,174);
  groebnerMatrix.row(61) = groebnerMatrix.row(61) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(61,176);
  groebnerMatrix.row(61) = groebnerMatrix.row(61) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(62,173);
  groebnerMatrix.row(62) = groebnerMatrix.row(62) - factor * groebnerMatrix.row(63);
  factor = groebnerMatrix(62,174);
  groebnerMatrix.row(62) = groebnerMatrix.row(62) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(62,176);
  groebnerMatrix.row(62) = groebnerMatrix.row(62) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(63,174);
  groebnerMatrix.row(63) = groebnerMatrix.row(63) - factor * groebnerMatrix.row(64);
  factor = groebnerMatrix(63,176);
  groebnerMatrix.row(63) = groebnerMatrix.row(63) - factor * groebnerMatrix.row(65);
  factor = groebnerMatrix(64,176);
  groebnerMatrix.row(64) = groebnerMatrix.row(64) - factor * groebnerMatrix.row(65);
}
