Minutes from 64th OpenVDB TSC meeting, Sep 29th, 2020, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Andre Pradhana (DW), Robin Rowe (Cinepaint)

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) PR 818 AX Review
5) Simd
6) Next Meeting

1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) Forum

Still need to reply to some forum posts, Dan to take a look. A few issues w.r.t
VDB 7.x dependent software not building as users are not realizing C++14 is now
required. Dan to put in a compile time check in Platform.h to explicitly fail
if C++14 is not enabled.

4) PR 818 AX Review

Most of this meeting was spent reviewing the comments made on PR 818. Replies
are copied here for convenience.

AX CI
Currently the AX CI builds LLVM from source and caches it on the available
github actions cache. Dan has initiated conversations with the LF to see if they
can provide docker containers for different LLVM versions.

Precision of integers and strict type binding
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496308313

AX currently support short, int and long signed integer values which are aliased
to 16, 32 and 64 bit respectively. This is primarily required due to the way AX
strictly binds to grids/attributes of the same type (i.e short@myattrib). Agreed
that, realistically, 32 or 64 bits should be exposed. There are some performance
considerations making everything 64 bit on some architectures. Best solution was
to first allow @ to bind to the same type category, remove short, rename int and
long to int32 and int64 and alias int to either int32 or int64 at compile time.
Same comments were made w.r.t float and double, however GPU support will
definitely need float and the lack of float for CPU code will make it impossible
to produce deterministic results.

$ syntax in Houdini
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496311518

The AX Houdini SOP supports some vex functions like ch/chramp etc. It evaluates
the raw string to avoid $ expanding at the cost of no backtick support (though
this can be added). Ultimately the presence of ch means that this isn't an issue.

Attrib dependencies
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496312075

No evaluation is performed on code values, so dead/unreachable code paths still
contribute to attribute/grid creation and dependencies.

C vs python style modulo
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496312423

Currently uses LLVM's default IR builder modulo instruction which will be C
style remainder op. Agreed to instead switch to python style "true" modulo op.

Line directives, pre-processing and runtime errors
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496315058

Currently no # directive support. Agreed adding it would be good. Catching
exceptions is not an ideal way to control top level behavior. Agreed that
custom logging would be better. This actually already exists but needs to be
upstreamed. This was going to be done as a subsequent PR but may as well be
bundled into this now.

lerp()
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496317012
fit()
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496318424

Agreed to investigate better formulation of lerp() and fit()

signbit()
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496319359

Agreed to change to sign()

Function signature type support
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496317548

Depending on the int precision work, this work will be simplified. Signatures
should really exist for all types unless it really doesn't make sense for some
specifically. Agreed to add a maxComponent style method for vector elements.

Determinant checking of polardecomp
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496319863

Need to check the behavior of openvdbs polardecomposition function if the
calculated det is negative and document this.

AX namespace, API/ABI
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496322339
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496449902

Agree on the two options stated - either AX should use its own versioned namespace
or be locked to VDBs. This includes lib versioning too. Preference is to lock to
VDBs namespace. Will peruse this and see if any issues arise.

VDB changes
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496433146

Although minor, agreed to split out VDB specific changes to a different PR.

Deprecated methods and odd implementations
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496434030
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496441704

For backwards compatibility and internal reasons, some design decisions were
made which now look odd in the open source version of AX. These still need to
exist in the standalone repo but can be removed and re-worked for the merge into
VDB. Agreed to action these.

Executable terminology
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496439529

Agreeded to rename to Binary and see what it looks like.

Executable member interface and usage
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496444627
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496443272

In the current design, the executables store all settings on a sub struct unique
ptr. This produces a clean API with separation of the trivial execute calls
from the member settings. However it means that they must be copied to make
modifications if the exe is const (though this copying is cheap) and requires
explicit copy constructors/assignment operators. Another option would be to have
users provide these settings on each call to execute. This better ties in some
settings to the grid data being executed, produces a trivially copyable object
and means the executable can be const. Nick, will play around with these ideas.

Combination of Compiler to Executable
https://github.com/AcademySoftwareFoundation/openvdb/pull/818#discussion_r496446789

The templated compile methods exist for internal reasons and can be removed. It
may be better to introduce static creators on the executables which take a compiler
vs the friend implementation. No clear advantage currently, but agreeded that
the workflow between the code generators, compiler and exes could use some
attention.

ax::run() with multiple grids/attribute bindings

Agreed that this particular signature could use some more explicit behavior.
Agreed to error if points and volumes are provided. Custom way to bind attributes
to grids should exist that don't rely on the grid name (i.e. what if the grid is
const).

Below are the main action points which block the initial merge:
 - Integer precision changes
 - Modulo implementation
 - Deprecated code removal
 - lerp(), fit(), signbit() changes
 - AX Versioning changes

5) Simd

Ken, working on some more intrinsic functionality for VDB. Nick, has code he'd
like to upstream which uses SIMD wrappers. TSC is open to including external
SIMD intrinsic wrapper software in VDB.

6) Next Meeting

Skipping next week.
Next meeting is October 13th, 2020. 1pm-2pm EDT (GMT-4).
