/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseEnglober
extends AbstractTextualComponent {
    private final SymbolContext symbolContext;
    private final double roundCorner;

    public ComponentRoseEnglober(Style style, SymbolContext symbolContext, Display strings, FontConfiguration font, ISkinSimple spriteContainer, double roundCorner) {
        super(style, LineBreakStrategy.NONE, strings, font, HorizontalAlignment.CENTER, 3, 3, 1, spriteContainer, false, null, null);
        if (UseStyle.useBetaStyle()) {
            roundCorner = style.value(PName.RoundCorner).asDouble();
            symbolContext = style.getSymbolContext(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        }
        this.roundCorner = roundCorner;
        this.symbolContext = symbolContext;
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = this.symbolContext.transparentBackColorToNull().apply(ug);
        ug.draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()).rounded(this.roundCorner));
        double xpos = (dimensionToUse.getWidth() - this.getPureTextWidth(ug.getStringBounder())) / 2.0;
        this.getTextBlock().drawU(ug.apply(UTranslate.dx(xpos)));
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

