/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.theme;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.sprite.RessourcesUtils;

public class ThemeUtils {
    private static final String THEME_FILE_PREFIX = "puml-theme-";
    private static final String THEME_FILE_SUFFIX = ".puml";
    private static final String THEME_PATH = "themes";

    public static List<String> getAllThemeNames() throws IOException {
        Collection filenames = Objects.requireNonNull(RessourcesUtils.getJarFile(THEME_PATH, false));
        ArrayList<String> result = new ArrayList<String>();
        for (String f : filenames) {
            if (!f.startsWith(THEME_FILE_PREFIX) || !f.endsWith(THEME_FILE_SUFFIX)) continue;
            result.add(f.substring(THEME_FILE_PREFIX.length(), f.length() - THEME_FILE_SUFFIX.length()));
        }
        Collections.sort(result);
        return result;
    }

    public static ReadLine getReaderTheme(String filename) {
        Log.info("Loading theme " + filename);
        String res = "/themes/puml-theme-" + filename + THEME_FILE_SUFFIX;
        String description = "<" + res + ">";
        InputStream is = Stdlib.class.getResourceAsStream(res);
        if (is == null) {
            return null;
        }
        return ReadLineReader.create(new InputStreamReader(is), description);
    }

    public static String getFullPath(String from, String filename) {
        StringBuilder sb = new StringBuilder(from);
        if (!from.endsWith("/")) {
            sb.append("/");
        }
        return sb + THEME_FILE_PREFIX + filename + THEME_FILE_SUFFIX;
    }
}

