/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

public class ColorUtils {
    private static final int MIN_ALPHA_SEARCH_MAX_ITERATIONS = 10;
    private static final int MIN_ALPHA_SEARCH_PRECISION = 1;

    private ColorUtils() {
    }

    public static int compositeColors(@ColorInt int foreground, @ColorInt int background) {
        int bgAlpha = Color.alpha((int)background);
        int fgAlpha = Color.alpha((int)foreground);
        int a = ColorUtils.compositeAlpha(fgAlpha, bgAlpha);
        int r = ColorUtils.compositeComponent(Color.red((int)foreground), fgAlpha, Color.red((int)background), bgAlpha, a);
        int g = ColorUtils.compositeComponent(Color.green((int)foreground), fgAlpha, Color.green((int)background), bgAlpha, a);
        int b = ColorUtils.compositeComponent(Color.blue((int)foreground), fgAlpha, Color.blue((int)background), bgAlpha, a);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private static int compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
        return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
    }

    private static int compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
        if (a == 0) {
            return 0;
        }
        return (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
    }

    @FloatRange(from=0.0, to=1.0)
    public static double calculateLuminance(@ColorInt int color) {
        double red = (double)Color.red((int)color) / 255.0;
        red = red < 0.03928 ? red / 12.92 : Math.pow((red + 0.055) / 1.055, 2.4);
        double green = (double)Color.green((int)color) / 255.0;
        green = green < 0.03928 ? green / 12.92 : Math.pow((green + 0.055) / 1.055, 2.4);
        double blue = (double)Color.blue((int)color) / 255.0;
        blue = blue < 0.03928 ? blue / 12.92 : Math.pow((blue + 0.055) / 1.055, 2.4);
        return 0.2126 * red + 0.7152 * green + 0.0722 * blue;
    }

    public static double calculateContrast(@ColorInt int foreground, @ColorInt int background) {
        if (Color.alpha((int)background) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(background));
        }
        if (Color.alpha((int)foreground) < 255) {
            foreground = ColorUtils.compositeColors(foreground, background);
        }
        double luminance1 = ColorUtils.calculateLuminance(foreground) + 0.05;
        double luminance2 = ColorUtils.calculateLuminance(background) + 0.05;
        return Math.max(luminance1, luminance2) / Math.min(luminance1, luminance2);
    }

    public static int calculateMinimumAlpha(@ColorInt int foreground, @ColorInt int background, float minContrastRatio) {
        if (Color.alpha((int)background) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(background));
        }
        int testForeground = ColorUtils.setAlphaComponent(foreground, 255);
        double testRatio = ColorUtils.calculateContrast(testForeground, background);
        if (testRatio < (double)minContrastRatio) {
            return -1;
        }
        int minAlpha = 0;
        int maxAlpha = 255;
        for (int numIterations = 0; numIterations <= 10 && maxAlpha - minAlpha > 1; ++numIterations) {
            int testAlpha = (minAlpha + maxAlpha) / 2;
            testForeground = ColorUtils.setAlphaComponent(foreground, testAlpha);
            testRatio = ColorUtils.calculateContrast(testForeground, background);
            if (testRatio < (double)minContrastRatio) {
                minAlpha = testAlpha;
                continue;
            }
            maxAlpha = testAlpha;
        }
        return maxAlpha;
    }

    public static void RGBToHSL(@IntRange(from=0L, to=255L) int r, @IntRange(from=0L, to=255L) int g, @IntRange(from=0L, to=255L) int b, @NonNull float[] hsl) {
        float h;
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float deltaMaxMin = max - min;
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            h = max == rf ? (gf - bf) / deltaMaxMin % 6.0f : (max == gf ? (bf - rf) / deltaMaxMin + 2.0f : (rf - gf) / deltaMaxMin + 4.0f);
            s = deltaMaxMin / (1.0f - Math.abs(2.0f * l - 1.0f));
        }
        h = h * 60.0f % 360.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        hsl[0] = ColorUtils.constrain(h, 0.0f, 360.0f);
        hsl[1] = ColorUtils.constrain(s, 0.0f, 1.0f);
        hsl[2] = ColorUtils.constrain(l, 0.0f, 1.0f);
    }

    public static void colorToHSL(@ColorInt int color, @NonNull float[] hsl) {
        ColorUtils.RGBToHSL(Color.red((int)color), Color.green((int)color), Color.blue((int)color), hsl);
    }

    @ColorInt
    public static int HSLToColor(@NonNull float[] hsl) {
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float m = l - 0.5f * c;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        int hueSegment = (int)h / 60;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (hueSegment) {
            case 0: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 1: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * m);
                break;
            }
            case 2: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (c + m));
                b = Math.round(255.0f * (x + m));
                break;
            }
            case 3: {
                r = Math.round(255.0f * m);
                g = Math.round(255.0f * (x + m));
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 4: {
                r = Math.round(255.0f * (x + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (c + m));
                break;
            }
            case 5: 
            case 6: {
                r = Math.round(255.0f * (c + m));
                g = Math.round(255.0f * m);
                b = Math.round(255.0f * (x + m));
            }
        }
        r = ColorUtils.constrain(r, 0, 255);
        g = ColorUtils.constrain(g, 0, 255);
        b = ColorUtils.constrain(b, 0, 255);
        return Color.rgb((int)r, (int)g, (int)b);
    }

    @ColorInt
    public static int setAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color & 0xFFFFFF | alpha << 24;
    }

    private static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    private static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

