% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-allelic.R
\name{plotAllelicHeatmap}
\alias{plotAllelicHeatmap}
\title{Plot allelic ratio heatmap}
\usage{
plotAllelicHeatmap(
  y,
  idx,
  breaks = NULL,
  cluster_cols = FALSE,
  main = "Allelic ratio",
  stripAfterChar = "-",
  ...
)
}
\arguments{
\item{y}{a SummarizedExperiment (see \code{swish})}

\item{idx}{a numeric or logical vector of which features
to plot}

\item{breaks}{breaks passed along to pheatmap}

\item{cluster_cols}{logical, passed to pheatmap}

\item{main}{title of the plot}

\item{stripAfterChar}{for the column names, if specified
will strip allelic identifiers after this character,
default is hyphen. set to NULL to avoid this action}

\item{...}{other arguments passed to pheatmap}
}
\value{
nothing, a plot is displayed
}
\description{
Plot allelic ratio heatmap over features and samples
using the pheatmap package. The a1/(a2 + a1) ratio
is displayed.
}
\references{
The methods for allelic expression analysis are described in:

Euphy Wu, Noor P. Singh, Kwangbom Choi, Mohsen Zakeri, Matthew
Vincent, Gary A. Churchill, Cheryl L. Ackert-Bicknell, Rob Patro,
Michael I. Love.
"Detecting isoform-level allelic imbalance accounting for
inferential uncertainty" bioRxiv (2022)
\url{https://doi.org/10.1101/2022.08.12.503785}

This function makes use of the pheatmap package:

Kolde, Raivo. "Pheatmap: pretty heatmaps."
R package version 1.2 (2012): 726.
}
