% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSds.R
\name{rowSds}
\alias{rowSds}
\alias{rowSds,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowSds,ANY-method}
\alias{colSds}
\alias{colSds,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colSds,ANY-method}
\title{Calculates the standard deviation for each row (column) of a matrix-like
object}
\usage{
rowSds(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...)

\S4method{rowSds}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, center = NULL, dim. = dim(x), ...)

\S4method{rowSds}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...)

colSds(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...)

\S4method{colSds}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, center = NULL, dim. = dim(x), ...)

\S4method{colSds}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{center}{(optional) the center, defaults to the row means}

\item{...}{Additional arguments passed to specific methods.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the standard deviation for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowSds}
/ \code{matrixStats::colSds}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowSds(mat)
  colSds(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowSds}()} and
\code{matrixStats::\link[matrixStats:rowSds]{colSds}()} which are used when
the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item For variance estimates, see \code{\link{rowVars}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
