% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation_bootstrap.R
\name{plot_correlation_bootstrap}
\alias{plot_correlation_bootstrap}
\title{Plots the correlation between bootstrapped signature contributions}
\usage{
plot_correlation_bootstrap(contri_boots, per_sample = TRUE)
}
\arguments{
\item{contri_boots}{A dataframe with bootstrapped signature contributions.}

\item{per_sample}{Whether or not a plot should be made per sample. Default: TRUE.}
}
\value{
A list of ggplot2 objects if run per sample.
Else it returns a single ggplot2 object.
}
\description{
This function plots the pearson correlation between signatures.
This can be done per sample or for all samples together.
It returns a list of the created figures.
}
\examples{

## Get a dataframe with bootstrapped signature contributions.
## See 'fit_to_signatures_bootstrapped()' for how to do this.
contri_boots <- readRDS(system.file("states/bootstrapped_snv_refit.rds",
  package = "MutationalPatterns"
))

## Plot the correlations between signatures per sample
fig_l <- plot_correlation_bootstrap(contri_boots)

## Look at the figure of the first sample.
fig_l[[1]]

## You can also look at the correlation for all samples combined
plot_correlation_bootstrap(contri_boots, per_sample = FALSE)
}
