% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SingleCellExperiment-methods.R
\docType{methods}
\name{bootstraps}
\alias{bootstraps}
\alias{bootstraps<-}
\alias{bootstraps,SingleCellExperiment-method}
\alias{bootstraps<-,SingleCellExperiment,array-method}
\title{Accessor and replacement for bootstrap results in a 
\code{\link{SingleCellExperiment}} object}
\usage{
bootstraps(object)

bootstraps(object) <- value

\S4method{bootstraps}{SingleCellExperiment}(object)

\S4method{bootstraps}{SingleCellExperiment,array}(object) <- value
}
\arguments{
\item{object}{a \code{SingleCellExperiment} object.}

\item{value}{an array of class \code{"numeric"} containing bootstrap
expression values}
}
\value{
If accessing bootstraps slot of an \code{SingleCellExperiment}, then 
an array with the bootstrap values, otherwise an \code{SingleCellExperiment} 
object containing new bootstrap values.
}
\description{
\code{\link{SingleCellExperiment}} objects can contain bootstrap 
expression values (for example, as generated by the kallisto software for 
quantifying feature abundance). These functions conveniently access and 
replace the 'bootstrap' elements in the \code{assays} slot with the value
supplied, which must be an matrix of the correct size, namely the same
number of rows and columns as the \code{SingleCellExperiment} object as a 
whole.
}
\examples{
example_sce <- mockSCE()
bootstraps(example_sce)

}
\author{
Davis McCarthy
}
