### Regression tests for helper functions

set.seed(290875)
library("coin")
isequal <- coin:::isequal
options(useFancyQuotes = FALSE)


###
### Test the 'is' family of functions
###

is_factor_y <- coin:::is_factor_y
is_factor_x <- coin:::is_factor_x
is_ordered_y <- coin:::is_ordered_y
is_ordered_x <- coin:::is_ordered_x
is_unordered_y <- coin:::is_unordered_y
is_unordered_x <- coin:::is_unordered_x
is_numeric_y <- coin:::is_numeric_y
is_numeric_x <- coin:::is_numeric_x
is_censored_y <- coin:::is_censored_y
is_censored_x <- coin:::is_censored_x
is_2sample <- coin:::is_2sample
is_Ksample <- coin:::is_Ksample
is_corr <- coin:::is_corr
is_contingency <- coin:::is_contingency
is_contingency_2x2 <- coin:::is_contingency_2x2
is_singly_ordered <- coin:::is_singly_ordered
is_doubly_ordered <- coin:::is_doubly_ordered
is_ordered <- coin:::is_ordered

### Example data
f2 <- sample(gl(2, 10))
f4 <- sample(gl(4, 5))
o2 <- as.ordered(f2)
o4 <- as.ordered(f4)
n1 <- sample(1:20)
c1 <- Surv(n1, sample(0:1, 20, replace = TRUE))

### Numeric vs. numeric
it <- independence_test(n1 ~ n1)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot( isTRUE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Numeric vs. censored
it <- independence_test(n1 ~ c1)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot( isTRUE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Numeric vs. unordered 2-level factor
it <- independence_test(n1 ~ f2)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Numeric vs. unordered 4-level factor
it <- independence_test(n1 ~ f4)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Numeric vs. ordered 2-level factor
it <- independence_test(n1 ~ o2)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Numeric vs. ordered 4-level factor
it <- independence_test(n1 ~ o4)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot( isTRUE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Censored vs. numeric
it <- independence_test(c1 ~ n1)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot( isTRUE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Censored vs. censored
it <- independence_test(c1 ~ c1)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot( isTRUE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Censored vs. unordered 2-level factor
it <- independence_test(c1 ~ f2)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Censored vs. unordered 4-level factor
it <- independence_test(c1 ~ f4)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Censored vs. ordered 2-level factor
it <- independence_test(c1 ~ o2)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Censored vs. ordered 4-level factor
it <- independence_test(c1 ~ o4)
stopifnot(isFALSE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot( isTRUE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. numeric
it <- independence_test(f2 ~ n1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. censored
it <- independence_test(f2 ~ c1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. unordered 2-level factor
it <- independence_test(f2 ~ f2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot( isTRUE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. unordered 4-level factor
it <- independence_test(f2 ~ f4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. ordered 2-level factor
it <- independence_test(f2 ~ o2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot( isTRUE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_ordered(it@statistic)))

### Unordered 2-level factor vs. ordered 4-level factor
it <- independence_test(f2 ~ o4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. numeric
it <- independence_test(f4 ~ n1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. censored
it <- independence_test(f4 ~ c1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. unordered 2-level factor
it <- independence_test(f4 ~ f2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. unordered 4-level factor
it <- independence_test(f4 ~ f4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot(isFALSE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. ordered 2-level factor
it <- independence_test(f4 ~ o2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Unordered 4-level factor vs. ordered 4-level factor
it <- independence_test(f4 ~ o4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot(isFALSE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot( isTRUE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. numeric
it <- independence_test(o2 ~ n1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. censored
it <- independence_test(o2 ~ c1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. unordered 2-level factor
it <- independence_test(o2 ~ f2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot( isTRUE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. unordered 4-level factor
it <- independence_test(o2 ~ f4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. ordered 2-level factor
it <- independence_test(o2 ~ o2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot( isTRUE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 2-level factor vs. ordered 4-level factor
it <- independence_test(o2 ~ o4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. numeric
it <- independence_test(o4 ~ n1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot( isTRUE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. censored
it <- independence_test(o4 ~ c1)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot(isFALSE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot( isTRUE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot(isFALSE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot(isFALSE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. unordered 2-level factor
it <- independence_test(o4 ~ f2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))  # By convention
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. unordered 4-level factor
it <- independence_test(o4 ~ f4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot(isFALSE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot( isTRUE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot( isTRUE(is_singly_ordered(it@statistic)))
stopifnot(isFALSE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. ordered 2-level factor
it <- independence_test(o4 ~ o2)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot( isTRUE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))

### Ordered 4-level factor vs. ordered 4-level factor
it <- independence_test(o4 ~ o4)
stopifnot( isTRUE(is_factor_y(it@statistic)))
stopifnot( isTRUE(is_factor_x(it@statistic)))
stopifnot( isTRUE(is_ordered_y(it@statistic)))
stopifnot( isTRUE(is_ordered_x(it@statistic)))
stopifnot(isFALSE(is_unordered_y(it@statistic)))
stopifnot(isFALSE(is_unordered_x(it@statistic)))
stopifnot(isFALSE(is_numeric_y(it@statistic)))
stopifnot(isFALSE(is_numeric_x(it@statistic)))
stopifnot(isFALSE(is_censored_y(it@statistic)))
stopifnot(isFALSE(is_censored_x(it@statistic)))
stopifnot(isFALSE(is_2sample(it@statistic)))
stopifnot( isTRUE(is_Ksample(it@statistic)))
stopifnot(isFALSE(is_corr(it@statistic)))
stopifnot( isTRUE(is_contingency(it@statistic)))
stopifnot(isFALSE(is_contingency_2x2(it@statistic)))
stopifnot(isFALSE(is_singly_ordered(it@statistic)))
stopifnot( isTRUE(is_doubly_ordered(it@statistic)))
stopifnot( isTRUE(is_ordered(it@statistic)))


###
### Test comparison functions
###

`%EQ%` <- coin:::`%EQ%`
`%NE%` <- coin:::`%NE%`
`%GE%` <- coin:::`%GE%`
`%LE%` <- coin:::`%LE%`
`%GT%` <- coin:::`%GT%`
`%LT%` <- coin:::`%LT%`

v <- 1.1                           # v >  1 --> v >= 1
w <- 1 + sqrt(.Machine$double.eps) # w == 1 --> w >= 1, w <= 1
x <- 1                             # x == 1 --> x >= 1, x <= 1
y <- 1 - sqrt(.Machine$double.eps) # y == 1 --> y >= 1, y <= 1
z <- 0.9                           # z <  1 -->         z <= 1

stopifnot(isFALSE(v %EQ% x))
stopifnot( isTRUE(w %EQ% x))
stopifnot( isTRUE(x %EQ% x))
stopifnot( isTRUE(y %EQ% x))
stopifnot(isFALSE(z %EQ% x))

stopifnot( isTRUE(v %NE% x))
stopifnot(isFALSE(w %NE% x))
stopifnot(isFALSE(x %NE% x))
stopifnot(isFALSE(y %NE% x))
stopifnot( isTRUE(z %NE% x))

stopifnot( isTRUE(v %GE% x))
stopifnot( isTRUE(w %GE% x))
stopifnot( isTRUE(x %GE% x))
stopifnot( isTRUE(y %GE% x))
stopifnot(isFALSE(z %GE% x))

stopifnot(isFALSE(v %LE% x))
stopifnot( isTRUE(w %LE% x))
stopifnot( isTRUE(x %LE% x))
stopifnot( isTRUE(y %LE% x))
stopifnot( isTRUE(z %LE% x))

stopifnot( isTRUE(v %GT% x))
stopifnot(isFALSE(w %GT% x))
stopifnot(isFALSE(x %GT% x))
stopifnot(isFALSE(y %GT% x))
stopifnot(isFALSE(z %GT% x))

stopifnot(isFALSE(v %LT% x))
stopifnot(isFALSE(w %LT% x))
stopifnot(isFALSE(x %LT% x))
stopifnot(isFALSE(y %LT% x))
stopifnot( isTRUE(z %LT% x))


###
### Test the 'n_decimal_digits' function
###

n_decimal_digits <- coin:::n_decimal_digits

stopifnot(identical(2L, n_decimal_digits(     -1.01 )))
stopifnot(identical(2L, n_decimal_digits(     -0.01 )))
stopifnot(identical(1L, n_decimal_digits(     -0.1  )))
stopifnot(identical(0L, n_decimal_digits(     -0.0  )))
stopifnot(identical(0L, n_decimal_digits(      0    )))
stopifnot(identical(0L, n_decimal_digits(      0.0  )))
stopifnot(identical(1L, n_decimal_digits(      0.1  )))
stopifnot(identical(2L, n_decimal_digits(      0.01 )))
stopifnot(identical(2L, n_decimal_digits(      1.01 )))

stopifnot(identical(2L, n_decimal_digits(c(0, -1.01))))
stopifnot(identical(2L, n_decimal_digits(c(0, -0.01))))
stopifnot(identical(1L, n_decimal_digits(c(0, -0.1 ))))
stopifnot(identical(0L, n_decimal_digits(c(0,  0   ))))
stopifnot(identical(1L, n_decimal_digits(c(0,  0.1 ))))
stopifnot(identical(2L, n_decimal_digits(c(0,  0.01))))
stopifnot(identical(2L, n_decimal_digits(c(0,  1.01))))
