% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_bayesian_indices.R
\name{interpret_ess}
\alias{interpret_ess}
\alias{interpret_rhat}
\title{Interpret Bayesian diagnostic indices}
\usage{
interpret_ess(ess, rules = "burkner2017")

interpret_rhat(rhat, rules = "vehtari2019")
}
\arguments{
\item{ess}{Value or vector of Effective Sample Size (ESS) values.}

\item{rules}{A character string (see \emph{Rules}) or a custom set of \code{\link[=rules]{rules()}}.}

\item{rhat}{Value or vector of Rhat values.}
}
\description{
Interpretation of Bayesian diagnostic indices, such as Effective Sample Size (ESS) and Rhat.
}
\section{Rules}{

\subsection{ESS}{
\itemize{
\item Bürkner, P. C. (2017) (\code{"burkner2017"}; default)
\itemize{
\item \strong{ESS < 1000} - Insufficient
\item \strong{ESS >= 1000} - Sufficient
}
}
}

\subsection{Rhat}{
\itemize{
\item Vehtari et al. (2019) (\code{"vehtari2019"}; default)
\itemize{
\item \strong{Rhat < 1.01} - Converged
\item \strong{Rhat >= 1.01} - Failed
}
\item Gelman & Rubin (1992) (\code{"gelman1992"})
\itemize{
\item \strong{Rhat < 1.1} - Converged
\item \strong{Rhat >= 1.1} - Failed
}
}
}
}

\examples{
interpret_ess(1001)
interpret_ess(c(852, 1200))

interpret_rhat(1.00)
interpret_rhat(c(1.5, 0.9))
}
\references{
\itemize{
\item Bürkner, P. C. (2017). brms: An R package for Bayesian multilevel models using Stan. Journal of Statistical Software, 80(1), 1-28.
\item Gelman, A., & Rubin, D. B. (1992). Inference from iterative simulation using multiple sequences. Statistical science, 7(4), 457-472.
\item Vehtari, A., Gelman, A., Simpson, D., Carpenter, B., & Bürkner, P. C. (2019). Rank-normalization, folding, and localization: An improved Rhat for assessing convergence of MCMC. arXiv preprint arXiv:1903.08008.
}
}
