% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_all.R
\name{parse_all}
\alias{parse_all}
\title{Parse, retaining comments}
\usage{
parse_all(x, filename = NULL, allow_error = FALSE)
}
\arguments{
\item{x}{object to parse.  Can be a string, a file connection, or a function.
If a connection, will be opened and closed only if it was closed initially.}

\item{filename}{string overriding the file name}

\item{allow_error}{whether to allow syntax errors in \code{x}}
}
\value{
A data frame two columns, \code{src} and \code{expr}, and one row for each complete
input in \code{x}. A complete input is R code that would trigger execution when
typed at the console. This might consist of multiple expressions separated
by \verb{;} or one expression spread over multiple lines (like a function
definition).

\code{src} is a character vector of source code. Each element represents a
complete input expression (which might span multiple line) and always has a
terminal \verb{\\n}.

\code{expr} is a list-column of \link{expression}s. The expressions can be of any
length, depending on the structure of the complete input source:
\itemize{
\item If \code{src} consists of only only whitespace and/or comments, \code{expr} will
be length 0.
\item If \code{src} a single scalar (like \code{TRUE}, \code{1}, or \code{"x"}), name, or
function call, \code{expr} will be length 1.
\item If \code{src} contains multiple expressions separated by \verb{;}, \code{expr} will
have length two or more.
}

The expressions have their srcrefs removed.

If there are syntax errors in \code{x} and \code{allow_error = TRUE}, the data
frame will have an attribute \code{PARSE_ERROR} that stores the error object.
}
\description{
Works very similarly to parse, but also keeps original formatting and
comments.
}
\examples{
# Each of these inputs are single line, but generate different numbers of
# expressions
source <- c(
  "# a comment",
  "x",
  "x;y",
  "x;y;z"
)
parsed <- parse_all(source)
lengths(parsed$expr)
str(parsed$expr)

# Each of these inputs are a single expression, but span different numbers
# of lines
source <- c(
  "function() {}",
  "function() {",
  "  # Hello!",
  "}",
  "function() {",
  "  # Hello!",
  "  # Goodbye!",
  "}"
)
parsed <- parse_all(source)
lengths(parsed$expr)
parsed$src
}
