% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{separate_header}
\alias{separate_header}
\title{Split column names using a separator into multiple rows}
\usage{
separate_header(
  x,
  opts = c("span-top", "center-hspan", "bottom-vspan", "default-theme"),
  split = "[_\\\\.]",
  fixed = FALSE
)
}
\arguments{
\item{x}{a flextable object}

\item{opts}{Optional treatments to apply to the resulting header part.
This should be a character vector with support for multiple values.

Supported values include:
\itemize{
\item "span-top": This operation spans empty cells with the first non-empty
cell, applied column by column.
\item "center-hspan": Center the cells that are horizontally spanned.
\item "bottom-vspan": Aligns to the bottom the cells treated at the  when "span-top" is applied.
\item "default-theme": Applies the theme set in \code{set_flextable_defaults(theme_fun = ...)} to the new header part.
}}

\item{split}{a regular expression (unless \code{fixed = TRUE})
to use for splitting.}

\item{fixed}{logical. If TRUE match \code{split} exactly,
otherwise use regular expressions.}
}
\description{
This function is used to separate and place individual
labels in their own rows if your variable names contain multiple
delimited labels.
\if{html}{\out{
<img src="https://www.ardata.fr/img/flextable-imgs/flextable-016.png" alt="add_header illustration" style="width:100\%;">
}}
}
\examples{
library(flextable)

x <- data.frame(
  Species = as.factor(c("setosa", "versicolor", "virginica")),
  Sepal.Length_mean = c(5.006, 5.936, 6.588),
  Sepal.Length_sd = c(0.35249, 0.51617, 0.63588),
  Sepal.Width_mean = c(3.428, 2.77, 2.974),
  Sepal.Width_sd = c(0.37906, 0.3138, 0.3225),
  Petal.Length_mean = c(1.462, 4.26, 5.552),
  Petal.Length_sd = c(0.17366, 0.46991, 0.55189),
  Petal.Width_mean = c(0.246, 1.326, 2.026),
  Petal.Width_sd = c(0.10539, 0.19775, 0.27465)
)

ft_1 <- flextable(x)
ft_1 <- colformat_double(ft_1, digits = 2)
ft_1 <- theme_box(ft_1)
ft_1 <- separate_header(
  x = ft_1,
  opts = c("span-top", "bottom-vspan")
)
ft_1
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{delete_rows}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
