% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_cluster.R
\name{fortify.kmeans}
\alias{fortify.kmeans}
\title{Convert cluster instances to \code{data.frame}}
\usage{
\method{fortify}{kmeans}(model, data = NULL, ...)
}
\arguments{
\item{model}{Clustered instance}

\item{data}{original dataset, if needed}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert cluster instances to \code{data.frame}
}
\examples{
\dontrun{
fortify(stats::kmeans(iris[-5], 3))
fortify(stats::kmeans(iris[-5], 3), data = iris)
fortify(cluster::clara(iris[-5], 3))
fortify(cluster::fanny(iris[-5], 3))
fortify(cluster::pam(iris[-5], 3), data = iris)
}
}
