% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npc_to_data_coord.R
\name{npc_to_data_coord}
\alias{npc_to_data_coord}
\title{Convert NPC to Data Coordinates}
\usage{
npc_to_data_coord(npc, data.ranges)
}
\arguments{
\item{npc}{a numeric vector. Each value should be in [0-1]}

\item{data.ranges}{a numeric vector of length 2 containing the data ranges (minimum and the maximum)}
}
\value{
a numeric vector representing data coordinates.
}
\description{
Convert NPC (Normalized Parent Coordinates) into data coordinates.
}
\examples{
npc_to_data_coord(npc = c(0.2, 0.95), data.ranges = c(1, 20))
as_npc(c("top", "right")) \%>\%
   npc_to_data_coord(data.ranges = c(1, 20))

}
\seealso{
\code{\link{as_npc}}, \code{\link{get_coord}}.
}
