% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2_parser.R
\name{m2_parser}
\alias{m2_parser}
\alias{m2_parse}
\alias{m2_parse_class.default}
\alias{m2_parse_class.m2_hashtable}
\alias{m2_parse_class.m2_optiontable}
\alias{m2_parse_class.m2_verticallist}
\alias{m2_parse_function.default}
\alias{m2_parse_function.m2_hashtable}
\alias{m2_parse_function.m2_optiontable}
\alias{m2_parse_function.m2_verticallist}
\alias{m2_parse_function.m2_symbol}
\alias{m2_parse_function.m2_monoid}
\alias{m2_parse_function.m2_tocc}
\alias{m2_parse_object_as_function.default}
\alias{m2_parse_object_as_function.m2_symbol}
\alias{print.m2_integer}
\alias{print.m2_float}
\alias{print.m2_complex}
\alias{print.m2_string}
\alias{print.m2_boolean}
\alias{print.m2_list}
\alias{print.m2_array}
\alias{print.m2_sequence}
\alias{print.m2_symbol}
\alias{print.m2_option}
\alias{print.m2_hashtable}
\alias{print.m2_module}
\alias{m2_toggle_gmp}
\alias{get_m2_gmp}
\title{Convert a M2 object into an R object}
\usage{
m2_parse(s)

\method{m2_parse_class}{default}(x)

\method{m2_parse_class}{m2_hashtable}(x)

\method{m2_parse_class}{m2_optiontable}(x)

\method{m2_parse_class}{m2_verticallist}(x)

\method{m2_parse_function}{default}(x)

\method{m2_parse_function}{m2_hashtable}(x)

\method{m2_parse_function}{m2_optiontable}(x)

\method{m2_parse_function}{m2_verticallist}(x)

\method{m2_parse_function}{m2_symbol}(x)

\method{m2_parse_function}{m2_monoid}(x)

\method{m2_parse_function}{m2_tocc}(x)

\method{m2_parse_object_as_function}{default}(x, params)

\method{m2_parse_object_as_function}{m2_symbol}(x, params)

\method{print}{m2_integer}(x, ...)

\method{print}{m2_float}(x, ...)

\method{print}{m2_complex}(x, ...)

\method{print}{m2_string}(x, ...)

\method{print}{m2_boolean}(x, ...)

\method{print}{m2_list}(x, ...)

\method{print}{m2_array}(x, ...)

\method{print}{m2_sequence}(x, ...)

\method{print}{m2_symbol}(x, ...)

\method{print}{m2_option}(x, ...)

\method{print}{m2_hashtable}(x, ...)

\method{print}{m2_module}(x, ...)

m2_toggle_gmp()

get_m2_gmp()
}
\arguments{
\item{s}{a character(1), typically the result of running toExternalString on
an M2 object}

\item{x}{an object to be printed}

\item{params}{e.g. \verb{[x,y,z]} or \verb{[x..z]}}

\item{...}{...}
}
\value{
an R object
}
\description{
Convert a M2 object into an R object
}
\examples{

\dontrun{ requires Macaulay2

m2("1+1")
m2.("1+1")
m2_parse(m2.("1+1"))

m2("QQ[x,y]")
m2.("QQ[x,y]")
m2_parse(m2.("QQ[x,y]"))

get_m2_gmp()
m2("3/2") \%>\% m2_parse()
m2_toggle_gmp() # gmp on
m2("3/2") \%>\% m2_parse()
m2("6/4") \%>\% m2_parse()
m2("3345234524352435432/223454325235432524352433245") \%>\% m2_parse()
m2_toggle_gmp() # gmp off



m2("50!") \%>\% m2_parse()
m2_toggle_gmp() # gmp on
m2("50!") \%>\% m2_parse()
m2_toggle_gmp() # gmp off

}
}
\references{
D. Kahle, C. O'Neill, and J. Sommars (2020). "A Computer Algebra
System for R: Macaulay2 and the m2r Package." Journal of Statistical
Software, 93(9):1-31.
}
