% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_networx.R
\name{identify.networx}
\alias{identify.networx}
\title{Identify splits in a network}
\usage{
\method{identify}{networx}(x, quiet = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{networx}}

\item{quiet}{a logical controlling whether to print a message inviting the
user to click on the tree.}

\item{\dots}{further arguments to be passed to or from other methods.}
}
\value{
\code{identify.networx} returns a splits object.
}
\description{
\code{identify.networx} reads the position of the graphics pointer when the
mouse button is pressed. It then returns the split belonging to the edge
closest to the pointer. The network must be plotted beforehand.
}
\examples{
\dontrun{
data(yeast)
dm <- dist.ml(yeast)
nnet <- neighborNet(dm)
plot(nnet)
identify(nnet) # click close to an edge
}
}
\seealso{
\code{\link[phangorn]{plot.networx}},
  \code{\link[graphics]{identify}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
