% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_clone}
\alias{env_clone}
\alias{env_coalesce}
\title{Clone or coalesce an environment}
\usage{
env_clone(env, parent = env_parent(env))

env_coalesce(env, from)
}
\arguments{
\item{env}{An environment.}

\item{parent}{The parent of the cloned environment.}

\item{from}{Environment to copy bindings from.}
}
\description{
\itemize{
\item \code{env_clone()} creates a new environment containing exactly the
same bindings as the input, optionally with a new parent.
\item \code{env_coalesce()} copies binding from the RHS environment into the
LHS. If the RHS already contains bindings with the same name as
in the LHS, those are kept as is.
}

Both these functions preserve active bindings and promises.
}
\examples{
# A clone initially contains the same bindings as the original
# environment
env <- env(a = 1, b = 2)
clone <- env_clone(env)

env_print(clone)
env_print(env)

# But it can acquire new bindings or change existing ones without
# impacting the original environment
env_bind(clone, a = "foo", c = 3)

env_print(clone)
env_print(env)


# `env_coalesce()` copies bindings from one environment to another
lhs <- env(a = 1)
rhs <- env(a = "a", b = "b", c = "c")
env_coalesce(lhs, rhs)
env_print(lhs)

# To copy all the bindings from `rhs` into `lhs`, first delete the
# conflicting bindings from `rhs`
env_unbind(lhs, env_names(rhs))
env_coalesce(lhs, rhs)
env_print(lhs)
}
