% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-functions.R
\name{loo-prediction}
\alias{loo-prediction}
\alias{loo_linpred}
\alias{loo_predict}
\alias{loo_predictive_interval}
\alias{loo_pit}
\alias{loo_pit.default}
\title{Generic functions for LOO predictions}
\usage{
loo_linpred(object, ...)

loo_predict(object, ...)

loo_predictive_interval(object, ...)

loo_pit(object, ...)

\method{loo_pit}{default}(object, y, lw, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}

\item{y}{For the default method of \code{loo_pit()}, a vector of \code{y} values the
same length as the number of columns in the matrix used as \code{object}.}

\item{lw}{For the default method of \code{loo_pit()}, a matrix of log-weights of
the same length as the number of columns in the matrix used as \code{object}.}
}
\value{
\code{loo_predict()}, \code{loo_linpred()}, and \code{loo_pit()}
(probability integral transform) methods should return a vector with length
equal to the number of observations in the data.
\code{loo_predictive_interval()} methods should return a two-column matrix
formatted in the same way as for \code{\link[=predictive_interval]{predictive_interval()}}.
}
\description{
See the methods in the \pkg{rstanarm} package for examples.
}
\seealso{
\itemize{
\item The \pkg{rstanarm} package (\href{https://mc-stan.org/rstanarm/}{mc-stan.org/rstanarm})
for example methods
(\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
\href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
\item Guidelines and recommendations for developers of \R packages
interfacing with Stan and a demonstration getting a simple package working
can be found in the vignettes included with \pkg{rstantools} and at
\href{https://mc-stan.org/rstantools/articles/}{mc-stan.org/rstantools/articles}.
}
}
