% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie_plots.R
\name{susie_plot}
\alias{susie_plot}
\alias{susie_plot_iteration}
\title{SuSiE Plots.}
\usage{
susie_plot(
  model,
  y,
  add_bar = FALSE,
  pos = NULL,
  b = NULL,
  max_cs = 400,
  add_legend = NULL,
  ...
)

susie_plot_iteration(model, L, file_prefix, pos = NULL)
}
\arguments{
\item{model}{A SuSiE fit, typically an output from
\code{\link{susie}} or one of its variants. For \code{suse_plot},
the susie fit must have \code{model$z}, \code{model$PIP}, and may
include \code{model$sets}. \code{model} may also be a vector of
z-scores or PIPs.}

\item{y}{A string indicating what to plot: either \code{"z_original"} for
z-scores, \code{"z"} for z-score derived p-values on (base-10) log-scale, 
\code{"PIP"} for posterior inclusion probabilities,
\code{"log10PIP"} for posterior inclusion probabiliities on the
(base-10) log-scale. For any other setting, the data are plotted as
is.}

\item{add_bar}{If \code{add_bar = TRUE}, add horizontal bar to
signals in credible interval.}

\item{pos}{Indices of variables to plot. If \code{pos = NULL} all
variables are plotted.}

\item{b}{For simulated data, set \code{b = TRUE} to highlight
"true" effects (highlights in red).}

\item{max_cs}{The largest credible set to display, either based on
purity (set \code{max_cs} between 0 and 1), or based on size (set
\code{max_cs > 1}).}

\item{add_legend}{If \code{add_legend = TRUE}, add a legend to
annotate the size and purity of each CS discovered. It can also be
specified as location where legends should be added, e.g.,
\code{add_legend = "bottomright"} (default location is
\code{"topright"}).}

\item{\dots}{Additional arguments passed to
\code{\link[graphics]{plot}}.}

\item{L}{An integer specifying the number of credible sets to plot.}

\item{file_prefix}{Prefix to path of output plot file. If not
specified, the plot, or plots, will be saved to a temporary
directory generated using \code{\link{tempdir}}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
\code{susie_plot} produces a per-variable summary of
  the SuSiE credible sets. \code{susie_plot_iteration} produces a
  diagnostic plot for the susie model fitting. For
  \code{susie_plot_iteration}, several plots will be created if
  \code{track_fit = TRUE} when calling \code{susie}.
}
\examples{
set.seed(1)
n = 1000
p = 1000
beta = rep(0,p)
beta[sample(1:1000,4)] = 1
X = matrix(rnorm(n*p),nrow = n,ncol = p)
X = scale(X,center = TRUE,scale = TRUE)
y = drop(X \%*\% beta + rnorm(n))
res = susie(X,y,L = 10)
susie_plot(res,"PIP")
susie_plot(res,"PIP",add_bar = TRUE)
susie_plot(res,"PIP",add_legend = TRUE)
susie_plot(res,"PIP", pos=1:500, add_legend = TRUE)
# Plot selected regions with adjusted x-axis position label
res$genomic_position = 1000 + (1:length(res$pip))
susie_plot(res,"PIP",add_legend = TRUE,
           pos = list(attr = "genomic_position",start = 1000,end = 1500))
# True effects are shown in red.
susie_plot(res,"PIP",b = beta,add_legend = TRUE)

set.seed(1)
n = 1000
p = 1000
beta = rep(0,p)
beta[sample(1:1000,4)] = 1
X = matrix(rnorm(n*p),nrow = n,ncol = p)
X = scale(X,center = TRUE,scale = TRUE)
y = drop(X \%*\% beta + rnorm(n))
res = susie(X,y,L = 10)
susie_plot_iteration(res, L=10)

}
\seealso{
\code{\link{susie_plot_changepoint}}
}
