# -*- coding: utf-8 -*-
# Copyright © 2015-2016 Carl Chenet <carl.chenet@ohmytux.com>
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>

'''Wait a moment before going on'''

# standard library imports
import time
from random import randint

class WaitAMoment:
    '''Wait a moment before going on'''
    def __init__(self, waitminsecs, waitmaxsecs):
        '''Constructor of the WaitAMoment class'''
        self.min = waitminsecs
        self.max = waitmaxsecs
        self.main()

    def main(self):
        '''main of the WaitAMoment class'''
        waitsec = randint(self.min, self.max)
        time.sleep(waitsec)
