#!/usr/bin/perl

use strict;
use warnings;
use NGCP::Rtpengine::Test;
use NGCP::Rtpclient::SRTP;
use NGCP::Rtpengine::AutoTest;
use Test::More;


$ENV{RTPENGINE_EXTENDED_TESTS} or exit();
$ENV{RTPENGINE_3GPP_EVS_LIB} or exit();

autotest_start(qw(--config-file=none -t -1 -i 203.0.113.1 -i 2001:db8:4321::1
			-n 2223 -f -L 7 -E --silence-detect=1 --dtx-delay=10),
			"--evs-lib-path=$ENV{RTPENGINE_3GPP_EVS_LIB}")
		or die;


my ($sock_a, $sock_b, $sock_c, $sock_d, $port_a, $port_b, $ssrc, $ssrc_b, $resp,
	$sock_ax, $sock_bx, $port_ax, $port_bx,
	$srtp_ctx_a, $srtp_ctx_b, $srtp_ctx_a_rev, $srtp_ctx_b_rev,
	@ret1, @ret2, @ret3, @ret4, $srtp_key_a, $srtp_key_b, $ts, $seq);




($sock_a, $sock_b) = new_call([qw(198.51.100.10 4076)], [qw(198.51.100.10 4078)]);

($port_a) = offer('EVS DTX out',
	{ ICE => 'remove', codec => { transcode => ['PCMA'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4076 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS DTX out', {  }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4078 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_b, $port_a, rtp(8, 2000, 4000, 0x5678, "\x77" x 160));
($seq, $ts, $ssrc) = rcv($sock_a, $port_b, rtpm(96, -1, -1, -1, "\x06\x0d\x67\x75\x43\x46\xc0\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x4e\xc0\x46\xc8\x8c\xc4\x76\x5c\x09\x62\x44\x43\x03\xaf\xc0\xe0\x46\x83\x56\x9b\xf4\x34\x20\x17\x50\x50\x8f\xc7\x04"));
Time::HiRes::usleep(10000);
snd($sock_b, $port_a, rtp(8, 2001, 4160, 0x5678, "\x77" x 160));
rcv($sock_a, $port_b, rtpm(96, $seq + 1, $ts + 320, $ssrc, "\x06\x0d\xe4\x73\x6a\x88\x50\x01\x57\xa3\x36\x3f\xaf\x66\x99\xe2\xaa\x22\xa4\x1a\xbf\xa1\x7d\x7e\x5a\xb4\x61\x82\xae\x4e\x39\x26\xfa\x85\xe0\xe0\x73\x78\xf1\xdb\x4d\x01\x9e\xf5\xd8\xc0\x34\x55\xfc\x88\xde\x95\x81\xe4\x28\xe9\x23\x07\x49\x08\x8d\x2f"));
Time::HiRes::usleep(10000);
snd($sock_b, $port_a, rtp(8, 2002, 4320, 0x5678, "\x77" x 160));
rcv($sock_a, $port_b, rtpm(96, $seq + 2, $ts + 640, $ssrc, "\x06\x0d\xe4\x58\xcb\x98\x18\x46\x88\xc8\xd2\x6a\xf1\xa1\x60\x35\x20\xfc\x07\xcc\xbd\xb8\x04\xec\xc7\x8b\xfe\x7a\x57\x65\x67\xc7\xe9\x45\xe3\x73\x0d\xbf\x4f\x6d\xb6\x25\xee\xb5\x75\x44\x2e\xc0\x80\x5b\x02\x39\x89\xed\xc9\x60\xd8\x43\x07\x00\xe0\xaf"));
# no input
rcv($sock_a, $port_b, rtpm(96, $seq + 3, $ts + 960, $ssrc, "\x06\x0d\x63\xe3\x74\xa0\x40\x0d\x1c\x9c\x43\x03\x29\x09\x1e\x0f\x4f\x4a\x06\x2a\xbf\xf1\x54\x49\xe0\x0a\x3d\x3f\xe6\xb9\xf2\x09\xca\x2e\xc0\x99\x8f\x11\xd6\x3e\x73\x64\x54\x9d\x57\xc4\x39\x20\x40\x14\x15\xc2\xdc\xa6\xd3\x05\xac\x9a\xeb\x81\xc1\x04"));

rcv_no($sock_b);


rtpe_req('delete', 'EVS DTX out', { 'from-tag' => ft() });




($sock_a, $sock_b) = new_call([qw(198.51.100.10 4096)], [qw(198.51.100.10 4098)]);

($port_a) = offer('EVS DTX in',
	{ ICE => 'remove', codec => { transcode => ['PCMA'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4096 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS DTX in', {  }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4098 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(96, 6000, 8000, 0x7654, "\x06\x0d\x67\x75\x43\x46\xc0\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x4e\xc0\x46\xc8\x8c\xc4\x76\x5c\x09\x62\x44\x43\x03\xaf\xc0\xe0\x46\x83\x56\x9b\xf4\x34\x20\x17\x50\x50\x8f\xc7\x04"));
Time::HiRes::usleep(10000);
snd($sock_a, $port_b, rtp(96, 6001, 8320, 0x7654, "\x06\x0d\xe4\x73\x6a\x88\x50\x01\x57\xa3\x36\x3f\xaf\x66\x99\xe2\xaa\x22\xa4\x1a\xbf\xa1\x7d\x7e\x5a\xb4\x61\x82\xae\x4e\x39\x26\xfa\x85\xe0\xe0\x73\x78\xf1\xdb\x4d\x01\x9e\xf5\xd8\xc0\x34\x55\xfc\x88\xde\x95\x81\xe4\x28\xe9\x23\x07\x49\x08\x8d\x2f"));
($seq, $ts, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, -1, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x54\x51\x57\x55\x56\xd5\xd6\x4f\x75\x49\x49\x4c\x4f\x42\x42\x40\x43\x46\x47\x47\x45\x5b\x5a\x58\x59\x5f\x5f\x5f\x5c\x5d\x5d\x53\x53\x53\x50\x51\x56\x56\x57\x54\x55\x54\x55\xd4\xd7\xd6\xd6\xd1\xd1\xd0\xd3\xd3\xd3\xd3\xd2\xd2\xd2\xd2\xdd\xdd\xdd\xdd\xdd\xdc\xdc\xdc\xdc\xdf\xdf\xdf\xdf"));
Time::HiRes::usleep(10000);
snd($sock_a, $port_b, rtp(96, 6002, 8640, $ssrc, "\x06\x0d\xe4\x58\xcb\x98\x18\x46\x88\xc8\xd2\x6a\xf1\xa1\x60\x35\x20\xfc\x07\xcc\xbd\xb8\x04\xec\xc7\x8b\xfe\x7a\x57\x65\x67\xc7\xe9\x45\xe3\x73\x0d\xbf\x4f\x6d\xb6\x25\xee\xb5\x75\x44\x2e\xc0\x80\x5b\x02\x39\x89\xed\xc9\x60\xd8\x43\x07\x00\xe0\xaf"));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, $ts + 160, $ssrc, "\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xde\xde\xde\xde\xde\xde\xde\xde\xde\xde\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd3\xd3\xd3\xd3\xd3\xd3\xd3\xd3\xd3\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd1\xd1\xd1\xd1\xd1\xd1\xd1\xd6\xd6\xd6\xd6\xd6\xd6\xd6\xd6\xd6\xd7\xd7\xd7\xd7\xd7\xd7\xd7\xd7\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x54\x54\x54\x54\x54\x54\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x56\x56\x56\x56\x56\x56\x56\x56\x56\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51"));
# no input
rcv($sock_b, $port_a, rtpm(8, $seq + 2, $ts + 320, $ssrc, "\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x50\x50\x50\x50\x50\x53\x53\x53\x53\x53\x53\x52\x52\x52\x52\x52\x52\x52\x52\x52\x52\x53\x53\x53\x53\x53\x53\x53\x50\x50\x50\x50\x50\x50\x50\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x51\x50\x50\x50\x50\x50\x50\x50\x50\x50\x51\x51\x51\x51\x51\x51\x51\x51\x51\x56\x56\x56\x56\x56\x56\x57\x57\x57\x57\x57\x57\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x57\x57\x57\x57\x57\x57\x57\x57\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x55\x55\x55\x55\x55\x55\x55\x55\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x55"));

rcv_no($sock_a);


rtpe_req('delete', 'EVS DTX in', { 'from-tag' => ft() });


#done_testing;NGCP::Rtpengine::AutoTest::terminate('f00');exit;
done_testing();
