// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::StyleProvider;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSettings")]
    pub struct Settings(Object<ffi::GtkSettings, ffi::GtkSettingsClass>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_settings_get_type(),
    }
}

impl Settings {
    #[doc(alias = "gtk_settings_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> Option<Settings> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_settings_get_default()) }
    }

    #[doc(alias = "gtk_settings_get_for_screen")]
    #[doc(alias = "get_for_screen")]
    pub fn for_screen(screen: &gdk::Screen) -> Option<Settings> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_settings_get_for_screen(screen.to_glib_none().0)) }
    }
}

pub const NONE_SETTINGS: Option<&Settings> = None;

pub trait SettingsExt: 'static {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    #[doc(alias = "gtk_settings_reset_property")]
    fn reset_property(&self, name: &str);

    #[doc(alias = "gtk-alternative-button-order")]
    fn is_gtk_alternative_button_order(&self) -> bool;

    #[doc(alias = "gtk-alternative-button-order")]
    fn set_gtk_alternative_button_order(&self, gtk_alternative_button_order: bool);

    #[doc(alias = "gtk-alternative-sort-arrows")]
    fn is_gtk_alternative_sort_arrows(&self) -> bool;

    #[doc(alias = "gtk-alternative-sort-arrows")]
    fn set_gtk_alternative_sort_arrows(&self, gtk_alternative_sort_arrows: bool);

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    fn is_gtk_application_prefer_dark_theme(&self) -> bool;

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    fn set_gtk_application_prefer_dark_theme(&self, gtk_application_prefer_dark_theme: bool);

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    #[doc(alias = "gtk-cursor-aspect-ratio")]
    fn gtk_cursor_aspect_ratio(&self) -> f32;

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    #[doc(alias = "gtk-cursor-aspect-ratio")]
    fn set_gtk_cursor_aspect_ratio(&self, gtk_cursor_aspect_ratio: f32);

    #[doc(alias = "gtk-cursor-blink")]
    fn is_gtk_cursor_blink(&self) -> bool;

    #[doc(alias = "gtk-cursor-blink")]
    fn set_gtk_cursor_blink(&self, gtk_cursor_blink: bool);

    #[doc(alias = "gtk-cursor-blink-time")]
    fn gtk_cursor_blink_time(&self) -> i32;

    #[doc(alias = "gtk-cursor-blink-time")]
    fn set_gtk_cursor_blink_time(&self, gtk_cursor_blink_time: i32);

    #[doc(alias = "gtk-cursor-blink-timeout")]
    fn gtk_cursor_blink_timeout(&self) -> i32;

    #[doc(alias = "gtk-cursor-blink-timeout")]
    fn set_gtk_cursor_blink_timeout(&self, gtk_cursor_blink_timeout: i32);

    #[doc(alias = "gtk-cursor-theme-name")]
    fn gtk_cursor_theme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-cursor-theme-name")]
    fn set_gtk_cursor_theme_name(&self, gtk_cursor_theme_name: Option<&str>);

    #[doc(alias = "gtk-cursor-theme-size")]
    fn gtk_cursor_theme_size(&self) -> i32;

    #[doc(alias = "gtk-cursor-theme-size")]
    fn set_gtk_cursor_theme_size(&self, gtk_cursor_theme_size: i32);

    #[doc(alias = "gtk-decoration-layout")]
    fn gtk_decoration_layout(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-decoration-layout")]
    fn set_gtk_decoration_layout(&self, gtk_decoration_layout: Option<&str>);

    #[doc(alias = "gtk-dialogs-use-header")]
    fn is_gtk_dialogs_use_header(&self) -> bool;

    #[doc(alias = "gtk-dialogs-use-header")]
    fn set_gtk_dialogs_use_header(&self, gtk_dialogs_use_header: bool);

    #[doc(alias = "gtk-dnd-drag-threshold")]
    fn gtk_dnd_drag_threshold(&self) -> i32;

    #[doc(alias = "gtk-dnd-drag-threshold")]
    fn set_gtk_dnd_drag_threshold(&self, gtk_dnd_drag_threshold: i32);

    #[doc(alias = "gtk-double-click-distance")]
    fn gtk_double_click_distance(&self) -> i32;

    #[doc(alias = "gtk-double-click-distance")]
    fn set_gtk_double_click_distance(&self, gtk_double_click_distance: i32);

    #[doc(alias = "gtk-double-click-time")]
    fn gtk_double_click_time(&self) -> i32;

    #[doc(alias = "gtk-double-click-time")]
    fn set_gtk_double_click_time(&self, gtk_double_click_time: i32);

    #[doc(alias = "gtk-enable-accels")]
    fn is_gtk_enable_accels(&self) -> bool;

    #[doc(alias = "gtk-enable-accels")]
    fn set_gtk_enable_accels(&self, gtk_enable_accels: bool);

    #[doc(alias = "gtk-enable-animations")]
    fn is_gtk_enable_animations(&self) -> bool;

    #[doc(alias = "gtk-enable-animations")]
    fn set_gtk_enable_animations(&self, gtk_enable_animations: bool);

    #[doc(alias = "gtk-enable-event-sounds")]
    fn is_gtk_enable_event_sounds(&self) -> bool;

    #[doc(alias = "gtk-enable-event-sounds")]
    fn set_gtk_enable_event_sounds(&self, gtk_enable_event_sounds: bool);

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    fn is_gtk_enable_input_feedback_sounds(&self) -> bool;

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    fn set_gtk_enable_input_feedback_sounds(&self, gtk_enable_input_feedback_sounds: bool);

    #[doc(alias = "gtk-enable-primary-paste")]
    fn is_gtk_enable_primary_paste(&self) -> bool;

    #[doc(alias = "gtk-enable-primary-paste")]
    fn set_gtk_enable_primary_paste(&self, gtk_enable_primary_paste: bool);

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    fn gtk_entry_password_hint_timeout(&self) -> u32;

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    fn set_gtk_entry_password_hint_timeout(&self, gtk_entry_password_hint_timeout: u32);

    #[doc(alias = "gtk-entry-select-on-focus")]
    fn is_gtk_entry_select_on_focus(&self) -> bool;

    #[doc(alias = "gtk-entry-select-on-focus")]
    fn set_gtk_entry_select_on_focus(&self, gtk_entry_select_on_focus: bool);

    #[doc(alias = "gtk-error-bell")]
    fn is_gtk_error_bell(&self) -> bool;

    #[doc(alias = "gtk-error-bell")]
    fn set_gtk_error_bell(&self, gtk_error_bell: bool);

    #[doc(alias = "gtk-font-name")]
    fn gtk_font_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-font-name")]
    fn set_gtk_font_name(&self, gtk_font_name: Option<&str>);

    #[doc(alias = "gtk-fontconfig-timestamp")]
    fn gtk_fontconfig_timestamp(&self) -> u32;

    #[doc(alias = "gtk-fontconfig-timestamp")]
    fn set_gtk_fontconfig_timestamp(&self, gtk_fontconfig_timestamp: u32);

    #[doc(alias = "gtk-icon-theme-name")]
    fn gtk_icon_theme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-icon-theme-name")]
    fn set_gtk_icon_theme_name(&self, gtk_icon_theme_name: Option<&str>);

    #[doc(alias = "gtk-im-module")]
    fn gtk_im_module(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-im-module")]
    fn set_gtk_im_module(&self, gtk_im_module: Option<&str>);

    #[doc(alias = "gtk-key-theme-name")]
    fn gtk_key_theme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-key-theme-name")]
    fn set_gtk_key_theme_name(&self, gtk_key_theme_name: Option<&str>);

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    #[doc(alias = "gtk-keynav-use-caret")]
    fn is_gtk_keynav_use_caret(&self) -> bool;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    #[doc(alias = "gtk-keynav-use-caret")]
    fn set_gtk_keynav_use_caret(&self, gtk_keynav_use_caret: bool);

    #[doc(alias = "gtk-label-select-on-focus")]
    fn is_gtk_label_select_on_focus(&self) -> bool;

    #[doc(alias = "gtk-label-select-on-focus")]
    fn set_gtk_label_select_on_focus(&self, gtk_label_select_on_focus: bool);

    #[doc(alias = "gtk-long-press-time")]
    fn gtk_long_press_time(&self) -> u32;

    #[doc(alias = "gtk-long-press-time")]
    fn set_gtk_long_press_time(&self, gtk_long_press_time: u32);

    #[doc(alias = "gtk-modules")]
    fn gtk_modules(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-modules")]
    fn set_gtk_modules(&self, gtk_modules: Option<&str>);

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    #[doc(alias = "gtk-overlay-scrolling")]
    fn is_gtk_overlay_scrolling(&self) -> bool;

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    #[doc(alias = "gtk-overlay-scrolling")]
    fn set_gtk_overlay_scrolling(&self, gtk_overlay_scrolling: bool);

    #[doc(alias = "gtk-primary-button-warps-slider")]
    fn is_gtk_primary_button_warps_slider(&self) -> bool;

    #[doc(alias = "gtk-primary-button-warps-slider")]
    fn set_gtk_primary_button_warps_slider(&self, gtk_primary_button_warps_slider: bool);

    #[doc(alias = "gtk-print-backends")]
    fn gtk_print_backends(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-print-backends")]
    fn set_gtk_print_backends(&self, gtk_print_backends: Option<&str>);

    #[doc(alias = "gtk-print-preview-command")]
    fn gtk_print_preview_command(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-print-preview-command")]
    fn set_gtk_print_preview_command(&self, gtk_print_preview_command: Option<&str>);

    #[doc(alias = "gtk-recent-files-enabled")]
    fn is_gtk_recent_files_enabled(&self) -> bool;

    #[doc(alias = "gtk-recent-files-enabled")]
    fn set_gtk_recent_files_enabled(&self, gtk_recent_files_enabled: bool);

    #[doc(alias = "gtk-recent-files-max-age")]
    fn gtk_recent_files_max_age(&self) -> i32;

    #[doc(alias = "gtk-recent-files-max-age")]
    fn set_gtk_recent_files_max_age(&self, gtk_recent_files_max_age: i32);

    #[doc(alias = "gtk-shell-shows-app-menu")]
    fn is_gtk_shell_shows_app_menu(&self) -> bool;

    #[doc(alias = "gtk-shell-shows-app-menu")]
    fn set_gtk_shell_shows_app_menu(&self, gtk_shell_shows_app_menu: bool);

    #[doc(alias = "gtk-shell-shows-desktop")]
    fn is_gtk_shell_shows_desktop(&self) -> bool;

    #[doc(alias = "gtk-shell-shows-desktop")]
    fn set_gtk_shell_shows_desktop(&self, gtk_shell_shows_desktop: bool);

    #[doc(alias = "gtk-shell-shows-menubar")]
    fn is_gtk_shell_shows_menubar(&self) -> bool;

    #[doc(alias = "gtk-shell-shows-menubar")]
    fn set_gtk_shell_shows_menubar(&self, gtk_shell_shows_menubar: bool);

    #[doc(alias = "gtk-sound-theme-name")]
    fn gtk_sound_theme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-sound-theme-name")]
    fn set_gtk_sound_theme_name(&self, gtk_sound_theme_name: Option<&str>);

    #[doc(alias = "gtk-split-cursor")]
    fn is_gtk_split_cursor(&self) -> bool;

    #[doc(alias = "gtk-split-cursor")]
    fn set_gtk_split_cursor(&self, gtk_split_cursor: bool);

    #[doc(alias = "gtk-theme-name")]
    fn gtk_theme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-theme-name")]
    fn set_gtk_theme_name(&self, gtk_theme_name: Option<&str>);

    #[doc(alias = "gtk-titlebar-double-click")]
    fn gtk_titlebar_double_click(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-titlebar-double-click")]
    fn set_gtk_titlebar_double_click(&self, gtk_titlebar_double_click: Option<&str>);

    #[doc(alias = "gtk-titlebar-middle-click")]
    fn gtk_titlebar_middle_click(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-titlebar-middle-click")]
    fn set_gtk_titlebar_middle_click(&self, gtk_titlebar_middle_click: Option<&str>);

    #[doc(alias = "gtk-titlebar-right-click")]
    fn gtk_titlebar_right_click(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-titlebar-right-click")]
    fn set_gtk_titlebar_right_click(&self, gtk_titlebar_right_click: Option<&str>);

    #[doc(alias = "gtk-xft-antialias")]
    fn gtk_xft_antialias(&self) -> i32;

    #[doc(alias = "gtk-xft-antialias")]
    fn set_gtk_xft_antialias(&self, gtk_xft_antialias: i32);

    #[doc(alias = "gtk-xft-dpi")]
    fn gtk_xft_dpi(&self) -> i32;

    #[doc(alias = "gtk-xft-dpi")]
    fn set_gtk_xft_dpi(&self, gtk_xft_dpi: i32);

    #[doc(alias = "gtk-xft-hinting")]
    fn gtk_xft_hinting(&self) -> i32;

    #[doc(alias = "gtk-xft-hinting")]
    fn set_gtk_xft_hinting(&self, gtk_xft_hinting: i32);

    #[doc(alias = "gtk-xft-hintstyle")]
    fn gtk_xft_hintstyle(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-xft-hintstyle")]
    fn set_gtk_xft_hintstyle(&self, gtk_xft_hintstyle: Option<&str>);

    #[doc(alias = "gtk-xft-rgba")]
    fn gtk_xft_rgba(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk-xft-rgba")]
    fn set_gtk_xft_rgba(&self, gtk_xft_rgba: Option<&str>);

    #[doc(alias = "gtk-alternative-button-order")]
    fn connect_gtk_alternative_button_order_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-alternative-sort-arrows")]
    fn connect_gtk_alternative_sort_arrows_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    fn connect_gtk_application_prefer_dark_theme_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    #[doc(alias = "gtk-cursor-aspect-ratio")]
    fn connect_gtk_cursor_aspect_ratio_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-cursor-blink")]
    fn connect_gtk_cursor_blink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-cursor-blink-time")]
    fn connect_gtk_cursor_blink_time_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-cursor-blink-timeout")]
    fn connect_gtk_cursor_blink_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-cursor-theme-name")]
    fn connect_gtk_cursor_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-cursor-theme-size")]
    fn connect_gtk_cursor_theme_size_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-decoration-layout")]
    fn connect_gtk_decoration_layout_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-dialogs-use-header")]
    fn connect_gtk_dialogs_use_header_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-dnd-drag-threshold")]
    fn connect_gtk_dnd_drag_threshold_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-double-click-distance")]
    fn connect_gtk_double_click_distance_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-double-click-time")]
    fn connect_gtk_double_click_time_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-enable-accels")]
    fn connect_gtk_enable_accels_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-enable-animations")]
    fn connect_gtk_enable_animations_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-enable-event-sounds")]
    fn connect_gtk_enable_event_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    fn connect_gtk_enable_input_feedback_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-enable-primary-paste")]
    fn connect_gtk_enable_primary_paste_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    fn connect_gtk_entry_password_hint_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-entry-select-on-focus")]
    fn connect_gtk_entry_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-error-bell")]
    fn connect_gtk_error_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-font-name")]
    fn connect_gtk_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-fontconfig-timestamp")]
    fn connect_gtk_fontconfig_timestamp_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-icon-theme-name")]
    fn connect_gtk_icon_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-im-module")]
    fn connect_gtk_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-key-theme-name")]
    fn connect_gtk_key_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    #[doc(alias = "gtk-keynav-use-caret")]
    fn connect_gtk_keynav_use_caret_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-label-select-on-focus")]
    fn connect_gtk_label_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-long-press-time")]
    fn connect_gtk_long_press_time_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-modules")]
    fn connect_gtk_modules_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    #[doc(alias = "gtk-overlay-scrolling")]
    fn connect_gtk_overlay_scrolling_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "gtk-primary-button-warps-slider")]
    fn connect_gtk_primary_button_warps_slider_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-print-backends")]
    fn connect_gtk_print_backends_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-print-preview-command")]
    fn connect_gtk_print_preview_command_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-recent-files-enabled")]
    fn connect_gtk_recent_files_enabled_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-recent-files-max-age")]
    fn connect_gtk_recent_files_max_age_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-shell-shows-app-menu")]
    fn connect_gtk_shell_shows_app_menu_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-shell-shows-desktop")]
    fn connect_gtk_shell_shows_desktop_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-shell-shows-menubar")]
    fn connect_gtk_shell_shows_menubar_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-sound-theme-name")]
    fn connect_gtk_sound_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-split-cursor")]
    fn connect_gtk_split_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-theme-name")]
    fn connect_gtk_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-titlebar-double-click")]
    fn connect_gtk_titlebar_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-titlebar-middle-click")]
    fn connect_gtk_titlebar_middle_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-titlebar-right-click")]
    fn connect_gtk_titlebar_right_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "gtk-xft-antialias")]
    fn connect_gtk_xft_antialias_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-xft-dpi")]
    fn connect_gtk_xft_dpi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-xft-hinting")]
    fn connect_gtk_xft_hinting_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-xft-hintstyle")]
    fn connect_gtk_xft_hintstyle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "gtk-xft-rgba")]
    fn connect_gtk_xft_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Settings>> SettingsExt for O {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    fn reset_property(&self, name: &str) {
        unsafe {
            ffi::gtk_settings_reset_property(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn is_gtk_alternative_button_order(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-alternative-button-order\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-alternative-button-order` getter")
        }
    }

    fn set_gtk_alternative_button_order(&self, gtk_alternative_button_order: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-alternative-button-order\0".as_ptr() as *const _,
                gtk_alternative_button_order.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_alternative_sort_arrows(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-alternative-sort-arrows\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-alternative-sort-arrows` getter")
        }
    }

    fn set_gtk_alternative_sort_arrows(&self, gtk_alternative_sort_arrows: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-alternative-sort-arrows\0".as_ptr() as *const _,
                gtk_alternative_sort_arrows.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_application_prefer_dark_theme(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-application-prefer-dark-theme\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-application-prefer-dark-theme` getter")
        }
    }

    fn set_gtk_application_prefer_dark_theme(&self, gtk_application_prefer_dark_theme: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-application-prefer-dark-theme\0".as_ptr() as *const _,
                gtk_application_prefer_dark_theme
                    .to_value()
                    .to_glib_none()
                    .0,
            );
        }
    }

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    fn gtk_cursor_aspect_ratio(&self) -> f32 {
        unsafe {
            let mut value = glib::Value::from_type(<f32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-aspect-ratio\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-aspect-ratio` getter")
        }
    }

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    fn set_gtk_cursor_aspect_ratio(&self, gtk_cursor_aspect_ratio: f32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-aspect-ratio\0".as_ptr() as *const _,
                gtk_cursor_aspect_ratio.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_cursor_blink(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-blink` getter")
        }
    }

    fn set_gtk_cursor_blink(&self, gtk_cursor_blink: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink\0".as_ptr() as *const _,
                gtk_cursor_blink.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_cursor_blink_time(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink-time\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-blink-time` getter")
        }
    }

    fn set_gtk_cursor_blink_time(&self, gtk_cursor_blink_time: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink-time\0".as_ptr() as *const _,
                gtk_cursor_blink_time.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_cursor_blink_timeout(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink-timeout\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-blink-timeout` getter")
        }
    }

    fn set_gtk_cursor_blink_timeout(&self, gtk_cursor_blink_timeout: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-blink-timeout\0".as_ptr() as *const _,
                gtk_cursor_blink_timeout.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_cursor_theme_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-theme-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-theme-name` getter")
        }
    }

    fn set_gtk_cursor_theme_name(&self, gtk_cursor_theme_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-theme-name\0".as_ptr() as *const _,
                gtk_cursor_theme_name.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_cursor_theme_size(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-theme-size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-cursor-theme-size` getter")
        }
    }

    fn set_gtk_cursor_theme_size(&self, gtk_cursor_theme_size: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-cursor-theme-size\0".as_ptr() as *const _,
                gtk_cursor_theme_size.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_decoration_layout(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-decoration-layout\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-decoration-layout` getter")
        }
    }

    fn set_gtk_decoration_layout(&self, gtk_decoration_layout: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-decoration-layout\0".as_ptr() as *const _,
                gtk_decoration_layout.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_dialogs_use_header(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-dialogs-use-header\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-dialogs-use-header` getter")
        }
    }

    fn set_gtk_dialogs_use_header(&self, gtk_dialogs_use_header: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-dialogs-use-header\0".as_ptr() as *const _,
                gtk_dialogs_use_header.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_dnd_drag_threshold(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-dnd-drag-threshold\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-dnd-drag-threshold` getter")
        }
    }

    fn set_gtk_dnd_drag_threshold(&self, gtk_dnd_drag_threshold: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-dnd-drag-threshold\0".as_ptr() as *const _,
                gtk_dnd_drag_threshold.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_double_click_distance(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-double-click-distance\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-double-click-distance` getter")
        }
    }

    fn set_gtk_double_click_distance(&self, gtk_double_click_distance: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-double-click-distance\0".as_ptr() as *const _,
                gtk_double_click_distance.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_double_click_time(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-double-click-time\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-double-click-time` getter")
        }
    }

    fn set_gtk_double_click_time(&self, gtk_double_click_time: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-double-click-time\0".as_ptr() as *const _,
                gtk_double_click_time.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_enable_accels(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-accels\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-enable-accels` getter")
        }
    }

    fn set_gtk_enable_accels(&self, gtk_enable_accels: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-accels\0".as_ptr() as *const _,
                gtk_enable_accels.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_enable_animations(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-animations\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-enable-animations` getter")
        }
    }

    fn set_gtk_enable_animations(&self, gtk_enable_animations: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-animations\0".as_ptr() as *const _,
                gtk_enable_animations.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_enable_event_sounds(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-event-sounds\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-enable-event-sounds` getter")
        }
    }

    fn set_gtk_enable_event_sounds(&self, gtk_enable_event_sounds: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-event-sounds\0".as_ptr() as *const _,
                gtk_enable_event_sounds.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_enable_input_feedback_sounds(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-input-feedback-sounds\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-enable-input-feedback-sounds` getter")
        }
    }

    fn set_gtk_enable_input_feedback_sounds(&self, gtk_enable_input_feedback_sounds: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-input-feedback-sounds\0".as_ptr() as *const _,
                gtk_enable_input_feedback_sounds.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_enable_primary_paste(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-primary-paste\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-enable-primary-paste` getter")
        }
    }

    fn set_gtk_enable_primary_paste(&self, gtk_enable_primary_paste: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-enable-primary-paste\0".as_ptr() as *const _,
                gtk_enable_primary_paste.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_entry_password_hint_timeout(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-entry-password-hint-timeout\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-entry-password-hint-timeout` getter")
        }
    }

    fn set_gtk_entry_password_hint_timeout(&self, gtk_entry_password_hint_timeout: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-entry-password-hint-timeout\0".as_ptr() as *const _,
                gtk_entry_password_hint_timeout.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_entry_select_on_focus(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-entry-select-on-focus\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-entry-select-on-focus` getter")
        }
    }

    fn set_gtk_entry_select_on_focus(&self, gtk_entry_select_on_focus: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-entry-select-on-focus\0".as_ptr() as *const _,
                gtk_entry_select_on_focus.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_error_bell(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-error-bell\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-error-bell` getter")
        }
    }

    fn set_gtk_error_bell(&self, gtk_error_bell: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-error-bell\0".as_ptr() as *const _,
                gtk_error_bell.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_font_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-font-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-font-name` getter")
        }
    }

    fn set_gtk_font_name(&self, gtk_font_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-font-name\0".as_ptr() as *const _,
                gtk_font_name.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_fontconfig_timestamp(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-fontconfig-timestamp\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-fontconfig-timestamp` getter")
        }
    }

    fn set_gtk_fontconfig_timestamp(&self, gtk_fontconfig_timestamp: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-fontconfig-timestamp\0".as_ptr() as *const _,
                gtk_fontconfig_timestamp.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_icon_theme_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-icon-theme-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-icon-theme-name` getter")
        }
    }

    fn set_gtk_icon_theme_name(&self, gtk_icon_theme_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-icon-theme-name\0".as_ptr() as *const _,
                gtk_icon_theme_name.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_im_module(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-im-module\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-im-module` getter")
        }
    }

    fn set_gtk_im_module(&self, gtk_im_module: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-im-module\0".as_ptr() as *const _,
                gtk_im_module.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_key_theme_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-key-theme-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-key-theme-name` getter")
        }
    }

    fn set_gtk_key_theme_name(&self, gtk_key_theme_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-key-theme-name\0".as_ptr() as *const _,
                gtk_key_theme_name.to_value().to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    fn is_gtk_keynav_use_caret(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-keynav-use-caret\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-keynav-use-caret` getter")
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    fn set_gtk_keynav_use_caret(&self, gtk_keynav_use_caret: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-keynav-use-caret\0".as_ptr() as *const _,
                gtk_keynav_use_caret.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_label_select_on_focus(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-label-select-on-focus\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-label-select-on-focus` getter")
        }
    }

    fn set_gtk_label_select_on_focus(&self, gtk_label_select_on_focus: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-label-select-on-focus\0".as_ptr() as *const _,
                gtk_label_select_on_focus.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_long_press_time(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-long-press-time\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-long-press-time` getter")
        }
    }

    fn set_gtk_long_press_time(&self, gtk_long_press_time: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-long-press-time\0".as_ptr() as *const _,
                gtk_long_press_time.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_modules(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-modules\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-modules` getter")
        }
    }

    fn set_gtk_modules(&self, gtk_modules: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-modules\0".as_ptr() as *const _,
                gtk_modules.to_value().to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    fn is_gtk_overlay_scrolling(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-overlay-scrolling\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-overlay-scrolling` getter")
        }
    }

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    fn set_gtk_overlay_scrolling(&self, gtk_overlay_scrolling: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-overlay-scrolling\0".as_ptr() as *const _,
                gtk_overlay_scrolling.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_primary_button_warps_slider(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-primary-button-warps-slider\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-primary-button-warps-slider` getter")
        }
    }

    fn set_gtk_primary_button_warps_slider(&self, gtk_primary_button_warps_slider: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-primary-button-warps-slider\0".as_ptr() as *const _,
                gtk_primary_button_warps_slider.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_print_backends(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-print-backends\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-print-backends` getter")
        }
    }

    fn set_gtk_print_backends(&self, gtk_print_backends: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-print-backends\0".as_ptr() as *const _,
                gtk_print_backends.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_print_preview_command(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-print-preview-command\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-print-preview-command` getter")
        }
    }

    fn set_gtk_print_preview_command(&self, gtk_print_preview_command: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-print-preview-command\0".as_ptr() as *const _,
                gtk_print_preview_command.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_recent_files_enabled(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-recent-files-enabled\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-recent-files-enabled` getter")
        }
    }

    fn set_gtk_recent_files_enabled(&self, gtk_recent_files_enabled: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-recent-files-enabled\0".as_ptr() as *const _,
                gtk_recent_files_enabled.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_recent_files_max_age(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-recent-files-max-age\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-recent-files-max-age` getter")
        }
    }

    fn set_gtk_recent_files_max_age(&self, gtk_recent_files_max_age: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-recent-files-max-age\0".as_ptr() as *const _,
                gtk_recent_files_max_age.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_shell_shows_app_menu(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-app-menu\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-shell-shows-app-menu` getter")
        }
    }

    fn set_gtk_shell_shows_app_menu(&self, gtk_shell_shows_app_menu: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-app-menu\0".as_ptr() as *const _,
                gtk_shell_shows_app_menu.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_shell_shows_desktop(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-desktop\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-shell-shows-desktop` getter")
        }
    }

    fn set_gtk_shell_shows_desktop(&self, gtk_shell_shows_desktop: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-desktop\0".as_ptr() as *const _,
                gtk_shell_shows_desktop.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_shell_shows_menubar(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-menubar\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-shell-shows-menubar` getter")
        }
    }

    fn set_gtk_shell_shows_menubar(&self, gtk_shell_shows_menubar: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-shell-shows-menubar\0".as_ptr() as *const _,
                gtk_shell_shows_menubar.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_sound_theme_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-sound-theme-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-sound-theme-name` getter")
        }
    }

    fn set_gtk_sound_theme_name(&self, gtk_sound_theme_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-sound-theme-name\0".as_ptr() as *const _,
                gtk_sound_theme_name.to_value().to_glib_none().0,
            );
        }
    }

    fn is_gtk_split_cursor(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-split-cursor\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-split-cursor` getter")
        }
    }

    fn set_gtk_split_cursor(&self, gtk_split_cursor: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-split-cursor\0".as_ptr() as *const _,
                gtk_split_cursor.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_theme_name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-theme-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-theme-name` getter")
        }
    }

    fn set_gtk_theme_name(&self, gtk_theme_name: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-theme-name\0".as_ptr() as *const _,
                gtk_theme_name.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_titlebar_double_click(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-double-click\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-titlebar-double-click` getter")
        }
    }

    fn set_gtk_titlebar_double_click(&self, gtk_titlebar_double_click: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-double-click\0".as_ptr() as *const _,
                gtk_titlebar_double_click.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_titlebar_middle_click(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-middle-click\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-titlebar-middle-click` getter")
        }
    }

    fn set_gtk_titlebar_middle_click(&self, gtk_titlebar_middle_click: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-middle-click\0".as_ptr() as *const _,
                gtk_titlebar_middle_click.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_titlebar_right_click(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-right-click\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-titlebar-right-click` getter")
        }
    }

    fn set_gtk_titlebar_right_click(&self, gtk_titlebar_right_click: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-titlebar-right-click\0".as_ptr() as *const _,
                gtk_titlebar_right_click.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_xft_antialias(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-antialias\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-xft-antialias` getter")
        }
    }

    fn set_gtk_xft_antialias(&self, gtk_xft_antialias: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-antialias\0".as_ptr() as *const _,
                gtk_xft_antialias.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_xft_dpi(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-dpi\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-xft-dpi` getter")
        }
    }

    fn set_gtk_xft_dpi(&self, gtk_xft_dpi: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-dpi\0".as_ptr() as *const _,
                gtk_xft_dpi.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_xft_hinting(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-hinting\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-xft-hinting` getter")
        }
    }

    fn set_gtk_xft_hinting(&self, gtk_xft_hinting: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-hinting\0".as_ptr() as *const _,
                gtk_xft_hinting.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_xft_hintstyle(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-hintstyle\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-xft-hintstyle` getter")
        }
    }

    fn set_gtk_xft_hintstyle(&self, gtk_xft_hintstyle: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-hintstyle\0".as_ptr() as *const _,
                gtk_xft_hintstyle.to_value().to_glib_none().0,
            );
        }
    }

    fn gtk_xft_rgba(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `gtk-xft-rgba` getter")
        }
    }

    fn set_gtk_xft_rgba(&self, gtk_xft_rgba: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"gtk-xft-rgba\0".as_ptr() as *const _,
                gtk_xft_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_gtk_alternative_button_order_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_button_order_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-alternative-button-order\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_alternative_button_order_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_alternative_sort_arrows_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_sort_arrows_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-alternative-sort-arrows\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_alternative_sort_arrows_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_application_prefer_dark_theme_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_application_prefer_dark_theme_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-application-prefer-dark-theme\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_application_prefer_dark_theme_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24")))]
    fn connect_gtk_cursor_aspect_ratio_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_aspect_ratio_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-aspect-ratio\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_aspect_ratio_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_cursor_blink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_cursor_blink_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_time_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_time_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_cursor_blink_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_timeout_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink-timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_cursor_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_cursor_theme_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_size_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-theme-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_decoration_layout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_decoration_layout_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-decoration-layout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_decoration_layout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_dialogs_use_header_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dialogs_use_header_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-dialogs-use-header\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_dialogs_use_header_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_dnd_drag_threshold_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dnd_drag_threshold_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-dnd-drag-threshold\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_dnd_drag_threshold_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_double_click_distance_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_distance_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-double-click-distance\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_double_click_distance_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_double_click_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_time_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-double-click-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_double_click_time_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_enable_accels_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_accels_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-accels\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_accels_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_enable_animations_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_animations_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-animations\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_animations_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_enable_event_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_event_sounds_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-event-sounds\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_event_sounds_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_enable_input_feedback_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_input_feedback_sounds_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-input-feedback-sounds\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_input_feedback_sounds_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_enable_primary_paste_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_primary_paste_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-primary-paste\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_primary_paste_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_entry_password_hint_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_password_hint_timeout_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-entry-password-hint-timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_entry_password_hint_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_entry_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_select_on_focus_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-entry-select-on-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_entry_select_on_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_error_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_error_bell_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-error-bell\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_error_bell_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_font_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-font-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_font_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_fontconfig_timestamp_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_fontconfig_timestamp_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-fontconfig-timestamp\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_fontconfig_timestamp_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_icon_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_icon_theme_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-icon-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_icon_theme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_im_module_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_key_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_key_theme_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-key-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_key_theme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    fn connect_gtk_keynav_use_caret_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_keynav_use_caret_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-keynav-use-caret\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_keynav_use_caret_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_label_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_label_select_on_focus_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-label-select-on-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_label_select_on_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_long_press_time_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_long_press_time_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-long-press-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_long_press_time_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_modules_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_modules_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-modules\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_modules_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_24_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_24_9")))]
    fn connect_gtk_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_overlay_scrolling_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-overlay-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_overlay_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_primary_button_warps_slider_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_primary_button_warps_slider_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-primary-button-warps-slider\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_primary_button_warps_slider_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_print_backends_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_backends_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-print-backends\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_print_backends_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_print_preview_command_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_preview_command_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-print-preview-command\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_print_preview_command_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_recent_files_enabled_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_enabled_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-recent-files-enabled\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_recent_files_enabled_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_recent_files_max_age_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_max_age_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-recent-files-max-age\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_recent_files_max_age_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_shell_shows_app_menu_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_app_menu_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-app-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_app_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_shell_shows_desktop_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_desktop_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-desktop\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_desktop_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_shell_shows_menubar_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_menubar_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-menubar\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_menubar_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_sound_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_sound_theme_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-sound-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_sound_theme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_split_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_split_cursor_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-split-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_split_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_theme_name_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_theme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_titlebar_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_double_click_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-double-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_double_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_titlebar_middle_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_middle_click_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-middle-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_middle_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_titlebar_right_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_right_click_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-right-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_right_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_xft_antialias_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_antialias_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-antialias\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_antialias_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_xft_dpi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_dpi_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-dpi\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_dpi_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_xft_hinting_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hinting_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-hinting\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_hinting_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_xft_hintstyle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hintstyle_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-hintstyle\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_hintstyle_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_gtk_xft_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_rgba_trampoline<
            P: IsA<Settings>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Settings::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Settings {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Settings")
    }
}
