#!/usr/bin/perl
#
my $revision = '$Id: Scoring.pm,v 1.2 2001/08/22 17:58:36 bre Exp $';
my $version = 'Anomy 0.0.0 : sanitizer.pl';
#
##  Copyright (c) 2001 Bjarni R. Einarsson. All rights reserved.
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
#
##############################################################################
#
# NOTE:  Sanitizer development is for the most part sponsored by
#        FRISK Software International, http://www.frisk.is/.  Please
#        consider buying their anti-virus products to show your 
#        appreciation.
#
##############################################################################
#
# This module implements scoring for the Anomy Sanitizer.
# It adds a few configuration variables.
#
# 
#
##[ Package definition ]######################################################

package Anomy::Sanitizer::Scoring;
use strict;
 
BEGIN {
    use Exporter ();
    use vars         qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
    $VERSION         = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };
    @ISA             = qw(Exporter);
    @EXPORT          = qw( );
    @EXPORT_OK       = qw( );
}

use vars @EXPORT_OK;

##[ Package implementation ]##################################################

sub new 
{
    my ($proto, $name) = @_;
    my $class = ref($proto) || $proto;

    my $self = {
	"name" => $name || "score",
        "score" => 0,
	"thresholds" => [ ],
    };
    bless ($self, $class);
    return $self;
}

# FIXME:  Here we *should* accept a sanitizer object to register into.
#
# Since the sanitizer is currently non-OO, we just register directly into
# provided configuration and log variables.
#
sub register
{
    my ($self, $conf, $log) = @_;

    
}

1;
#EOF#
