#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - MIME recursion limiting
  - Handling of attributes with null values at ends of header lines.

tac
$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
     "feat_testing = 1" \
     "max_mime_depth = 1" \
     "header_rev = 0" \
     "feat_verbose = 0" \
     "feat_log_stderr = 1" \
     "feat_log_xml = 1" \
     <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Subject: Clean multipart/mixed test case with a very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long harmless subject.
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"
  trailing=

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain
Content-Transfer-Encoding: 8bit

blah blah

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: multipart/appledouble; x-mac-creator="5068466C"; x-mac-type="4A504547"; boundary="=ABACAB:=_0005@@P6505M9FyrTJqS3QJpeU"
Content-Disposition: attachment; filename="20802160428.jpg"


--=ABACAB:=_0005@@P6505M9FyrTJqS3QJpeU
Content-Type: application/applefile; x-mac-creator="5068466C"; x-mac-type="4A504547"
Content-Disposition: attachment; 
Content-Transfer-Encoding: base64

AAUWBwACAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAJAAAAPgAAACAAAAADAAAAXgAA
AA8AAAACAAAAbQAAH35KUEVHUGhGbAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADIw
6gVnJK8bZBOD1Fak9o9rKxGSuaqTWxYb41+Xvz0rupyja3Q9KlKHLZbD7e5dJVJO
Rmumt1V48H5t44Fc1YWMt3KkMalnJ4A/XPpgc57VV17xxJp8b2Xh2aGeVMK2ohC6
qwPIiUjB6ffIOedoGAx9XLeHsZndb2eFVkvik9l/m/JHz+e5nhcugpVZavZLdm/P
awabBJJqNxDZQN8yNO2C49VQAsw5/hBrBufE/h6CZmikvrxgcgR26pHJ7h2bcB6E
p+FcXNcz3aNPetLJPKctM7bizY6knBJ9c/ypTGiErKoIxjep7/UDmv17A8AZZh4/
7S5VZetl8kv1bPzPFcaZhOT9ilBfe/x0/A65PGen+VJcHQL5ooSolcXqsqZPBP7k
Y/E1s2vjHw9clEM91auy53XFv+7U+mUZmP8A3z+VecpbqxBQfLkEHbnac9+P881I
lvskBb+HkHqDj6/SvQxHBORV429jy+jkv1a/A8yPFmaRd5VOb1S/Sx6yn7y2NzA8
dzbk4E0Lh0HTAOPunkcNg89KoSu2RnOK4zT7m5splurKaSGdcBXQkZ56HjkHHIPB
rqtM1qPXiLOeOK01DbtRh8kdw/8Ad54Rz2/hPT5cAH85zrgKvgouvgZOpFbxfxL0
6P8AB+p9hkvGOHxVRUcVHkk+v2X/AJFlpRHFvXBPaqUtw86hpOccdO1KztEWikR4

--=ABACAB:=_0005@@P6505M9FyrTJqS3QJpeU
Content-Type: application/octet-stream; x-mac-creator="5068466C"; x-mac-type="4A504547"
Content-Disposition: attachment; filename="20802160428.jpg"
Content-Transfer-Encoding: base64

/9j/4AAQSkZJRgABAQEASABIAAD//gAsQ29tcHJlc3Npb24gYnkgU3Rvcm0gVGVj
aG5vbG9neagsIEluYy42Nk5x/+4ADkFkb2JlAGWAAAAAAf/tABBTdG9ybQABAAEB
AEgASP/bAIQABQMEBAQDBQQEBAYFBQYIDQgIBwcIEAsMCQ0TERQUExESEhUYHhoV
Fh0XEhIaJBsdHyAiIiIUGSUoJSEoHiEiIQEFBgYIBwgPCAgPIRYSFiEhISEhISEh
ISEhISEhISEhISEhISEhISEhISEhISEhISEhISEhISEhISEhISEhISEh/8AAEQgB
4AJzAwEiAAIRAQMRAf/EAaIAAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKCxAA
AgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAk
M2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlq
c3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXG
x8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6AQADAQEBAQEBAQEBAAAA

--=ABACAB:=_0005@@P6505M9FyrTJqS3QJpeU--

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--

EOF
echo "*** Exit code was $? ***" >>test.out
